//****************************************************************************
//*                           cl_opcodes.pas
//****************************************************************************
//*   Purpose:    Irinos Opcodes
//*
//****************************************************************************
//*   Comment:    Opcodes for Irinos 2nd generation (Irinos IR-xxx)
//*
//****************************************************************************
//*             (c) Messtechnik Sachs GmbH, D-73614 Schorndorf
//****************************************************************************
unit cl_opcodes;

interface

const
  // Initialization
  opcRIV	  = $01;    // Read inventory
  opcRMI    = $03;    // Read module information
  opcRSS    = $05;    // Read system string
  opcWCC    = $09;    // Write channel characteristics
	opcRCA    = $10;    // Read channel assignment
	opcWCA    = $11;	  // Write channel assignment
  opcWCP    = $1E;    // Write communication parameter

  // Configuration / various
  opcWCL    = $22;    // Write channel list
  opcRCL    = $23;    // Read channel list
	opcACL    = $24;    // Activate channel list for static measurement
  opcDT     = $30;    // Define trigger for dynamic measurement
  opcAT     = $31;    // Activate trigger for dynamic measurement
  opcIT     = $32;    // Inactivate trigger for dynamic measurement
	opcSP     = $35;    // Set (channel) parameter
	opcRHS    = $38;    // Read hardware status
  opcREv    = $39;    // Read event status
  opcSAbstT = $3A;    // Set absolute time
  opcREvCfg = $3C;    // Read event configuration and status
  opcWEvCfg = $3D;    // Write event configuration

  // Measurement
	opcRS 	  = $40;    // Read static measurement values
	opcBIO	  = $42;    // Read digital inputs / write digital outputs
	opcRSW	  = $44;    // Read statusword for dynamic measurement
	opcDDM1	  = $50;    // Define dynamic measurement 1
	opcDDM2	  = $51;    // Define dynamic measurement 2
	opcRDM1	  = $60;    // Read data of dynamic measurement 1
	opcRDM2	  = $61;    // Read data of dynamic measurement 2

   // Service
   opcRST   = $7E;    // System reset

implementation

end.
