﻿Public Class Form1
    Const N_STATIC_CHANNELS As UInt32 = 24
    Const N_DYN_CHANNELS_MAX As UInt32 = 32
    Const INOUT_BITS As UInt32 = 128
    Dim cIrinos As cl_Irinos
    Dim albStaticValues(24) As System.Windows.Forms.Label
    Dim albHardStat(24) As System.Windows.Forms.Label
    Dim acbOutputs(INOUT_BITS) As System.Windows.Forms.CheckBox
    Dim acbDynProbeUsed(N_DYN_CHANNELS_MAX) As System.Windows.Forms.CheckBox
    Dim abDynChannelsUsed(N_DYN_CHANNELS_MAX) As Boolean
    Dim bNewStaticMeasurementValuesAvailable As Boolean = False
    Dim bNewBitIOValuesAvailable As Boolean = False
    Dim bNewHardStatAvailable As Boolean = False
    Dim ulNStaticMeasurementValueUpdates As UInt32 = 0
    Dim ulNBitIOValueUpdates As UInt32 = 0
    Dim ulNHardStatUpdates As UInt32 = 0
    Dim bTimedOut As Boolean = False
    Dim ulDynChannels As UInt32 = 0


    '******************************************************************************
    ' FUNCTION: Form1_Load
    '-----------------------------------------------------------------------------
    ' "OnLoad" event is fired when the form is loaded.
    ' - Initialize class variables.
    ' - Assign GUI objects to arrays for easier access in the rest of the code.
    ' - Load MscDll.
    '*****************************************************************************/
    Private Sub Form1_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
        Dim ApiVers As UInt32 = 0
        Dim DllVers As UInt32 = 0
        Dim str As String
        Dim strHeader As String


        'Set readme text
        str = "This is a demo for the Irinos MscDll. Please note:" & Environment.NewLine & Environment.NewLine &
         "The purpose of this demo is helping software developers to integrate the Irinos-System into their software." & Environment.NewLine &
         "Focus has been put on demonstrating how to use the MscDll.dll. User interface design an error handling are very basic. " &
         "Integration into your own software probably requires a more sophisticated user interface and extended error handling." &
         Environment.NewLine & Environment.NewLine &
         "THIS DEMO COMES WITHOUT ANY WARRANTY OR LIABILITY." &
         Environment.NewLine & Environment.NewLine &
         "We strongly recomment to separate the GUI-update and the DLL into different Windows-threads. " &
         "One way to do this is using Windows messages in combination with a timer, that runs in the GUI thread. " &
         "In this example this is demonstrated by the combination of T_MSC_SetNotificationMessage, WndProc, " &
         "and tmrUpdateStatic_Tick." & Environment.NewLine &
         "(The MscDll also supports notification by callback or by event. However, we do not recommend these " &
         "techniques. Therefore they are not documented. If you need to use them, please contact us.)" &
         Environment.NewLine & Environment.NewLine &
         "In this demo the MscDll.dll file must be placed in the same directory as the Exe. Further the Msc.cfg " &
         "file is required in the same directory. The IP-settings in the Msc.cfg file must fit to the IP-Settings " &
         "of the Irinos-System." &
         Environment.NewLine & Environment.NewLine &
         "Messtechnik Sachs GmbH" & Environment.NewLine & "www.messtechnik-sachs.de" &
         Environment.NewLine & "Phone: +49 7181 99960 0"
        tbReadme.Text = str


        'Setup static measurement GUI
        albStaticValues(0) = lbStaticT1
        albStaticValues(1) = lbStaticT2
        albStaticValues(2) = lbStaticT3
        albStaticValues(3) = lbStaticT4
        albStaticValues(4) = lbStaticT5
        albStaticValues(5) = lbStaticT6
        albStaticValues(6) = lbStaticT7
        albStaticValues(7) = lbStaticT8
        albStaticValues(8) = lbStaticT9
        albStaticValues(9) = lbStaticT10
        albStaticValues(10) = lbStaticT11
        albStaticValues(11) = lbStaticT12
        albStaticValues(12) = lbStaticT13
        albStaticValues(13) = lbStaticT14
        albStaticValues(14) = lbStaticT15
        albStaticValues(15) = lbStaticT16
        albStaticValues(16) = lbStaticT17
        albStaticValues(17) = lbStaticT18
        albStaticValues(18) = lbStaticT19
        albStaticValues(19) = lbStaticT20
        albStaticValues(20) = lbStaticT21
        albStaticValues(21) = lbStaticT22
        albStaticValues(22) = lbStaticT23
        albStaticValues(23) = lbStaticT24
        albHardStat(0) = lbHardStat1
        albHardStat(1) = lbHardStat2
        albHardStat(2) = lbHardStat3
        albHardStat(3) = lbHardStat4
        albHardStat(4) = lbHardStat5
        albHardStat(5) = lbHardStat6
        albHardStat(6) = lbHardStat7
        albHardStat(7) = lbHardStat8
        albHardStat(8) = lbHardStat9
        albHardStat(9) = lbHardStat10
        albHardStat(10) = lbHardStat11
        albHardStat(11) = lbHardStat12
        albHardStat(12) = lbHardStat13
        albHardStat(13) = lbHardStat14
        albHardStat(14) = lbHardStat15
        albHardStat(15) = lbHardStat16
        albHardStat(16) = lbHardStat17
        albHardStat(17) = lbHardStat18
        albHardStat(18) = lbHardStat19
        albHardStat(19) = lbHardStat20
        albHardStat(20) = lbHardStat21
        albHardStat(21) = lbHardStat22
        albHardStat(22) = lbHardStat23
        albHardStat(23) = lbHardStat24

        'Setup Bit I/O GUI
        For I = 0 To 15
            dataGridViewInputs.Rows.Add()
        Next
        acbOutputs(0) = cbOutput1
        acbOutputs(1) = cbOutput2
        acbOutputs(2) = cbOutput3
        acbOutputs(3) = cbOutput4
        acbOutputs(4) = cbOutput5
        acbOutputs(5) = cbOutput6
        acbOutputs(6) = cbOutput7
        acbOutputs(7) = cbOutput8
        acbOutputs(8) = cbOutput9
        acbOutputs(9) = cbOutput10
        acbOutputs(10) = cbOutput11
        acbOutputs(11) = cbOutput12
        acbOutputs(12) = cbOutput13
        acbOutputs(13) = cbOutput14
        acbOutputs(14) = cbOutput15
        acbOutputs(15) = cbOutput16
        acbOutputs(16) = cbOutput17
        acbOutputs(17) = cbOutput18
        acbOutputs(18) = cbOutput19
        acbOutputs(19) = cbOutput20
        acbOutputs(20) = cbOutput21
        acbOutputs(21) = cbOutput22
        acbOutputs(22) = cbOutput23
        acbOutputs(23) = cbOutput24
        acbOutputs(24) = cbOutput25
        acbOutputs(25) = cbOutput26
        acbOutputs(26) = cbOutput27
        acbOutputs(27) = cbOutput28
        acbOutputs(28) = cbOutput29
        acbOutputs(29) = cbOutput30
        acbOutputs(30) = cbOutput31
        acbOutputs(31) = cbOutput32
        acbOutputs(32) = cbOutput33
        acbOutputs(33) = cbOutput34
        acbOutputs(34) = cbOutput35
        acbOutputs(35) = cbOutput36
        acbOutputs(36) = cbOutput37
        acbOutputs(37) = cbOutput38
        acbOutputs(38) = cbOutput39
        acbOutputs(39) = cbOutput40
        acbOutputs(40) = cbOutput41
        acbOutputs(41) = cbOutput42
        acbOutputs(42) = cbOutput43
        acbOutputs(43) = cbOutput44
        acbOutputs(44) = cbOutput45
        acbOutputs(45) = cbOutput46
        acbOutputs(46) = cbOutput47
        acbOutputs(47) = cbOutput48
        acbOutputs(48) = cbOutput49
        acbOutputs(49) = cbOutput50
        acbOutputs(50) = cbOutput51
        acbOutputs(51) = cbOutput52
        acbOutputs(52) = cbOutput53
        acbOutputs(53) = cbOutput54
        acbOutputs(54) = cbOutput55
        acbOutputs(55) = cbOutput56
        acbOutputs(56) = cbOutput57
        acbOutputs(57) = cbOutput58
        acbOutputs(58) = cbOutput59
        acbOutputs(59) = cbOutput60
        acbOutputs(60) = cbOutput61
        acbOutputs(61) = cbOutput62
        acbOutputs(62) = cbOutput63
        acbOutputs(63) = cbOutput64
        acbOutputs(64) = cbOutput65
        acbOutputs(65) = cbOutput66
        acbOutputs(66) = cbOutput67
        acbOutputs(67) = cbOutput68
        acbOutputs(68) = cbOutput69
        acbOutputs(69) = cbOutput70
        acbOutputs(70) = cbOutput71
        acbOutputs(71) = cbOutput72
        acbOutputs(72) = cbOutput73
        acbOutputs(73) = cbOutput74
        acbOutputs(74) = cbOutput75
        acbOutputs(75) = cbOutput76
        acbOutputs(76) = cbOutput77
        acbOutputs(77) = cbOutput78
        acbOutputs(78) = cbOutput79
        acbOutputs(79) = cbOutput80
        acbOutputs(80) = cbOutput81
        acbOutputs(81) = cbOutput82
        acbOutputs(82) = cbOutput83
        acbOutputs(83) = cbOutput84
        acbOutputs(84) = cbOutput85
        acbOutputs(85) = cbOutput86
        acbOutputs(86) = cbOutput87
        acbOutputs(87) = cbOutput88
        acbOutputs(88) = cbOutput89
        acbOutputs(89) = cbOutput90
        acbOutputs(90) = cbOutput91
        acbOutputs(91) = cbOutput92
        acbOutputs(92) = cbOutput93
        acbOutputs(93) = cbOutput94
        acbOutputs(94) = cbOutput95
        acbOutputs(95) = cbOutput96
        acbOutputs(96) = cbOutput97
        acbOutputs(97) = cbOutput98
        acbOutputs(98) = cbOutput99
        acbOutputs(99) = cbOutput100
        acbOutputs(100) = cbOutput101
        acbOutputs(101) = cbOutput102
        acbOutputs(102) = cbOutput103
        acbOutputs(103) = cbOutput104
        acbOutputs(104) = cbOutput105
        acbOutputs(105) = cbOutput106
        acbOutputs(106) = cbOutput107
        acbOutputs(107) = cbOutput108
        acbOutputs(108) = cbOutput109
        acbOutputs(109) = cbOutput110
        acbOutputs(110) = cbOutput111
        acbOutputs(111) = cbOutput112
        acbOutputs(112) = cbOutput113
        acbOutputs(113) = cbOutput114
        acbOutputs(114) = cbOutput115
        acbOutputs(115) = cbOutput116
        acbOutputs(116) = cbOutput117
        acbOutputs(117) = cbOutput118
        acbOutputs(118) = cbOutput119
        acbOutputs(119) = cbOutput120
        acbOutputs(120) = cbOutput121
        acbOutputs(121) = cbOutput122
        acbOutputs(122) = cbOutput123
        acbOutputs(123) = cbOutput124
        acbOutputs(124) = cbOutput125
        acbOutputs(125) = cbOutput126
        acbOutputs(126) = cbOutput127
        acbOutputs(127) = cbOutput128

        'Setup dynamic measurement GUI
        acbDynProbeUsed(0) = cbDynProbeUsedT1
        acbDynProbeUsed(1) = cbDynProbeUsedT2
        acbDynProbeUsed(2) = cbDynProbeUsedT3
        acbDynProbeUsed(3) = cbDynProbeUsedT4
        acbDynProbeUsed(4) = cbDynProbeUsedT5
        acbDynProbeUsed(5) = cbDynProbeUsedT6
        acbDynProbeUsed(6) = cbDynProbeUsedT7
        acbDynProbeUsed(7) = cbDynProbeUsedT8
        acbDynProbeUsed(8) = cbDynProbeUsedT9
        acbDynProbeUsed(9) = cbDynProbeUsedT10
        acbDynProbeUsed(10) = cbDynProbeUsedT11
        acbDynProbeUsed(11) = cbDynProbeUsedT12
        acbDynProbeUsed(12) = cbDynProbeUsedT13
        acbDynProbeUsed(13) = cbDynProbeUsedT14
        acbDynProbeUsed(14) = cbDynProbeUsedT15
        acbDynProbeUsed(15) = cbDynProbeUsedT16
        acbDynProbeUsed(16) = cbDynProbeUsedT17
        acbDynProbeUsed(17) = cbDynProbeUsedT18
        acbDynProbeUsed(18) = cbDynProbeUsedT19
        acbDynProbeUsed(19) = cbDynProbeUsedT20
        acbDynProbeUsed(20) = cbDynProbeUsedT21
        acbDynProbeUsed(21) = cbDynProbeUsedT22
        acbDynProbeUsed(22) = cbDynProbeUsedT23
        acbDynProbeUsed(23) = cbDynProbeUsedT24
        acbDynProbeUsed(24) = cbDynProbeUsedT25
        acbDynProbeUsed(25) = cbDynProbeUsedT26
        acbDynProbeUsed(26) = cbDynProbeUsedT27
        acbDynProbeUsed(27) = cbDynProbeUsedT28
        acbDynProbeUsed(28) = cbDynProbeUsedT29
        acbDynProbeUsed(29) = cbDynProbeUsedT30
        acbDynProbeUsed(30) = cbDynProbeUsedT31
        acbDynProbeUsed(31) = cbDynProbeUsedT32
        For I = 0 To (N_DYN_CHANNELS_MAX - 1)
            cbDynPositionTrgChannel.Items.Add(String.Format("T{0}", I + 1))
            abDynChannelsUsed(I) = False
        Next
        cbDynPositionTrgChannel.SelectedIndex = 0


        'Try to load the Irinos MscDll
        cIrinos = New cl_Irinos
        Try
            cIrinos.F_MSC_GetVersion(ApiVers, DllVers)
            str = String.Format("MscDll loaded successfully: DLL-Api V{0}.{1}, DLL V{2}.{3}", _
                                ApiVers >> 16, _
                                ApiVers And &HFFFF, _
                                DllVers >> 16, _
                                DllVers And &HFFFF)
            strHeader = String.Format("DLL-Api V{0}.{1}, DLL V{2}.{3}", _
                                ApiVers >> 16, _
                                ApiVers And &HFFFF, _
                                DllVers >> 16, _
                                DllVers And &HFFFF)
            AddHistoryEntry(str, False)
        Catch ex As Exception
            strHeader = ""
            AddHistoryEntry("Failed to load the MscDll. In same directory as the exe?", True)
        End Try
        Me.Text = "MscDll Demo V1.0.0 # " + strHeader

        tmrUpdateStatic.Enabled = True
    End Sub



    '******************************************************************************
    ' FUNCTION: btnConnect_Click
    '-----------------------------------------------------------------------------
    ' "Click" event of button "Connect".
    ' - Try to connect to the Irinos system vai the MscDll.
    ' - If connection has been established successfully, start reading
    '   "static measurement values", "Bit I/O" and "hardware status" continuously.
    '   If new data is available for one of these three, a windows message will
    '   be send to this form. See function WndProc for message handling.
    '*****************************************************************************/
    Private Sub btnConnect_Click(sender As System.Object, e As System.EventArgs) Handles btnConnect.Click
        Dim str As String
        Dim cDt As DateTime = DateTime.Now

        If (cIrinos.eConnStat = cl_Irinos.E_CONNECT_STATUS.cscConnectionClosed) Or (cIrinos.eConnStat = cl_Irinos.E_CONNECT_STATUS.cscUndefined) Then
            AddHistoryEntry("Trying to establish connection.", False)
            Application.DoEvents()

            If cIrinos.ConnectIrinos <> cl_Irinos.E_CONNECT_STATUS.cscCommStarted Then
                str = "Failed to establish connection (" + cIrinos.eConnStat.ToString + ")."
                AddHistoryEntry(str, True)
            Else
                AddHistoryEntry("Connection established successfully.", False)

                'Set absolute date/time. This is not requires, but if the Irinos system knows the
                'current time, diagnosis memory entries will show the absolute date/time.
                str = "#1;" + cDt.Year.ToString + ";" + cDt.Month.ToString + ";" + cDt.Day.ToString + ";" + cDt.Hour.ToString + ";" + cDt.Minute.ToString + ";" + cDt.Second.ToString + ";" + cDt.Millisecond.ToString + "#"
                cIrinos.WriteCommandStr(cl_Irinos.E_MSC_OPCODES.opcSAbsT, str)

                '----> It is recommended to read the system string from the Irinos system
                '      here and to compare it with a reference string.
                '      Since this is a demo program for various systems,
                '      we cannot use a reference string here.
                str = "#1#"
                cIrinos.WriteCommandStr(cl_Irinos.E_MSC_OPCODES.opcRSS, str)
                ' If str <> refstr Then
                '      Do some error handling, e.g. show a message box
                ' End If
                AddHistoryEntry("System string: " + str, False)
                tbSystemString.Text = str
                lbSystemString.Visible = True
                tbSystemString.Visible = True

                'Start reading static measurement values
                cIrinos.SetupStaticChannel(cl_Irinos.E_MSC_OPCODES.opcRS, 1, Me.Handle)

                'Start transferring Bit I/O continuously
                cIrinos.SetupStaticChannel(cl_Irinos.E_MSC_OPCODES.opcBIO, (INOUT_BITS / 8), Me.Handle)

                'Start reading hardware status continuously
                cIrinos.SetupStaticChannel(cl_Irinos.E_MSC_OPCODES.opcRHS, 1, Me.Handle)
            End If
        Else
            If cIrinos.StopAndClose = True Then
                AddHistoryEntry("Connection closed", False)
            End If
        End If
    End Sub



    '******************************************************************************
    ' FUNCTION: WndProc
    '-----------------------------------------------------------------------------
    ' This function is called when the form receives a new windows message.
    ' All messages from the MscDll are filtered out and processed. All other
    ' messages are forwarded to the respective form message function
    ' MyBase.WndProc(recWinMessage).
    '*****************************************************************************/
    Protected Overrides Sub WndProc(ByRef recWinMessage As System.Windows.Forms.Message)
        Select Case recWinMessage.Msg
            Case cl_Irinos.WM_USER
                If recWinMessage.WParam = 10 Then
                    ' Set marker, that new static measurement values are available.
                    ' This marker will be checked in a timer event routine (tmrUpdateStatic_Tick).
                    ' If it is set, GUI data is updated. This procedure is Thread-safe.
                    bNewStaticMeasurementValuesAvailable = True
                    ulNStaticMeasurementValueUpdates += 1
                    bTimedOut = False
                ElseIf recWinMessage.WParam = 20 Then
                    bTimedOut = True
                ElseIf recWinMessage.WParam = 30 Then
                    ' Set marker, that new Bit I/O data is available.
                    ' This marker will be checked in a timer event routine (tmrUpdateStatic_Tick).
                    ' If it is set, GUI data is updated. This procedure is Thread-safe.
                    bNewBitIOValuesAvailable = True
                    ulNBitIOValueUpdates += 1
                ElseIf recWinMessage.WParam = 40 Then
                    ' Set marker, that new hardware status data is available.
                    ' This marker will be checked in a timer event routine (tmrUpdateStatic_Tick).
                    ' If it is set, GUI data is updated. This procedure is Thread-safe.
                    bNewHardStatAvailable = True
                    ulNHardStatUpdates += 1
                End If

            Case Else
                'Pass all standard messages to the GUI form. 
                MyBase.WndProc(recWinMessage)
        End Select
    End Sub



    '******************************************************************************
    ' FUNCTION: AddHistoryEntry
    '-----------------------------------------------------------------------------
    ' Add a new line with information for the user in the history-Listbox.
    '-----------------------------------------------------------------------------
    ' PARAMETERS: 
    ' str: String to display in the new line
    ' bError: false -> "only" information
    '         true -> an error occured
    '         So far this parameter is not used. It is intended future
    '         extension of this function. However, when calling this function, 
    '         this parameter should be used as intended.
    '-----------------------------------------------------------------------------
    ' Return: none
    '*****************************************************************************
    Private Sub AddHistoryEntry(ByVal str As String, ByVal bError As Boolean)
        lbHistory.Items.Add(str)
    End Sub


    '******************************************************************************
    ' FUNCTION: tmrUpdateStatic_Tick
    '-----------------------------------------------------------------------------
    ' Event of the timer tmrUpdateStatic. Update the following GUI information:
    ' - Connection status
    ' - Static measurement values (if new data is available)
    ' - Hardware status (if new data is available)
    ' - Bit I/O (inputs if new data is available, outputs always)
    ' Updating the GUI is separated from receiving data by intention in order to
    ' load the GUI thread with updating the GUI and not any other thread.
    '*****************************************************************************
    Private Sub tmrUpdateStatic_Tick(sender As System.Object, e As System.EventArgs) Handles tmrUpdateStatic.Tick
        Dim aslStaticValues(N_STATIC_CHANNELS) As Int32
        Dim aucHardStat(N_STATIC_CHANNELS) As Byte
        Dim aucBitInData((INOUT_BITS / 8) * 2) As Byte
        Dim aucBitOutData((INOUT_BITS / 8) - 1) As Byte
        Dim ulByteNr As UInt32 = 0
        Dim ulBitNr As UInt32 = 0
        Dim ucBitMask As Byte = 0
        Dim slColumn As Integer = 0
        Dim slRow As Integer = 0

        'Update connection state in status bar
        If bTimedOut = True Then
            toolStripStatusLabelConnection.Text = "Timeout"
            toolStripStatusLabelConnection.BackColor = Color.Yellow
        Else
            Select Case cIrinos.eConnStat
                Case cl_Irinos.E_CONNECT_STATUS.cscTryConnect
                    toolStripStatusLabelConnection.Text = "Trying to connect"
                    toolStripStatusLabelConnection.BackColor = Color.Yellow
                Case cl_Irinos.E_CONNECT_STATUS.cscNoDevices
                    toolStripStatusLabelConnection.Text = "No devices found"
                    toolStripStatusLabelConnection.BackColor = Color.Yellow
                Case cl_Irinos.E_CONNECT_STATUS.cscNoDeviceInfo
                    toolStripStatusLabelConnection.Text = "No device information available"
                    toolStripStatusLabelConnection.BackColor = Color.Yellow
                Case cl_Irinos.E_CONNECT_STATUS.cscConnected
                    toolStripStatusLabelConnection.Text = "Connection established, communication not yet active"
                    toolStripStatusLabelConnection.BackColor = Color.Yellow
                Case cl_Irinos.E_CONNECT_STATUS.cscConnectionClosed
                    toolStripStatusLabelConnection.Text = "Connection closed"
                    toolStripStatusLabelConnection.BackColor = Color.Yellow
                Case cl_Irinos.E_CONNECT_STATUS.cscNoDeviceOpen
                    toolStripStatusLabelConnection.Text = "Failed to open device"
                    toolStripStatusLabelConnection.BackColor = Color.Yellow
                Case cl_Irinos.E_CONNECT_STATUS.cscInitDone
                    toolStripStatusLabelConnection.Text = "Initialization done"
                    toolStripStatusLabelConnection.BackColor = Color.Yellow
                Case cl_Irinos.E_CONNECT_STATUS.cscInitFailed
                    toolStripStatusLabelConnection.Text = "Initialization failed"
                    toolStripStatusLabelConnection.BackColor = Color.Yellow
                Case cl_Irinos.E_CONNECT_STATUS.cscCommStarted
                    toolStripStatusLabelConnection.Text = "Communication started"
                    toolStripStatusLabelConnection.BackColor = Color.MediumAquamarine
                Case cl_Irinos.E_CONNECT_STATUS.cscCommFailed
                    toolStripStatusLabelConnection.Text = "Establishing communication failed"
                    toolStripStatusLabelConnection.BackColor = Color.Yellow
                Case cl_Irinos.E_CONNECT_STATUS.cscUndefined
                    toolStripStatusLabelConnection.Text = "."
                    toolStripStatusLabelConnection.BackColor = Color.WhiteSmoke
                Case Else
                    toolStripStatusLabelConnection.Text = "Unknown state"
                    toolStripStatusLabelConnection.BackColor = Color.Red
            End Select
        End If

        'Update Text of Button "Connect" according to connection state
        If cIrinos.eConnStat = cl_Irinos.E_CONNECT_STATUS.cscCommStarted Then
            btnConnect.Text = "Disconnect"
        Else
            btnConnect.Text = "Connect"
        End If



        'Update static measurement values (if new values are available).
        If bNewStaticMeasurementValuesAvailable = True Then
            bNewStaticMeasurementValuesAvailable = False

            cIrinos.GetStaticMeasurementValues(aslStaticValues)
            For I = 0 To (N_STATIC_CHANNELS - 1)
                albStaticValues(I).Text = aslStaticValues(I).ToString
            Next
            lbStaticUpdates.Text = ulNStaticMeasurementValueUpdates.ToString + " measurement value updates"
        End If



        'Update hardware status
        If bNewHardStatAvailable = True Then
            bNewHardStatAvailable = False

            cIrinos.GetHardStat(aucHardStat)
            For I = 0 To (N_STATIC_CHANNELS - 1)
                albHardStat(I).Text = String.Format("0x{0:X2}", aucHardStat(I))
                ' The hardware status is a bitfield per channel. The content of the
                ' bitfield depends on the channel type (e.g. inductive probe,
                ' incremental encoder, ...).
                ' In the following example, the hardware status is evaluated for
                ' incremental encoders and inductive probes. In your software, you
                ' should distinquish between the different channel types. */
                If (aucHardStat(I) And &HDF) = 0 Then
                    albHardStat(I).ForeColor = Color.Black
                Else
                    albHardStat(I).ForeColor = Color.Red
                End If
            Next
            lbHardStatUpdates.Text = ulNHardStatUpdates.ToString + " hardware status updates"
        End If


        'Update Bit inputs (if new values are available).
        If bNewBitIOValuesAvailable = True Then
            bNewBitIOValuesAvailable = False

            cIrinos.GetBitIO(aucBitInData)
            For I As UInt32 = 0 To (INOUT_BITS - 1)
                ulBitNr = I Mod 8
                ulByteNr = (INOUT_BITS / 8) + ((I - ulBitNr) / 8)
                ucBitMask = 1 << ulBitNr
                slRow = I Mod 16
                slColumn = (I - slRow) / 16
                dataGridViewInputs.Item(slColumn, slRow).Value = ((aucBitInData(ulByteNr) And ucBitMask) = ucBitMask)
            Next
            lbBitIOUpdates.Text = ulNBitIOValueUpdates.ToString + " Bit I/O updates"
        End If

        'Update Bit outputs
        For I As UInt32 = 0 To (INOUT_BITS - 1)
            ulBitNr = I Mod 8
            ulByteNr = (I - ulBitNr) / 8
            ucBitMask = 1 << ulBitNr
            If acbOutputs(I).Checked = True Then
                aucBitOutData(ulByteNr) = aucBitOutData(ulByteNr) Or ucBitMask
            Else
                aucBitOutData(ulByteNr) = aucBitOutData(ulByteNr) And (Not ucBitMask)
            End If
        Next
        cIrinos.RefreshOutputs(aucBitOutData)
    End Sub


    '******************************************************************************
    ' FUNCTION: Form1_FormClosing
    '-----------------------------------------------------------------------------
    ' "OnClose" event of the form.
    ' -> Disconnect the Irinos system (if connected) and close dll handle.
    '    (If the connection is not closed via this function and a connection
    '    remains established, an exception can occur.)
    '*****************************************************************************
    Private Sub Form1_FormClosing(sender As System.Object, e As System.Windows.Forms.FormClosingEventArgs) Handles MyBase.FormClosing
        cIrinos.StopAndClose()
    End Sub


    '******************************************************************************
    ' FUNCTION: btnDynTimeStart_Click
    '-----------------------------------------------------------------------------
    ' Start a time-based dynamic measurement with channel list 1, Trigger 1 and
    ' dynamic measurement 1.
    ' The following steps are performed:
    ' 1. Create a channel list of the used channels and send it to the Irinos
    '    system. (Use only the required channels to reduce memory and
    '    communication bandwidth consumption.)
    ' 2. Make sure trigger 1 is disabled.
    ' 3. Define / configure trigger 1 for time-based measurement.
    ' 4. Define the dynamic measurement.
    ' 5. Assign a buffer for the measurement values. The DLL will write received
    '    values directly into this buffer.
    ' 6. Activate Trigger 1 to start the measurement.
    ' NOTE: Time- and position-based measurement differ only in
    '       trigger configuration (step 3).
    '*****************************************************************************
    Private Sub btnDynTimeStart_Click(sender As System.Object, e As System.EventArgs) Handles btnDynTimeStart.Click
        Dim str As String
        Dim bStatus As Boolean = True

        ulDynChannels = 0
        btnDynValuesStore.Enabled = False
        tmrUpdateDynMeas.Enabled = False

        ' ###
        ' Create channel list for dynamic measurement and send it to the Irinos system.
        ' In this example channel list 1 is used. Any of the other channel lists (2..10)
        ' could also be used.
        str = "#1"
        For I = 0 To (N_DYN_CHANNELS_MAX - 1)
            abDynChannelsUsed(I) = acbDynProbeUsed(I).Checked
            If abDynChannelsUsed(I) = True Then
                str = str & String.Format(";T{0}", I + 1)
                ulDynChannels = ulDynChannels + 1
            End If
        Next
        str = str & "#"

        If ulDynChannels = 0 Then
            AddHistoryEntry("Dynamic measurement: no measurement channel selected", True)
            bStatus = False
        Else
            ' Send channel list to the Irinos system and check response string.
            cIrinos.WriteCommandStr(cl_Irinos.E_MSC_OPCODES.opcWCL, str)
            If String.Compare("#0#", str, False) = 0 Then
                AddHistoryEntry("Dynamic measurement: channel list 1 written successfully.", False)
            Else
                bStatus = False
                AddHistoryEntry("Dynamic measurement: failed to write channel list 1: " & str, True)
            End If
        End If

        ' ###
        ' Inactivate Trigger 1 (in case it is already running)
        If bStatus = True Then
            str = "#1#"
            cIrinos.WriteCommandStr(cl_Irinos.E_MSC_OPCODES.opcIT, str)
            If String.Compare("#0#", str, False) <> 0 Then
                bStatus = False
                AddHistoryEntry("Dynamic measurement: failed to inactivate trigger 1: " & str, True)
            End If
        End If

        ' ###
        ' Define / configure trigger.
        ' In this example trigger 1 is used. Alternatively trigger 2 could be used as well.
        If bStatus = True Then
            If rbDynTime100us.Checked = True Then
                str = "#1;T;*;1;0.1;*;*#"
            ElseIf rbDynTime1ms.Checked = True Then
                str = "#1;T;*;1;1;*;*#"
            Else
                str = "#1;T;*;1;10;*;*#"
            End If
            cIrinos.WriteCommandStr(cl_Irinos.E_MSC_OPCODES.opcDT, str)
            If String.Compare("#0#", str) = 0 Then
                AddHistoryEntry("Dynamic measurement: Trigger 1 defined successfully", False)
            Else
                bStatus = False
                AddHistoryEntry("Dynamic measurement: Failed to define Trigger 1: " & str, True)
            End If
        End If

        ' ###
        ' Define dynamic measurement.
        ' In this example dynamic measurement 1 is used. Alternatively dynamic measurement 2 could be used.
        ' They can further be used/active in parallel.
        If bStatus = True Then
            str = "#1;1;1;" & nudDynTimeNValues.Value.ToString & "#"
            cIrinos.WriteCommandStr(cl_Irinos.E_MSC_OPCODES.opcDDM1, str)
            If String.Compare("#0#", str) = 0 Then
                AddHistoryEntry("Dynamic measurement 1 defined successfully.", False)
            Else
                bStatus = False
                AddHistoryEntry("Dynamic measurement 1: Failed to define dynamic measurement: " & str, True)
            End If
        End If

        ' ###
        ' Create buffer for measurement values
        If bStatus = True Then
            bStatus = cIrinos.SetupDynamicChannel(cl_Irinos.E_MSC_OPCODES.opcRDM1, CUInt(nudDynTimeNValues.Value), ulDynChannels)
            If bStatus = False Then
                AddHistoryEntry("Dynamic measurement: Failed to create receive buffer", True)
            End If
        End If

        ' ###
        ' Activate trigger 1. This will start the dynamic measurement.
        If bStatus = True Then
            str = "#1#"
            cIrinos.WriteCommandStr(cl_Irinos.E_MSC_OPCODES.opcAT, str)
            If String.Compare("#0#", str, False) = 0 Then
                AddHistoryEntry("Dynamic measurement: Trigger 1 activeted successfully", False)
            Else
                bStatus = False
                AddHistoryEntry("Dynamic measurement: Failed to activate trigger 1: " & str, True)
            End If
        End If

        ' ###
        ' Start timer for updating status and number of values received.
        If bStatus = True Then
            tmrUpdateDynMeas.Enabled = True
        End If
    End Sub


    '******************************************************************************
    ' FUNCTION: btnDynPosStart_Click
    '-----------------------------------------------------------------------------
    ' Start a position-based dynamic measurement with channel list 1, Trigger 1 and
    ' dynamic measurement 1.
    ' The following steps are performed:
    ' 1. Create a channel list of the used channels and send it to the Irinos
    '    system. (Use only the required channels to reduce memory and
    '    communication bandwidth consumption.)
    ' 2. Make sure trigger 1 is disabled.
    ' 3. Define / configure trigger 1 for position-based measurement.
    ' 4. Define the dynamic measurement.
    ' 5. Assign a buffer for the measurement values. The DLL will write received
    '    values directly into this buffer.
    ' 6. Activate Trigger 1 to start the measurement.
    ' NOTE: Time- and position-based measurement differ only in
    '       trigger configuration (step 3).
    '*****************************************************************************
    Private Sub btnDynPosStart_Click(sender As System.Object, e As System.EventArgs) Handles btnDynPosStart.Click
        Dim str As String = ""
        Dim bStatus As Boolean = True

        ulDynChannels = 0
        btnDynValuesStore.Enabled = False
        tmrUpdateDynMeas.Enabled = False

        ' ###
        ' Create channel list for dynamic measurement and send it to the Irinos system.
        ' In this example channel list 1 is used. Any of the other channel lists (2..10)
        ' could also be used.
        str = "#1"
        For I = 0 To (N_DYN_CHANNELS_MAX - 1)
            abDynChannelsUsed(I) = acbDynProbeUsed(I).Checked
            If abDynChannelsUsed(I) = True Then
                str = str & String.Format(";T{0}", I + 1)
                ulDynChannels = ulDynChannels + 1
            End If
        Next
        str = str & "#"

        If ulDynChannels = 0 Then
            AddHistoryEntry("Dynamic measurement: no measurement channel selected", True)
            bStatus = False
        Else
            ' Send channel list to the Irinos system and check response string.
            cIrinos.WriteCommandStr(cl_Irinos.E_MSC_OPCODES.opcWCL, str)
            If String.Compare("#0#", str, False) = 0 Then
                AddHistoryEntry("Dynamic measurement: channel list 1 written successfully.", False)
            Else
                bStatus = False
                AddHistoryEntry("Dynamic measurement: failed to write channel list 1: " & str, True)
            End If
        End If

        ' ###
        ' Inactivate Trigger 1 (in case it is already running)
        If bStatus = True Then
            str = "#1#"
            cIrinos.WriteCommandStr(cl_Irinos.E_MSC_OPCODES.opcIT, str)
            If String.Compare("#0#", str, False) <> 0 Then
                bStatus = False
                AddHistoryEntry("Dynamic measurement: failed to inactivate trigger 1: " & str, True)
            End If
        End If

        ' ###
        ' Define / configure trigger.
        ' In this example trigger 1 is used. Alternatively trigger 2 could be used as well.
        If bStatus = True Then
            str = "#1;P;" + cbDynPositionTrgChannel.Text & ";" & _
               nudDynPosDivisor.Value.ToString() & ";" & _
               nuDynPosTriggerDistance.Value.ToString() & ";" & _
               nuDynPosTriggerStart.Value.ToString() & ";" & _
               nuDynPosTriggerStop.Value.ToString() & "#"
            cIrinos.WriteCommandStr(cl_Irinos.E_MSC_OPCODES.opcDT, str)
            If String.Compare("#0#", str) = 0 Then
                AddHistoryEntry("Dynamic measurement: Trigger 1 defined successfully", False)
            Else
                bStatus = False
                AddHistoryEntry("Dynamic measurement: Failed to define Trigger 1: " & str, True)
            End If
        End If

        ' ###
        ' Define dynamic measurement.
        ' In this example dynamic measurement 1 is used. Alternatively dynamic measurement 2 could be used.
        ' They can further be used/active in parallel.
        If bStatus = True Then
            str = "#1;1;1;" & nudDynPositionNValues.Value.ToString & "#"
            cIrinos.WriteCommandStr(cl_Irinos.E_MSC_OPCODES.opcDDM1, str)
            If String.Compare("#0#", str) = 0 Then
                AddHistoryEntry("Dynamic measurement 1 defined successfully.", False)
            Else
                bStatus = False
                AddHistoryEntry("Dynamic measurement 1: Failed to define dynamic measurement: " & str, True)
            End If
        End If

        ' ###
        ' Create buffer for measurement values
        If bStatus = True Then
            bStatus = cIrinos.SetupDynamicChannel(cl_Irinos.E_MSC_OPCODES.opcRDM1, CUInt(nudDynPositionNValues.Value), ulDynChannels)
            If bStatus = False Then
                AddHistoryEntry("Dynamic measurement: Failed to create receive buffer", True)
            End If
        End If

        ' ###
        ' Activate trigger 1. This will start the dynamic measurement.
        If bStatus = True Then
            str = "#1#"
            cIrinos.WriteCommandStr(cl_Irinos.E_MSC_OPCODES.opcAT, str)
            If String.Compare("#0#", str, False) = 0 Then
                AddHistoryEntry("Dynamic measurement: Trigger 1 activeted successfully", False)
            Else
                bStatus = False
                AddHistoryEntry("Dynamic measurement: Failed to activate trigger 1: " & str, True)
            End If
        End If

        ' ###
        ' Start timer for updating status and number of values received.
        If bStatus = True Then
            tmrUpdateDynMeas.Enabled = True
        End If
    End Sub


    '******************************************************************************
    ' FUNCTION: tmrUpdateDynMeas_Tick
    '-----------------------------------------------------------------------------
    ' Event of the timer tmrUpdateDynMeas. Update the following GUI information:
    ' - Amount of dynamic measurement data received.
    ' - Dynamic measurement status
    '*****************************************************************************
    Private Sub tmrUpdateDynMeas_Tick(sender As System.Object, e As System.EventArgs) Handles tmrUpdateDynMeas.Tick
        Dim ulPosition As UInt32 = 0
        Dim ulValPerChannel As UInt32 = 0
        Dim ulValTotal As UInt32 = 0
        Dim ulBytesTotal As UInt32 = 0
        Dim aucSendBuf() As Byte = {0}
        Dim aucReceiveBuf() As Byte = {0, 0, 0, 0}
        Dim ulReceiveSize As UInt32 = 0
        Dim ulStatusWord As UInt32 = 0

        'Update the number of values/bytes received for the dynamic measurement
        If cIrinos.GetDynBytesReceived(cl_Irinos.E_MSC_OPCODES.opcRDM1, ulPosition) = True Then
            ulValPerChannel = ulPosition / 4
            ulValTotal = ulPosition / 4 * ulDynChannels
            ulBytesTotal = ulPosition * ulDynChannels
            lbDynValuesPerChannelReceived.Text = String.Format("{0} values per channel received", ulValPerChannel)
            lbDynBytesPerChannelReceived.Text = String.Format("{0} bytes per channel received", ulPosition)
            lbDynValuesReceived.Text = String.Format("{0} values received", ulValTotal)
            lbDynBytesReceived.Text = String.Format("{0} bytes received", ulBytesTotal)

            If ulPosition > 0 Then
                btnDynValuesStore.Enabled = True
            Else
                btnDynValuesStore.Enabled = False
            End If
        End If

        'Update measurement status
        If cIrinos.WriteCommand(cl_Irinos.E_MSC_OPCODES.opcRSW, aucSendBuf, aucReceiveBuf, ulReceiveSize) = True Then
            ulStatusWord = aucReceiveBuf(0) And &HFF
            ulStatusWord = ulStatusWord Or ((aucReceiveBuf(1) << 8) And &HFF00)
            ulStatusWord = ulStatusWord Or ((aucReceiveBuf(2) << 16) And &HFF0000)
            ulStatusWord = ulStatusWord Or ((aucReceiveBuf(3) << 24) And &HFF000000)
            cbDynTrg1Active.Checked = ((ulStatusWord And &H1) = &H1)
            cbDynTrg1WasActive.Checked = ((ulStatusWord And &H2) = &H2)
            cbDynTrg1EventOccured.Checked = ((ulStatusWord And &H4) = &H4)
            cbDyn1Active.Checked = ((ulStatusWord And &H10) = &H10)
            cbDyn1WasActive.Checked = ((ulStatusWord And &H20) = &H20)
            cbDyn1ValueStored.Checked = ((ulStatusWord And &H40) = &H40)
            cbDyn1ReadActive.Checked = ((ulStatusWord And &H80) = &H80)
            cbDyn1BufferFull.Checked = ((ulStatusWord And &H100) = &H100)
        End If
    End Sub


    '******************************************************************************
    ' FUNCTION: btnDynValuesStore_Click
    '-----------------------------------------------------------------------------
    ' Event is fired when the button "Store to DynValues.csv" is clicked.
    ' Read dynamic measurement values from the buffer and store them into a
    ' ";" separated *.csv-file.
    ' The *.csv-file can be opened with MS Excel.
    '*****************************************************************************
    Private Sub btnDynValuesStore_Click(sender As System.Object, e As System.EventArgs) Handles btnDynValuesStore.Click
        Dim strPath As String = System.IO.Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().Location)
        Dim str As String = ""
        Dim ulCtr As UInt32 = 0
        Dim ulPosition As UInt32 = 0
        Dim slValue As Int32 = 0

        Try
            'Create file path. DynValues.csv will be stored in the same
            'directory as the *.exe-File of the application
            strPath = strPath & "\DynValues.csv"
            Dim cStreamWriter As System.IO.StreamWriter = System.IO.File.CreateText(strPath)

            'Write header line
            str = ""
            For I = 0 To (N_DYN_CHANNELS_MAX - 1)
                If abDynChannelsUsed(I) = True Then
                    If ulCtr > 0 Then
                        str = str & ";"
                    End If
                    str = str & String.Format("T{0}", I + 1)
                    ulCtr = ulCtr + 1
                End If
            Next
            cStreamWriter.WriteLine(str)

            'Write measurement values
            cIrinos.GetDynBytesReceived(cl_Irinos.E_MSC_OPCODES.opcRDM1, ulPosition)
            ulPosition = ulPosition / 4
            For I = 0 To (ulPosition - 1)
                str = ""
                For J = 0 To (ulDynChannels - 1)
                    If J > 0 Then
                        str = str & ";"
                    End If
                    slValue = -2147483647
                    cIrinos.GetDynValue(cl_Irinos.E_MSC_OPCODES.opcRDM1, I, J, slValue)
                    str = str & String.Format("{0}", slValue)
                Next
                cStreamWriter.WriteLine(str)
            Next

            cStreamWriter.Close()

            str = "Dynamic measurement values successfully written to " & strPath & "."
            AddHistoryEntry(str, False)
        Catch ex As Exception
            str = "Dynamic measurement: cannot write DynValues.csv (" & ex.Message & ")."
            AddHistoryEntry(str, True)
        End Try

        MessageBox.Show(str, "Store dynamic measurement values")
    End Sub

End Class
