﻿Public Class cl_MscDll
    Public Const MSC_MAX_UNIQUEID_SIZE = 40

    'Function return codes (MSC_STATUS)
    Public Const MSC_STATUS_SUCCESS = &H0                       'no error detected
    Public Const MSC_STATUS_FAILED = &HF0000001                 'general error
    Public Const MSC_STATUS_INVALID_HANDLE = &HF0000002         'call an invalid handle
    Public Const MSC_STATUS_INVALID_PARAMS = &HF0000003         'invalid parameter 
    Public Const MSC_STATUS_NO_RESOURCES = &HF0000004           'no resources for creation
    Public Const MSC_STATUS_NO_DEVICES = &HF0000005             'no device found
    Public Const MSC_STATUS_NOT_INITIALIZED = &HF0000006        'member not initialzed
    Public Const MSC_STATUS_ALREADY_INITIALIZED = &HF0000007    'cfi interface is already initialzed, repeated call
    Public Const MSC_STATUS_INVALID_OBJECT_TYPE = &HF0000008    'handle identifies an invalid object type, handle is invalid for this function call
    Public Const MSC_STATUS_INVALID_CHANNEL_TYPE = &HF0000009   'channel don't have the correct type for this function
    Public Const MSC_STATUS_DEVICE_DISCONNECTED = &HF0000010    'device disconnected, disconnect timeout passed
    Public Const MSC_STATUS_FUNCTION_NOT_ALLOWED = &HF0000100   'function not allowed at time
    Public Const MSC_STATUS_NO_DATA_AVAILABLE = &HF0000200      'no data available
    Public Const MSC_STATUS_NO_MORE_DATA = &HF0000400           'no more data
    Public Const MSC_STATUS_BUFFER_TO_SHORT = &HF0000401        'buffer too short

    'errors specific for USB FTDI part
    Public Const MSC_STATUS_INVALID_ENDPOINT = &HF0000800       'invalid endpoint
    Public Const MSC_STATUS_NOT_CONFIGERED = &HF0000801         'pipe was is not configured
    Public Const MSC_STATUS_ALREADY_RUNNING = &HF0000802        'thread is already started
    Public Const MSC_STATUS_THREAD_NOT_STARTED = &HF0000803     'thread cannot be started

    Public Const MSC_STATUS_NOT_COMPLETED = &HF000FFFE          'function not completed
    Public Const MSC_STATUS_NOT_IMPLEMENTED = &HF000FFFF        'function not implemented

    Public Declare Sub F_MSC_GetVersion Lib "MSCDLL.DLL" Alias "MSC_GetVersion" (ByRef ApiVersion As UInt32,
                                                                                 ByRef DllVersion As UInt32)
    Public Declare Function F_MSC_EnumerateDevices Lib "MSCDLL.DLL" Alias "MSC_EnumerateDevices" (ByRef DeviceNumber As UInt32) As UInt32
    Public Declare Function F_MSC_GetDeviceInfo Lib "MSCDLL.DLL" Alias "MSC_GetDeviceInfo" (ByVal Index As UInt32,
                                                                                            ByRef BusType As UInt32,
                                                                                            ByRef UniqueID As Byte) As UInt32
    Public Declare Function F_MSC_OpenDevice Lib "MSCDLL.DLL" Alias "MSC_OpenDevice" (ByVal Index As UInt32,
                                                                                      ByRef Handle As UInt32) As UInt32
    Public Declare Function F_MSC_InitDevice Lib "MSCDLL.DLL" Alias "MSC_InitDevice" (ByVal Handle As UInt32) As UInt32
    Public Declare Function F_MSC_CloseDevice Lib "MSCDLL.DLL" Alias "MSC_CloseDevice" (ByVal Handle As UInt32) As UInt32
    Public Declare Function F_MSC_SetNotificationMessage Lib "MSCDLL.DLL" Alias "MSC_SetNotificationMessage" (ByVal Handle As UInt32,
                                                                                                              ByVal OpCode As Int32,
                                                                                                              ByVal hWnd As IntPtr,
                                                                                                              ByVal MsgCode As UInt32,
                                                                                                              ByVal wParam As UInt32,
                                                                                                              ByVal lParam As UInt32) As UInt32
    Public Declare Function F_MSC_Start Lib "MSCDLL.DLL" Alias "MSC_Start" (ByVal Handle As UInt32,
                                                                            ByVal SndPeriod As UInt32,
                                                                            ByVal DisconnectTimeout As UInt32,
                                                                            ByVal RetryCount As UInt32,
                                                                            ByVal RespondsTimeout As UInt32) As UInt32
    Public Declare Function F_MSC_Stop Lib "MSCDLL.DLL" Alias "MSC_Stop" (ByVal Handle As UInt32) As UInt32
    Public Declare Function F_MSC_WriteCommand Lib "MSCDLL.DLL" Alias "MSC_WriteCommand" (ByVal Handle As UInt32,
                                                                                          ByVal OpCode As Byte,
                                                                                          ByVal SndBufferSize As UInt32,
                                                                                          ByVal pucBuffer As UInt32,
                                                                                          ByVal RcvBufferSize As UInt32,
                                                                                          ByVal pucRcvBuffer As UInt32,
                                                                                          ByRef BytesReceived As UInt32,
                                                                                          ByVal Timeout As UInt32) As UInt32
    Public Declare Function F_MSC_SetupStaticChannel Lib "MSCDLL.DLL" Alias "MSC_SetupStaticChannel" (ByVal Handle As UInt32,
                                                                                                      ByVal OpCode As Byte,
                                                                                                      ByVal SndBufferSize As UInt32,
                                                                                                      ByVal pucSndBuffer As UInt32,
                                                                                                      ByVal RcvBufferSize As UInt32) As UInt32
    Public Declare Function F_MSC_SetupExtendedDynamicChannel Lib "MSCDLL.DLL" Alias "MSC_SetupExtendedDynamicChannel" (ByVal Handle As UInt32,
                                                                                                                        ByVal OpCode As Byte,
                                                                                                                        ByVal NumberOfSubChannels As Byte,
                                                                                                                        ByVal SndBufferSize As UInt32,
                                                                                                                        ByVal pucSndBuffer As UInt32) As UInt32
    Public Declare Function F_MSC_AttachSubChannelBuffer Lib "MSCDLL.DLL" Alias "MSC_AttachSubChannelBuffer" (ByVal Handle As UInt32,
                                                                                                              ByVal OpCode As Byte,
                                                                                                              ByVal SubChannel As Byte,
                                                                                                              ByVal BufferSize As UInt32,
                                                                                                              ByVal pucBuffer As UInt32) As UInt32
    Public Declare Function F_MSC_DetachSubChannelBuffers Lib "MSCDLL.DLL" Alias "MSC_DetachSubChannelBuffers" (ByVal Handle As UInt32,
                                                                                                                ByVal OpCode As Byte) As UInt32
    Public Declare Function F_MSC_RefreshChannel Lib "MSCDLL.DLL" Alias "MSC_RefreshChannel" (ByVal Handle As UInt32,
                                                                                              ByVal OpCode As Byte) As UInt32
    Public Declare Function F_MSC_GetPosition Lib "MSCDLL.DLL" Alias "MSC_GetPosition" (ByVal Handle As UInt32,
                                                                                        ByVal OpCode As Byte,
                                                                                        ByRef Position As UInt32) As UInt32
    Public Declare Function F_MSC_GetDeviceState Lib "MSCDLL.DLL" Alias "MSC_GetDeviceState" (ByVal Handle As UInt32,
                                                                                              ByRef LastMsgReceived As UInt32,
                                                                                              ByRef SndErrorCounter As UInt32,
                                                                                              ByRef RcvErrorCounter As UInt32,
                                                                                              ByRef CmdDiscarded As UInt32,
                                                                                              ByRef CmdDiscardedArray As UInt32,
                                                                                              ByVal Flags As UInt32) As UInt32
    Public Declare Function F_MSC_ReadStatic Lib "MSCDLL.DLL" Alias "MSC_ReadStatic" (ByVal Handle As UInt32,
                                                                                      ByVal OpCode As Byte,
                                                                                      ByVal BufferSize As UInt32,
                                                                                      ByRef Buffer As Byte,
                                                                                      ByRef DataCount As UInt32) As UInt32
    Public Declare Function F_MSC_ReadStatic32 Lib "MSCDLL.DLL" Alias "MSC_ReadStatic" (ByVal Handle As UInt32,
                                                                                        ByVal OpCode As Byte,
                                                                                        ByVal BufferSize As UInt32,
                                                                                        ByRef Buffer As Int32,
                                                                                        ByRef DataCount As UInt32) As UInt32

End Class
