﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.IO;
using System.Windows.Forms;

namespace MscDll_Demo_VCS_2010
{
    public partial class Form1 : Form
    {
        private const int N_STATIC_CHANNELS = 24;   // Number of static channels displayed in this demo-application
        private const int N_DYN_CHANNELS_GUI = 32;  // Maximum number of dynamic channels, which can be selected via the GUI
        private const int N_INOUT_BITS = 128;       // Number of in- and output bits displayed on the GUI
        private const int N_INOUT_GRID_ROWS = 16;   // Rows used in the Bit input grid dataGridViewInputs

        // Class for access to the Irinos-System. Object is created once after startup
        private cl_Irinos cIrinos;

        /* Status-variables between "receiving notification messages from the MscDll"
         * in WndProc and timer-based GUI update in tmrUpdateStatic_Tick. */
        private bool bNewStaticMeasurementValuesAvailable = false;
        private bool bNewBitIOValuesAvailable = false;
        private bool bNewHardStatAvailable = false;
        private int iNStaticMeasurementValueUpdates = 0;
        private int iNBitIOValueUpdates = 0;
        private int iNHardStatUpdates = 0;

        /* Communication timeout flag. Set/Reset after receiving notification messages
         * from the MscDll (see WndProc). */
        private bool bTimedOut = false;

        // Status-variables for current dynamic measurement
        private int iNDynChannelsUsed = 0;
        private bool[] abDynChannelUsed = new bool[N_DYN_CHANNELS_GUI];


        /* List of available measurement channels. This list is retrieved after connecting.
         * This list is not required for your application, but you can use it, if you want to. */
        private cl_IriChannel[] aclChannels = new cl_IriChannel[0];
        

        /* Lists of GUI elements.
         * This is not required, but makes life much easier. Various GUI elements
         * are assigned to these lists once at startup (see Form1_Load). Afterwards
         * they can be accessed in loops via the array index. */
        private System.Windows.Forms.Label[] albStaticValues;
        private System.Windows.Forms.Label[] albHardStat;
        private System.Windows.Forms.CheckBox[] acbOutputs;
        private System.Windows.Forms.CheckBox[] acbDynProbeUsed;


        public Form1()
        {
            InitializeComponent();
        }


        /******************************************************************************
        * FUNCTION: Form1_Load
        *-----------------------------------------------------------------------------
        * "OnLoad" event is fired when the form is loaded.
        * - Initialize class variables.
        * - Assign GUI objects to arrays for easier access in the rest of the code.
        * - Load MscDll.
        ******************************************************************************/
        private void Form1_Load(object sender, EventArgs e)
        {
            string strHeader = "";
            string str = "";

            tbReadme.Text = "This is a demo for the Irinos MscDll. Please note:\r\n\r\n" +
                            "The purpose of this demo is helping software developers to integrate the Irinos-System into their software.\r\n" +
                            "Focus has been put on demonstrating how to use the MscDll.dll. User interface design an error handling are very basic. " +
                            "Integration into your own software probably requires a more sophisticated user interface and extended error handling.\r\n\r\n" +
                            "THIS DEMO COMES WITHOUT ANY WARRANTY OR LIABILITY.\r\n\r\n" +
                            "We strongly recomment to separate the GUI-update and the DLL into different Windows-threads. " +
                            "One way to do this is using Windows messages in combination with a timer, that runs in the GUI thread. " +
                            "In this example this is demonstrated by the combination of T_MSC_SetNotificationMessage, WndProc, " +
                            "and tmrUpdateStatic_Tick.\r\n" +
                            "(The MscDll also supports notification by callback or by event. However, we do not recommend these " +
                            "techniques. Therefore they are not documented. If you need to use them, please contact us.)\r\n\r\n" +
                            "In this demo the MscDll.dll file must be placed in the same directory as the Exe. Further the Msc.cfg " +
                            "file is required in the same directory. The IP-settings in the Msc.cfg file must fit to the IP-Settings " +
                            "of the Irinos-System.\r\n\r\n" +
                            "Messtechnik Sachs GmbH\r\nwww.messtechnik-sachs.de\r\nPhone: +49 7181 99960 0";


            // Setup static measurement GUI
            albStaticValues = new Label[N_STATIC_CHANNELS];
            albStaticValues[0] = lbStaticT1;
            albStaticValues[1] = lbStaticT2;
            albStaticValues[2] = lbStaticT3;
            albStaticValues[3] = lbStaticT4;
            albStaticValues[4] = lbStaticT5;
            albStaticValues[5] = lbStaticT6;
            albStaticValues[6] = lbStaticT7;
            albStaticValues[7] = lbStaticT8;
            albStaticValues[8] = lbStaticT9;
            albStaticValues[9] = lbStaticT10;
            albStaticValues[10] = lbStaticT11;
            albStaticValues[11] = lbStaticT12;
            albStaticValues[12] = lbStaticT13;
            albStaticValues[13] = lbStaticT14;
            albStaticValues[14] = lbStaticT15;
            albStaticValues[15] = lbStaticT16;
            albStaticValues[16] = lbStaticT17;
            albStaticValues[17] = lbStaticT18;
            albStaticValues[18] = lbStaticT19;
            albStaticValues[19] = lbStaticT20;
            albStaticValues[20] = lbStaticT21;
            albStaticValues[21] = lbStaticT22;
            albStaticValues[22] = lbStaticT23;
            albStaticValues[23] = lbStaticT24;
            albHardStat = new Label[N_STATIC_CHANNELS];
            albHardStat[0] = lbHardStat1;
            albHardStat[1] = lbHardStat2;
            albHardStat[2] = lbHardStat3;
            albHardStat[3] = lbHardStat4;
            albHardStat[4] = lbHardStat5;
            albHardStat[5] = lbHardStat6;
            albHardStat[6] = lbHardStat7;
            albHardStat[7] = lbHardStat8;
            albHardStat[8] = lbHardStat9;
            albHardStat[9] = lbHardStat10;
            albHardStat[10] = lbHardStat11;
            albHardStat[11] = lbHardStat12;
            albHardStat[12] = lbHardStat13;
            albHardStat[13] = lbHardStat14;
            albHardStat[14] = lbHardStat15;
            albHardStat[15] = lbHardStat16;
            albHardStat[16] = lbHardStat17;
            albHardStat[17] = lbHardStat18;
            albHardStat[18] = lbHardStat19;
            albHardStat[19] = lbHardStat20;
            albHardStat[20] = lbHardStat21;
            albHardStat[21] = lbHardStat22;
            albHardStat[22] = lbHardStat23;
            albHardStat[23] = lbHardStat24;

            // Setup Bit I/O GUI
            for (int i = 0; i < N_INOUT_GRID_ROWS; i++)
            {
                dataGridViewInputs.Rows.Add();
            }
            acbOutputs = new CheckBox[N_INOUT_BITS];
            acbOutputs[0] = cbOutput1;
            acbOutputs[1] = cbOutput2;
            acbOutputs[2] = cbOutput3;
            acbOutputs[3] = cbOutput4;
            acbOutputs[4] = cbOutput5;
            acbOutputs[5] = cbOutput6;
            acbOutputs[6] = cbOutput7;
            acbOutputs[7] = cbOutput8;
            acbOutputs[8] = cbOutput9;
            acbOutputs[9] = cbOutput10;
            acbOutputs[10] = cbOutput11;
            acbOutputs[11] = cbOutput12;
            acbOutputs[12] = cbOutput13;
            acbOutputs[13] = cbOutput14;
            acbOutputs[14] = cbOutput15;
            acbOutputs[15] = cbOutput16;
            acbOutputs[16] = cbOutput17;
            acbOutputs[17] = cbOutput18;
            acbOutputs[18] = cbOutput19;
            acbOutputs[19] = cbOutput20;
            acbOutputs[20] = cbOutput21;
            acbOutputs[21] = cbOutput22;
            acbOutputs[22] = cbOutput23;
            acbOutputs[23] = cbOutput24;
            acbOutputs[24] = cbOutput25;
            acbOutputs[25] = cbOutput26;
            acbOutputs[26] = cbOutput27;
            acbOutputs[27] = cbOutput28;
            acbOutputs[28] = cbOutput29;
            acbOutputs[29] = cbOutput30;
            acbOutputs[30] = cbOutput31;
            acbOutputs[31] = cbOutput32;
            acbOutputs[32] = cbOutput33;
            acbOutputs[33] = cbOutput34;
            acbOutputs[34] = cbOutput35;
            acbOutputs[35] = cbOutput36;
            acbOutputs[36] = cbOutput37;
            acbOutputs[37] = cbOutput38;
            acbOutputs[38] = cbOutput39;
            acbOutputs[39] = cbOutput40;
            acbOutputs[40] = cbOutput41;
            acbOutputs[41] = cbOutput42;
            acbOutputs[42] = cbOutput43;
            acbOutputs[43] = cbOutput44;
            acbOutputs[44] = cbOutput45;
            acbOutputs[45] = cbOutput46;
            acbOutputs[46] = cbOutput47;
            acbOutputs[47] = cbOutput48;
            acbOutputs[48] = cbOutput49;
            acbOutputs[49] = cbOutput50;
            acbOutputs[50] = cbOutput51;
            acbOutputs[51] = cbOutput52;
            acbOutputs[52] = cbOutput53;
            acbOutputs[53] = cbOutput54;
            acbOutputs[54] = cbOutput55;
            acbOutputs[55] = cbOutput56;
            acbOutputs[56] = cbOutput57;
            acbOutputs[57] = cbOutput58;
            acbOutputs[58] = cbOutput59;
            acbOutputs[59] = cbOutput60;
            acbOutputs[60] = cbOutput61;
            acbOutputs[61] = cbOutput62;
            acbOutputs[62] = cbOutput63;
            acbOutputs[63] = cbOutput64;
            acbOutputs[64] = cbOutput65;
            acbOutputs[65] = cbOutput66;
            acbOutputs[66] = cbOutput67;
            acbOutputs[67] = cbOutput68;
            acbOutputs[68] = cbOutput69;
            acbOutputs[69] = cbOutput70;
            acbOutputs[70] = cbOutput71;
            acbOutputs[71] = cbOutput72;
            acbOutputs[72] = cbOutput73;
            acbOutputs[73] = cbOutput74;
            acbOutputs[74] = cbOutput75;
            acbOutputs[75] = cbOutput76;
            acbOutputs[76] = cbOutput77;
            acbOutputs[77] = cbOutput78;
            acbOutputs[78] = cbOutput79;
            acbOutputs[79] = cbOutput80;
            acbOutputs[80] = cbOutput81;
            acbOutputs[81] = cbOutput82;
            acbOutputs[82] = cbOutput83;
            acbOutputs[83] = cbOutput84;
            acbOutputs[84] = cbOutput85;
            acbOutputs[85] = cbOutput86;
            acbOutputs[86] = cbOutput87;
            acbOutputs[87] = cbOutput88;
            acbOutputs[88] = cbOutput89;
            acbOutputs[89] = cbOutput90;
            acbOutputs[90] = cbOutput91;
            acbOutputs[91] = cbOutput92;
            acbOutputs[92] = cbOutput93;
            acbOutputs[93] = cbOutput94;
            acbOutputs[94] = cbOutput95;
            acbOutputs[95] = cbOutput96;
            acbOutputs[96] = cbOutput97;
            acbOutputs[97] = cbOutput98;
            acbOutputs[98] = cbOutput99;
            acbOutputs[99] = cbOutput100;
            acbOutputs[100] = cbOutput101;
            acbOutputs[101] = cbOutput102;
            acbOutputs[102] = cbOutput103;
            acbOutputs[103] = cbOutput104;
            acbOutputs[104] = cbOutput105;
            acbOutputs[105] = cbOutput106;
            acbOutputs[106] = cbOutput107;
            acbOutputs[107] = cbOutput108;
            acbOutputs[108] = cbOutput109;
            acbOutputs[109] = cbOutput110;
            acbOutputs[110] = cbOutput111;
            acbOutputs[111] = cbOutput112;
            acbOutputs[112] = cbOutput113;
            acbOutputs[113] = cbOutput114;
            acbOutputs[114] = cbOutput115;
            acbOutputs[115] = cbOutput116;
            acbOutputs[116] = cbOutput117;
            acbOutputs[117] = cbOutput118;
            acbOutputs[118] = cbOutput119;
            acbOutputs[119] = cbOutput120;
            acbOutputs[120] = cbOutput121;
            acbOutputs[121] = cbOutput122;
            acbOutputs[122] = cbOutput123;
            acbOutputs[123] = cbOutput124;
            acbOutputs[124] = cbOutput125;
            acbOutputs[125] = cbOutput126;
            acbOutputs[126] = cbOutput127;
            acbOutputs[127] = cbOutput128;


            // Setup dynamic measurement GUI
            acbDynProbeUsed = new CheckBox[N_DYN_CHANNELS_GUI];
			acbDynProbeUsed[0] = cbDynProbeUsedT1;
			acbDynProbeUsed[1] = cbDynProbeUsedT2;
			acbDynProbeUsed[2] = cbDynProbeUsedT3;
			acbDynProbeUsed[3] = cbDynProbeUsedT4;
			acbDynProbeUsed[4] = cbDynProbeUsedT5;
			acbDynProbeUsed[5] = cbDynProbeUsedT6;
			acbDynProbeUsed[6] = cbDynProbeUsedT7;
			acbDynProbeUsed[7] = cbDynProbeUsedT8;
			acbDynProbeUsed[8] = cbDynProbeUsedT9;
			acbDynProbeUsed[9] = cbDynProbeUsedT10;
			acbDynProbeUsed[10] = cbDynProbeUsedT11;
			acbDynProbeUsed[11] = cbDynProbeUsedT12;
			acbDynProbeUsed[12] = cbDynProbeUsedT13;
			acbDynProbeUsed[13] = cbDynProbeUsedT14;
			acbDynProbeUsed[14] = cbDynProbeUsedT15;
			acbDynProbeUsed[15] = cbDynProbeUsedT16;
			acbDynProbeUsed[16] = cbDynProbeUsedT17;
			acbDynProbeUsed[17] = cbDynProbeUsedT18;
			acbDynProbeUsed[18] = cbDynProbeUsedT19;
			acbDynProbeUsed[19] = cbDynProbeUsedT20;
			acbDynProbeUsed[20] = cbDynProbeUsedT21;
			acbDynProbeUsed[21] = cbDynProbeUsedT22;
			acbDynProbeUsed[22] = cbDynProbeUsedT23;
			acbDynProbeUsed[23] = cbDynProbeUsedT24;
			acbDynProbeUsed[24] = cbDynProbeUsedT25;
			acbDynProbeUsed[25] = cbDynProbeUsedT26;
			acbDynProbeUsed[26] = cbDynProbeUsedT27;
			acbDynProbeUsed[27] = cbDynProbeUsedT28;
			acbDynProbeUsed[28] = cbDynProbeUsedT29;
			acbDynProbeUsed[29] = cbDynProbeUsedT30;
			acbDynProbeUsed[30] = cbDynProbeUsedT31;
			acbDynProbeUsed[31] = cbDynProbeUsedT32;
            Array.Clear(abDynChannelUsed, 0, abDynChannelUsed.Length);
			for (int i = 0; i < N_DYN_CHANNELS_GUI; i++)
			{
				cbDynPositionTrgChannel.Items.Add(String.Format("T{0}", i+1));
			}
			cbDynPositionTrgChannel.SelectedIndex = 0;


            /* #####
             * Create object from Irinos-class and check the availability of the MscDll
             * by reading the versoon information. */
            cIrinos = new cl_Irinos();
            int iApiMajor = 0;
            int iApiMinor = 0;
            int iDllMajor = 0;
            int iDllMinor = 0;
            if (cIrinos.GetMscDllVersion(ref iApiMajor, ref iApiMinor, ref iDllMajor, ref iDllMinor) == true)
            {
                // MscDll access successful
                str = String.Format("MscDll loaded successfully: DLL-Api V{0}.{1}, DLL V{2}.{3}",
                                        iApiMajor, iApiMinor, iDllMajor, iDllMinor);
                strHeader = String.Format("DLL-Api V{0}.{1}, DLL V{2}.{3}",
                                        iApiMajor, iApiMinor, iDllMajor, iDllMinor);
                AddHistoryEntry(str, false);
            }
            else
            {
                // Failed to load the Dll
                MessageBox.Show("Failed to load the MscDll. In same directory as the exe?");
                AddHistoryEntry("Failed to load the MscDll. In same directory as the exe?", true);
            }


            // Create form/program header
            this.Text = "MscDll Demo V1.1.0.4 " + " # " + strHeader;
        }


        
        /******************************************************************************
        * FUNCTION: AddHistoryEntry
        *-----------------------------------------------------------------------------
        * Add a new line with information for the user in the history-Listbox.
        *-----------------------------------------------------------------------------
        * PARAMETERS: 
        * str: String to display in the new line
        * bError: false -> "only" information
        *         true -> an error occured
        *         So far this parameter is not used. It is intended future
        *         extension of this function. However, when calling this function, 
        *         this parameter should be used as intended.
        *-----------------------------------------------------------------------------
        * Return: none
        ******************************************************************************/
        private void AddHistoryEntry(string str, bool bError)
        {
            lbHistory.Items.Add(str);
        }


        /******************************************************************************
        * FUNCTION: btnConnect_Click
        *-----------------------------------------------------------------------------
        * "Click" event of button "Connect".
        * - Try to connect to the Irinos system vai the MscDll.
        * - If connection has been established successfully, start reading
        *   "static measurement values", "Bit I/O" and "hardware status" continuously.
        *   If new data is available for one of these three, a windows message will
        *   be send to this form. See function WndProc for message handling.
        ******************************************************************************/
        private void btnConnect_Click(object sender, EventArgs e)
        {
            string str = "";

            if (cIrinos.eConnStat != E_CONNECT_STATUS.cscCommStarted)
            {
                AddHistoryEntry("Trying to establish connection.", false);
                Application.DoEvents();

                if (cIrinos.ConnectIrinos() != E_CONNECT_STATUS.cscCommStarted)
                {
				    str = String.Format("Failed to establish connection ({0})", (UInt32)cIrinos.eConnStat);
				    AddHistoryEntry(str, true);
                }
                else
                {
                    AddHistoryEntry("Connection established successfully.", false);

                    // Set absolute date/time. This is not required, but if the Irinos-System
                    // knows the current time, diagnostic memory entries will show the
                    // absolute date/time.
                    cIrinos.WriteAbsoluteDateTime();

                    // ----> It is recommended to read the system string from the Irinos system
					//      here and to compare it with a reference string.
					//      Since this is a demo program for various systems,
				    //      we cannot use a reference string here.
                    str = "#1#";
                    cIrinos.WriteCommandStr(E_MSC_OPCODES.opcRSS, ref str);
                    // Example:
                    // if (str != referenceString)
                    // {
                    //      --> do some error handling here, e.g. show a message box
                    // }
                    AddHistoryEntry("System string: " + str, false);
                    tbSystemString.Text = str;
                    lbSystemString.Visible = true;
                    tbSystemString.Visible = true;

                    // Optional: Retrieve channel information
                    // Alternatively cIrinos.GetAvailableChannelsExtended can be used.
                    cIrinos.GetAvailableChannelsStandard(ref aclChannels, ref str);                    

                    // Start reading static measurement values
                    cIrinos.SetupStaticChannel(E_MSC_OPCODES.opcRS, 1, (IntPtr)Handle);

                    // Start reading hardware status
                    cIrinos.SetupStaticChannel(E_MSC_OPCODES.opcRHS, 1, (IntPtr)Handle);

                    /* Start exchanging Bit I/O data.
                     * If Bit I/Os are not used, this is not needed. */
                    cIrinos.SetupStaticChannel(E_MSC_OPCODES.opcBIO, N_INOUT_BITS/8, (IntPtr)Handle);
                }
            }
            else
            {
                if (cIrinos.StopAndClose() == true)
                {
                    AddHistoryEntry("Connection closed", false);
                }
            }

        }


        /******************************************************************************
        * FUNCTION: WndProc
        *-----------------------------------------------------------------------------
        * This function is called when the form receives a new windows message.
        * All messages from the MscDll are filtered out and processed. All other
        * messages are forwarded to the respective form message function
        * (Form::WndProc).
        ******************************************************************************/
        protected override void WndProc(ref Message m)
        {
            // Listen for operating system messages.
            switch (m.Msg)
            {
                case cl_IriConst.WM_MESSAGE_MSC_READSTATIC:
                    {
                        if ((int)m.WParam == 10)
                        {
                            /* Set marker, that new static measurement values are available.
                             * This marker will be checked in a timer event routine (tmrUpdateStatic_Tick).
                             * If it is set, GUI data is updated. This procedure is Thread-safe. */
                            bNewStaticMeasurementValuesAvailable = true;
                            iNStaticMeasurementValueUpdates++;
                            bTimedOut = false;
                        }
                    }
                    break;

                case cl_IriConst.WM_MESSAGE_MSC_BITIO:
                    {
                        /* Set marker, that new Bit I/O data is available.
                         * This marker will be checked in a timer event routine (tmrUpdateStatic_Tick).
                         * If it is set, GUI data is updated. This procedure is Thread-safe. */
                        bNewBitIOValuesAvailable = true;
                        iNBitIOValueUpdates++;
                    }
                    break;

                case cl_IriConst.WM_MESSAGE_MSC_HW_STATUS:
                    {
                        /* Set marker, that new hardware status data is available.
                         * This marker will be checked in a timer event routine (tmrUpdateStatic_Tick).
                         * If it is set, GUI data is updated. This procedure is Thread-safe. */
                        bNewHardStatAvailable = true;
                        iNHardStatUpdates++;
                    }
                    break;

                case cl_IriConst.WM_MESSAGE_ERROR:
                    {
                        bTimedOut = true;
                    }
                    break;

                default:
                    {
                        /* Pass all standard messages to the GUI form. */
                        base.WndProc(ref m);
                    }
                    break;
            }
        }


        /******************************************************************************
        * FUNCTION: tmrUpdateStatic_Tick
        *-----------------------------------------------------------------------------
        * Event of the timer tmrUpdateStatic. Update the following GUI information:
        * - Connection status
        * - Static measurement values (if new data is available)
        * - Hardware status (if new data is available)
        * - Bit I/O (inputs if new data is available, outputs always)
        * Updating the GUI is separated from receiving data by intention in order to
        * load the GUI thread with updating the GUI and not any other thread.
        ******************************************************************************/
        private void tmrUpdateStatic_Tick(object sender, EventArgs e)
        {
            /* Update connection state in status bar */
            if (bTimedOut == true)
            {
                toolStripStatusLabelConnection.Text = "Timeout";
                toolStripStatusLabelConnection.BackColor = Color.Yellow;
            }
            else
            {
                switch (cIrinos.eConnStat)
                {
                    case E_CONNECT_STATUS.cscTryConnect:
                        toolStripStatusLabelConnection.Text = "Trying to connect";
                        toolStripStatusLabelConnection.BackColor = Color.Yellow;
                    break;

                    case E_CONNECT_STATUS.cscNoDevices:
                        toolStripStatusLabelConnection.Text = "No devices found";
                        toolStripStatusLabelConnection.BackColor = Color.Yellow;
                    break;

                    case E_CONNECT_STATUS.cscNoDeviceInfo:
                        toolStripStatusLabelConnection.Text = "No device information available";
                        toolStripStatusLabelConnection.BackColor = Color.Yellow;
                    break;

                    case E_CONNECT_STATUS.cscConnected:
                        toolStripStatusLabelConnection.Text = "Connection established, communication not yet active";
                        toolStripStatusLabelConnection.BackColor = Color.Yellow;
                    break;

                    case E_CONNECT_STATUS.cscConnectionClosed:
                        toolStripStatusLabelConnection.Text = "Connection closed";
                        toolStripStatusLabelConnection.BackColor = Color.Yellow;
                    break;

                    case E_CONNECT_STATUS.cscNoDeviceOpen:
                        toolStripStatusLabelConnection.Text = "Failed to open device";
                        toolStripStatusLabelConnection.BackColor = Color.Yellow;
                    break;

                    case E_CONNECT_STATUS.cscInitDone:
                        toolStripStatusLabelConnection.Text = "Initialization done";
                        toolStripStatusLabelConnection.BackColor = Color.Yellow;
                    break;

                    case E_CONNECT_STATUS.cscInitFailed:
                        toolStripStatusLabelConnection.Text = "Initialization failed";
                        toolStripStatusLabelConnection.BackColor = Color.Yellow;
                    break;

                    case E_CONNECT_STATUS.cscCommStarted:
                        toolStripStatusLabelConnection.Text = "Communication started";
                        toolStripStatusLabelConnection.BackColor = Color.MediumAquamarine;
                    break;

                    case E_CONNECT_STATUS.cscCommFailed:
                        toolStripStatusLabelConnection.Text = "Establishing communication failed";
                        toolStripStatusLabelConnection.BackColor = Color.Yellow;
                    break;

                    case E_CONNECT_STATUS.cscUndefined:
                        toolStripStatusLabelConnection.Text = ".";
                        toolStripStatusLabelConnection.BackColor = Color.WhiteSmoke;
                    break;

                    default:
                        toolStripStatusLabelConnection.Text = "Unknown state";
                        toolStripStatusLabelConnection.BackColor = Color.Red;
                    break;
                }
            }


            // Update the text of the Button "Connect" according to connection state */
            if (cIrinos.eConnStat == E_CONNECT_STATUS.cscCommStarted)
            {
                btnConnect.Text = "Disconnect";
            }
            else
            {
                btnConnect.Text = "Connect";
            }


            /* Update static measurement values (if new values are available).
             * NOTE: Measurement values from the Irinos-System are always coming from
             *       the Irinos-System in digits and not in physical units.
             *       In order to get physical units (e.g. µm), you will need to implement
             *       a conversion into your application.
             *       Details about digits can be found in the documentation. Here are some
             *       examples:
             *       Ind. probe Tesa:  -2000µm = -32000
             *                             0µm = 0
             *                         +2000µm = +32000
             *       Ind. probe Knäbel: -200µm = -32000
             *                             0µm = 0
             *                          +200µm = +32000
             *       Analogue input:      -10V = -32000
             *                              0V = 0
             *                            +10V = +32000
             *       Incremental encoder: 1 Incremenet = 1 */
            if (bNewStaticMeasurementValuesAvailable == true)
            {
                bNewStaticMeasurementValuesAvailable = false;

                Int32[] aslStaticMVals = new Int32[N_STATIC_CHANNELS];
                cIrinos.GetStaticMeasurementValues(ref aslStaticMVals);
                for (int i = 0; i < N_STATIC_CHANNELS; i++)
                {
                    albStaticValues[i].Text = String.Format("{0}", aslStaticMVals[i]);
                }
                lbStaticUpdates.Text = iNStaticMeasurementValueUpdates.ToString() + " measurement value updates";
            }


			// Update hardware status data (if new data is available)
			if (bNewHardStatAvailable == true)
			{
				bNewHardStatAvailable = false;

                byte[] aucHardStat = new byte[N_STATIC_CHANNELS];
                cIrinos.GetHardwareStatusData(ref aucHardStat);
				for (int i = 0; i < N_STATIC_CHANNELS; i++)
				{
					albHardStat[i].Text = String.Format("0x{0:X2}", aucHardStat[i]);

					/* The hardware status is a bitfield per channel. The content of the
					* bitfield depends on the channel type (e.g. inductive probe,
					* incremental encoder, ...).
					* In the following example, the hardware status is evaluated for
					* incremental encoders and inductive probes. In your software, you
					* should distinquish between the different channel types. */
					if ((aucHardStat[i] & 0xDF) == 0)
					{
						albHardStat[i].ForeColor = Color.Black; // Everything ok
					}
					else
					{
						albHardStat[i].ForeColor = Color.Red;   // Measurement channel error
					}
				}
				lbHardStatUpdates.Text = String.Format("{0} hardware status updates", iNHardStatUpdates);
			}


            // Update bit inputs (if new data is available)
            if (bNewBitIOValuesAvailable == true)
            {
                bNewBitIOValuesAvailable = false;

                bool[] abInputs = new bool[N_INOUT_BITS];
                cIrinos.GetBitInputs(ref abInputs);
                for (int i = 0; i < N_INOUT_BITS; i++)
                {
                    int Column = i / N_INOUT_GRID_ROWS;
                    int Row = i % N_INOUT_GRID_ROWS;
                    dataGridViewInputs[Column, Row].Value = abInputs[i];
                }

                lbBitIOUpdates.Text = String.Format("{0} Bit I/O updates", iNBitIOValueUpdates);
            }

            
            // Update bit outputs
            bool[] abOutputs = new bool[N_INOUT_BITS];
            for (int i = 0; i < N_INOUT_BITS; i++)
            {
                abOutputs[i] = acbOutputs[i].Checked;
                cIrinos.RefreshBitOutputs(abOutputs);
            }
        }


        /******************************************************************************
        * FUNCTION: Form1_FormClosing
        *-----------------------------------------------------------------------------
        * "OnClose" event of the form.
        * -> Disconnect the Irinos system (if connected) and close dll handle.
        *    (If the connection is not closed via this function and a connection
        *    remains established, an exception can occur.)
        ******************************************************************************/
        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            cIrinos.StopAndClose();
        }


        /******************************************************************************
        * FUNCTION: btnDynTimeStart_Click
        *-----------------------------------------------------------------------------
        * Start a time-based dynamic measurement with channel list 1, Trigger 1 and
        * dynamic measurement 1.
        * The following steps are performed:
        * 1. Create a channel list of the used channels and send it to the Irinos
        *    system. (Use only the required channels to reduce memory and
        *    communication bandwidth consumption.)
        * 2. Make sure trigger 1 is disabled.
        * 3. Define / configure trigger 1 for time-based measurement.
        * 4. Define the dynamic measurement.
        * 5. Assign a buffer for the measurement values. The DLL will write received
        *    values directly into this buffer.
        * 6. Activate Trigger 1 to start the measurement.
        * NOTE: Time- and position-based measurement differ only in
        *       trigger configuration (step 3).
        ******************************************************************************/
        private void btnDynTimeStart_Click(object sender, EventArgs e)
        {
            string strError = "";
            string str = "";

            // ### CHANNEL LIST
            // Create the channel list for the dynamic measurement and send it to the
            // Irinos-System. In this example, channel list 1 is used. Any of the
            // other channel lists (2..10) could also be used.
            // Notes: 
            // - If the same dynamic measurement is repeated multiple times
            //   in your application, it is sufficient to write this channel
            //   list only once.
            // - The list of available channels (aclChannels) must have been
            //   created before using cIrinos.GetAvailableChannelsXXX (e.g.
            //   after connecting).
            Array.Clear(abDynChannelUsed, 0, abDynChannelUsed.Length);
            iNDynChannelsUsed = 0;
            for (int i = 0; (i < N_DYN_CHANNELS_GUI); i++)
            {
                abDynChannelUsed[i] = acbDynProbeUsed[i].Checked;
                if (abDynChannelUsed[i] == true)
                {
                    iNDynChannelsUsed++;
                }
            }

            // Create channel list string
            if (cIrinos.CreateChannelListString(1, abDynChannelUsed, ref str, ref strError) == false)
            {
                AddHistoryEntry("Dynamic measurement: Failed to create channel list string: " + strError, true);
                return;
            }

            // Write channel list to the Irinos-System
            // Example string: #1;T2;T3;T5;T7;T26;T19#
            cIrinos.WriteCommandStr(E_MSC_OPCODES.opcWCL, ref str);
            if (str != "#0#")
            {
                AddHistoryEntry("Dynamic measurement: Failed to write channel list to the Irinos-System: " + str, true);
                return;
            }


            // ### INACTIVATE TRIGGER 1 (in case it is already active)
            str = "#1#";
            cIrinos.WriteCommandStr(E_MSC_OPCODES.opcIT, ref str);
            if (str != "#0#")
            {
                AddHistoryEntry("Dynamic measurement: Failed to inactivate trigger 1: " + str, true);
                return;
            }


            // ### DEFINE / CONFIGURE TRIGGER
            // In this example trigger 1 us used. Alternatively trigger 2 could be used as well.
            if (rbDynTime100us.Checked == true)
            {
                str = cIrinos.CreateTriggerDefinition_Time(1, "0.1", "0", "*"); // 100 µs example
            }
            else if (rbDynTime500us.Checked == true)
            {
                str = cIrinos.CreateTriggerDefinition_Time(1, "0.5", "0", "*"); // 500 µs example
            }
            else if (rbDynTime1ms.Checked == true)
            {
                str = cIrinos.CreateTriggerDefinition_Time(1, "1", "0", "*");   // 1 ms example
            }
            else
            {
                str = cIrinos.CreateTriggerDefinition_Time(1, "10", "0", "*");  // 10 ms example
            }
            cIrinos.WriteCommandStr(E_MSC_OPCODES.opcDT, ref str);
            if (str != "#0#")
            {
                AddHistoryEntry("Dynamic measurement: Failed to define trigger 1: " + str, true);
                return;
            }


            // ### DEFINE DYNAMIC MEASUREMENT
            // In this example dynamic measurement 1 is used. Alternatively dynamic measurement 2 could be used.
            // (They can even be used in parallel.)
            if (cIrinos.CreateDynamicMeasurementDefinition(1, 1, true, Decimal.ToInt32(nudDynTimeNValues.Value), ref str, ref strError) == false)
            {
                AddHistoryEntry("Failed to generate definition string for dynamic measurement: " + strError, true);
                return;
            }
            cIrinos.WriteCommandStr(E_MSC_OPCODES.opcDDM1, ref str);
            if (str != "#0#")
            {
                AddHistoryEntry("Failed to define dynamic measurement: " + str, true);
                return;
            }


            /* ### CREATE BUFFERS for measurement values
             * The buffers must be created by the application and provided to the MscDll.
             * Creating the buffers is done in cIrinos.SetupDynamicChannel.
             * The MscDll will store the dynamic measurement values in the created
             * buffers automatically. The buffers can be accessed using
             * cIrinos.GetDynamicMeasurementValue */
            if (cIrinos.SetupDynamicChannel(E_MSC_OPCODES.opcRDM1, Decimal.ToInt32(nudDynTimeNValues.Value), iNDynChannelsUsed) == false)
            {
                AddHistoryEntry("Dynamic measurement: Failed to assign memory buffers for dynamic measurement values.", true);
                return;
            }


            // ### ACTIVATE TRIGGER 1. This will start the dynamic measurement.
            str = "#1#";
            cIrinos.WriteCommandStr(E_MSC_OPCODES.opcAT, ref str);
            if (str != "#0#")
            {
                AddHistoryEntry("Dynamic measurement: Failed to activate trigger 1: " + str, true);
                return;
            }

            AddHistoryEntry("Dynamic measurement 1 started successfully", false);
        }


        /******************************************************************************
        * FUNCTION: btnDynPosStart_Click
        *-----------------------------------------------------------------------------
        * Start a position-based dynamic measurement with channel list 1, Trigger 1 and
        * dynamic measurement 1.
        * The following steps are performed:
        * 1. Create a channel list of the used channels and send it to the Irinos
        *    system. (Use only the required channels to reduce memory and
        *    communication bandwidth consumption.)
        * 2. Make sure trigger 1 is disabled.
        * 3. Define / configure trigger 1 for position-based measurement.
        * 4. Define the dynamic measurement.
        * 5. Assign a buffer for the measurement values. The DLL will write received
        *    values directly into this buffer.
        * 6. Activate Trigger 1 to start the measurement.
        * NOTE: Time- and position-based measurement differ only in
        *       trigger configuration (step 3).
        * NOTE: The internal trigger-resolution for position-triggered dynamic
        *       measurement is 1000 samples/s.
        ******************************************************************************/
        private void btnDynPosStart_Click(object sender, EventArgs e)
        {
            string strError = "";
            string str = "";

            // ### CHANNEL LIST
            // Create the channel list for the dynamic measurement and send it to the
            // Irinos-System. In this example, channel list 1 is used. Any of the
            // other channel lists (2..10) could also be used.
            // Notes: 
            // - If the same dynamic measurement is repeated multiple times
            //   in your application, it is sufficient to write this channel
            //   list only once.
            // - The list of available channels (aclChannels) must have been
            //   created before using cIrinos.GetAvailableChannelsXXX (e.g.
            //   after connecting).
            Array.Clear(abDynChannelUsed, 0, abDynChannelUsed.Length);
            iNDynChannelsUsed = 0;
            for (int i = 0; (i < N_DYN_CHANNELS_GUI); i++)
            {
                abDynChannelUsed[i] = acbDynProbeUsed[i].Checked;
                if (abDynChannelUsed[i] == true)
                {
                    iNDynChannelsUsed++;
                }
            }

            // Create channel list string
            if (cIrinos.CreateChannelListString(1, abDynChannelUsed, ref str, ref strError) == false)
            {
                AddHistoryEntry("Dynamic measurement: Failed to create channel list string: " + strError, true);
                return;
            }

            // Write channel list to the Irinos-System
            // Example string: #1;T2;T3;T5;T7;T26;T19#
            cIrinos.WriteCommandStr(E_MSC_OPCODES.opcWCL, ref str);
            if (str != "#0#")
            {
                AddHistoryEntry("Dynamic measurement: Failed to write channel list to the Irinos-System: " + str, true);
                return;
            }


            // ### INACTIVATE TRIGGER 1 (in case it is already active)
            str = "#1#";
            cIrinos.WriteCommandStr(E_MSC_OPCODES.opcIT, ref str);
            if (str != "#0#")
            {
                AddHistoryEntry("Dynamic measurement: Failed to inactivate trigger 1: " + str, true);
                return;
            }


            // ### DEFINE / CONFIGURE TRIGGER
            // In this example trigger 1 us used. Alternatively trigger 2 could be used as well.
            str = cIrinos.CreateTriggerDefinition_Position(1, cbDynPositionTrgChannel.Text, (float)nudDynPosDivisor.Value,
                (float)nuDynPosTriggerDistance.Value, (float)nuDynPosTriggerStart.Value, (float)nuDynPosTriggerStop.Value, true);
            cIrinos.WriteCommandStr(E_MSC_OPCODES.opcDT, ref str);
            if (str != "#0#")
            {
                AddHistoryEntry("Dynamic measurement: Failed to define trigger 1: " + str, true);
                return;
            }


            // ### DEFINE DYNAMIC MEASUREMENT
            // In this example dynamic measurement 1 is used. Alternatively dynamic measurement 2 could be used.
            // (They can even be used in parallel.)
            if (cIrinos.CreateDynamicMeasurementDefinition(1, 1, true, Decimal.ToInt32(nudDynPositionNValues.Value), ref str, ref strError) == false)
            {
                AddHistoryEntry("Failed to generate definition string for dynamic measurement: " + strError, true);
                return;
            }
            cIrinos.WriteCommandStr(E_MSC_OPCODES.opcDDM1, ref str);
            if (str != "#0#")
            {
                AddHistoryEntry("Failed to define dynamic measurement: " + str, true);
                return;
            }


            /* ### CREATE BUFFERS for measurement values
             * The buffers must be created by the application and provided to the MscDll.
             * Creating the buffers is done in cIrinos.SetupDynamicChannel.
             * The MscDll will store the dynamic measurement values in the created
             * buffers automatically. The buffers can be accessed using
             * cIrinos.GetDynamicMeasurementValue */
            if (cIrinos.SetupDynamicChannel(E_MSC_OPCODES.opcRDM1, Decimal.ToInt32(nudDynPositionNValues.Value), iNDynChannelsUsed) == false)
            {
                AddHistoryEntry("Dynamic measurement: Failed to assign memory buffers for dynamic measurement values.", true);
                return;
            }


            // ### ACTIVATE TRIGGER 1. This will start the dynamic measurement.
            str = "#1#";
            cIrinos.WriteCommandStr(E_MSC_OPCODES.opcAT, ref str);
            if (str != "#0#")
            {
                AddHistoryEntry("Dynamic measurement: Failed to activate trigger 1: " + str, true);
                return;
            }

            AddHistoryEntry("Dynamic measurement 1 started successfully", false);
        }

        
        /******************************************************************************
        * FUNCTION: tmrUpdateDynMeas_Tick
        *-----------------------------------------------------------------------------
        * Event of the timer tmrUpdateDynMeas. Update the following GUI information:
        * - Amount of dynamic measurement data received.
        * - Dynamic measurement status
        ******************************************************************************/
        private void tmrUpdateDynMeas_Tick(object sender, EventArgs e)
        {
            // Update the number of dynamic measurement values already received
            int iNValues = 0;
            int iNBytes = 0;
            if (cIrinos.GetDynamicValuesReceived(E_MSC_OPCODES.opcRDM1, ref iNValues, ref iNBytes) == true)
            {
			    lbDynValuesPerChannelReceived.Text = String.Format("{0} values per channel received", iNValues);
			    lbDynBytesPerChannelReceived.Text = String.Format("{0} bytes per channel received", iNBytes);
                lbDynValuesReceived.Text = String.Format("{0} values received", iNValues * iNDynChannelsUsed);
                lbDynBytesReceived.Text = String.Format("{0} bytes received", iNBytes * iNDynChannelsUsed);
                btnDynValuesStore.Enabled = (iNValues > 1);
            }

            /* Update dynamic measurement status.
             * These status bits can be used for example to check, if a dynamic measurement
             * is finished. A condition for a finished measurement is for example:
             * (bDynMeas1_Active == false) && (bDynMeas1_ReadActive == false) */
            cl_IriDynMeasStatusword clSw = cIrinos.GetDynamicMeasurementStatus();
            cbDynTrg1Active.Checked = clSw.bTrigger1_Active;
            cbDynTrg1WasActive.Checked = clSw.bTrigger1_WasActive;
            cbDynTrg1EventOccured.Checked = clSw.bTrigger1_Min1Pulse;
            cbDyn1Active.Checked = clSw.bDynMeas1_Active;
            cbDyn1WasActive.Checked = clSw.bDynMeas1_WasActive;
            cbDyn1ValueStored.Checked = clSw.bDynMeas1_Min1Value;
            cbDyn1ReadActive.Checked = clSw.bDynMeas1_ReadActive;
            cbDyn1BufferFull.Checked = clSw.bDynMeas1_BufferFull;
        }


        /******************************************************************************
         * FUNCTION: btnDynValuesStore_Click
         *-----------------------------------------------------------------------------
         * Event is fired when the button "Store to DynValues.csv" is clicked.
         * Read dynamic measurement values from the buffer and store them into a
         * ";" separated *.csv-file.
         * The *.csv-file can be opened with MS Excel.
         * 
         * NOTE for your application:
         * Transfer of dynamic measurement values is started after the first
         * values have been sampled. It is possible to read these values before the
         * dynamic measurement is finished.
         * You can compare the buffer to a ton of water: The ton is the buffer and
         * the water are the measurement values. These measurement values are filled
         * into the buffer until it is full. You can "see" the measurement values
         * (= water) before the buffer (= ton) is completely full.
         * The only difference is that reading the values does not empty the buffer.
         * This allows reading the values as often as you want until the next
         * dynamic measurement is started.
        ******************************************************************************/
        private void btnDynValuesStore_Click(object sender, EventArgs e)
        {
            string strPath = Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().Location) + "\\DynValues.csv";
            string str = "";

            try
            {
                StreamWriter cStreamWriter = File.CreateText(strPath);

                // Write header line
                str = "";
                bool bFirst = true;
                for (int i = 0; i < abDynChannelUsed.Length; i++)
                {
                    if (abDynChannelUsed[i] == true)
                    {
                        if (bFirst == false)
                        {
                            str += ";";
                        }
                        str += String.Format("T{0}", i + 1);
                        bFirst = false;
                    }
                }
                cStreamWriter.WriteLine(str);

                // Write measurement values
                int iNValues = 0;
                int iNBytes = 0;
                cIrinos.GetDynamicValuesReceived(E_MSC_OPCODES.opcRDM1, ref iNValues, ref iNBytes);
                for (int iSample = 0; iSample < iNValues; iSample++)
                {
                    str = "";
                    for (int iCh = 0; iCh < iNDynChannelsUsed; iCh++)
                    {
                        if (iCh > 0)
                        {
                            str += ";";
                        }
                        int iValue = -2147483647;
                        cIrinos.GetDynamicMeasurementValue(E_MSC_OPCODES.opcRDM1, iSample, iCh, ref iValue);
                        str += iValue.ToString();
                    }
                    cStreamWriter.WriteLine(str);
                }

                cStreamWriter.Close();

                str = "Dynamic measurement values successfully written to " + strPath + ".";
                AddHistoryEntry(str, false);
            }
            catch (Exception ex)
            {
                str = "Dynamic measurement: cannot write DynValues.csv (" + ex.Message + ").";
                AddHistoryEntry(str, true);
            }

            MessageBox.Show(str, "Store dynamic measurement values");
        }

    }
}
