﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;

namespace MscDll_Demo_VCS_2017
{
    class cl_MscDll
    {
        public enum MSC_STATUS
        {
            MSC_STATUS_SUCCESS,
            MSC_STATUS_FAILED,
            MSC_STATUS_INVALID_HANDLE,
            MSC_STATUS_INVALID_PARAMS,
            MSC_STATUS_NO_RESOURCES,
            MSC_STATUS_NO_DEVICES,
            MSC_STATUS_NOT_INITIALIZED,
            MSC_STATUS_ALREADY_INITIALIZED,
            MSC_STATUS_INVALID_OBJECT_TYPE,
            MSC_STATUS_INVALID_CHANNEL_TYPE,
            MSC_STATUS_DEVICE_DISCONNECTED,
            MSC_STATUS_FUNCTION_NOT_ALLOWED,
            MSC_STATUS_NO_DATA_AVAILABLE,
            MSC_STATUS_NO_MORE_DATA,
            MSC_STATUS_BUFFER_TO_SHORT,

            MSC_STATUS_INVALID_ENDPOINT,
            MSC_STATUS_NOT_CONFIGERED,
            MSC_STATUS_ALREADY_RUNNING,
            MSC_STATUS_THREAD_NOT_STARTED,

            MSC_STATUS_NOT_COMPLETED,
            MSC_STATUS_NOT_IMPLEMENTED,

            MSC_STATUS_UNKNOWN
        };


        public const UInt32 MSC_MAX_UNIQUEID_SIZE = 40;

        private const string DRIVER_DLL_NAME = "MscDll.dll";


        /******************************************************************************
        * FUNCTION: UInt32_To_MSC_STATUS
        *-----------------------------------------------------------------------------
        * Convert a UInt32 return value from the MscDll to the enum MSC_STATUS.
        *-----------------------------------------------------------------------------
        * PARAMETERS: 
        * ulStatus: return value from MscDll
        *-----------------------------------------------------------------------------
        * Return: see type definition and MscDll reference guide
        ******************************************************************************/
        private MSC_STATUS UInt32_To_MSC_STATUS(UInt32 ulStatus)
        {
            switch (ulStatus)
            {
                case 0x00000000: return MSC_STATUS.MSC_STATUS_SUCCESS;
                case 0xF0000001: return MSC_STATUS.MSC_STATUS_FAILED;
                case 0xF0000002: return MSC_STATUS.MSC_STATUS_INVALID_HANDLE;
                case 0xF0000003: return MSC_STATUS.MSC_STATUS_INVALID_PARAMS;
                case 0xF0000004: return MSC_STATUS.MSC_STATUS_NO_RESOURCES;
                case 0xF0000005: return MSC_STATUS.MSC_STATUS_NO_DEVICES;
                case 0xF0000006: return MSC_STATUS.MSC_STATUS_NOT_INITIALIZED;
                case 0xF0000007: return MSC_STATUS.MSC_STATUS_ALREADY_INITIALIZED;
                case 0xF0000008: return MSC_STATUS.MSC_STATUS_INVALID_OBJECT_TYPE;
                case 0xF0000009: return MSC_STATUS.MSC_STATUS_INVALID_CHANNEL_TYPE;
                case 0xF0000010: return MSC_STATUS.MSC_STATUS_DEVICE_DISCONNECTED;
                case 0xF0000100: return MSC_STATUS.MSC_STATUS_FUNCTION_NOT_ALLOWED;
                case 0xF0000200: return MSC_STATUS.MSC_STATUS_NO_DATA_AVAILABLE;
                case 0xF0000400: return MSC_STATUS.MSC_STATUS_NO_MORE_DATA;
                case 0xF0000401: return MSC_STATUS.MSC_STATUS_BUFFER_TO_SHORT;
                case 0xF0000800: return MSC_STATUS.MSC_STATUS_INVALID_ENDPOINT;
                case 0xF0000801: return MSC_STATUS.MSC_STATUS_NOT_CONFIGERED;
                case 0xF0000802: return MSC_STATUS.MSC_STATUS_ALREADY_RUNNING;
                case 0xF0000803: return MSC_STATUS.MSC_STATUS_THREAD_NOT_STARTED;
                case 0xF000FFFE: return MSC_STATUS.MSC_STATUS_NOT_COMPLETED;
                case 0xF000FFFF: return MSC_STATUS.MSC_STATUS_NOT_IMPLEMENTED;
                default: return MSC_STATUS.MSC_STATUS_UNKNOWN;
            }
        }


        // ### MSC_GetVersion
        [DllImport(DRIVER_DLL_NAME)]
        private static extern void MSC_GetVersion(ref UInt32 ApiVersion, ref UInt32 DllVersion);
        protected void F_MSC_GetVersion(ref UInt32 ApiVersion, ref UInt32 DllVersion)
        {
            MSC_GetVersion(ref ApiVersion, ref DllVersion);
        }


        // ### MSC_EnumerateDevices
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 MSC_EnumerateDevices(ref UInt32 DeviceNumber);
        protected MSC_STATUS F_MSC_EnumerateDevices(ref UInt32 DeviceNumber)
        {
            return UInt32_To_MSC_STATUS(MSC_EnumerateDevices(ref DeviceNumber));
        }

        // ### MSC_GetDeviceInfo
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 MSC_GetDeviceInfo(UInt32 Index, ref UInt32 BusType, byte[] UniqueID);
        protected MSC_STATUS F_MSC_GetDeviceInfo(UInt32 Index, ref UInt32 BusType, byte[] UniqueID)
        {
            return UInt32_To_MSC_STATUS(MSC_GetDeviceInfo(Index, ref BusType, UniqueID));
        }

        // ### MSC_OpenDevice
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 MSC_OpenDevice(UInt32 Index, ref IntPtr Handle);
        protected MSC_STATUS F_MSC_OpenDevice(UInt32 Index, ref IntPtr Handle)
        {
            return UInt32_To_MSC_STATUS(MSC_OpenDevice(Index, ref Handle));
        }

        // ### MSC_InitDevice
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 MSC_InitDevice(IntPtr Handle);
        protected MSC_STATUS F_MSC_InitDevice(IntPtr Handle)
        {
            return UInt32_To_MSC_STATUS(MSC_InitDevice(Handle));
        }

        // ### MSC_CloseDevice
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 MSC_CloseDevice(IntPtr Handle);
        protected MSC_STATUS F_MSC_CloseDevice(IntPtr Handle)
        {
            return UInt32_To_MSC_STATUS(MSC_CloseDevice(Handle));
        }

        // ### MSC_Start
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 MSC_Start(IntPtr Handle,
											    UInt32 SndPeriod,			// ms 
											    UInt32 DisconnectTimeout,	// ms
											    UInt32 RetryCount,
											    UInt32 RespondsTimeout);
        protected MSC_STATUS F_MSC_Start(IntPtr Handle,
                                                UInt32 SndPeriod,			// ms 
                                                UInt32 DisconnectTimeout,	// ms
                                                UInt32 RetryCount,
                                                UInt32 RespondsTimeout)
        {
            return UInt32_To_MSC_STATUS(MSC_Start(Handle, SndPeriod, DisconnectTimeout, RetryCount, RespondsTimeout));
        }

        // ### MSC_Stop
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 MSC_Stop(IntPtr Handle);
        protected MSC_STATUS F_MSC_Stop(IntPtr Handle)
        {
            return UInt32_To_MSC_STATUS(MSC_Stop(Handle));
        }

        // ### MSC_WriteCommand
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 MSC_WriteCommand(IntPtr Handle,
													  byte OpCode,
  													  UInt32 SndBufferSize,
                                                      IntPtr SndBuffer,
													  UInt32 RcvBufferSize,
                                                      IntPtr RcvBuffer,
													  ref UInt32 BytesReceived,
													  UInt32 Timeout);	// in ms
        protected MSC_STATUS F_MSC_WriteCommand(IntPtr Handle,
                                                      byte OpCode,
                                                      UInt32 SndBufferSize,
                                                      IntPtr SndBuffer,
                                                      UInt32 RcvBufferSize,
                                                      IntPtr RcvBuffer,
                                                      ref UInt32 BytesReceived,
                                                      UInt32 Timeout)
        {
            return UInt32_To_MSC_STATUS(MSC_WriteCommand(Handle,
                                                         OpCode,
                                                         SndBufferSize,
                                                         SndBuffer,
                                                         RcvBufferSize,
                                                         RcvBuffer,
                                                         ref BytesReceived,
                                                         Timeout));
        }

        // ### MSC_SetupStaticChannel
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 MSC_SetupStaticChannel(IntPtr Handle,
													        byte OpCode,
													        UInt32 SndBufferSize,
                                                            IntPtr SndBuffer,
													        UInt32 RcvBufferSize);
        protected MSC_STATUS F_MSC_SetupStaticChannel(IntPtr Handle,
                                                            byte OpCode,
                                                            UInt32 SndBufferSize,
                                                            IntPtr SndBuffer,
                                                            UInt32 RcvBufferSize)
        {
            return UInt32_To_MSC_STATUS(MSC_SetupStaticChannel(Handle, OpCode, SndBufferSize, SndBuffer, RcvBufferSize));
        }

        // ### MSC_SetNotificationMessage
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 MSC_SetNotificationMessage(IntPtr Handle,
                                                                Int32 OpCode,
                                                                IntPtr hWnd,		// hWnd = NULL for unregister
                                                                UInt32 MsgCode,
                                                                UInt32 wParam,
                                                                UInt32 lParam);
        protected MSC_STATUS F_MSC_SetNotificationMessage(IntPtr Handle,
                                                                Int32 OpCode,
                                                                IntPtr hWnd,		// hWnd = NULL for unregister
                                                                UInt32 MsgCode,
                                                                UInt32 wParam,
                                                                UInt32 lParam)
        {
            return UInt32_To_MSC_STATUS(MSC_SetNotificationMessage(Handle, OpCode, hWnd, MsgCode, wParam, lParam));
        }

        // ### MSC_ReadStatic
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 MSC_ReadStatic(IntPtr Handle,
												    byte OpCode,
												    UInt32 BufferSize,
                                                    IntPtr RcvBuffer,
												    ref UInt32 DataCount);
        protected MSC_STATUS F_MSC_ReadStatic(IntPtr Handle,
                                              byte OpCode,
                                              UInt32 BufferSize,
                                              IntPtr RcvBuffer,
                                              ref UInt32 DataCount)
        {
            return UInt32_To_MSC_STATUS(MSC_ReadStatic(Handle, OpCode, BufferSize, RcvBuffer, ref DataCount));
        }

        // ### MSC_RefreshChannel
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 MSC_RefreshChannel(IntPtr Handle, byte OpCode);
        protected MSC_STATUS F_MSC_RefreshChannel(IntPtr Handle, byte OpCode)
        {
            return UInt32_To_MSC_STATUS(MSC_RefreshChannel(Handle, OpCode));
        }

        // ### MSC_GetPosition
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 MSC_GetPosition(IntPtr Handle,
												     byte OpCode,
												     ref UInt32 Position);
        protected MSC_STATUS F_MSC_GetPosition(IntPtr Handle,
                                                     byte OpCode,
                                                     ref UInt32 Position)
        {
            return UInt32_To_MSC_STATUS(MSC_GetPosition(Handle, OpCode, ref Position));
        }

        // ### MSC_SetupExtendedDynamicChannel
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 MSC_SetupExtendedDynamicChannel(IntPtr Handle,
																     byte OpCode,
																     byte NumberOfSubChannels,
																     UInt32 SndBufferSize,
																     IntPtr SndBuffer);
        protected MSC_STATUS F_MSC_SetupExtendedDynamicChannel(IntPtr Handle,
                                                                byte OpCode,
                                                                byte NumberOfSubChannels,
                                                                UInt32 SndBufferSize,
                                                                IntPtr SndBuffer)
        {
            return UInt32_To_MSC_STATUS(MSC_SetupExtendedDynamicChannel(Handle, OpCode, NumberOfSubChannels, SndBufferSize, SndBuffer));
        }

        // ### MSC_AttachSubChannelBuffer
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 MSC_AttachSubChannelBuffer(IntPtr Handle,
															    byte OpCode,
															    byte SubChannel,
															    UInt32 BufferSize,
															    IntPtr Buffer);
        protected MSC_STATUS F_MSC_AttachSubChannelBuffer(IntPtr Handle,
                                                                byte OpCode,
                                                                byte SubChannel,
                                                                UInt32 BufferSize,
                                                                IntPtr Buffer)
        {
            return UInt32_To_MSC_STATUS(MSC_AttachSubChannelBuffer(Handle, OpCode, SubChannel, BufferSize, Buffer));
        }
    }

}
