#pragma once
#include "cl_MscDll.h"

#define MSC_BUF_SIZE_STATIC		((unsigned long)1500)
#define MSC_BUF_SIZE_BITIO		((unsigned long)64)
#define MSC_BUF_SIZE_HARDSTAT	((unsigned long)256)
#define MSC_BUF_SIZE_WRITECMD	((unsigned long)1000)

#define	WM_MESSAGE_MSC_READSTATIC	(WM_USER + 0)		// Message for static measurement values
#define WM_MESSAGE_MSC_BITIO		(WM_USER + 1)		// Message for BitIO
#define	WM_MESSAGE_MSC_HW_STATUS	(WM_USER + 2)		// Message for "read hardware status"

#define MAX_DYNAMIC_MEASUREMENT		((unsigned long)2)


typedef enum
{
    cscUndefined,        // Initialization
    cscTryConnect,       // Trying to connect
    cscNoDevices,        // No devices found
    cscNoDeviceInfo,     // No device info available
    cscConnected,        // Connection established successfully
    cscConnectionClosed, // Connection closed
    cscNoDeviceOpen,     // Failed to open connection to device
    cscInitDone,         // Device initialization finished
    cscInitFailed,       // Device initialization failed
    cscCommStarted,      // Communication started
    cscCommFailed        // Failed to start communication
} E_CONNECT_STATUS;


/* DLL communication opcodes */
typedef enum
{
	/* Initialization */
	opcRIV = 0x01,		// Read inventory
	opcRMI = 0x03,		// Read module information
	opcRSS = 0x05,	    // Read system string
	opcWCC = 0x09,		// Write channel characteristics
	opcRCA = 0x10,		// Read channel assignment
	opcWCA = 0x11,		// Write channel assignment
	opcWCP = 0x1E,		// Set communication parameter

	/* Configuration, various */
	opcWCL = 0x22,		// Write channel list
	opcRCL = 0x23,		// Read channel list
	opcAL = 0x24,		// Activate channel list for static measurement
	opcDT = 0x30,		// Define trigger for dynamic measurement
	opcAT = 0x31,		// Activate trigger for dynamic measurement
	opcIT = 0x32,		// Inactivate trigger for dynamic measurement
	opcSP = 0x35,		// Set (channel) parameter
	opcRHS = 0x38,		// Read hardware status
	opcREv = 0x39,		// Read event status
	opcSAbsT = 0x3A,	// Set absolute time
	opcREvCfg = 0x3C,	// Read event configuration and status
	opcWEvCfg = 0x3D,	// Write event configuration

	/* Measurement */
	opcRS = 0x40,		// Read static measurement values
	opcBIO = 0x42,		// Read digital inputs / write digital outputs
	opcRSW = 0x44,		// Read status word for dynamic measurements
	opcDDM1 = 0x50,		// Define dynamic measurement 1
	opcDDM2 = 0x51,		// Define dynamic measurement 2
	opcRDM1 = 0x60,		// Read data of dynamic measurement 1
	opcRDM2 = 0x61,		// Read data of dynamic measurement 2

	/* Service */
	opcRst = 0x7E,		// System-Reset
} E_MSC_OPCODES;


class cl_Irinos : public cl_MscDll
{
public:
	cl_Irinos(void);
	
	E_CONNECT_STATUS ConnectIrinos(void);
	bool StopAndClose(void);
	bool SetupStaticChannel(E_MSC_OPCODES eOpcode, unsigned long ulSendSize, HWND pWindowHandle);
	void GetStaticMeasurementValues(signed long *pslValueBuffer, unsigned long ulMaxValues);
	void GetBitIO(void);
	void RefreshOutputs(void);
	void GetHardStat(void);
	bool WriteCommand(E_MSC_OPCODES eOpcode, unsigned long ulSendSize, unsigned long *pulReceiveSize);
	bool SetupDynamicChannel(E_MSC_OPCODES eOpcode, unsigned long ulMaxMeasValues, unsigned long ulNChannels);
	bool GetDynBytesReceived(E_MSC_OPCODES eOpcode, unsigned long *pulPosition);
	bool GetDynValue(E_MSC_OPCODES eOpcode, unsigned long ulPosition, unsigned long ulChannel, signed long *pslValue);

	E_CONNECT_STATUS eConnStat;
	unsigned char aucRcvBufferStatic[MSC_BUF_SIZE_STATIC];
	unsigned char aucRcvBufferBitIO[MSC_BUF_SIZE_BITIO];
	unsigned char aucSndBufferBitIO[MSC_BUF_SIZE_BITIO];
	unsigned char aucRcvBufferHardStat[MSC_BUF_SIZE_HARDSTAT];
	unsigned char aucRcvBufferCmd[MSC_BUF_SIZE_WRITECMD];
	unsigned char aucSndBufferCmd[MSC_BUF_SIZE_WRITECMD];
private:
	MSC_HANDLE pDevice;
	signed long *apslValBufDyn[MAX_DYNAMIC_MEASUREMENT];
	unsigned long aulSizeValBufDyn[MAX_DYNAMIC_MEASUREMENT];
	unsigned long aulDynBytesPerChannel[MAX_DYNAMIC_MEASUREMENT];
};

