#include "StdAfx.h"
#include "cl_MscDll.h"



cl_MscDll::cl_MscDll(void)
{
}


/******************************************************************************
* FUNCTION: cl_MscDll::Load
*-----------------------------------------------------------------------------
* Loads the Msc-DLL and initializes all function pointers to the DLL.
* If the DLL or at least one function pointer can not be loaded/initialized,
* the return value is false.
*-----------------------------------------------------------------------------
* PARAMETERS: none
*-----------------------------------------------------------------------------
* Return: true on success, otherwise false
******************************************************************************/
bool cl_MscDll::Load(void)
{
	bool bReturnValue = true;

	/* Load MscDll */
	hMscDll = LoadLibrary(TEXT(".\\MscDll.dll"));
	if (hMscDll == NULL)
	{
		bReturnValue = false;
	}
	else
	{
		F_MSC_GetVersion = (T_MSC_GetVersion)GetProcAddress(hMscDll, "MSC_GetVersion");
		if (F_MSC_GetVersion == NULL)
		{
			bReturnValue = false;
		}
		
		F_MSC_EnumerateDevices = (T_MSC_EnumerateDevices)GetProcAddress(hMscDll, "MSC_EnumerateDevices");
		if (F_MSC_EnumerateDevices == NULL)
		{
			bReturnValue = false;
		}

		F_MSC_GetDeviceInfo = (T_MSC_GetDeviceInfo)GetProcAddress(hMscDll, "MSC_GetDeviceInfo");
		if (F_MSC_GetDeviceInfo == NULL)
		{
			bReturnValue = false;
		}

		F_MSC_OpenDevice = (T_MSC_OpenDevice)GetProcAddress(hMscDll, "MSC_OpenDevice");
		if (F_MSC_OpenDevice == NULL)
		{
			bReturnValue = false;
		}

		F_MSC_InitDevice = (T_MSC_InitDevice)GetProcAddress(hMscDll, "MSC_InitDevice");
		if (F_MSC_InitDevice == NULL)
		{
			bReturnValue = false;
		}

		F_MSC_CloseDevice = (T_MSC_CloseDevice)GetProcAddress(hMscDll, "MSC_CloseDevice");
		if (F_MSC_CloseDevice == NULL)
		{
			bReturnValue = false;
		}

		F_MSC_SetNotificationMessage = (T_MSC_SetNotificationMessage)GetProcAddress(hMscDll, "MSC_SetNotificationMessage");
		if (F_MSC_SetNotificationMessage == NULL)
		{
			bReturnValue = false;
		}

		F_MSC_Start = (T_MSC_Start)GetProcAddress(hMscDll, "MSC_Start");
		if (F_MSC_Start == NULL)
		{
			bReturnValue = false;
		}

		F_MSC_Stop = (T_MSC_Stop)GetProcAddress(hMscDll, "MSC_Stop");
		if (F_MSC_Stop == NULL)
		{
			bReturnValue = false;
		}

		F_MSC_WriteCommand = (T_MSC_WriteCommand)GetProcAddress(hMscDll, "MSC_WriteCommand");
		if (F_MSC_WriteCommand == NULL)
		{
			bReturnValue = false;
		}

		F_MSC_SetupStaticChannel = (T_MSC_SetupStaticChannel)GetProcAddress(hMscDll, "MSC_SetupStaticChannel");
		if (F_MSC_SetupStaticChannel == NULL)
		{
			bReturnValue = false;
		}

		F_MSC_SetupExtendedDynamicChannel = (T_MSC_SetupExtendedDynamicChannel)GetProcAddress(hMscDll, "MSC_SetupExtendedDynamicChannel");
		if (F_MSC_SetupExtendedDynamicChannel == NULL)
		{
			bReturnValue = false;
		}

		F_MSC_AttachSubChannelBuffer = (T_MSC_AttachSubChannelBuffer)GetProcAddress(hMscDll, "MSC_AttachSubChannelBuffer");
		if (F_MSC_AttachSubChannelBuffer == NULL)
		{
			bReturnValue = false;
		}

		F_MSC_DetachSubChannelBuffers = (T_MSC_DetachSubChannelBuffers)GetProcAddress(hMscDll, "MSC_DetachSubChannelBuffers");
		if (F_MSC_DetachSubChannelBuffers == NULL)
		{
			bReturnValue = false;
		}

		F_MSC_RefreshChannel = (T_MSC_RefreshChannel)GetProcAddress(hMscDll, "MSC_RefreshChannel");
		if (F_MSC_RefreshChannel == NULL)
		{
			bReturnValue = false;
		}

		F_MSC_GetPosition = (T_MSC_GetPosition)GetProcAddress(hMscDll, "MSC_GetPosition");
		if (F_MSC_GetPosition == NULL)
		{
			bReturnValue = false;
		}

		F_MSC_GetDeviceState = (T_MSC_GetDeviceState)GetProcAddress(hMscDll, "MSC_GetDeviceState");
		if (F_MSC_GetDeviceState == NULL)
		{
			bReturnValue = false;
		}

		F_MSC_ReadStatic = (T_MSC_ReadStatic)GetProcAddress(hMscDll, "MSC_ReadStatic");
		if (F_MSC_ReadStatic == NULL)
		{
			bReturnValue = false;
		}

		F_MSC_GetDwordValue = (T_MSC_GetDwordValue)GetProcAddress(hMscDll, "MSC_GetDwordValue");
		if (F_MSC_GetDwordValue == NULL)
		{
			bReturnValue = false;
		}
	}

	return bReturnValue;
}
