#pragma once
#include "Windows.h"

using namespace System;


#define MSC_MAX_UNIQUEID_SIZE 40
typedef void* MSC_HANDLE;


/* ### Return codes for various Dll functions */
typedef unsigned long MSC_STATUS;

#define MSC_STATUS_SUCCESS										0x00000000		// no error detected
#define MSC_STATUS_FAILED										0xF0000001		// general error
#define MSC_STATUS_INVALID_HANDLE								0xF0000002		// call an invalid handle
#define MSC_STATUS_INVALID_PARAMS								0xF0000003		// invalid parameter 
#define MSC_STATUS_NO_RESOURCES									0xF0000004		// no resources for creation
#define MSC_STATUS_NO_DEVICES									0xF0000005		// no device found
#define MSC_STATUS_NOT_INITIALIZED								0xF0000006		// member not initialzed
#define MSC_STATUS_ALREADY_INITIALIZED							0xF0000007		// cfi interface is already initialzed, repeated call
#define MSC_STATUS_INVALID_OBJECT_TYPE							0xF0000008		// handle identifies an invalid object type, handle is invalid for this function call
#define MSC_STATUS_INVALID_CHANNEL_TYPE							0xF0000009		// channel don't have the correct type for this function
#define MSC_STATUS_DEVICE_DISCONNECTED							0xF0000010		// device disconnected, disconnect timeout passed
#define MSC_STATUS_FUNCTION_NOT_ALLOWED							0xF0000100		// function not allowed at time
#define MSC_STATUS_NO_DATA_AVAILABLE							0xF0000200		// no data available
#define MSC_STATUS_NO_MORE_DATA									0xF0000400		// no more data
#define MSC_STATUS_BUFFER_TO_SHORT								0xF0000401		// buffer too short

// errors specific for USB FTDI part
#define MSC_STATUS_INVALID_ENDPOINT								0xF0000800		// invalid endpoint
#define MSC_STATUS_NOT_CONFIGERED								0xF0000801		// pipe was is not configured
#define MSC_STATUS_ALREADY_RUNNING								0xF0000802		// thread is already started
#define	MSC_STATUS_THREAD_NOT_STARTED							0xF0000803		// thread cannot be started

#define MSC_STATUS_NOT_COMPLETED								0xF000FFFE		// function not completed
#define MSC_STATUS_NOT_IMPLEMENTED								0xF000FFFF		// function not implemented


/* ### Declaration of DLL functions. See Dll-Documentation for information about the various functions. */
typedef void		(__stdcall *T_MSC_GetVersion)(unsigned long* ApiVersion,
												  unsigned long* DllVersion);
typedef MSC_STATUS	(__stdcall *T_MSC_EnumerateDevices)(unsigned long *DeviceNumber);
typedef MSC_STATUS  (__stdcall *T_MSC_GetDeviceInfo)(unsigned long Index,
									  				 unsigned long *BusType,
													 char *UniqueID);
typedef MSC_STATUS  (__stdcall *T_MSC_OpenDevice)(unsigned long Index,
												  MSC_HANDLE *Handle);
typedef MSC_STATUS  (__stdcall *T_MSC_InitDevice)(MSC_HANDLE Handle);
typedef MSC_STATUS  (__stdcall *T_MSC_CloseDevice)(MSC_HANDLE Handle);
typedef MSC_STATUS  (__stdcall *T_MSC_SetNotificationMessage)(MSC_HANDLE Handle,
															  int OpCode,
															  HWND hWnd,		// hWnd = NULL for unregister
															  ULONG MsgCode,
															  ULONG wParam,
															  ULONG lParam);
typedef MSC_STATUS  (__stdcall *T_MSC_Start)(MSC_HANDLE Handle,
											 unsigned long SndPeriod,			// ms 
											 unsigned long DisconnectTimeout,	// ms
											 unsigned long RetryCount,
											 unsigned long RespondsTimeout);	// ms 
typedef MSC_STATUS	(__stdcall *T_MSC_Stop)(MSC_HANDLE Handle);
typedef MSC_STATUS  (__stdcall *T_MSC_WriteCommand)(MSC_HANDLE Handle,
													unsigned char OpCode,
  													unsigned long SndBufferSize,
													void* SndBuffer,
													unsigned long RcvBufferSize,
													void* RcvBuffer,
													unsigned long* BytesReceived,
													unsigned long Timeout);	// in ms
typedef MSC_STATUS	(__stdcall *T_MSC_SetupStaticChannel)(MSC_HANDLE Handle,
													      unsigned char OpCode,
													      unsigned long SndBufferSize,
													      void* SndBuffer,
													      unsigned long RcvBufferSize);
typedef MSC_STATUS	(__stdcall *T_MSC_SetupExtendedDynamicChannel)(MSC_HANDLE Handle,
																   unsigned char OpCode,
																   unsigned char NumberOfSubChannels,
																   unsigned long SndBufferSize,
																   void* SndBuffer);
typedef MSC_STATUS	(__stdcall *T_MSC_AttachSubChannelBuffer)(MSC_HANDLE Handle,
															  unsigned char OpCode,
															  unsigned char SubChannel,
															  unsigned long BufferSize,
															  void* Buffer);
typedef MSC_STATUS	(__stdcall *T_MSC_DetachSubChannelBuffers)(MSC_HANDLE Handle,
															   unsigned char OpCode);
typedef MSC_STATUS  (__stdcall *T_MSC_RefreshChannel)(MSC_HANDLE Handle,
													  unsigned char OpCode);
typedef MSC_STATUS	(__stdcall *T_MSC_GetPosition)(MSC_HANDLE Handle,
												   unsigned char OpCode,
												   unsigned long *Position);
typedef MSC_STATUS	(__stdcall *T_MSC_GetDeviceState)(MSC_HANDLE Handle,
													  unsigned long* LastMsgReceived, // in ms units
													  unsigned long* SndErrorCounter,
													  unsigned long* RcvErrorCounter,
													  unsigned long* CmdDiscarded,
													  unsigned long* CmdDiscardedArray,
													  unsigned long Flags);
typedef MSC_STATUS	(__stdcall *T_MSC_ReadStatic)(MSC_HANDLE Handle,
												  unsigned char OpCode,
												  unsigned long BufferSize,
												  void* Buffer,
												  unsigned long* DataCount);
typedef MSC_STATUS  (__stdcall *T_MSC_GetDwordValue)(unsigned char* SectionName,
	                                                 unsigned char* KeyName,
													 unsigned long* Value);




class cl_MscDll
{
public:
	cl_MscDll(void);
	bool Load(void);
	T_MSC_GetVersion					F_MSC_GetVersion;
	T_MSC_EnumerateDevices				F_MSC_EnumerateDevices;
	T_MSC_GetDeviceInfo					F_MSC_GetDeviceInfo;
	T_MSC_OpenDevice					F_MSC_OpenDevice;
	T_MSC_InitDevice					F_MSC_InitDevice;
	T_MSC_CloseDevice					F_MSC_CloseDevice;
	T_MSC_SetNotificationMessage		F_MSC_SetNotificationMessage;
	T_MSC_Start							F_MSC_Start;
	T_MSC_Stop							F_MSC_Stop;
	T_MSC_WriteCommand					F_MSC_WriteCommand;
	T_MSC_SetupStaticChannel			F_MSC_SetupStaticChannel;
	T_MSC_SetupExtendedDynamicChannel	F_MSC_SetupExtendedDynamicChannel;
	T_MSC_AttachSubChannelBuffer		F_MSC_AttachSubChannelBuffer;
	T_MSC_DetachSubChannelBuffers		F_MSC_DetachSubChannelBuffers;
	T_MSC_RefreshChannel				F_MSC_RefreshChannel;
	T_MSC_GetPosition					F_MSC_GetPosition;
	T_MSC_GetDeviceState				F_MSC_GetDeviceState;
	T_MSC_ReadStatic					F_MSC_ReadStatic;
	T_MSC_GetDwordValue					F_MSC_GetDwordValue;
private:
	HINSTANCE hMscDll;
};

