﻿Public Class ChannelData
    Private slStaticValue As Int32 = &H7FFFFFFF
    Private slStaticMin As Int32 = &H7FFFFFFF
    Private slStaticMax As Int32 = &H80000000
    Public fdFactor As Double = 1.0
    Public strUnit As String = "Digit"
    Public ulNDigits As UInt32 = 0

    Public Sub NewStaticValue(ByVal slValue As Int32)
        ' Update Min/Max
        If slValue < slStaticMin Then
            slStaticMin = slValue
        End If
        If slValue > slStaticMax Then
            slStaticMax = slValue
        End If

        ' Update Value
        slStaticValue = slValue
    End Sub

    Public Function GetNewestValue() As Int32
        Return slStaticValue
    End Function

    Public Sub ResetStaticMinMax()
        slStaticMin = &H7FFFFFFF
        slStaticMax = &H80000000
    End Sub

    Public Function GetStaticDiff() As Int32
        If slStaticMax >= slStaticMin Then
            Return slStaticMax - slStaticMin
        End If
        Return &H7FFFFFFF
    End Function

    Public Function GetStaticUnitValue() As String
        Dim strFormat As String = String.Format("F{0}", ulNDigits)
        Dim fdValue As Double = slStaticValue * fdFactor
        Return fdValue.ToString(strFormat) + " " + strUnit
    End Function

    Public Function GetStaticUnitMin() As String
        Dim strFormat As String = String.Format("F{0}", ulNDigits)
        Dim fdValue As Double = slStaticMin * fdFactor
        Return fdValue.ToString(strFormat) + " " + strUnit
    End Function

    Public Function GetStaticUnitMax() As String
        Dim strFormat As String = String.Format("F{0}", ulNDigits)
        Dim fdValue As Double = slStaticMax * fdFactor
        Return fdValue.ToString(strFormat) + " " + strUnit
    End Function

    Public Function GetStaticUnitDiff() As String
        Dim strFormat As String = String.Format("F{0}", ulNDigits)
        Dim fdValue As Double = GetStaticDiff() * fdFactor
        Return fdValue.ToString(strFormat) + " " + strUnit
    End Function
End Class
