﻿Public Class Form1
    Private Const N_STATIC_CH_DISPLAY = 64
    Private Const N_DIGIIO_DISPLAY = 128
    Private Const N_MAX_SAMPLING_CHANNELS = 256
    Dim albDIn(N_DIGIIO_DISPLAY) As System.Windows.Forms.Label
    Dim acbDigiOut(N_DIGIIO_DISPLAY) As System.Windows.Forms.CheckBox
    Dim aaslRingBuf(,) As Int32
    Dim pHandleNmx As UInt32 = 0
    Dim bConnected As Boolean = False
    Dim ulBoxInfoUpdates As UInt32 = 0
    Dim ulChannelInfoUpdates As UInt32 = 0
    Dim ulStatic1stCh As UInt32 = 1
    Dim ulNSamplingElements As UInt32 = 0
    Dim bNewStatic As Boolean = False
    Dim bNewSamplingData As Boolean = False
    Dim bSamplingReadRows As Boolean = False
    Dim bNewReconnected As Boolean = False
    Dim ulCtrReconnects As UInt32 = 0
    Dim ulCtrSamplingNotificationsNewData As UInt32 = 0
    Dim ulCtrSamplingNotificationsFinished As UInt32 = 0
    Dim ulCtrSamplingNotificationsAllReceived As UInt32 = 0
    Dim ulCtrSamplingNotificationsError As UInt32 = 0
    Dim ulCtrSamplingNotificationsBufferOverflow As UInt32 = 0
    Dim ulCtrSamplingNotificationTimeout As UInt32 = 0
    Dim aclChannelData As New List(Of ChannelData)
    Dim ulSamplePeriodExtreme As UInt32 = 2000
    Dim ulSamplePeriodUltraFast As UInt32 = 1000
    Dim ulSamplePeriodFast As UInt32 = 500
    Dim ulSamplePeriodStandard As UInt32 = 100
    Dim ulSamplingEndlessArrayLength As UInt32 = 0
    Dim ulSamplingArrayRowNewest As UInt32 = 0
    Dim udSamplingCtrNewest As UInt64 = 0
    Dim bWriteDigitalOutputData As Boolean = False


    '*****************************************************************************
    ' FUNCTION: Form1_Load
    '-----------------------------------------------------------------------------
    ' Called after the form is loaded. Do several initializations.
    '*****************************************************************************
    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        Dim usMajor As UInt16 = 0
        Dim usMinor As UInt16 = 0
        Dim usPatch As UInt16 = 0
        Dim usBuild As UInt16 = 0
        Dim ulI As UInt32 = 0
        Dim str As String = ""
        Dim strHeader As String = ""

        For ulI = 0 To N_STATIC_CH_DISPLAY - 1
            aclChannelData.Add(New ChannelData())
        Next

        cbSampling_MeasChannels.Items.Clear()
        cbSampling_DigitalInputs.Items.Clear()
        cbSampling_DigitalOutputs.Items.Clear()

        'Set Readme text
        str = "This is a demo for the Nmx-DLL. Please note:" & Environment.NewLine & Environment.NewLine &
            "The purpose of this demo is helping software developers to integrate the measurement system into their software." & Environment.NewLine &
            "Focus has been put on demonstrating how to use the Nmx-DLL. User interface design an error handling are very basic. " &
            "Integration into your own software probably requires a more sophisticated user interface and extended error handling." & Environment.NewLine & Environment.NewLine &
            "THIS DEMO COMES WITHOUT ANY WARRANTY OR LIABILITY." & Environment.NewLine & Environment.NewLine &
            "We strongly recomment to separate the GUI-update and the DLL into different Windows-threads. " &
            "One way to do this is using Windows messages in combination with a timer, that runs in the GUI thread. " &
            "In this example this is demonstrated by the combination of WndProc and tmrStatic_Tick." & Environment.NewLine &
            "In this demo the NmxDLL.dll file must be placed in the same directory as the Exe." & Environment.NewLine &
            "By default the IP-Adress 192.168.3.99 is used for the system. Change it, if required." & Environment.NewLine &
            "Messtechnik Sachs GmbH\r\nwww.messtechnik-sachs.de\r\nPhone: +49 7181 26935 0"
        tBoxReadme.Text = str

        albDIn = {lbDIn_1, lbDIn_2, lbDIn_3, lbDIn_4, lbDIn_5, lbDIn_6, lbDIn_7, lbDIn_8,
            lbDIn_9, lbDIn_10, lbDIn_11, lbDIn_12, lbDIn_13, lbDIn_14, lbDIn_15, lbDIn_16,
            lbDIn_17, lbDIn_18, lbDIn_19, lbDIn_20, lbDIn_21, lbDIn_22, lbDIn_23, lbDIn_24,
            lbDIn_25, lbDIn_26, lbDIn_27, lbDIn_28, lbDIn_29, lbDIn_30, lbDIn_31, lbDIn_32,
            lbDIn_33, lbDIn_34, lbDIn_35, lbDIn_36, lbDIn_37, lbDIn_38, lbDIn_39, lbDIn_40,
            lbDIn_41, lbDIn_42, lbDIn_43, lbDIn_44, lbDIn_45, lbDIn_46, lbDIn_47, lbDIn_48,
            lbDIn_49, lbDIn_50, lbDIn_51, lbDIn_52, lbDIn_53, lbDIn_54, lbDIn_55, lbDIn_56,
            lbDIn_57, lbDIn_58, lbDIn_59, lbDIn_60, lbDIn_61, lbDIn_62, lbDIn_63, lbDIn_64,
            lbDIn_65, lbDIn_66, lbDIn_67, lbDIn_68, lbDIn_69, lbDIn_70, lbDIn_71, lbDIn_72,
            lbDIn_73, lbDIn_74, lbDIn_75, lbDIn_76, lbDIn_77, lbDIn_78, lbDIn_79, lbDIn_80,
            lbDIn_81, lbDIn_82, lbDIn_83, lbDIn_84, lbDIn_85, lbDIn_86, lbDIn_87, lbDIn_88,
            lbDIn_89, lbDIn_90, lbDIn_91, lbDIn_92, lbDIn_93, lbDIn_94, lbDIn_95, lbDIn_96,
            lbDIn_97, lbDIn_98, lbDIn_99, lbDIn_100, lbDIn_101, lbDIn_102, lbDIn_103, lbDIn_104,
            lbDIn_105, lbDIn_106, lbDIn_107, lbDIn_108, lbDIn_109, lbDIn_110, lbDIn_111, lbDIn_112,
            lbDIn_113, lbDIn_114, lbDIn_115, lbDIn_116, lbDIn_117, lbDIn_118, lbDIn_119, lbDIn_120,
            lbDIn_121, lbDIn_122, lbDIn_123, lbDIn_124, lbDIn_125, lbDIn_126, lbDIn_127, lbDIn_128}
        acbDigiOut = {dbDOut_1, dbDOut_2, dbDOut_3, dbDOut_4, dbDOut_5, dbDOut_6, dbDOut_7, dbDOut_8,
            dbDOut_9, dbDOut_10, dbDOut_11, dbDOut_12, dbDOut_13, dbDOut_14, dbDOut_15, dbDOut_16,
            dbDOut_17, dbDOut_18, dbDOut_19, dbDOut_20, dbDOut_21, dbDOut_22, dbDOut_23, dbDOut_24,
            dbDOut_25, dbDOut_26, dbDOut_27, dbDOut_28, dbDOut_29, dbDOut_30, dbDOut_31, dbDOut_32,
            dbDOut_33, dbDOut_34, dbDOut_35, dbDOut_36, dbDOut_37, dbDOut_38, dbDOut_39, dbDOut_40,
            dbDOut_41, dbDOut_42, dbDOut_43, dbDOut_44, dbDOut_45, dbDOut_46, dbDOut_47, dbDOut_48,
            dbDOut_49, dbDOut_50, dbDOut_51, dbDOut_52, dbDOut_53, dbDOut_54, dbDOut_55, dbDOut_56,
            dbDOut_57, dbDOut_58, dbDOut_59, dbDOut_60, dbDOut_61, dbDOut_62, dbDOut_63, dbDOut_64,
            dbDOut_65, dbDOut_66, dbDOut_67, dbDOut_68, dbDOut_69, dbDOut_70, dbDOut_71, dbDOut_72,
            dbDOut_73, dbDOut_74, dbDOut_75, dbDOut_76, dbDOut_77, dbDOut_78, dbDOut_79, dbDOut_80,
            dbDOut_81, dbDOut_82, dbDOut_83, dbDOut_84, dbDOut_85, dbDOut_86, dbDOut_87, dbDOut_88,
            dbDOut_89, dbDOut_90, dbDOut_91, dbDOut_92, dbDOut_93, dbDOut_94, dbDOut_95, dbDOut_96,
            dbDOut_97, dbDOut_98, dbDOut_99, dbDOut_100, dbDOut_101, dbDOut_102, dbDOut_103, dbDOut_104,
            dbDOut_105, dbDOut_106, dbDOut_107, dbDOut_108, dbDOut_109, dbDOut_110, dbDOut_111, dbDOut_112,
            dbDOut_113, dbDOut_114, dbDOut_115, dbDOut_116, dbDOut_117, dbDOut_118, dbDOut_119, dbDOut_120,
            dbDOut_121, dbDOut_122, dbDOut_123, dbDOut_124, dbDOut_125, dbDOut_126, dbDOut_127, dbDOut_128}

        'Try to load the DLL
        Try
            NmxDLL.GetDllVersion_1(usMajor, usMinor, usPatch, usBuild)
            str = String.Format("NmxDll loaded successfully: V{0}.{1}.{2}.{3}", usMajor, usMinor, usPatch, usBuild)
            strHeader = String.Format("NmxDLL V{0}.{1}.{2}.{3}", usMajor, usMinor, usPatch, usBuild)
            AddHistoryEntry(str, False)
        Catch ex As Exception
            AddHistoryEntry("Failed to load the NmxDll. In same directory as the exe?", True)
        End Try

        Me.Text = "Nmx Demo for VB # " + strHeader
    End Sub


    '******************************************************************************
    ' FUNCTION: AddHistoryEntry
    '-----------------------------------------------------------------------------
    ' Add a new line with information for the user in the history-Listbox.
    '-----------------------------------------------------------------------------
    ' PARAMETERS:
    ' str: String to display in the new line
    ' bError: false -> "only" information
    '         true -> an error occured
    '         So far this parameter is not used. It is intended future
    '         extension of this function. However, when calling this function,
    '         this parameter should be used as intended.
    '-----------------------------------------------------------------------------
    ' Return: none
    '*****************************************************************************
    Private Sub AddHistoryEntry(ByVal str As String, ByVal bError As Boolean)
        If bError = False Then
            lbHistory.Items.Insert(0, str)
        Else
            lbHistory.Items.Insert(0, "[Error] " + str)
        End If

    End Sub

    '******************************************************************************
    ' FUNCTION: Form1_FormClosed
    '-----------------------------------------------------------------------------
    ' Called after the form has been closed. Do some cleanup.
    '*****************************************************************************
    Private Sub Form1_FormClosed(sender As Object, e As FormClosedEventArgs) Handles MyBase.FormClosed
        NmxDLL.DeviceClose_1(pHandleNmx)
    End Sub


    '******************************************************************************
    ' FUNCTION: SamplingClearNotificationCtrs
    '-----------------------------------------------------------------------------
    ' Clear all notification counters for sampling.
    '-----------------------------------------------------------------------------
    ' PARAMETERS: none
    '-----------------------------------------------------------------------------
    ' Return: none
    '*****************************************************************************
    Private Sub SamplingClearNotificationCtrs()
        ulCtrSamplingNotificationsNewData = 0
        ulCtrSamplingNotificationsFinished = 0
        ulCtrSamplingNotificationsAllReceived = 0
        ulCtrSamplingNotificationsError = 0
        ulCtrSamplingNotificationsBufferOverflow = 0
        ulCtrSamplingNotificationTimeout = 0
    End Sub

    '******************************************************************************
    ' FUNCTION: btnConnect_Click
    '-----------------------------------------------------------------------------
    ' Connect / Disconnect the NMX device.
    '*****************************************************************************
    Private Sub btnConnect_Click(sender As Object, e As EventArgs) Handles btnConnect.Click
        Dim ulStatus As UInt32 = NmxDLL.NST_SUCCESS
        Dim I As Integer = 0

        If bConnected = False Then
            ulCtrReconnects = 0

            ulStatus = NmxDLL.DeviceIPv4Open_1(192, 168, 3, 99, 22517, 22516, pHandleNmx)
            If ulStatus = NmxDLL.NST_SUCCESS Then
                AddHistoryEntry("Device connected successfully", False)
                bConnected = True
                lbConnectionStatus.Text = "Status: Connected"
                lbConnectionStatus.ForeColor = Color.Green
                btnConnect.Text = "Disconnect"

                btnChannelInfoUpdate_Click(sender, e)

                Dim ulNChannels As UInt32 = 0
                Dim ulNInputs As UInt32 = 0
                Dim ulNOutputs As UInt32 = 0
                NmxDLL.GetChannelCount_1(pHandleNmx, ulNChannels, ulNInputs, ulNOutputs)

                nuChannelSetParameterNo.Value = 0
                nuChannelSetConfigNo.Value = 0
                If ulNChannels > 0 Then
                    For I = 0 To ulNChannels - 1
                        Dim ulBoxNo As UInt32 = &HFF
                        Dim ulChannelNo As UInt32 = &HFF
                        NmxDLL.GetChannelInfo_1(pHandleNmx, I, Nothing, Nothing, ulBoxNo, Nothing, ulChannelNo, Nothing, Nothing, Nothing, Nothing, Nothing, Nothing, Nothing, Nothing, Nothing, Nothing)
                        cbSampling_MeasChannels.Items.Add(String.Format("P{0} - Box {1} . Ch {2}", I + 1, ulBoxNo, ulChannelNo))
                    Next
                    nuChannelSetParameterNo.Maximum = ulNChannels - 1
                    nuChannelSetConfigNo.Maximum = ulNChannels - 1
                End If

                If ulNInputs > 0 Then
                    For I = 0 To ulNInputs - 1
                        Dim ulBoxNo As UInt32 = &HFF
                        Dim ulByteNo As UInt32 = &HFF
                        NmxDLL.GetDigitalInputInfo_1(pHandleNmx, I, ulBoxNo, ulByteNo)
                        cbSampling_DigitalInputs.Items.Add(String.Format("In Byte {0} - Box {1} : {2}..{3}", I + 1, ulBoxNo, (ulByteNo - 1) * 8 + 1, (ulByteNo - 1) * 8 + 8))
                    Next
                End If

                If ulNOutputs > 0 Then
                    For I = 0 To ulNOutputs - 1
                        Dim ulBoxNo = &HFF
                        Dim ulByteNo = &HFF
                        NmxDLL.GetDigitalOutputInfo_1(pHandleNmx, I, ulBoxNo, ulByteNo)
                        cbSampling_DigitalOutputs.Items.Add(String.Format("Out Byte {0} - Box {1} : {2}..{3}", I + 1, ulBoxNo, (ulByteNo - 1) * 8 + 1, (ulByteNo - 1) * 8 + 8))
                    Next
                End If

                ' Register Windows messages to receive notifications from the NMX-DLL. 
                ' The messages will be received by the message handler WndProc (see below).
                ulStatus = NmxDLL.RegisterMessage_1(pHandleNmx, NmxDLL.NOTIFY_DISCONNECTED, Me.Handle, NmxDLL.WM_DISCONNECTED, 0, 0)
                If ulStatus <> NmxDLL.NST_SUCCESS Then
                    AddHistoryEntry("Registering message for disconnect failed.", True)
                End If
                ulStatus = NmxDLL.RegisterMessage_1(pHandleNmx, NmxDLL.NOTIFY_FAILURE_DATA_EXCHANGE, Me.Handle, NmxDLL.WM_FAILURE_DATA_EXCHANGE, 0, 0)
                If ulStatus <> NmxDLL.NST_SUCCESS Then
                    AddHistoryEntry("Registering message for data exchange failure failed.", True)
                End If
                ulStatus = NmxDLL.RegisterMessage_1(pHandleNmx, NmxDLL.NOTIFY_RECONNECTED, Me.Handle, NmxDLL.WM_RECONNECTED, 0, 0)
                If ulStatus <> NmxDLL.NST_SUCCESS Then
                    AddHistoryEntry("Registering message for reconnected failed.", True)
                End If
                ulStatus = NmxDLL.RegisterMessage_1(pHandleNmx, NmxDLL.NOTIFY_NEW_STATIC32, Me.Handle, NmxDLL.WM_NEW_STATIC32, 0, 0)
                If ulStatus <> NmxDLL.NST_SUCCESS Then
                    AddHistoryEntry("Registering message for new static data failed.", True)
                End If
                ulStatus = NmxDLL.RegisterMessage_1(pHandleNmx, NmxDLL.NOTIFY_SAMPLING_NEW_DATA, Me.Handle, NmxDLL.WM_SAMPLING_NEW_DATA, 0, 0)
                If ulStatus <> NmxDLL.NST_SUCCESS Then
                    AddHistoryEntry("Registering message for new sampling data failed.", True)
                End If
                ulStatus = NmxDLL.RegisterMessage_1(pHandleNmx, NmxDLL.NOTIFY_SAMPLING_ALL_DATA_RECEIVED, Me.Handle, NmxDLL.WM_SAMPLING_ALL_DATA_RECEIVED, 0, 0)
                If ulStatus <> NmxDLL.NST_SUCCESS Then
                    AddHistoryEntry("Registering message for 'all sampling data received' failed.", True)
                End If
                ulStatus = NmxDLL.RegisterMessage_1(pHandleNmx, NmxDLL.NOTIFY_SAMPLING_FINISHED, Me.Handle, NmxDLL.WM_SAMPLING_FINISHED, 0, 0)
                If ulStatus <> NmxDLL.NST_SUCCESS Then
                    AddHistoryEntry("Registering message for 'sampling finished' failed.", True)
                End If
                ulStatus = NmxDLL.RegisterMessage_1(pHandleNmx, NmxDLL.NOTIFY_SAMPLING_ERROR, Me.Handle, NmxDLL.WM_SAMPLING_ERROR, 0, 0)
                If ulStatus <> NmxDLL.NST_SUCCESS Then
                    AddHistoryEntry("Registering message for 'sampling error' failed.", True)
                End If
                ulStatus = NmxDLL.RegisterMessage_1(pHandleNmx, NmxDLL.NOTIFY_SAMPLING_BUFFER_OVERFLOW, Me.Handle, NmxDLL.WM_SAMPLING_BUFFER_OVERFLOW, 0, 0)
                If ulStatus <> NmxDLL.NST_SUCCESS Then
                    AddHistoryEntry("Registering message for 'sampling buffer overflow' failed.", True)
                End If
                ulStatus = NmxDLL.RegisterMessage_1(pHandleNmx, NmxDLL.NOTIFY_SAMPLING_TIMEOUT, Me.Handle, NmxDLL.WM_SAMPLING_TIMEOUT, 0, 0)
                If ulStatus <> NmxDLL.NST_SUCCESS Then
                    AddHistoryEntry("Registering message for 'sampling timeout' failed.", True)
                End If

                ' Get min sample period and determine different speed levels for the demo.
                ' In your measurement application you do not need to have different speed levels.
                ' This is just for the demo!
                SamplingUpdateSpeedLevels()
            Else
                AddHistoryEntry("Failed connecting the device", True)
            End If
        Else
            ulStatus = NmxDLL.DeviceClose_1(pHandleNmx)
            If ulStatus = NmxDLL.NST_SUCCESS Then
                AddHistoryEntry("Device disconnected successfully", False)
            Else
                AddHistoryEntry("Failed disconnecting the device", True)
            End If
            bConnected = False
            btnConnect.Text = "Connect"
        End If
    End Sub


    '******************************************************************************
    ' FUNCTION: WndProc
    '-----------------------------------------------------------------------------
    ' This function is called when the form receives a new windows message.
    ' All messages from the NmxDll are filtered out and processed. All other
    ' messages are forwarded to the respective form message function
    ' MyBase.WndProc(recWinMessage).
    '*****************************************************************************/
    Protected Overrides Sub WndProc(ByRef recWinMessage As System.Windows.Forms.Message)
        Select Case recWinMessage.Msg
            Case NmxDLL.WM_DISCONNECTED
                bConnected = False
                btnConnect.Text = "Connect"
                lbConnectionStatus.Text = "Status: Disconnected"
                lbConnectionStatus.ForeColor = Color.Black

            Case NmxDLL.WM_FAILURE_DATA_EXCHANGE
                lbConnectionStatus.Text = "Status: Timeout"
                lbConnectionStatus.ForeColor = Color.Red

            Case NmxDLL.WM_RECONNECTED
                bConnected = True
                ulCtrReconnects += 1
                btnConnect.Text = "Disconnect"
                lbConnectionStatus.Text = String.Format("Status: Reconnected ({0})", ulCtrReconnects)
                lbConnectionStatus.ForeColor = Color.Purple
                bNewReconnected = True

            Case NmxDLL.WM_NEW_STATIC32
                bNewStatic = True

            Case NmxDLL.WM_SAMPLING_NEW_DATA
                bNewSamplingData = True
                ulCtrSamplingNotificationsNewData += 1

            Case NmxDLL.WM_SAMPLING_FINISHED
                ulCtrSamplingNotificationsFinished += 1

            Case NmxDLL.WM_SAMPLING_ALL_DATA_RECEIVED
                ulCtrSamplingNotificationsAllReceived += 1

            Case NmxDLL.WM_SAMPLING_ERROR
                ulCtrSamplingNotificationsError += 1

            Case NmxDLL.WM_SAMPLING_BUFFER_OVERFLOW
                ulCtrSamplingNotificationsBufferOverflow += 1

            Case NmxDLL.WM_SAMPLING_TIMEOUT
                ulCtrSamplingNotificationTimeout += 1

            Case Else
                'Pass all standard messages to the GUI form. 
                MyBase.WndProc(recWinMessage)
        End Select
    End Sub


    '******************************************************************************
    ' FUNCTION: btnChannelInfoUpdate_Click
    '-----------------------------------------------------------------------------
    ' Update channel information.
    '*****************************************************************************
    Private Sub btnChannelInfoUpdate_Click(sender As Object, e As EventArgs) Handles btnChannelInfoUpdate.Click
        Dim ulChannelCount As UInt32 = 0
        Dim ulChannel As UInt32 = 0

        Dim ulChannelType As UInt32 = 0
        Dim ulNDigits As UInt32 = 1
        Dim ulBoxNo As UInt32 = 0
        Dim ulBoxChannelNo As UInt32 = 0
        Dim slRawDataType As Int32 = 0
        Dim slFactNumerator As Int32 = 1
        Dim slFactDenominator As Int32 = 1
        Dim flFactDigitsToUnit As Single = 1.0
        Dim acUnit(8 + 1) As Byte
        Dim acOrderNo(16 + 1) As Byte
        Dim acSerialNo(16 + 1) As Byte
        Dim strChannelNo As String = ""
        Dim strLocation As String = ""
        Dim strChannelType As String = ""
        Dim strUnit As String = ""
        Dim strFactor As String = ""
        Dim strDigits As String = ""
        Dim strOrderNo As String = ""
        Dim strSerialNo As String = ""
        Dim astrRow As String()

        If NmxDLL.UpdateChannelInfo_1(pHandleNmx) <> NmxDLL.NST_SUCCESS Then
            AddHistoryEntry("Updating channel information failed.", True)
            Return
        End If

        If NmxDLL.GetChannelCount_1(pHandleNmx, ulChannelCount, Nothing, Nothing) <> NmxDLL.NST_SUCCESS Then
            AddHistoryEntry("Reading channel count failed.", True)
        End If

        dataGridViewChInfo.Rows.Clear()
        ulChannel = 0
        While ulChannel < ulChannelCount
            acUnit(0) = 0
            acOrderNo(0) = 0
            acSerialNo(0) = 0
            If NmxDLL.GetChannelInfo_1(pHandleNmx, ulChannel, ulChannelType, ulNDigits, ulBoxNo, Nothing, ulBoxChannelNo, slRawDataType, slFactNumerator, slFactDenominator, flFactDigitsToUnit, acUnit(0), acUnit.Length, acOrderNo(0), acOrderNo.Length, acSerialNo(0), acSerialNo.Length) <> NmxDLL.NST_SUCCESS Then
                AddHistoryEntry("Reading channel info failed.", True)
            Else
                strChannelNo = String.Format("{0}", ulChannel)
                strLocation = String.Format("Box {0} # Ch. {1}", ulBoxNo, ulBoxChannelNo)
                strChannelType = String.Format("0x{0:X4}", ulChannelType)
                strUnit = System.Text.Encoding.Default.GetString(acUnit, 0, GetByteArrayStringLength(acUnit))
                strFactor = String.Format("{0} {1}/digit # {2}/{3}", flFactDigitsToUnit, strUnit, slFactNumerator, slFactDenominator)
                strDigits = String.Format("{0}", ulNDigits)
                strOrderNo = System.Text.Encoding.Default.GetString(acOrderNo, 0, GetByteArrayStringLength(acOrderNo))
                strSerialNo = System.Text.Encoding.Default.GetString(acSerialNo, 0, GetByteArrayStringLength(acSerialNo))
                astrRow = New String() {strChannelNo, strLocation, strChannelType, strUnit, strFactor, strDigits, strOrderNo, strSerialNo}
                dataGridViewChInfo.Rows.Add(astrRow)
                If ulChannel < N_STATIC_CH_DISPLAY Then
                    aclChannelData(ulChannel).fdFactor = flFactDigitsToUnit
                    aclChannelData(ulChannel).ulNDigits = ulNDigits
                    aclChannelData(ulChannel).strUnit = strUnit
                End If
            End If
            ulChannel += 1
        End While

        ulChannelInfoUpdates += 1
        lbChInfoUpdates.Text = String.Format("{0} update", ulChannelInfoUpdates)
        If ulChannelInfoUpdates > 1 Then
            lbChInfoUpdates.Text += "s"
        End If

    End Sub


    '******************************************************************************
    ' FUNCTION: GetByteArrayStringLength
    '-----------------------------------------------------------------------------
    ' Calculates the length of a 0-terminates Default string in a byte array.
    '*****************************************************************************
    Private Function GetByteArrayStringLength(ByVal aString As Byte()) As Integer
        Dim I As Integer = 0

        If aString.Length = 0 Then
            Return 0
        End If

        For I = 0 To aString.Length
            If aString(I) = 0 Then
                Return I
            End If
        Next

        Return 0
    End Function


    '******************************************************************************
    ' FUNCTION: SamplingUpdateSpeedLevels
    '-----------------------------------------------------------------------------
    ' Retrieve the maximum speed from the system and set speed levels
    ' accordingly.
    ' Using different speed levels is not required for your measurement application.
    ' It is just for demonstration purposes here.
    '*****************************************************************************
    Private Sub SamplingUpdateSpeedLevels()
        Dim ulPeriodMin As UInt32 = 1000
        If NmxDLL.Sampling_GetMaxSpeed_1(pHandleNmx, ulPeriodMin) = NmxDLL.NST_SUCCESS Then
            ulSamplePeriodExtreme = ulPeriodMin
            If ulPeriodMin <= 50 Then
                ulSamplePeriodFast = 1000
                ulSamplePeriodStandard = 10000
                ulSamplePeriodUltraFast = 2 * ulPeriodMin
            ElseIf ulPeriodMin < 1000 Then
                ulSamplePeriodFast = 1000
                ulSamplePeriodStandard = 10000
                ulSamplePeriodUltraFast = 2 * ulPeriodMin
            Else
                ulSamplePeriodFast = 250
                ulSamplePeriodStandard = 10000
                ulSamplePeriodUltraFast = 500
            End If
            Dim flTime As Double = ulSamplePeriodUltraFast / 1000.0F
            Dim flSpeed As Double = 1000000.0F / ulSamplePeriodUltraFast
            rbSampling_TimeHigh.Text = String.Format("{0}ms / {1:0} samples/s", flTime, flSpeed)
            flTime = ulSamplePeriodFast / 1000.0F
            flSpeed = 1000000.0F / ulSamplePeriodFast
            rbSampling_TimeMid.Text = String.Format("{0}ms / {1:0} samples/s", flTime, flSpeed)
            flTime = ulSamplePeriodStandard / 1000.0F
            flSpeed = 1000000.0F / ulSamplePeriodStandard
            rbSampling_TimeStandard.Text = String.Format("{0}ms / {1:0} samples/s", flTime, flSpeed)
            flTime = ulSamplePeriodExtreme / 1000.0F
            flSpeed = 1000000.0F / ulSamplePeriodExtreme
            rbSampling_TimeExtreme.Text = String.Format("{0}ms / {1:0} samples/s", flTime, flSpeed)
        Else
            AddHistoryEntry("Failed reading minimum sample period.", True)
        End If
    End Sub


    '******************************************************************************
    ' FUNCTION: btnBoxInfoUpdate_Click
    '-----------------------------------------------------------------------------
    ' Update box information.
    '*****************************************************************************
    Private Sub btnBoxInfoUpdate_Click(sender As Object, e As EventArgs) Handles btnBoxInfoUpdate.Click
        Dim ulBoxCount As UInt32 = 0
        Dim ulBoxNo As UInt32 = 0
        Dim aulInfoData(20) As UInt32
        Dim udMacAddress As UInt64 = 0
        Dim acSerNo(16 + 1) As Byte
        Dim acProdCode(16 + 1) As Byte
        Dim acOrderNo(32 + 1) As Byte
        Dim acName(128 + 1) As Byte
        Dim strBoxNo As String = ""
        Dim strName As String = ""
        Dim strSerial As String = ""
        Dim strMac As String = ""
        Dim strFwVersion As String = ""
        Dim strHwVersion As String = ""
        Dim strNChannels As String = ""
        Dim strNDIn As String = ""
        Dim strNDOut As String = ""
        Dim strProdCode As String = ""
        Dim astrRow As String()

        If NmxDLL.GetBoxCount_1(pHandleNmx, ulBoxCount) <> NmxDLL.NST_SUCCESS Then
            AddHistoryEntry("Reading box count failed.", True)
            Return
        End If

        dataGridViewBoxInfo.Rows.Clear()
        ulBoxNo = 0
        While ulBoxNo < ulBoxCount
            acSerNo(0) = 0
            acProdCode(0) = 0
            acOrderNo(0) = 0
            acName(0) = 0
            If NmxDLL.GetBoxInfo_1(pHandleNmx, ulBoxNo, aulInfoData(0), aulInfoData.Length, udMacAddress, acSerNo(0), acSerNo.Length, acProdCode(0), acProdCode.Length, acOrderNo(0), acOrderNo.Length, acName(0), acName.Length) <> NmxDLL.NST_SUCCESS Then
                AddHistoryEntry("Reading box info failed.", True)
            Else
                strBoxNo = String.Format("{0}", aulInfoData(0))
                strName = System.Text.Encoding.Default.GetString(acName, 0, GetByteArrayStringLength(acName))
                strSerial = System.Text.Encoding.Default.GetString(acSerNo, 0, GetByteArrayStringLength(acSerNo))
                strMac = String.Format("{0:X2}-{1:X2}-{2:X2}-{3:X2}-{4:X2}-{5:X2}",
                    (udMacAddress >> 40) And &HFF,
                    (udMacAddress >> 32) And &HFF,
                    (udMacAddress >> 24) And &HFF,
                    (udMacAddress >> 16) And &HFF,
                    (udMacAddress << 8) And &HFF,
                    udMacAddress And &HFF)
                strFwVersion = String.Format("V{0}.{1}.{2}.{3}",
                    aulInfoData(4),
                    aulInfoData(5),
                    aulInfoData(6),
                    aulInfoData(7))
                strHwVersion = String.Format("V{0}.{1} Rev {2}",
                    aulInfoData(1),
                    aulInfoData(2),
                    aulInfoData(3))
                strNChannels = String.Format("{0}", aulInfoData(8))
                strNDIn = String.Format("{0}", aulInfoData(13))
                strNDOut = String.Format("{0}", aulInfoData(14))
                strProdCode = System.Text.Encoding.Default.GetString(acProdCode, 0, GetByteArrayStringLength(acProdCode))
                astrRow = New String() {strBoxNo, strName, strSerial, strMac, strFwVersion, strHwVersion, strNChannels, strNDIn, strNDOut, strProdCode}
                dataGridViewBoxInfo.Rows.Add(astrRow)
            End If
            ulBoxNo += 1
        End While

        ulBoxInfoUpdates += 1
        lbBoxInfoUpdates.Text = String.Format("{0} update", ulBoxInfoUpdates)
        If ulBoxInfoUpdates > 1 Then
            lbBoxInfoUpdates.Text += "s"
        End If
    End Sub

    '******************************************************************************
    ' FUNCTION: rbStaticCH1_8_CheckedChanged
    '-----------------------------------------------------------------------------
    ' Static measurement: The channel selection has been changed (e.g. from 1..8
    ' to 9..16). Update GUI.
    '*****************************************************************************
    Private Sub rbStaticCH1_8_CheckedChanged(sender As Object, e As EventArgs) Handles rbStaticCH1_8.CheckedChanged, rbStaticCH9_16.CheckedChanged, rbStaticCH57_64.CheckedChanged, rbStaticCH49_56.CheckedChanged, rbStaticCH41_48.CheckedChanged, rbStaticCH33_40.CheckedChanged, rbStaticCH25_32.CheckedChanged, rbStaticCH17_24.CheckedChanged
        If sender.Equals(rbStaticCH9_16) = True Then
            ulStatic1stCh = 9
        ElseIf sender.Equals(rbStaticCH17_24) = True Then
            ulStatic1stCh = 17
        ElseIf sender.Equals(rbStaticCH25_32) = True Then
            ulStatic1stCh = 25
        ElseIf sender.Equals(rbStaticCH33_40) = True Then
            ulStatic1stCh = 33
        ElseIf sender.Equals(rbStaticCH41_48) = True Then
            ulStatic1stCh = 41
        ElseIf sender.Equals(rbStaticCH49_56) = True Then
            ulStatic1stCh = 49
        ElseIf sender.Equals(rbStaticCH57_64) = True Then
            ulStatic1stCh = 57
        Else
            ulStatic1stCh = 1
        End If

        lbStaticCh1.Text = (ulStatic1stCh + 0).ToString()
        lbStaticCh2.Text = (ulStatic1stCh + 1).ToString()
        lbStaticCh3.Text = (ulStatic1stCh + 2).ToString()
        lbStaticCh4.Text = (ulStatic1stCh + 3).ToString()
        lbStaticCh5.Text = (ulStatic1stCh + 4).ToString()
        lbStaticCh6.Text = (ulStatic1stCh + 5).ToString()
        lbStaticCh7.Text = (ulStatic1stCh + 6).ToString()
        lbStaticCh8.Text = (ulStatic1stCh + 7).ToString()
        lbStaticDigits1.Text = "*"
        lbStaticDigits2.Text = "*"
        lbStaticDigits3.Text = "*"
        lbStaticDigits4.Text = "*"
        lbStaticDigits5.Text = "*"
        lbStaticDigits6.Text = "*"
        lbStaticDigits7.Text = "*"
        lbStaticDigits8.Text = "*"
        lbStaticUnit1.Text = "*"
        lbStaticUnit2.Text = "*"
        lbStaticUnit3.Text = "*"
        lbStaticUnit4.Text = "*"
        lbStaticUnit5.Text = "*"
        lbStaticUnit6.Text = "*"
        lbStaticUnit7.Text = "*"
        lbStaticUnit8.Text = "*"
        lbStaticHwStat1.Text = "*"
        lbStaticHwStat2.Text = "*"
        lbStaticHwStat3.Text = "*"
        lbStaticHwStat4.Text = "*"
        lbStaticHwStat5.Text = "*"
        lbStaticHwStat6.Text = "*"
        lbStaticHwStat7.Text = "*"
        lbStaticHwStat8.Text = "*"
        lbStaticMin1.Text = "*"
        lbStaticMin2.Text = "*"
        lbStaticMin3.Text = "*"
        lbStaticMin4.Text = "*"
        lbStaticMin5.Text = "*"
        lbStaticMin6.Text = "*"
        lbStaticMin7.Text = "*"
        lbStaticMin8.Text = "*"
        lbStaticMax1.Text = "*"
        lbStaticMax2.Text = "*"
        lbStaticMax3.Text = "*"
        lbStaticMax4.Text = "*"
        lbStaticMax5.Text = "*"
        lbStaticMax6.Text = "*"
        lbStaticMax7.Text = "*"
        lbStaticMax8.Text = "*"
        lbStaticDiff1.Text = "*"
        lbStaticDiff2.Text = "*"
        lbStaticDiff3.Text = "*"
        lbStaticDiff4.Text = "*"
        lbStaticDiff5.Text = "*"
        lbStaticDiff6.Text = "*"
        lbStaticDiff7.Text = "*"
        lbStaticDiff8.Text = "*"
    End Sub

    '******************************************************************************
    ' FUNCTION: tmrStatic_Tick
    '-----------------------------------------------------------------------------
    ' Timer for update of static data.
    '*****************************************************************************
    Private Sub tmrStatic_Tick(sender As Object, e As EventArgs) Handles tmrStatic.Tick
        Dim ulI As UInt32 = 0
        Dim iByte As Integer = 0
        Dim iBit As Integer = 0

        ' Disable this timer
        tmrStatic.Enabled = False

        cbStaticFastUpdate.Enabled = bConnected
        btnDigiEnableOutputWrite.Enabled = bConnected

        If bNewStatic <> False Then
            bNewStatic = False
            Dim aslMeasVal(N_STATIC_CH_DISPLAY) As Int32
            Dim aucHardStat(N_STATIC_CH_DISPLAY) As Byte
            Dim aucDigiIn(N_DIGIIO_DISPLAY / 8) As Byte
            Dim ulNUpdates As UInt32 = 0
            If NmxDLL.StaticGet32_1(pHandleNmx, aslMeasVal(0), aslMeasVal.Length, aucHardStat(0), aucHardStat.Length, aucDigiIn(0), aucDigiIn.Length, Nothing, 0, ulNUpdates) = NmxDLL.NST_SUCCESS Then
                If (ulStatic1stCh > 0) And (ulStatic1stCh <= (N_STATIC_CH_DISPLAY - 7)) Then
                    Dim ul1stCh As UInt32 = ulStatic1stCh - 1

                    For ulI = 0 To (8 - 1)
                        aclChannelData(ul1stCh + ulI).NewStaticValue(aslMeasVal(ul1stCh + ulI))
                    Next

                    lbStaticDigits1.Text = aclChannelData(ul1stCh + 0).GetNewestValue().ToString()
                    lbStaticDigits2.Text = aclChannelData(ul1stCh + 1).GetNewestValue().ToString()
                    lbStaticDigits3.Text = aclChannelData(ul1stCh + 2).GetNewestValue().ToString()
                    lbStaticDigits4.Text = aclChannelData(ul1stCh + 3).GetNewestValue().ToString()
                    lbStaticDigits5.Text = aclChannelData(ul1stCh + 4).GetNewestValue().ToString()
                    lbStaticDigits6.Text = aclChannelData(ul1stCh + 5).GetNewestValue().ToString()
                    lbStaticDigits7.Text = aclChannelData(ul1stCh + 6).GetNewestValue().ToString()
                    lbStaticDigits8.Text = aclChannelData(ul1stCh + 7).GetNewestValue().ToString()

                    lbStaticHwStat1.Text = String.Format("0x{0:X2}", aucHardStat(ul1stCh + 0))
                    lbStaticHwStat2.Text = String.Format("0x{0:X2}", aucHardStat(ul1stCh + 1))
                    lbStaticHwStat3.Text = String.Format("0x{0:X2}", aucHardStat(ul1stCh + 2))
                    lbStaticHwStat4.Text = String.Format("0x{0:X2}", aucHardStat(ul1stCh + 3))
                    lbStaticHwStat5.Text = String.Format("0x{0:X2}", aucHardStat(ul1stCh + 4))
                    lbStaticHwStat6.Text = String.Format("0x{0:X2}", aucHardStat(ul1stCh + 5))
                    lbStaticHwStat7.Text = String.Format("0x{0:X2}", aucHardStat(ul1stCh + 6))
                    lbStaticHwStat8.Text = String.Format("0x{0:X2}", aucHardStat(ul1stCh + 7))

                    lbStaticUnit1.Text = aclChannelData(ul1stCh + 0).GetStaticUnitValue()
                    lbStaticUnit2.Text = aclChannelData(ul1stCh + 1).GetStaticUnitValue()
                    lbStaticUnit3.Text = aclChannelData(ul1stCh + 2).GetStaticUnitValue()
                    lbStaticUnit4.Text = aclChannelData(ul1stCh + 3).GetStaticUnitValue()
                    lbStaticUnit5.Text = aclChannelData(ul1stCh + 4).GetStaticUnitValue()
                    lbStaticUnit6.Text = aclChannelData(ul1stCh + 5).GetStaticUnitValue()
                    lbStaticUnit7.Text = aclChannelData(ul1stCh + 6).GetStaticUnitValue()
                    lbStaticUnit8.Text = aclChannelData(ul1stCh + 7).GetStaticUnitValue()

                    lbStaticMin1.Text = aclChannelData(ul1stCh + 0).GetStaticUnitMin()
                    lbStaticMin2.Text = aclChannelData(ul1stCh + 1).GetStaticUnitMin()
                    lbStaticMin3.Text = aclChannelData(ul1stCh + 2).GetStaticUnitMin()
                    lbStaticMin4.Text = aclChannelData(ul1stCh + 3).GetStaticUnitMin()
                    lbStaticMin5.Text = aclChannelData(ul1stCh + 4).GetStaticUnitMin()
                    lbStaticMin6.Text = aclChannelData(ul1stCh + 5).GetStaticUnitMin()
                    lbStaticMin7.Text = aclChannelData(ul1stCh + 6).GetStaticUnitMin()
                    lbStaticMin8.Text = aclChannelData(ul1stCh + 7).GetStaticUnitMin()

                    lbStaticMax1.Text = aclChannelData(ul1stCh + 0).GetStaticUnitMax()
                    lbStaticMax2.Text = aclChannelData(ul1stCh + 1).GetStaticUnitMax()
                    lbStaticMax3.Text = aclChannelData(ul1stCh + 2).GetStaticUnitMax()
                    lbStaticMax4.Text = aclChannelData(ul1stCh + 3).GetStaticUnitMax()
                    lbStaticMax5.Text = aclChannelData(ul1stCh + 4).GetStaticUnitMax()
                    lbStaticMax6.Text = aclChannelData(ul1stCh + 5).GetStaticUnitMax()
                    lbStaticMax7.Text = aclChannelData(ul1stCh + 6).GetStaticUnitMax()
                    lbStaticMax8.Text = aclChannelData(ul1stCh + 7).GetStaticUnitMax()

                    lbStaticDiff1.Text = aclChannelData(ul1stCh + 0).GetStaticUnitDiff()
                    lbStaticDiff2.Text = aclChannelData(ul1stCh + 1).GetStaticUnitDiff()
                    lbStaticDiff3.Text = aclChannelData(ul1stCh + 2).GetStaticUnitDiff()
                    lbStaticDiff4.Text = aclChannelData(ul1stCh + 3).GetStaticUnitDiff()
                    lbStaticDiff5.Text = aclChannelData(ul1stCh + 4).GetStaticUnitDiff()
                    lbStaticDiff6.Text = aclChannelData(ul1stCh + 5).GetStaticUnitDiff()
                    lbStaticDiff7.Text = aclChannelData(ul1stCh + 6).GetStaticUnitDiff()
                    lbStaticDiff8.Text = aclChannelData(ul1stCh + 7).GetStaticUnitDiff()
                End If

                lbStaticUpdates.Text = String.Format("{0} Updates", ulNUpdates)
                lbDInUpdates.Text = lbStaticUpdates.Text

                For ulI = 0 To N_DIGIIO_DISPLAY - 1
                    iBit = ulI Mod 8
                    iByte = (ulI - iBit) / 8
                    If (aucDigiIn(iByte) And (1 << iBit)) Then
                        albDIn(ulI).ForeColor = Color.Blue
                        albDIn(ulI).Font = New Font(albDIn(ulI).Font, FontStyle.Bold)
                    Else
                        albDIn(ulI).ForeColor = Color.Gray
                        albDIn(ulI).Font = New Font(albDIn(ulI).Font, FontStyle.Regular)
                    End If
                Next
            End If
        End If

        ' Update system time in case of a reconnect
        If bNewReconnected <> False Then
            bNewReconnected = False
            NmxDLL.SetDateTime_1(pHandleNmx)
        End If

        ' Re-enable this timer
        tmrStatic.Enabled = True
    End Sub


    '******************************************************************************
    ' FUNCTION: btnStaticResetMinMax_Click
    '-----------------------------------------------------------------------------
    ' Reset all Min/Max - values of static measurement data.
    '*****************************************************************************
    Private Sub btnStaticResetMinMax_Click(sender As Object, e As EventArgs) Handles btnStaticResetMinMax.Click
        Dim ulI As UInt32 = 0

        For ulI = 0 To N_STATIC_CH_DISPLAY - 1
            aclChannelData(ulI).ResetStaticMinMax()
        Next
    End Sub


    '******************************************************************************
    ' FUNCTION: cbDOut_1_CheckedChanged
    '-----------------------------------------------------------------------------
    ' Transfer digital output data from GUI to device.
    '*****************************************************************************
    Private Sub dbDOut_1_CheckedChanged(sender As Object, e As EventArgs) Handles dbDOut_1.CheckedChanged, dbDOut_9.CheckedChanged, dbDOut_8.CheckedChanged, dbDOut_7.CheckedChanged, dbDOut_6.CheckedChanged, dbDOut_5.CheckedChanged, dbDOut_4.CheckedChanged, dbDOut_3.CheckedChanged, dbDOut_2.CheckedChanged, dbDOut_16.CheckedChanged, dbDOut_15.CheckedChanged, dbDOut_14.CheckedChanged, dbDOut_13.CheckedChanged, dbDOut_12.CheckedChanged, dbDOut_11.CheckedChanged, dbDOut_10.CheckedChanged, dbDOut_82.CheckedChanged, dbDOut_81.CheckedChanged, dbDOut_80.CheckedChanged, dbDOut_79.CheckedChanged, dbDOut_78.CheckedChanged, dbDOut_77.CheckedChanged, dbDOut_76.CheckedChanged, dbDOut_75.CheckedChanged, dbDOut_74.CheckedChanged, dbDOut_73.CheckedChanged, dbDOut_72.CheckedChanged, dbDOut_71.CheckedChanged, dbDOut_70.CheckedChanged, dbDOut_69.CheckedChanged, dbDOut_68.CheckedChanged, dbDOut_67.CheckedChanged, dbDOut_66.CheckedChanged, dbDOut_65.CheckedChanged, dbDOut_64.CheckedChanged, dbDOut_63.CheckedChanged, dbDOut_62.CheckedChanged, dbDOut_61.CheckedChanged, dbDOut_60.CheckedChanged, dbDOut_59.CheckedChanged, dbDOut_58.CheckedChanged, dbDOut_57.CheckedChanged, dbDOut_56.CheckedChanged, dbDOut_55.CheckedChanged, dbDOut_54.CheckedChanged, dbDOut_53.CheckedChanged, dbDOut_52.CheckedChanged, dbDOut_51.CheckedChanged, dbDOut_50.CheckedChanged, dbDOut_49.CheckedChanged, dbDOut_48.CheckedChanged, dbDOut_47.CheckedChanged, dbDOut_46.CheckedChanged, dbDOut_45.CheckedChanged, dbDOut_44.CheckedChanged, dbDOut_43.CheckedChanged, dbDOut_42.CheckedChanged, dbDOut_41.CheckedChanged, dbDOut_40.CheckedChanged, dbDOut_39.CheckedChanged, dbDOut_38.CheckedChanged, dbDOut_37.CheckedChanged, dbDOut_36.CheckedChanged, dbDOut_35.CheckedChanged, dbDOut_34.CheckedChanged, dbDOut_33.CheckedChanged, dbDOut_32.CheckedChanged, dbDOut_31.CheckedChanged, dbDOut_30.CheckedChanged, dbDOut_29.CheckedChanged, dbDOut_28.CheckedChanged, dbDOut_27.CheckedChanged, dbDOut_26.CheckedChanged, dbDOut_25.CheckedChanged, dbDOut_24.CheckedChanged, dbDOut_23.CheckedChanged, dbDOut_22.CheckedChanged, dbDOut_21.CheckedChanged, dbDOut_20.CheckedChanged, dbDOut_19.CheckedChanged, dbDOut_18.CheckedChanged, dbDOut_17.CheckedChanged, dbDOut_99.CheckedChanged, dbDOut_98.CheckedChanged, dbDOut_97.CheckedChanged, dbDOut_96.CheckedChanged, dbDOut_95.CheckedChanged, dbDOut_94.CheckedChanged, dbDOut_93.CheckedChanged, dbDOut_92.CheckedChanged, dbDOut_91.CheckedChanged, dbDOut_90.CheckedChanged, dbDOut_89.CheckedChanged, dbDOut_88.CheckedChanged, dbDOut_87.CheckedChanged, dbDOut_86.CheckedChanged, dbDOut_85.CheckedChanged, dbDOut_84.CheckedChanged, dbDOut_83.CheckedChanged, dbDOut_104.CheckedChanged, dbDOut_103.CheckedChanged, dbDOut_102.CheckedChanged, dbDOut_101.CheckedChanged, dbDOut_100.CheckedChanged, dbDOut_128.CheckedChanged, dbDOut_127.CheckedChanged, dbDOut_126.CheckedChanged, dbDOut_125.CheckedChanged, dbDOut_124.CheckedChanged, dbDOut_123.CheckedChanged, dbDOut_122.CheckedChanged, dbDOut_121.CheckedChanged, dbDOut_120.CheckedChanged, dbDOut_119.CheckedChanged, dbDOut_118.CheckedChanged, dbDOut_117.CheckedChanged, dbDOut_116.CheckedChanged, dbDOut_115.CheckedChanged, dbDOut_114.CheckedChanged, dbDOut_113.CheckedChanged, dbDOut_112.CheckedChanged, dbDOut_111.CheckedChanged, dbDOut_110.CheckedChanged, dbDOut_109.CheckedChanged, dbDOut_108.CheckedChanged, dbDOut_107.CheckedChanged, dbDOut_106.CheckedChanged, dbDOut_105.CheckedChanged
        Dim aucDigiOut(N_DIGIIO_DISPLAY / 8) As Byte
        Dim ulI As UInt32 = 0
        Dim iByte As Integer = 0
        Dim iBit As Integer = 0

        If bWriteDigitalOutputData <> False Then
            For ulI = 0 To aucDigiOut.Length - 1
                aucDigiOut(ulI) = 0
            Next

            For ulI = 0 To N_DIGIIO_DISPLAY - 1
                iBit = ulI Mod 8
                iByte = (ulI - iBit) / 8
                If acbDigiOut(ulI).Checked Then
                    aucDigiOut(iByte) = aucDigiOut(iByte) Or (1 << iBit)
                End If
            Next

        End If

        NmxDLL.SetOutputs_1(pHandleNmx, aucDigiOut(0), aucDigiOut.Length, 0)
    End Sub


    '******************************************************************************
    ' FUNCTION: btnDigiEnableOutputWrite_Click
    '-----------------------------------------------------------------------------
    ' Enable/Disable writing the digital output data.
    '*****************************************************************************
    Private Sub btnDigiEnableOutputWrite_Click(sender As Object, e As EventArgs) Handles btnDigiEnableOutputWrite.Click
        If bWriteDigitalOutputData = False Then
            bWriteDigitalOutputData = True
            btnDigiEnableOutputWrite.Text = "Click to DISABLE writing output data to device"
            btnDigiEnableOutputWrite.ForeColor = Color.Black
            dbDOut_1_CheckedChanged(sender, e)
        Else
            bWriteDigitalOutputData = False
            btnDigiEnableOutputWrite.Text = "Click to ENABLE writing output data to device"
            btnDigiEnableOutputWrite.ForeColor = Color.Red
            NmxDLL.DisableOutputUpdate_1(pHandleNmx)
        End If
    End Sub

    '******************************************************************************
    ' FUNCTION: tmrUpdateDateTime_Tick
    '-----------------------------------------------------------------------------
    ' Correct date/time in Measurement system every few hours for improved
    ' diagnostics information.
    ' This time correction is not relevant for measurement.
    '*****************************************************************************
    Private Sub tmrUpdateDateTime_Tick(sender As Object, e As EventArgs) Handles tmrUpdateDateTime.Tick
        tmrUpdateDateTime.Enabled = False
        If bConnected <> False Then
            NmxDLL.SetDateTime_1(pHandleNmx)
        End If

        tmrUpdateDateTime.Enabled = True
    End Sub

    '******************************************************************************
    ' FUNCTION: cbStaticFastUpdate_CheckedChanged
    '-----------------------------------------------------------------------------
    ' Enable/Disable median filter for static values. Default by the system is
    ' enabled.
    '*****************************************************************************
    Private Sub cbStaticFastUpdate_CheckedChanged(sender As Object, e As EventArgs) Handles cbStaticFastUpdate.CheckedChanged
        If cbStaticFastUpdate.Checked Then
            ' Enable median filter. Filter depth should be odd. 5 is a good value.
            NmxDLL.StaticSetMedianDepth_1(pHandleNmx, 5)
        Else
            ' Disable median filter
            NmxDLL.StaticSetMedianDepth_1(pHandleNmx, 1)
        End If
    End Sub

    '******************************************************************************
    ' FUNCTION: btnSamplingReset_Click
    '-----------------------------------------------------------------------------
    ' Resets the current sampling configuration (and stop sampling if running).
    '*****************************************************************************
    Private Sub btnSamplingReset_Click(sender As Object, e As EventArgs) Handles btnSamplingReset.Click
        If NmxDLL.Sampling_Reset_1(pHandleNmx) = NmxDLL.NST_SUCCESS Then
            AddHistoryEntry("Sampling reset successfully.", False)
            lbSampling_NElements.Text = "No sampling elements added."

            btnSampling_AddChannelsAll.Enabled = True
            btnSampling_AddChannels.Enabled = True
            btnSampling_AddInputsAll.Enabled = True
            btnSampling_AddDigitalInputs.Enabled = True
            btnSampling_AddOutputsAll.Enabled = True
            btnSampling_AddDigitalOutputs.Enabled = True

            btnSampling_PrepareFiniteT.Enabled = False
            btnSampling_PrepareEndless.Enabled = False

            SamplingClearNotificationCtrs()
        Else
            AddHistoryEntry("Failed to reset sampling.", True)
        End If
    End Sub

    '******************************************************************************
    ' FUNCTION: btnSampling_AddChannels_Click
    '-----------------------------------------------------------------------------
    ' Add selected measurement channels (checkboxes) to the list of sampled data.
    '*****************************************************************************
    Private Sub btnSampling_AddChannels_Click(sender As Object, e As EventArgs) Handles btnSampling_AddChannels.Click
        Dim ulNTotal As UInt32 = 0
        Dim ulCtr As UInt32 = 0
        Dim bOk As Boolean = True
        Dim I As Integer = 0

        For I = 0 To cbSampling_MeasChannels.Items.Count - 1
            If cbSampling_MeasChannels.GetItemChecked(I) <> False Then
                If NmxDLL.Sampling_AddChannel_1(pHandleNmx, I, ulNTotal) <> NmxDLL.NST_SUCCESS Then
                    AddHistoryEntry(String.Format("Failed adding P{0} to the list of sampled elements.", I + 1), True)
                    bOk = False
                End If
                ulCtr += 1
            End If
        Next

        If bOk <> False Then
            AddHistoryEntry(String.Format("Successfully added {0} MEASUREMENT CHANNELS to sampling list.", ulCtr), False)
        End If

        lbSampling_NElements.Text = String.Format("{0} sampling elements added.", ulNTotal)
        ulNSamplingElements = ulNTotal

        btnSampling_AddChannelsAll.Enabled = False
        btnSampling_AddChannels.Enabled = False

        If ulNTotal > 0 Then
            btnSampling_PrepareFiniteT.Enabled = True
            btnSampling_PrepareEndless.Enabled = True
        End If
    End Sub

    '******************************************************************************
    ' FUNCTION: btnSamplingAddChannelsAll_Click
    '-----------------------------------------------------------------------------
    ' Add all measurement channels to the list of sampled data.
    '*****************************************************************************/
    Private Sub btnSampling_AddChannelsAll_Click(sender As Object, e As EventArgs) Handles btnSampling_AddChannelsAll.Click
        Dim ulNElements As UInt32 = 0
        If NmxDLL.Sampling_AddChannelsAll_1(pHandleNmx, ulNElements) = NmxDLL.NST_SUCCESS Then
            AddHistoryEntry("All measurement channels successfully added to the sampling list.", False)
            lbSampling_NElements.Text = String.Format("{0} sampling elements added.", ulNElements)
            ulNSamplingElements = ulNElements
        Else
            AddHistoryEntry("Failed adding all measurement channels to the sampling list.", True)
        End If

        btnSampling_AddChannelsAll.Enabled = False
        btnSampling_AddChannels.Enabled = False

        If ulNElements > 0 Then
            btnSampling_PrepareFiniteT.Enabled = True
            btnSampling_PrepareEndless.Enabled = True
        End If
    End Sub

    '******************************************************************************
    ' FUNCTION: btnSampling_AddDigitalInputs_Click
    '-----------------------------------------------------------------------------
    ' Add selected digital input bytes (checkboxes) to the list of sampled data.
    '*****************************************************************************
    Private Sub btnSampling_AddDigitalInputs_Click(sender As Object, e As EventArgs) Handles btnSampling_AddDigitalInputs.Click
        Dim ulNTotal As UInt32 = 0
        Dim ulCtr As UInt32 = 0
        Dim bOk As Boolean = True
        Dim I As Integer = 0

        For I = 0 To cbSampling_DigitalInputs.Items.Count - 1
            If cbSampling_DigitalInputs.GetItemChecked(I) <> False Then
                If NmxDLL.Sampling_AddDigiInByte_1(pHandleNmx, I, ulNTotal) <> NmxDLL.NST_SUCCESS Then
                    AddHistoryEntry(String.Format("Failed adding Digital Input byte {0} to the list of sampled elements.", I + 1), True)
                    bOk = False
                End If
                ulCtr += 1
            End If
        Next

        If bOk <> False Then
            AddHistoryEntry(String.Format("Successfully added {0} digital INPUT bytes to sampling list.", ulCtr), False)
        End If

        lbSampling_NElements.Text = String.Format("{0} sampling elements added.", ulNTotal)
        ulNSamplingElements = ulNTotal

        btnSampling_AddInputsAll.Enabled = False
        btnSampling_AddDigitalInputs.Enabled = False


        If ulNTotal > 0 Then
            btnSampling_PrepareFiniteT.Enabled = True
            btnSampling_PrepareEndless.Enabled = True
        End If
    End Sub

    '******************************************************************************
    ' FUNCTION: btnSampling_AddInputsAll_Click
    '-----------------------------------------------------------------------------
    ' Add all digital input bytes to the list of sampled data.
    '*****************************************************************************
    Private Sub btnSampling_AddInputsAll_Click(sender As Object, e As EventArgs) Handles btnSampling_AddInputsAll.Click
        Dim ulNElements As UInt32 = 0
        If NmxDLL.Sampling_AddDigiInAll_1(pHandleNmx, ulNElements) = NmxDLL.NST_SUCCESS Then
            AddHistoryEntry("All digital inputs successfully added to the sampling list.", False)
            lbSampling_NElements.Text = String.Format("{0} sampling elements added.", ulNElements)
            ulNSamplingElements = ulNElements
        Else
            AddHistoryEntry("Failed adding all digital inputs to the sampling list.", True)
        End If

        btnSampling_AddInputsAll.Enabled = False
        btnSampling_AddDigitalInputs.Enabled = False

        If ulNElements > 0 Then
            btnSampling_PrepareFiniteT.Enabled = True
            btnSampling_PrepareEndless.Enabled = True
        End If
    End Sub

    '******************************************************************************
    ' FUNCTION: btnSampling_AddDigitalOutputs_Click
    '-----------------------------------------------------------------------------
    ' Add selected digital output bytes (checkboxes) to the list of sampled data.
    '*****************************************************************************
    Private Sub btnSampling_AddDigitalOutputs_Click(sender As Object, e As EventArgs) Handles btnSampling_AddDigitalOutputs.Click
        Dim ulNTotal As UInt32 = 0
        Dim ulCtr As UInt32 = 0
        Dim bOk As Boolean = True
        Dim I As Integer = 0

        For I = 0 To cbSampling_DigitalOutputs.Items.Count - 1
            If cbSampling_DigitalOutputs.GetItemChecked(I) <> False Then
                If NmxDLL.Sampling_AddDigiOutByte_1(pHandleNmx, I, ulNTotal) <> NmxDLL.NST_SUCCESS Then
                    AddHistoryEntry(String.Format("Failed adding Digital Output byte {0} to the list of sampled elements.", I + 1), True)
                    bOk = False
                End If
                ulCtr += 1
            End If
        Next

        If bOk <> False Then
            AddHistoryEntry(String.Format("Successfully added {0} digital OUTPUT bytes to sampling list.", ulCtr), False)
        End If

        lbSampling_NElements.Text = String.Format("{0} sampling elements added.", ulNTotal)
        ulNSamplingElements = ulNTotal

        btnSampling_AddOutputsAll.Enabled = False
        btnSampling_AddDigitalOutputs.Enabled = False

        If ulNTotal > 0 Then
            btnSampling_PrepareFiniteT.Enabled = True
            btnSampling_PrepareEndless.Enabled = True
        End If
    End Sub

    '******************************************************************************
    ' FUNCTION: btnSampling_AddOutputsAll_Click
    '-----------------------------------------------------------------------------
    ' Add all digital output bytes to the list of sampled data.
    '*****************************************************************************
    Private Sub btnSampling_AddOutputsAll_Click(sender As Object, e As EventArgs) Handles btnSampling_AddOutputsAll.Click
        Dim ulNElements As UInt32 = 0
        If NmxDLL.Sampling_AddDigiOutAll_1(pHandleNmx, ulNElements) = NmxDLL.NST_SUCCESS Then
            AddHistoryEntry("All digital outputs successfully added to the sampling list.", False)
            lbSampling_NElements.Text = String.Format("{0} sampling elements added.", ulNElements)
            ulNSamplingElements = ulNElements
        Else
            AddHistoryEntry("Failed adding all digital outputs to the sampling list.", True)
        End If

        btnSampling_AddOutputsAll.Enabled = False
        btnSampling_AddDigitalOutputs.Enabled = False


        If ulNElements > 0 Then
            btnSampling_PrepareFiniteT.Enabled = True
            btnSampling_PrepareEndless.Enabled = True
        End If
    End Sub

    '******************************************************************************
    ' FUNCTION: btnSampling_PrepareFiniteT_Click
    '-----------------------------------------------------------------------------
    ' Prepare time-based & time-limited measurement.
    '*****************************************************************************
    Private Sub btnSampling_PrepareFiniteT_Click(sender As Object, e As EventArgs) Handles btnSampling_PrepareFiniteT.Click
        tmrSampling.Enabled = False
        tmrSamplingEndlessReadData.Enabled = False

        ' Get sample period from radio buttons
        Dim ulSamplePeriod As UInt32 = ulSamplePeriodFast
        If rbSampling_TimeHigh.Checked = True Then
            ulSamplePeriod = ulSamplePeriodUltraFast
        ElseIf rbSampling_TimeStandard.Checked = True Then
            ulSamplePeriod = ulSamplePeriodStandard
        ElseIf rbSampling_TimeExtreme.Checked = True Then
            ulSamplePeriod = ulSamplePeriodExtreme
        End If

        ' --> In this example with time-limited sampling, the DLL-internal buffer has enough space for
        '      storing all the sample values in the DLL (Sampling_PrepareTime_1 function parameters
        '      ulDLLArrayLength = udMaxSamples). This is possible, if the sampling-time is limited
        '      to a few seconds, since then only a small amount of memory is required.
        If NmxDLL.Sampling_PrepareTime_1(pHandleNmx, ulSamplePeriod, nuSampling_TimeNSamples.Value, nuSampling_TimeNSamples.Value) = NmxDLL.NST_SUCCESS Then
            AddHistoryEntry("Time-limited sampling prepared successfully.", False)
            btnSampling_TEndlessStart.Enabled = False
            btnSampling_TLimitedStart.Enabled = True
            btnSampling_Store.Enabled = False
            btnSampling_EndlessStore.Enabled = False

            btnSampling_AddChannelsAll.Enabled = False
            btnSampling_AddChannels.Enabled = False
            btnSampling_AddInputsAll.Enabled = False
            btnSampling_AddDigitalInputs.Enabled = False
            btnSampling_AddOutputsAll.Enabled = False
            btnSampling_AddDigitalOutputs.Enabled = False
        Else
            AddHistoryEntry("Failed preparing time-limited sampling.", True)
        End If

        SamplingClearNotificationCtrs()
    End Sub

    '******************************************************************************
    ' FUNCTION: btnSampling_PrepareEndlessT_Click
    '-----------------------------------------------------------------------------
    ' Prepare endless time-based measurement.
    '*****************************************************************************
    Private Sub btnSampling_PrepareEndless_Click(sender As Object, e As EventArgs) Handles btnSampling_PrepareEndless.Click
        tmrSampling.Enabled = False
        tmrSamplingEndlessReadData.Enabled = False

        ' Get sample period from radio buttons
        Dim ulSamplePeriod As UInt32 = ulSamplePeriodFast
        If rbSampling_TimeHigh.Checked = True Then
            ulSamplePeriod = ulSamplePeriodUltraFast
        ElseIf rbSampling_TimeStandard.Checked = True Then
            ulSamplePeriod = ulSamplePeriodStandard
        ElseIf rbSampling_TimeExtreme.Checked = True Then
            ulSamplePeriod = ulSamplePeriodExtreme
        End If

        ' Specify DLL internal array size for buffering the samples. An array, which is large enough for
        ' a few seconds, e.g. 10s, is good practice.
        Dim ulSamplesPer10s As UInt32 = (10 * 1000000) / ulSamplePeriod

        ' Create buffers for sample values
        ulSamplingEndlessArrayLength = nuSampling_TimeKeepSamples.Value
        ReDim aaslRingBuf(ulNSamplingElements, ulSamplingEndlessArrayLength) ' ulNSamplingElements = Columns / ulSamplingEndlessArrayLength = Rows

        ulSamplingArrayRowNewest = 0
        udSamplingCtrNewest = 0

        ' --> Since it is impossible having an endless buffer for the sampled data, using a ring-buffer is required.
        '     The Nmx-DLL uses an internal ring-buffer; its size if specified by ulSamplesPer10s. 
        '     Using 0 as the last function parameter tells the DLL/measurement system, that the sampling is endless.
        '     Please note: this demo application also uses a ringbuffer for storing the last sampled data. It
        '     is optional and independent of the DLLs ringbuffer. Feel free to store the sampled data as you prefer it.
        If NmxDLL.Sampling_PrepareTime_1(pHandleNmx, ulSamplePeriod, ulSamplesPer10s, 0) = NmxDLL.NST_SUCCESS Then
            AddHistoryEntry("Endless sampling prepared successfully.", False)
            tmrSamplingEndlessReadData.Enabled = True

            btnSampling_TLimitedStart.Enabled = False
            btnSampling_TEndlessStart.Enabled = True
            btnSampling_Store.Enabled = False
            btnSampling_EndlessStore.Enabled = False

            btnSampling_AddChannelsAll.Enabled = False
            btnSampling_AddChannels.Enabled = False
            btnSampling_AddInputsAll.Enabled = False
            btnSampling_AddDigitalInputs.Enabled = False
            btnSampling_AddOutputsAll.Enabled = False
            btnSampling_AddDigitalOutputs.Enabled = False
        Else
            AddHistoryEntry("Failed preparing endless sampling.", True)
        End If

        SamplingClearNotificationCtrs()
    End Sub

    '******************************************************************************
    ' FUNCTION: btnSampling_Start_Click
    '-----------------------------------------------------------------------------
    ' Start time-limited sampling.
    '*****************************************************************************
    Private Sub btnSampling_TLimitedStart_Click(sender As Object, e As EventArgs) Handles btnSampling_TLimitedStart.Click
        If NmxDLL.Sampling_Start_1(pHandleNmx) = NmxDLL.NST_SUCCESS Then
            AddHistoryEntry("Sampling (time-limited) started successfully.", False)
            bSamplingReadRows = False
            tmrSampling.Enabled = True
            btnSampling_TLimitedStart.Enabled = False
        Else
            AddHistoryEntry("Failed starting time-limited sampling.", True)
        End If
    End Sub

    '******************************************************************************
    ' FUNCTION: btnSampling_TEndlessStart_Click
    '-----------------------------------------------------------------------------
    ' Start endless sampling.
    '*****************************************************************************
    Private Sub btnSampling_TEndlessStart_Click(sender As Object, e As EventArgs) Handles btnSampling_TEndlessStart.Click
        If NmxDLL.Sampling_Start_1(pHandleNmx) = NmxDLL.NST_SUCCESS Then
            AddHistoryEntry("Sampling (endless) started successfully.", False)
            tmrSampling.Enabled = True
            btnSampling_TEndlessStart.Enabled = False
        Else
            AddHistoryEntry("Failed starting endless sampling.", True)
        End If
    End Sub

    '******************************************************************************
    ' FUNCTION: btnSampling_Stop_Click
    '-----------------------------------------------------------------------------
    ' Stop sampling.
    '*****************************************************************************
    Private Sub btnSampling_Stop_Click(sender As Object, e As EventArgs) Handles btnSampling_Stop.Click, btnSampling_EndlessStop.Click
        If NmxDLL.Sampling_Stop_1(pHandleNmx) = NmxDLL.NST_SUCCESS Then
            AddHistoryEntry("Sampling stop requested.", False)
        Else
            AddHistoryEntry("Failed stopping sampling.", True)
        End If
    End Sub

    '******************************************************************************
    ' FUNCTION: btnSampling_Store_Click
    '-----------------------------------------------------------------------------
    ' Time-limited sampling: Store sampled values into a CSV file.
    '*****************************************************************************
    Private Sub btnSampling_Store_Click(sender As Object, e As EventArgs) Handles btnSampling_Store.Click
        Dim strPath As String = System.IO.Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().Location)
        Dim str As String = ""
        Dim ulColumn As UInt32 = 0
        Dim ulElements As UInt32 = 0
        Dim udRowsLeft As UInt64 = 0

        ' ---> In this example with time-limited sampling, all measurement values are
        ' read here from the DLL in a single step. This is possible, if the time and therefore the
        ' memory consumption for the samples is not too large.

        NmxDLL.Sampling_GetStatus_1(pHandleNmx, Nothing, ulElements, udRowsLeft, Nothing)
        If (udRowsLeft = 0) Or (ulElements = 0) Then
            MessageBox.Show("No data available", "Store sampled measurement values")
            Return
        End If

        bSamplingReadRows = True


        Try
            ' Create file path. Samples.csv will be stored in the same
            ' directory as the *.exe-File of the application.
            strPath = strPath & "\Samples.csv"

            Dim cStreamWriter As System.IO.StreamWriter = System.IO.File.CreateText(strPath)

            ' Writer Header line
            str = ""
            For ulColumn = 0 To ulElements - 1
                If ulColumn = 0 Then
                    str += String.Format("E{0}", ulColumn + 1)
                Else
                    str += String.Format(";E{0}", ulColumn + 1)
                End If
            Next
            cStreamWriter.WriteLine(str)

            ' There are 2 possibilities reading data from the DLL:
            ' 1. Read data column-wise, which means: read an array of sample-values for a specific sampling element, e.g. a probe. 
            ' 2. Read data row-wise, which means: read the values of all sampling-elements, which have been sampled at the same time.
            ' The first way is a bit better regarding performance. On many PCs this is neglectable. 
            ' See documentation for more information.
            ' Choose the possibility, which is more convenient for you.
            ' In this example ONLY the "ROW-WISE"-Method is shown for simplicity.

            ' Create array for values
            Dim aslValues(ulElements) As Int32

            While udRowsLeft > 0
                udRowsLeft -= 1

                For ulColumn = 0 To ulElements - 1
                    aslValues(ulColumn) = -2147483647
                Next

                ' Get values from DLL.
                ' Feel free to do some more error handling here, e.g. check ulSamplesCopied and checking the function return code.
                NmxDLL.Sampling_ReadRow32_1(pHandleNmx, aslValues(0), ulElements, Nothing, Nothing)

                ' Write line with samples.
                str = ""
                For ulColumn = 0 To ulElements - 1
                    If ulColumn = 0 Then
                        str += String.Format("{0}", aslValues(ulColumn))
                    Else
                        str += String.Format(";{0}", aslValues(ulColumn))
                    End If
                Next
                cStreamWriter.WriteLine(str)
            End While

            ' Disable this button, since reading row-wise can only be done once.
            btnSampling_Store.Enabled = False

            ' Write finished: close file
            cStreamWriter.Close()

            str = "Sample values successfully written to " + strPath + "."
            AddHistoryEntry(str, False)
        Catch ex As Exception
            str = "Sample values cannot be written to Samples.csv (" + ex.Message + ")."
            AddHistoryEntry(str, True)
        End Try

        ' Inform user about result of writing the file (success, error)
        MessageBox.Show(str, "Store sampled measurement values")
    End Sub


    '******************************************************************************
    ' FUNCTION: tmrSampling_Tick
    '-----------------------------------------------------------------------------
    ' Update sampling status.
    '*****************************************************************************
    Private Sub tmrSampling_Tick(sender As Object, e As EventArgs) Handles tmrSampling.Tick
        Dim ucStatus As Byte = 0
        Dim udSamplesReceived As UInt64 = 0
        Dim udSamplesMax As UInt64 = 0

        ' Disable this timer
        tmrSampling.Enabled = False

        ' Update status information
        lbSampling_NotificationsNewData.Text = String.Format("{0} new-data notifications", ulCtrSamplingNotificationsNewData)
        lbSampling_NotificationAllReceived.Text = String.Format("{0} all-received notifications", ulCtrSamplingNotificationsAllReceived)
        lbSampling_NotificationFinished.Text = String.Format("{0} finished notifications", ulCtrSamplingNotificationsFinished)
        lbSampling_NotificationError.Text = String.Format("{0} error notifications", ulCtrSamplingNotificationsError)
        lbSampling_NotificationBufOverflow.Text = String.Format("{0} buffer overflow notifications", ulCtrSamplingNotificationsBufferOverflow)
        lbSampling_NotificationTimeout.Text = String.Format("{0} timeout notifications", ulCtrSamplingNotificationTimeout)

        If NmxDLL.Sampling_GetStatus_1(pHandleNmx, ucStatus, Nothing, udSamplesReceived, udSamplesMax) = NmxDLL.NST_SUCCESS Then
            lbSampling_NSamplesReceived.Text = String.Format("{0} samples received", udSamplesReceived)

            If (udSamplesReceived > 0) And (bSamplingReadRows = False) Then
                btnSampling_Store.Enabled = True
            End If

            If udSamplesMax > 1000000000 Then
                ' Just an alternate text to ensure that its length gets not too large with endless sampling.
                lbSampling_MaxSamples.Text = String.Format("> 1 billion samples max")
            Else
                lbSampling_MaxSamples.Text = String.Format("{0} samples max", udSamplesMax)
            End If
        Else
            lbSampling_NSamplesReceived.Text = "*"
            lbSampling_MaxSamples.Text = "*"
        End If

        ' Re-enable this timer
        tmrSampling.Enabled = True
    End Sub

    '******************************************************************************
    ' FUNCTION: tmrSamplingEndlessReadData_Tick
    '-----------------------------------------------------------------------------
    ' Endless sampling: read sampled data and store it in local (ring-)buffer.
    '*****************************************************************************
    Private Sub tmrSamplingEndlessReadData_Tick(sender As Object, e As EventArgs) Handles tmrSamplingEndlessReadData.Tick
        Dim ulColumn As UInt32 = 0

        ' Disable this timer
        tmrSamplingEndlessReadData.Enabled = False

        If bNewSamplingData <> False Then
            bNewSamplingData = False

            btnSampling_EndlessStore.Enabled = True

            ' There are 2 possibilities reading data from the DLL:
            ' 1. Read data column-wise, which means: read an array of sample-values for a specific sampling element, e.g. a probe. 
            ' 2. Read data row-wise, which means: read the values of all sampling-elements, which have been sampled at the same time.
            ' The first way is a bit better regarding performance. On many PCs this is neglectable. 
            ' See documentation for more information.
            ' Choose the possibility, which is more convenient for you.
            ' In this example ONLY the "ROW-WISE"-Method is shown for simplicity.
            Dim aslValues(ulNSamplingElements) As Int32
            Dim bError As Boolean = False
            Dim udRowsLeft As UInt64 = 0
            NmxDLL.Sampling_GetRowsLeft_1(pHandleNmx, udRowsLeft)
            While udRowsLeft > 0
                udRowsLeft -= 1

                For ulColumn = 0 To ulNSamplingElements - 1
                    aslValues(ulColumn) = -2147483647
                Next

                ' Read samples from DLL into local array
                If NmxDLL.Sampling_ReadRow32_1(pHandleNmx, aslValues(0), ulNSamplingElements, Nothing, Nothing) <> NmxDLL.NST_SUCCESS Then
                    AddHistoryEntry("Error reading endless sampling data: cannot read sample data", True)
                    bError = True
                    Exit While
                End If

                ' Copy samples from local array to global Ring-buffer
                For ulColumn = 0 To ulNSamplingElements - 1
                    aaslRingBuf(ulColumn, ulSamplingArrayRowNewest) = aslValues(ulColumn)
                Next
                ' Update row, which contains the newest sampling data
                ulSamplingArrayRowNewest += 1
                If ulSamplingArrayRowNewest >= ulSamplingEndlessArrayLength Then
                    ulSamplingArrayRowNewest = 0
                End If

                udSamplingCtrNewest += 1
            End While

            If bError <> False Then
                Return
            End If
        End If


        ' Re-enable this timer
        tmrSamplingEndlessReadData.Enabled = True
    End Sub

    '******************************************************************************
    ' FUNCTION: btnSampling_EndlessStore_Click
    '-----------------------------------------------------------------------------
    ' Store last sampled values of endless sampling into a CSV file.
    '*****************************************************************************
    Private Sub btnSampling_EndlessStore_Click(sender As Object, e As EventArgs) Handles btnSampling_EndlessStore.Click
        Dim strPath As String = System.IO.Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().Location)
        Dim str As String = ""
        Dim ulColumn As UInt32 = 0
        Dim ulRow As UInt32 = 0
        Dim ulArrayIndex As UInt32 = 0

        ' Check if minimum 1 sample buffer is available
        If aaslRingBuf.Length > 0 Then
            Try
                ' Create file path. Samples.csv will be stored in the same
                ' directory as the *.exe-File of the application.
                strPath = strPath & "\Samples.csv"

                Dim cStreamWriter As System.IO.StreamWriter = System.IO.File.CreateText(strPath)

                ' Writer Header line
                str = ""
                For ulColumn = 0 To ulNSamplingElements - 1
                    If ulColumn = 0 Then
                        str += String.Format("E{0}", ulColumn + 1)
                    Else
                        str += String.Format(";E{0}", ulColumn + 1)
                    End If
                Next
                cStreamWriter.WriteLine(str)


                ' Write sample values to file
                Dim ulTotalRows As UInt32 = ulSamplingEndlessArrayLength
                Dim ulSkip As UInt32 = 0
                If ulTotalRows > udSamplingCtrNewest Then
                    ulTotalRows = udSamplingCtrNewest
                    ulSkip = ulSamplingEndlessArrayLength - ulTotalRows
                End If
                For ulRow = 0 To ulTotalRows - 1
                    str = ""
                    ulArrayIndex = ulRow + ulSamplingArrayRowNewest + ulSkip
                    While ulArrayIndex >= ulSamplingEndlessArrayLength
                        ulArrayIndex -= ulSamplingEndlessArrayLength
                    End While
                    For ulColumn = 0 To ulNSamplingElements - 1
                        If ulColumn = 0 Then
                            str += String.Format("{0}", aaslRingBuf(ulColumn, ulArrayIndex))
                        Else
                            str += String.Format(";{0}", aaslRingBuf(ulColumn, ulArrayIndex))
                        End If
                    Next
                    cStreamWriter.WriteLine(str)
                Next

                ' Write finished: close file
                cStreamWriter.Close()

                str = "Sample values successfully written to " + strPath + "."
                AddHistoryEntry(str, False)
            Catch ex As Exception
                str = "Sample values cannot be written Samples.csv (" + ex.Message + ")."
                AddHistoryEntry(str, True)
            End Try

        Else
            str = "No data available."
        End If

        ' Inform user about result of writing the file (success, error)
        MessageBox.Show(str, "Store sampled measurement values")
    End Sub

    '******************************************************************************
    ' FUNCTION: btnChannelSetParameter_Click
    '-----------------------------------------------------------------------------
    ' Send string with "channel parameter" to device and receive its response.
    '*****************************************************************************
    Private Sub btnChannelSetParameter_Click(sender As Object, e As EventArgs) Handles btnChannelSetParameter.Click
        Dim acTxData() As Byte
        Dim acRxData(1024) As Byte
        Dim ulRxSize As UInt32 = 0
        Dim I As Integer = 0

        acTxData = System.Text.Encoding.Default.GetBytes(tbChannelSetParameterTx.Text)
        For I = 0 To acRxData.Length - 1
            acRxData(I) = 0
        Next

        tbChannelSetParameterRx.Text = ""
        If NmxDLL.ChannelSetParameter_1(pHandleNmx, nuChannelSetParameterNo.Value, acTxData(0), acTxData.Length, acRxData(0), acRxData.Length, ulRxSize) = NmxDLL.NST_SUCCESS Then
            AddHistoryEntry("Channel Parameter string exchanged successfully", False)
            tbChannelSetParameterRx.Text = System.Text.Encoding.Default.GetString(acRxData, 0, GetByteArrayStringLength(acRxData))
        Else
            AddHistoryEntry("Failed exchanging Channel Parameter String", True)
            tbChannelSetParameterRx.Text = "Error"
        End If
    End Sub

    '******************************************************************************
    ' FUNCTION: btnChannelSetConfig_Click
    '-----------------------------------------------------------------------------
    ' Send string with "channel config" to device and receive its response.
    '*****************************************************************************
    Private Sub btnChannelSetConfig_Click(sender As Object, e As EventArgs) Handles btnChannelSetConfig.Click
        Dim acTxData() As Byte
        Dim acRxData(1024) As Byte
        Dim ulRxSize As UInt32 = 0
        Dim I As Integer = 0

        acTxData = System.Text.Encoding.Default.GetBytes(tbChannelSetConfigTx.Text)
        For I = 0 To acRxData.Length - 1
            acRxData(I) = 0
        Next

        tbChannelSetConfigRx.Text = ""
        If NmxDLL.ChannelSetConfig_1(pHandleNmx, nuChannelSetConfigNo.Value, acTxData(0), acTxData.Length, acRxData(0), acRxData.Length, ulRxSize) = NmxDLL.NST_SUCCESS Then
            AddHistoryEntry("Channel Config string exchanged successfully", False)
            tbChannelSetConfigRx.Text = System.Text.Encoding.Default.GetString(acRxData, 0, GetByteArrayStringLength(acRxData))
        Else
            AddHistoryEntry("Failed exchanging Channel Config String", True)
            tbChannelSetConfigRx.Text = "Error"
        End If
    End Sub
End Class
