﻿Public Class NmxDLL

    ' ---------------------------------------------------------------------------
    ' Function return codes
    ' ---------------------------------------------------------------------------

    ' General
    Public Const NST_SUCCESS = &H0                              ' Everything ok
    Public Const NST_HANDLE_INVALID = &HF0000000                ' Invalid device handle
    Public Const NST_HANDLE_TOO_MANY = &HF0000001               ' Too many handles exist
    Public Const NST_CONNECT_OPEN_FAILED = &HF0000010           ' Failed to open a connection
    Public Const NST_NOT_CONNECTED = &HF0000011                 ' No connection established
    Public Const NST_NOT_AVAILABLE = &HF000001F                 ' Data not available
    Public Const NST_SEND_SIZE_TOO_LARGE = &HF0000020           ' Too much data to send
    Public Const NST_DX_TIMEOUT_1 = &HF0000021                  ' Data exchange timeout (type 1)
    Public Const NST_DX_TIMEOUT_2 = &HF0000022                  ' Data exchange timeout (type 2)
    Public Const NST_DX_TIMEOUT_COMMON = &HF0000023             ' General data exchange timeout
    Public Const NST_INV_RESP = &HF0000030                      ' Invalid response received from device
    Public Const NST_RESP_ERR = &HF0000031                      ' Device response contained error code
    Public Const NST_REQ_VERS_NOSUPPORT = &HF0000032            ' Request version not supported by device */

    Public Const NST_BOXNO_INVALID = &HF0000040                 ' Invalid box number
    Public Const NST_CHANNEL_INVALID = &HF0000041               ' Invalid channel number
    Public Const NST_DIGIIN_INVALID = &HF0000042                ' Invalid digital input byte number
    Public Const NST_DIGIOUT_INVALID = &HF0000043               ' Invalid digital output byte number
    Public Const NST_STRING_INVALID = &HF0000047                ' Invalid string

    Public Const NST_DATA_TOOLARGE = &HF0000048                 ' Data provided in the parameters list is too large

    Public Const NST_NOTIFICATION_UNKNOWN = &HF0000050          ' Unknown notification type

    ' Sampling
    Public Const NST_SAMPLING_TOOMANY_ELEMENTS = &HF0000100     ' Too many sampling channels defined
    Public Const NST_SAMPLING_GUID_INVALID = &HF0000101         ' Sampling configuration is invalid (e.g. configured in parallel by other software)
    Public Const NST_SAMPLING_NO_ELEMENTS = &HF0000102          ' No elements selected for sampling
    Public Const NST_SAMPLING_DOUBLE_ELEMENT = &HF0000103       ' An element is already part of the sampling list and therefore cannot be added
    Public Const NST_SAMPLING_INVALID_CHANNELNO = &HF0000104    ' The channel number is invalid
    Public Const NST_SAMPLING_INVALID_ELEMENTNO = &HF0000105    ' The number of the sampling element is invalid
    Public Const NST_SAMPLING_ALREADY_STARTED = &HF0000106      ' Action cannot be done, because sampling has already been prepared / started.
    Public Const NST_SAMPLING_INVALID_BITNO = &HF0000107        ' Invalid digital input or output bit number
    Public Const NST_SAMPLING_INVALID_TRGMODE = &HF0000108      ' Invalid trigger mode
    Public Const NST_SAMPLING_INVALID_TRGPOL = &HF0000109       ' Invalid trigger polarity
    Public Const NST_SAMPLING_ELEMENTS_NOACCEPT = &HF0000120    ' The list of sampling elements has not been accepted by the device
    Public Const NST_SAMPLING_INVALID_PERIOD = &HF0000121       ' Invalid sampling period
    Public Const NST_SAMPLING_INVALID_MAXSAMPLES = &HF0000122   ' Maximum number of measurement samples is invalid
    Public Const NST_SAMPLING_START_FAILED = &HF0000130         ' Starting Sampling failed
    Public Const NST_SAMPLING_START_CONFIG = &HF0000131         ' Sampling cannot be started due to invalid configuration
    Public Const NST_SAMPLING_START_NOTPREPARED = &HF0000132    ' Sampling has not been prepared and therefore cannot be started
    Public Const NST_SAMPLING_NO_DATA_AVAILABLE = &HF0000140    ' No data is available for readout
    Public Const NST_SAMPLING_READ_DATA_ERROR = &HF0000141      ' General error reading sampled data
    Public Const NST_SAMPLING_NOTENOUGH_MEMORY = &HF00001F8     ' Not enough memory for allocating internal sampling buffers
    Public Const NST_SAMPLING_INTERNAL = &HF00001FF             ' Internal sampling error

    ' High-level sampling
    Public Const NST_HLSAMPLING_INVALID_FILTPERIOD = &HF0000200 ' Invalid filter period
    Public Const NST_HLSAMPLING_INVALID_SCALE = &HF0000201      ' Invalid scale factor (zero or invalid floating point value)
    Public Const NST_HLSAMPLING_INVALID_START = &HF0000202      ' Invalid start value (invalid floating point value)
    Public Const NST_HLSAMPLING_INVALID_DISTANCE = &HF0000203   ' Invalid distance value (zero or invalid floating point value)

    ' DLL Internal
    Public Const NST_INTERNAL_SEQ = &HF0001000                  ' Internal sequence error
    Public Const NST_INVALID_EVENT = &HF0001001                 ' Invalid internal event

    ' ---------------------------------------------------------------------------
    ' Notifications, which can be triggered by the NmxDll
    ' ---------------------------------------------------------------------------
    Public Const NOTIFY_DISCONNECTED = &H2                   ' Connection closed
    Public Const NOTIFY_FAILURE_DATA_EXCHANGE = &H3          ' Permanent failure during data exchange (e.g. timeout)
    Public Const NOTIFY_RECONNECTED = &H4                    ' Reconnected after data exchange failure
    Public Const NOTIFY_NEW_STATIC32 = &H10                  ' New static data available
    Public Const NOTIFY_SAMPLING_NEW_DATA = &H20             ' New sampling data available
    Public Const NOTIFY_SAMPLING_FINISHED = &H21             ' Sampling has been finished
    Public Const NOTIFY_SAMPLING_ALL_DATA_RECEIVED = &H22    ' All sampled data has been received
    Public Const NOTIFY_SAMPLING_ERROR = &H28                ' An error occured during sampling
    Public Const NOTIFY_SAMPLING_BUFFER_OVERFLOW = &H29      ' A buffer overflow occured: application has not read data
    Public Const NOTIFY_SAMPLING_TIMEOUT = &H2A              ' A timeout occured during sampling. (-> Multiple root causes / no new data received)

    ' ---------------------------------------------------------------------------
    ' Windows messages for Notifications
    ' These numbers are just examples and can be freely assigned according to the
    ' Windows requirements.
    ' ---------------------------------------------------------------------------
    Public Const WM_USER As UInt32 = &H400  ' Start of Windows Default Message IDs for user-defined messages
    Public Const WM_DISCONNECTED As UInt32 = WM_USER + NOTIFY_DISCONNECTED
    Public Const WM_FAILURE_DATA_EXCHANGE As UInt32 = WM_USER + NOTIFY_FAILURE_DATA_EXCHANGE
    Public Const WM_RECONNECTED As UInt32 = WM_USER + NOTIFY_RECONNECTED
    Public Const WM_NEW_STATIC32 As UInt32 = WM_USER + NOTIFY_NEW_STATIC32
    Public Const WM_SAMPLING_NEW_DATA As UInt32 = WM_USER + NOTIFY_SAMPLING_NEW_DATA
    Public Const WM_SAMPLING_FINISHED As UInt32 = WM_USER + NOTIFY_SAMPLING_FINISHED
    Public Const WM_SAMPLING_ALL_DATA_RECEIVED As UInt32 = WM_USER + NOTIFY_SAMPLING_ALL_DATA_RECEIVED
    Public Const WM_SAMPLING_ERROR As UInt32 = WM_USER + NOTIFY_SAMPLING_ERROR
    Public Const WM_SAMPLING_BUFFER_OVERFLOW As UInt32 = WM_USER + NOTIFY_SAMPLING_BUFFER_OVERFLOW
    Public Const WM_SAMPLING_TIMEOUT As UInt32 = WM_USER + NOTIFY_SAMPLING_TIMEOUT

    ' ---------------------------------------------------------------------------
    ' Measurement channel raw data types
    ' ---------------------------------------------------------------------------
    Public Const DTRAW_UNKNOWN = 0      ' Unknown raw data type
    Public Const DTRAW_SINT08 = 1       ' Signed character (byte)
    Public Const DTRAW_SINT16 = 2       ' Signed short integer (single word)
    Public Const DTRAW_SINT32 = 4       ' Signed long integer (double word)
    Public Const DTRAW_SINT64 = 8       ' Signed long long integer


    Public Declare Sub GetDllVersion_1 Lib "NmxDllx86.DLL" Alias "NMX_GetDllVersion_1" (ByRef pusMajor As UInt16,
        ByRef pusMinor As UInt16,
        ByRef pusPatch As UInt16,
        ByRef pusBuild As UInt16)

    Public Declare Function DeviceIPv4Open_1 Lib "NmxDllx86.dll" Alias "NMX_DeviceIPv4Open_1" (ByVal ucIp3 As Byte,
        ByVal ucIp2 As Byte,
        ByVal ucIp1 As Byte,
        ByVal ucIp0 As Byte,
        ByVal usPortCmd As UInt16,
        ByVal usPortData As UInt16,
        ByRef ppHandle As UInt32) As UInt32

    Public Declare Function DeviceClose_1 Lib "NmxDllx86.dll" Alias "NMX_DeviceClose_1" (ByRef ppHandle As UInt32) As UInt32

    Public Declare Function GetBoxCount_1 Lib "NmxDllx86.dll" Alias "NMX_GetBoxCount_1" (ByVal pHandle As UInt32,
        ByRef pulBoxCount As UInt32) As UInt32

    Public Declare Function GetBoxInfo_1 Lib "NmxDllx86.dll" Alias "NMX_GetBoxInfo_1" (ByVal pHandle As UInt32,
        ByVal ulBoxNo As UInt32,
        ByRef pulInfoData As UInt32, ByVal ulInfoDataNElements As UInt32,
        ByRef pudMacAddress As UInt64,
        ByRef pcSerNo As Byte, ByVal ulSizeofSerNo As UInt32,
        ByRef pcProdCode As Byte, ByVal ulSizeofProdCode As UInt32,
        ByRef pcOrderNo As Byte, ByVal ulSizeofOrderNo As UInt32,
        ByRef pcName As Byte, ByVal ulSizeofName As UInt32) As UInt32

    Public Declare Function UpdateChannelInfo_1 Lib "NmxDllx86.dll" Alias "NMX_UpdateChannelInfo_1" (ByVal pHandle As UInt32) As UInt32

    Public Declare Function GetChannelCount_1 Lib "NmxDllx86.dll" Alias "NMX_GetChannelCount_1" (ByVal pHandle As UInt32,
        ByRef pulChannelCount As UInt32,
        ByRef pulNDigitalInputBytes As UInt32,
        ByRef pulNDigitalOutputBytes As UInt32) As UInt32

    Public Declare Function GetChannelInfo_1 Lib "NmxDllx86.dll" Alias "NMX_GetChannelInfo_1" (ByVal pHandle As UInt32,
        ByVal ulChannelNo As UInt32,
        ByRef pulChannelType As UInt32,
        ByRef pulNDigits As UInt32,
        ByRef pulBoxNo As UInt32,
        ByRef pulReserved As UInt32,
        ByRef pulBoxChannelNo As UInt32,
        ByRef pslRawDataType As Int32,
        ByRef pslFactNumerator As Int32,
        ByRef pslFactDenominator As Int32,
        ByRef pflFactDigitsToUnit As Single,
        ByRef pcUnit As Byte, ByVal ulSizeofUnit As UInt32,
        ByRef pcOrderNo As Byte, ByVal ulSizeofOrderNo As UInt32,
        ByRef pcSerialNo As Byte, ByVal ulSizeofSerialNo As UInt32) As UInt32

    Public Declare Function GetDigitalInputInfo_1 Lib "NmxDllx86.dll" Alias "NMX_GetDigitalInputInfo_1" (ByVal pHandle As UInt32,
        ByVal ulInputByteNo As UInt32,
        ByRef pulBoxNo As UInt32,
        ByRef pulBoxByteNo As UInt32) As UInt32

    Public Declare Function GetDigitalOutputInfo_1 Lib "NmxDllx86.dll" Alias "NMX_GetDigitalOutputInfo_1" (ByVal pHandle As UInt32,
        ByVal ulOutputByteNo As UInt32,
        ByRef pulBoxNo As UInt32,
        ByRef pulBoxByteNo As UInt32) As UInt32

    Public Declare Function RegisterMessage_1 Lib "NmxDllx86.dll" Alias "NMX_RegisterMessage_1" (ByVal pHandle As UInt32,
        ByVal ulNotification As UInt32,
        ByVal hWnd As IntPtr,
        ByVal ulMsgCode As UInt32,
        ByVal tWParam As UInt32,
        ByVal tLParam As UInt32) As UInt32

    Public Declare Function ChannelSetParameter_1 Lib "NmxDllx86.dll" Alias "NMX_ChannelSetParameter_1" (ByVal pHandle As UInt32,
        ByVal ulChannelNo As UInt32,
        ByRef pcStringTx As Byte, ByVal ulSizeofTxString As UInt32,
        ByRef pcStringRx As Byte, ByVal ulMaxSizeofRxString As UInt32, ByRef pulSizeofRxString As UInt32) As UInt32

    Public Declare Function ChannelSetConfig_1 Lib "NmxDllx86.dll" Alias "NMX_ChannelSetConfig_1" (ByVal pHandle As UInt32,
        ByVal ulChannelNo As UInt32,
        ByRef pcStringTx As Byte, ByVal ulSizeofTxString As UInt32,
        ByRef pcStringRx As Byte, ByVal ulMaxSizeofRxString As UInt32, ByRef pulSizeofRxString As UInt32) As UInt32

    Public Declare Function StaticGet32_1 Lib "NmxDllx86.dll" Alias "NMX_StaticGet32_1" (ByVal pHandle As UInt32,
        ByRef pslValues As Int32, ByVal ulValuesNElements As UInt32,
        ByRef pucHardwareStatus As Byte, ByVal ulSizeofHardwareStatus As UInt32,
        ByRef pucDigiIn As Byte, ByVal ulSizeofDigiIn As UInt32,
        ByRef pucBoxStatus As Byte, ByVal ulSizeofBoxStatus As UInt32,
        ByRef pulUpdateCtr As UInt32) As UInt32

    Public Declare Function StaticSetMedianDepth_1 Lib "NmxDllx86.dll" Alias "NMX_StaticSetMedianDepth_1" (ByVal pHandle As UInt32,
        ByVal ulMedianDepth As UInt32) As UInt32

    Public Declare Function SetOutputs_1 Lib "NmxDllx86.dll" Alias "NMX_SetOutputs_1" (ByVal pHandle As UInt32,
        ByRef pucDigiOut As Byte, ByVal ulSizeofDigiOut As UInt32,
        ByVal ucForceSendImmediately As Byte) As UInt32

    Public Declare Function DisableOutputUpdate_1 Lib "NmxDllx86.dll" Alias "NMX_DisableOutputUpdate_1" (ByVal pHandle As UInt32) As UInt32

    Public Declare Function DigitalIoConfig_1 Lib "NmxDllx86.dll" Alias "NMX_DigitalIoConfig_1" (ByVal pHandle As UInt32,
        ByVal ucOutputResetEnabled As Byte) As UInt32

    Public Declare Function DigitalOutputsGetState_1 Lib "NmxDllx86.dll" Alias "NMX_DigitalOutputsGetState_1" (ByVal pHandle As UInt32,
        ByRef pucOutputState As Byte,
        ByVal ulSizeofOutputState As UInt32) As UInt32

    Public Declare Function Sampling_GetMaxSpeed_1 Lib "NmxDllx86.dll" Alias "NMX_Sampling_GetMaxSpeed_1" (ByVal pHandle As UInt32,
        ByRef pulMinSamplePeriodUs As UInt32) As UInt32

    Public Declare Function Sampling_Reset_1 Lib "NmxDllx86.dll" Alias "NMX_Sampling_Reset_1" (ByVal pHandle As UInt32) As UInt32

    Public Declare Function Sampling_AddChannelsAll_1 Lib "NmxDllx86.dll" Alias "NMX_Sampling_AddChannelsAll_1" (ByVal pHandle As UInt32,
        ByRef pulNElementsTotal As UInt32) As UInt32

    Public Declare Function Sampling_AddChannel_1 Lib "NmxDllx86.dll" Alias "NMX_Sampling_AddChannel_1" (ByVal pHandle As UInt32,
        ByVal ulChannelNumber As UInt32,
        ByRef pulNElementsTotal As UInt32) As UInt32

    Public Declare Function Sampling_AddDigiInAll_1 Lib "NmxDllx86.dll" Alias "NMX_Sampling_AddDigiInAll_1" (ByVal pHandle As UInt32,
        ByRef pulNElementsTotal As UInt32) As UInt32

    Public Declare Function Sampling_AddDigiInByte_1 Lib "NmxDllx86.dll" Alias "NMX_Sampling_AddDigiInByte_1" (ByVal pHandle As UInt32,
        ByVal ulDigiInByteNo As UInt32,
        ByRef pulNElementsTotal As UInt32) As UInt32

    Public Declare Function Sampling_AddDigiOutAll_1 Lib "NmxDllx86.dll" Alias "NMX_Sampling_AddDigiOutAll_1" (ByVal pHandle As UInt32,
        ByRef pulNElementsTotal As UInt32) As UInt32

    Public Declare Function Sampling_AddDigiOutByte_1 Lib "NmxDllx86.dll" Alias "NMX_Sampling_AddDigiOutByte_1" (ByVal pHandle As UInt32,
        ByVal ulDigiOutByteNo As UInt32,
        ByRef pulNElementsTotal As UInt32) As UInt32

    Public Declare Function Sampling_SetTriggerDigiIn_1 Lib "NmxDllx86.dll" Alias "NMX_Sampling_SetTriggerDigiIn_1" (ByVal pHandle As UInt32,
        ByVal ulDigiInByteNo As UInt32,
        ByVal ulDigiInBitNo As UInt32,
        ByVal ulMode As UInt32,
        ByVal ulPolarity As UInt32) As UInt32

    Public Declare Function Sampling_PrepareTime_1 Lib "NmxDllx86.dll" Alias "NMX_Sampling_PrepareTime_1" (ByVal pHandle As UInt32,
        ByVal ulSamplePeriod As UInt32,
        ByVal ulDLLArrayLength As UInt32,
        ByVal udMaxSamples As UInt64) As UInt32

    Public Declare Function Sampling_PrepareCustomTFT_1 Lib "NmxDllx86.dll" Alias "NMX_Sampling_PrepareCustomTFT_1" (ByVal pHandle As UInt32,
        ByVal ulSamplePeriod As UInt32,
        ByVal ulFilteredPeriod As UInt32,
        ByVal ulArrayLength As UInt32,
        ByVal udMaxSamples As UInt64,
        ByVal ulNTailSamples As UInt32,
        ByVal ulTriggerDigiInByteNo As UInt32,
        ByVal ulTriggerDigiInBitNo As UInt32,
        ByVal ulTriggerMode As UInt32,
        ByVal ulTriggerPolarity As UInt32) As UInt32

    Public Declare Function Sampling_PreparePosition_1 Lib "NmxDllx86.dll" Alias "NMX_Sampling_PreparePosition_1" (ByVal pHandle As UInt32,
        ByVal ulSamplePeriod As UInt32,
        ByVal ulArrayLength As UInt32,
        ByVal udMaxSamples As UInt64,
        ByVal ulTriggerChannelNumber As UInt32,
        ByVal fdScale As Double,
        ByVal fdStart As Double,
        ByVal fdDistance As Double) As UInt32

    Public Declare Function Sampling_Start_1 Lib "NmxDllx86.dll" Alias "NMX_Sampling_Start_1" (ByVal pHandle As UInt32) As UInt32

    Public Declare Function Sampling_Stop_1 Lib "NmxDllx86.dll" Alias "NMX_Sampling_Stop_1" (ByVal pHandle As UInt32) As UInt32

    Public Declare Function Sampling_ReadColumn32_1 Lib "NmxDllx86.dll" Alias "NMX_Sampling_ReadColumn32_1" (ByVal pHandle As UInt32,
        ByRef pslSamples As Int32,
        ByVal ulMaxSamples As UInt32,
        ByVal ulElementNo As UInt32,
        ByVal ulDoNotDelete As UInt32,
        ByRef pulSamplesCopied As UInt32,
        ByRef pudNoFirstSample As UInt64) As UInt32

    Public Declare Function Sampling_ReadRow32_1 Lib "NmxDllx86.dll" Alias "NMX_Sampling_ReadRow32_1" (ByVal pHandle As UInt32,
        ByRef pslSamples As Int32,
        ByVal ulMaxSamples As UInt32,
        ByRef pulSamplesCopied As UInt32,
        ByRef pudSampleNo As UInt64) As UInt32

    Public Declare Function Sampling_GetStatus_1 Lib "NmxDllx86.dll" Alias "NMX_Sampling_GetStatus_1" (ByVal pHandle As UInt32,
        ByRef pucStatus As Byte,
        ByRef pulNSamplingElements As UInt32,
        ByRef pudSamplesReceived As UInt64,
        ByRef pudMaxSamples As UInt64) As UInt32

    Public Declare Function Sampling_GetRowsLeft_1 Lib "NmxDllx86.dll" Alias "NMX_Sampling_GetRowsLeft_1" (ByVal pHandle As UInt32,
        ByRef pudRowsLeft As UInt64) As UInt32

    Public Declare Function DiagClearEvent_1 Lib "NmxDllx86.dll" Alias "NMX_DiagClearEvent_1" (ByVal pHandle As UInt32,
        ByVal ulBoxNo As UInt32,
        ByVal ucEventNo As Byte) As UInt32

    Public Declare Function DiagGetEventText_1 Lib "NmxDllx86.dll" Alias "NMX_DiagGetEventText_1" (ByVal pHandle As UInt32,
        ByVal ucEventNo As Byte,
        ByRef pcText As Byte, ByVal ulSizeofText As UInt32) As UInt32

    Public Declare Function SetDateTime_1 Lib "NmxDllx86.dll" Alias "NMX_SetDateTime_1" (ByVal pHandle As UInt32) As UInt32

    Public Declare Function SystemReset_1 Lib "NmxDllx86.dll" Alias "NMX_SystemReset_1" (ByVal pHandle As UInt32,
        ByVal ulDelayMaster As UInt32,
        ByVal ulDelaySlave As UInt32) As UInt32

    Public Declare Function ExchangeString_1 Lib "NmxDllx86.dll" Alias "NMX_ExchangeString_1" (ByVal pHandle As UInt32,
        ByVal ucDataCode As Byte,
        ByRef pcStringTx As Byte, ByVal ulSizeofTxString As UInt32,
        ByRef pcStringRx As Byte, ByVal ulMaxSizeofRxString As UInt32, ByRef pulSizeofRxString As UInt32) As UInt32

End Class
