﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;

namespace NmxDLL_Demo_CS_2017
{
    public enum NMX_STATUS
    {
        SUCCESS,
        HANDLE_INVALID,
        HANDLE_TOO_MANY,
        CONNECT_OPEN_FAILED,
        NOT_CONNECTED,
        NOT_AVAILABLE,
        SEND_SIZE_TOO_LARGE,
        DX_TIMEOUT_1,
        DX_TIMEOUT_2,
        DX_TIMEOUT_COMMON,
        INV_RESP,
        RESP_ERR,
        REQ_VERS_NOSUPPORT,
        BOXNO_INVALID,
        CHANNEL_INVALID,
        DIGIIN_INVALID,
        DIGIOUT_INVALID,
        STRING_INVALID,
        DATA_TOOLARGE,
        NOTIFICATION_UNKNOWN,
        SAMPLING_TOOMANY_ELEMENTS,
        SAMPLING_GUID_INVALID,
        SAMPLING_NO_ELEMENTS,
        SAMPLING_DOUBLE_ELEMENT,
        SAMPLING_INVALID_CHANNELNO,
        SAMPLING_INVALID_ELEMENTNO,
        SAMPLING_ALREADY_STARTED,
        SAMPLING_INVALID_BITNO,
        SAMPLING_INVALID_TRGMODE,
        SAMPLING_INVALID_TRGPOL,
        SAMPLING_ELEMENTS_NOACCEPT,
        SAMPLING_INVALID_PERIOD,
        SAMPLING_INVALID_MAXSAMPLES,
        SAMPLING_START_FAILED,
        SAMPLING_START_CONFIG,
        SAMPLING_START_NOTPREPARED,
        SAMPLING_NO_DATA_AVAILABLE,
        SAMPLING_READ_DATA_ERROR,
        SAMPLING_NOTENOUGH_MEMORY,
        SAMPLING_INTERNAL,
        HLSAMPLING_INVALID_FILTPERIOD,
        HLSAMPLING_INVALID_SCALE,
        HLSAMPLING_INVALID_START,
        HLSAMPLING_INVALID_DISTANCE,
        INTERNAL_SEQ,
        INVALID_EVENT,
        UNKNOWN
    };

    public enum NMX_NOTIFY
    {
        DISCONNECTED = 0x00000002,	            /* Connection closed */
        FAILURE_DATA_EXCHANGE = 0x00000003,	    /* Permanent failure during data exchange (e.g. timeout) */
        RECONNECTED = 0x00000004,               /* Reconnected after data exchange failure */
        NEW_STATIC32 = 0x00000010,              /* New static data available */
        SAMPLING_NEW_DATA = 0x00000020,         /* New sampling data available */
        SAMPLING_FINISHED = 0x00000021,         /* Sampling has been finished */
        SAMPLING_ALL_DATA_RECEIVED = 0x00000022,/* All sampled data has been received */
        SAMPLING_ERROR = 0x00000028,            /* An error occured during sampling */
        SAMPLING_BUFFER_OVERFLOW = 0x00000029,	/* A buffer overflow occured: application has not read data */
        SAMPLING_TIMEOUT = 0x0000002A           /* A timeout occured during sampling. (-> Multiple root causes / no new data received) */
    }

    public static class NMXWM
    {
        // Windows Messages for RegisterMessage_1.
        // User-defined messages start at 0x0400.
        public const int USER = 0x400;
        public const int DISCONNECTED               = USER + (int)NMX_NOTIFY.DISCONNECTED;
        public const int FAILURE_DATA_EXCHANGE      = USER + (int)NMX_NOTIFY.FAILURE_DATA_EXCHANGE;
        public const int RECONNECTED                = USER + (int)NMX_NOTIFY.RECONNECTED;
        public const int NEW_STATIC32               = USER + (int)NMX_NOTIFY.NEW_STATIC32;
        public const int SAMPLING_NEW_DATA          = USER + (int)NMX_NOTIFY.SAMPLING_NEW_DATA;
        public const int SAMPLING_FINISHED          = USER + (int)NMX_NOTIFY.SAMPLING_FINISHED;
        public const int SAMPLING_ALL_DATA_RECEIVED = USER + (int)NMX_NOTIFY.SAMPLING_ALL_DATA_RECEIVED;
        public const int SAMPLING_ERROR             = USER + (int)NMX_NOTIFY.SAMPLING_ERROR;
        public const int SAMPLING_BUFFER_OVERFLOW   = USER + (int)NMX_NOTIFY.SAMPLING_BUFFER_OVERFLOW;
        public const int SAMPLING_TIMEOUT           = USER + (int)NMX_NOTIFY.SAMPLING_TIMEOUT;
    }


    public class CNmx
    {
        #if _M_X64 
            private const string DRIVER_DLL_NAME = ".\\NmxDllx64.dll";
        #else
            private const string DRIVER_DLL_NAME = ".\\NmxDllx86.dll";
        #endif

        private const int MAX_STR_LENGTH = 256;
        private IntPtr pBuf1 = Marshal.AllocHGlobal(MAX_STR_LENGTH);
        private IntPtr pBuf2 = Marshal.AllocHGlobal(MAX_STR_LENGTH);
        private IntPtr pBuf3 = Marshal.AllocHGlobal(MAX_STR_LENGTH);
        private IntPtr pBuf4 = Marshal.AllocHGlobal(MAX_STR_LENGTH);

        /******************************************************************************
        * FUNCTION: UInt32_To_STATUS
        *-----------------------------------------------------------------------------
        * Convert a UInt32 return value from the NmxDll to the enum NMX_STATUS.
        *-----------------------------------------------------------------------------
        * PARAMETERS: 
        * ulStatus: return value from NmxDll
        *-----------------------------------------------------------------------------
        * Return: see type definition and NmxDll reference guide
        ******************************************************************************/
        private NMX_STATUS UInt32_To_STATUS(UInt32 ulStatus)
        {
            switch (ulStatus)
            {
                case 0x00000000: return NMX_STATUS.SUCCESS;
                case 0xF0000000: return NMX_STATUS.HANDLE_INVALID;
                case 0xF0000001: return NMX_STATUS.HANDLE_TOO_MANY;
                case 0xF0000010: return NMX_STATUS.CONNECT_OPEN_FAILED;
                case 0xF0000011: return NMX_STATUS.NOT_CONNECTED;
                case 0xF000001F: return NMX_STATUS.NOT_AVAILABLE;
                case 0xF0000020: return NMX_STATUS.SEND_SIZE_TOO_LARGE;
                case 0xF0000021: return NMX_STATUS.DX_TIMEOUT_1;
                case 0xF0000022: return NMX_STATUS.DX_TIMEOUT_2;
                case 0xF0000023: return NMX_STATUS.DX_TIMEOUT_COMMON;
                case 0xF0000030: return NMX_STATUS.INV_RESP;
                case 0xF0000031: return NMX_STATUS.RESP_ERR;
                case 0xF0000032: return NMX_STATUS.REQ_VERS_NOSUPPORT;
                case 0xF0000040: return NMX_STATUS.BOXNO_INVALID;
                case 0xF0000041: return NMX_STATUS.CHANNEL_INVALID;
                case 0xF0000042: return NMX_STATUS.DIGIIN_INVALID;
                case 0xF0000043: return NMX_STATUS.DIGIOUT_INVALID;
                case 0xF0000047: return NMX_STATUS.STRING_INVALID;
                case 0xF0000048: return NMX_STATUS.DATA_TOOLARGE;
                case 0xF0000050: return NMX_STATUS.NOTIFICATION_UNKNOWN;
                case 0xF0000100: return NMX_STATUS.SAMPLING_TOOMANY_ELEMENTS;
                case 0xF0000101: return NMX_STATUS.SAMPLING_GUID_INVALID;
                case 0xF0000102: return NMX_STATUS.SAMPLING_NO_ELEMENTS;
                case 0xF0000103: return NMX_STATUS.SAMPLING_DOUBLE_ELEMENT;
                case 0xF0000104: return NMX_STATUS.SAMPLING_INVALID_CHANNELNO;
                case 0xF0000105: return NMX_STATUS.SAMPLING_INVALID_ELEMENTNO;
                case 0xF0000106: return NMX_STATUS.SAMPLING_ALREADY_STARTED;
                case 0xF0000107: return NMX_STATUS.SAMPLING_INVALID_BITNO;
                case 0xF0000108: return NMX_STATUS.SAMPLING_INVALID_TRGMODE;
                case 0xF0000109: return NMX_STATUS.SAMPLING_INVALID_TRGPOL;
                case 0xF0000120: return NMX_STATUS.SAMPLING_ELEMENTS_NOACCEPT;
                case 0xF0000121: return NMX_STATUS.SAMPLING_INVALID_PERIOD;
                case 0xF0000122: return NMX_STATUS.SAMPLING_INVALID_MAXSAMPLES;
                case 0xF0000130: return NMX_STATUS.SAMPLING_START_FAILED;
                case 0xF0000131: return NMX_STATUS.SAMPLING_START_CONFIG;
                case 0xF0000132: return NMX_STATUS.SAMPLING_START_NOTPREPARED;
                case 0xF0000140: return NMX_STATUS.SAMPLING_NO_DATA_AVAILABLE;
                case 0xF0000141: return NMX_STATUS.SAMPLING_READ_DATA_ERROR;
                case 0xF00001F8: return NMX_STATUS.SAMPLING_NOTENOUGH_MEMORY;
                case 0xF00001FF: return NMX_STATUS.SAMPLING_INTERNAL;
                case 0xF0000200: return NMX_STATUS.HLSAMPLING_INVALID_FILTPERIOD;
                case 0xF0000201: return NMX_STATUS.HLSAMPLING_INVALID_SCALE;
                case 0xF0000202: return NMX_STATUS.HLSAMPLING_INVALID_START;
                case 0xF0000203: return NMX_STATUS.HLSAMPLING_INVALID_DISTANCE;
                case 0xF0001000: return NMX_STATUS.INTERNAL_SEQ;
                case 0xF0001001: return NMX_STATUS.INVALID_EVENT;
                default: return NMX_STATUS.UNKNOWN;
            }
        }

        private int GetByteStringLength(byte[] byteString)
        {
            int iLength = 0;

            foreach (byte b in byteString)
            {
                if (b == 0)
                {
                    break;
                }
                else
                {
                    iLength++;
                }
            }

            if (iLength > MAX_STR_LENGTH)
            {
                iLength = MAX_STR_LENGTH;
            }

            return iLength;
        }

        // ### NMX_GetDllVersion_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern void NMX_GetDllVersion_1(ref UInt16 usMajor, ref UInt16 usMinor, ref UInt16 usPatch, ref UInt16 usBuild);
        public void GetDllVersion_1(ref UInt16 usMajor, ref UInt16 usMinor, ref UInt16 usPatch, ref UInt16 usBuild)
        {
            NMX_GetDllVersion_1(ref usMajor, ref usMinor, ref usPatch, ref usBuild);
        }

        // ### NMX_DeviceIPv4Open_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_DeviceIPv4Open_1(Byte ucIp3, Byte ucIp2, Byte ucIp1, Byte ucIp0, UInt16 usPortCmd, UInt16 usPortData, ref IntPtr ppHandle);
        public NMX_STATUS DeviceIPv4Open_1(Byte ucIp3, Byte ucIp2, Byte ucIp1, Byte ucIp0, UInt16 usPortCmd, UInt16 usPortData, ref IntPtr ppHandle)
        {
            return UInt32_To_STATUS(NMX_DeviceIPv4Open_1(ucIp3, ucIp2, ucIp1, ucIp0, usPortCmd, usPortData, ref ppHandle));
        }

        // ### NMX_DeviceClose_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_DeviceClose_1(ref IntPtr ppHandle);
        public NMX_STATUS DeviceClose_1(ref IntPtr ppHandle)
        {
            return UInt32_To_STATUS(NMX_DeviceClose_1(ref ppHandle));
        }

        // ### NMX_GetBoxCount_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_GetBoxCount_1(IntPtr pHandle, ref UInt32 pulBoxCount);
        public NMX_STATUS GetBoxCount_1(IntPtr pHandle, ref UInt32 pulBoxCount)
        {
            return UInt32_To_STATUS(NMX_GetBoxCount_1(pHandle, ref pulBoxCount));
        }

        // ### NMX_GetBoxInfo_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_GetBoxInfo_1(
            IntPtr pHandle,
            UInt32 ulBoxNo,
            ref UInt32 pulInfoData, UInt32 ulInfoDataNElements,
            ref UInt64 pudMacAddress,
            IntPtr pcSerNo, UInt32 ulSizeofSerNo,
            IntPtr pcProdCode, UInt32 ulSizeofProdCode,
            IntPtr pcOrderNo, UInt32 ulSizeofOrderNo,
            IntPtr pcName, UInt32 ulSizeofName);
        public NMX_STATUS GetBoxInfo_1(
            IntPtr pHandle,
            UInt32 ulBoxNo,
            ref UInt32[] pulInfoData,
            ref UInt64 pudMacAddress,
            ref string strSerNo,
            ref string strProdCode,
            ref string strOrderNo,
            ref string strName)
        {
            NMX_STATUS eReturn = NMX_STATUS.UNKNOWN;
            byte[] byteData = new byte[MAX_STR_LENGTH];

            eReturn = UInt32_To_STATUS(NMX_GetBoxInfo_1(pHandle, ulBoxNo, ref pulInfoData[0], (UInt32)pulInfoData.Length, ref pudMacAddress, pBuf1, MAX_STR_LENGTH, pBuf2, MAX_STR_LENGTH, pBuf3, MAX_STR_LENGTH, pBuf4, MAX_STR_LENGTH));

            if (eReturn == NMX_STATUS.SUCCESS)
            {
                Array.Resize(ref byteData, MAX_STR_LENGTH);
                Array.Clear(byteData, 0, MAX_STR_LENGTH);
                Marshal.Copy(pBuf1, byteData, 0, MAX_STR_LENGTH);
                Array.Resize(ref byteData, GetByteStringLength(byteData));
                strSerNo = System.Text.Encoding.UTF7.GetString(byteData);

                Array.Resize(ref byteData, MAX_STR_LENGTH);
                Array.Clear(byteData, 0, MAX_STR_LENGTH);
                Marshal.Copy(pBuf2, byteData, 0, MAX_STR_LENGTH);
                Array.Resize(ref byteData, GetByteStringLength(byteData));
                strProdCode = System.Text.Encoding.UTF7.GetString(byteData);

                Array.Resize(ref byteData, MAX_STR_LENGTH);
                Array.Clear(byteData, 0, MAX_STR_LENGTH);
                Marshal.Copy(pBuf3, byteData, 0, MAX_STR_LENGTH);
                Array.Resize(ref byteData, GetByteStringLength(byteData));
                strOrderNo = System.Text.Encoding.UTF7.GetString(byteData);

                Array.Resize(ref byteData, MAX_STR_LENGTH);
                Array.Clear(byteData, 0, MAX_STR_LENGTH);
                Marshal.Copy(pBuf4, byteData, 0, MAX_STR_LENGTH);
                Array.Resize(ref byteData, GetByteStringLength(byteData));
                strName = System.Text.Encoding.UTF7.GetString(byteData);
            }

            return eReturn;
        }

        // ### NMX_UpdateChannelInfo_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_UpdateChannelInfo_1(IntPtr pHandle);
        public NMX_STATUS UpdateChannelInfo_1(IntPtr pHandle)
        {
            return UInt32_To_STATUS(NMX_UpdateChannelInfo_1(pHandle));
        }

        // ### NMX_GetChannelCount_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_GetChannelCount_1(IntPtr pHandle, ref UInt32 pulChannelCount, ref UInt32 pulNDigitalInputBytes, ref UInt32 pulNDigitalOutputBytes);
        public NMX_STATUS GetChannelCount_1(IntPtr pHandle, ref UInt32 pulChannelCount, ref UInt32 pulNDigitalInputBytes, ref UInt32 pulNDigitalOutputBytes)
        {
            return UInt32_To_STATUS(NMX_GetChannelCount_1(pHandle, ref pulChannelCount, ref pulNDigitalInputBytes, ref pulNDigitalOutputBytes));
        }

        // ### NMX_GetChannelInfo_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_GetChannelInfo_1(IntPtr pHandle,
            UInt32 ulChannelNo,
            ref UInt32 pulChannelType,
            ref UInt32 pulNDigits,
            ref UInt32 pulBoxNo,
            ref UInt32 pulReserved,
            ref UInt32 pulBoxChannelNo,
            ref Int32 pslRawDataType,
            ref Int32 pslFactNumerator,
            ref Int32 pslFactDenominator,
            ref float pflFactDigitsToUnit,
            IntPtr pcUnit, UInt32 ulSizeofUnit,
            IntPtr pcOrderNo, UInt32 ulSizeofOrderNo,
            IntPtr pcSerialNo, UInt32 ulSizeofSerialNo);
        public NMX_STATUS GetChannelInfo_1(IntPtr pHandle,
            UInt32 ulChannelNo,
            ref UInt32 pulChannelType,
            ref UInt32 pulNDigits,
            ref UInt32 pulBoxNo,
            ref UInt32 pulReserved,
            ref UInt32 pulBoxChannelNo,
            ref Int32 pslRawDataType,
            ref Int32 pslFactNumerator,
            ref Int32 pslFactDenominator,
            ref float pflFactDigitsToUnit,
            ref string strUnit,
            ref string strOrderNo,
            ref string strSerialNo)
        {
            NMX_STATUS eReturn = NMX_STATUS.UNKNOWN;
            byte[] byteData = new byte[MAX_STR_LENGTH];

            eReturn = UInt32_To_STATUS(NMX_GetChannelInfo_1(pHandle, ulChannelNo, ref pulChannelType, ref pulNDigits, ref pulBoxNo, 
                ref pulReserved, ref pulBoxChannelNo, ref pslRawDataType, ref pslFactNumerator, ref pslFactDenominator,
                ref pflFactDigitsToUnit, pBuf1, MAX_STR_LENGTH, pBuf2, MAX_STR_LENGTH, pBuf3, MAX_STR_LENGTH));

            if (eReturn == NMX_STATUS.SUCCESS)
            {
                Array.Resize(ref byteData, MAX_STR_LENGTH);
                Array.Clear(byteData, 0, MAX_STR_LENGTH);
                Marshal.Copy(pBuf1, byteData, 0, MAX_STR_LENGTH);
                Array.Resize(ref byteData, GetByteStringLength(byteData));
                strUnit = System.Text.Encoding.UTF7.GetString(byteData);

                Array.Resize(ref byteData, MAX_STR_LENGTH);
                Array.Clear(byteData, 0, MAX_STR_LENGTH);
                Marshal.Copy(pBuf2, byteData, 0, MAX_STR_LENGTH);
                Array.Resize(ref byteData, GetByteStringLength(byteData));
                strOrderNo = System.Text.Encoding.UTF7.GetString(byteData);

                Array.Resize(ref byteData, MAX_STR_LENGTH);
                Array.Clear(byteData, 0, MAX_STR_LENGTH);
                Marshal.Copy(pBuf3, byteData, 0, MAX_STR_LENGTH);
                Array.Resize(ref byteData, GetByteStringLength(byteData));
                strSerialNo = System.Text.Encoding.UTF7.GetString(byteData);
            }

            return eReturn;
        }

        // ### NMX_GetDigitalInputInfo_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_GetDigitalInputInfo_1(IntPtr pHandle, UInt32 ulInputByteNo, ref UInt32 pulBoxNo, ref UInt32 pulBoxByteNo);
        public NMX_STATUS GetDigitalInputInfo_1(IntPtr pHandle, UInt32 ulInputByteNo, ref UInt32 pulBoxNo, ref UInt32 pulBoxByteNo)
        {
            return UInt32_To_STATUS(NMX_GetDigitalInputInfo_1(pHandle, ulInputByteNo, ref pulBoxNo, ref pulBoxByteNo));
        }

        // ### NMX_GetDigitalOutputInfo_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_GetDigitalOutputInfo_1(IntPtr pHandle, UInt32 ulOutputByteNo, ref UInt32 pulBoxNo, ref UInt32 pulBoxByteNo);
        public NMX_STATUS GetDigitalOutputInfo_1(IntPtr pHandle, UInt32 ulOutputByteNo, ref UInt32 pulBoxNo, ref UInt32 pulBoxByteNo)
        {
            return UInt32_To_STATUS(NMX_GetDigitalOutputInfo_1(pHandle, ulOutputByteNo, ref pulBoxNo, ref pulBoxByteNo));
        }

        // ### NMX_RegisterMessage_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_RegisterMessage_1(IntPtr pHandle,
            UInt32 ulNotification,
            IntPtr hWnd,
            UInt32 ulMsgCode,
            UInt32 tWParam,
            UInt32 tLParam);
        public NMX_STATUS RegisterMessage_1(IntPtr pHandle,
            UInt32 ulNotification,
            IntPtr hWnd,
            UInt32 ulMsgCode,
            UInt32 tWParam,
            UInt32 tLParam)
        {
            return UInt32_To_STATUS(NMX_RegisterMessage_1(pHandle, ulNotification, hWnd, ulMsgCode, tWParam, tLParam));
        }

        // ### NMX_ChannelSetParameter_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_ChannelSetParameter_1(IntPtr pHandle, UInt32 ulChannelNo,
            IntPtr pcStringTx, UInt32 ulSizeofTxString,
            IntPtr pcStringRx, UInt32 ulMaxSizeofRxString, ref UInt32 pulSizeofRxString);
        public NMX_STATUS ChannelSetParameter_1(IntPtr pHandle, UInt32 ulChannelNo, string strTx, ref string strRx)
        {
            NMX_STATUS eReturn = NMX_STATUS.UNKNOWN;
            byte[] byteData;
            int iTxLength = 0;
            UInt32 ulSizeofRxString = 0;

            byteData = System.Text.Encoding.ASCII.GetBytes(strTx);
            iTxLength = byteData.Length;
            if (iTxLength > MAX_STR_LENGTH)
            {
                iTxLength = MAX_STR_LENGTH;
            }
            Marshal.Copy(byteData, 0, pBuf1, iTxLength);

            eReturn = UInt32_To_STATUS(NMX_ChannelSetParameter_1(pHandle, ulChannelNo,
                pBuf1, (UInt32)iTxLength, pBuf2, MAX_STR_LENGTH, ref ulSizeofRxString));

            if (eReturn == NMX_STATUS.SUCCESS)
            {
                Array.Resize(ref byteData, MAX_STR_LENGTH);
                Array.Clear(byteData, 0, MAX_STR_LENGTH);
                Marshal.Copy(pBuf2, byteData, 0, MAX_STR_LENGTH);
                Array.Resize(ref byteData, (int)ulSizeofRxString);
                strRx = System.Text.Encoding.UTF7.GetString(byteData);
            }

            return eReturn;
        }

        // ### NMX_ChannelSetConfig_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_ChannelSetConfig_1(IntPtr pHandle, UInt32 ulChannelNo,
            IntPtr pcStringTx, UInt32 ulSizeofTxString,
            IntPtr pcStringRx, UInt32 ulMaxSizeofRxString, ref UInt32 pulSizeofRxString);
        public NMX_STATUS ChannelSetConfig_1(IntPtr pHandle, UInt32 ulChannelNo, string strTx, ref string strRx)
        {
            NMX_STATUS eReturn = NMX_STATUS.UNKNOWN;
            byte[] byteData;
            int iTxLength = 0;
            UInt32 ulSizeofRxString = 0;

            byteData = System.Text.Encoding.ASCII.GetBytes(strTx);
            iTxLength = byteData.Length;
            if (iTxLength > MAX_STR_LENGTH)
            {
                iTxLength = MAX_STR_LENGTH;
            }
            Marshal.Copy(byteData, 0, pBuf1, iTxLength);

            eReturn = UInt32_To_STATUS(NMX_ChannelSetConfig_1(pHandle, ulChannelNo,
                pBuf1, (UInt32)iTxLength, pBuf2, MAX_STR_LENGTH, ref ulSizeofRxString));

            if (eReturn == NMX_STATUS.SUCCESS)
            {
                Array.Resize(ref byteData, MAX_STR_LENGTH);
                Array.Clear(byteData, 0, MAX_STR_LENGTH);
                Marshal.Copy(pBuf2, byteData, 0, MAX_STR_LENGTH);
                Array.Resize(ref byteData, (int)ulSizeofRxString);
                strRx = System.Text.Encoding.UTF7.GetString(byteData);
            }

            return eReturn;
        }

        // ### NMX_StaticGet32_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_StaticGet32_1(IntPtr pHandle,
            ref Int32 paslValues, UInt32 ulValuesNElements,
            ref byte paucHardwareStatus, UInt32 ulSizeofHardwareStatus,
            ref byte paucDigiIn, UInt32 ulSizeofDigiIn,
            ref byte paucBoxStatus, UInt32 ulSizeofBoxStatus,
            ref UInt32 pulUpdateCtr);
        public NMX_STATUS StaticGet32_1(IntPtr pHandle,
            ref Int32[] aslValues, ref byte[] aucHardwareStatus,
            ref byte[] aucDigiIn, ref byte[] aucBoxStatus,
            ref UInt32 pulUpdateCtr)
        {
            return UInt32_To_STATUS(NMX_StaticGet32_1(pHandle,
            ref aslValues[0], (UInt32)aslValues.Length,
            ref aucHardwareStatus[0], (UInt32)aucHardwareStatus.Length,
            ref aucDigiIn[0], (UInt32)aucDigiIn.Length,
            ref aucBoxStatus[0], (UInt32)aucBoxStatus.Length,
            ref pulUpdateCtr));
        }

        // ### NMX_StaticSetMedianDepth_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_StaticSetMedianDepth_1(IntPtr pHandle, UInt32 ulMedianDepth);
        public NMX_STATUS StaticSetMedianDepth_1(IntPtr pHandle, UInt32 ulMedianDepth)
        {
            return UInt32_To_STATUS(NMX_StaticSetMedianDepth_1(pHandle, ulMedianDepth));
        }

        // ### NMX_SetOutputs_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_SetOutputs_1(IntPtr pHandle,
            ref byte pucDigiOut, UInt32 ulSizeofDigiOut, byte ucForceSendImmediately);
        public NMX_STATUS SetOutputs_1(IntPtr pHandle, byte[] aucDigiOut, byte ucForceSendImmediately)
        {
            return UInt32_To_STATUS(NMX_SetOutputs_1(pHandle, ref aucDigiOut[0], (UInt32)aucDigiOut.Length, ucForceSendImmediately));
        }

        // ### NMX_DisableOutputUpdate_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_DisableOutputUpdate_1(IntPtr pHandle);
        public NMX_STATUS DisableOutputUpdate_1(IntPtr pHandle)
        {
            return UInt32_To_STATUS(NMX_DisableOutputUpdate_1(pHandle));
        }

        // ### NMX_DigitalIoConfig_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_DigitalIoConfig_1(IntPtr pHandle, byte ucOutputResetEnabled);
        public NMX_STATUS DigitalIoConfig_1(IntPtr pHandle, byte ucOutputResetEnabled)
        {
            return UInt32_To_STATUS(NMX_DigitalIoConfig_1(pHandle, ucOutputResetEnabled));
        }

        // ### NMX_DigitalOutputsGetState_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_DigitalOutputsGetState_1(IntPtr pHandle, ref byte pucOutputState, UInt32 ulSizeofOutputState);
        public NMX_STATUS DigitalOutputsGetState_1(IntPtr pHandle, ref byte[] aucOutputState)
        {
            return UInt32_To_STATUS(NMX_DigitalOutputsGetState_1(pHandle, ref aucOutputState[0], (UInt32)aucOutputState.Length));
        }

        // ### NMX_Sampling_GetMaxSpeed_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_Sampling_GetMaxSpeed_1(IntPtr pHandle, ref UInt32 pulInSamplePeriodUs);
        public NMX_STATUS Sampling_GetMaxSpeed_1(IntPtr pHandle, ref UInt32 pulInSamplePeriodUs)
        {
            return UInt32_To_STATUS(NMX_Sampling_GetMaxSpeed_1(pHandle, ref pulInSamplePeriodUs));
        }

        // ### NMX_Sampling_Reset_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_Sampling_Reset_1(IntPtr pHandle);
        public NMX_STATUS Sampling_Reset_1(IntPtr pHandle)
        {
            return UInt32_To_STATUS(NMX_Sampling_Reset_1(pHandle));
        }

        // ### NMX_Sampling_AddChannelsAll_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_Sampling_AddChannelsAll_1(IntPtr pHandle, ref UInt32 pulNElementsTotal);
        public NMX_STATUS Sampling_AddChannelsAll_1(IntPtr pHandle, ref UInt32 pulNElementsTotal)
        {
            return UInt32_To_STATUS(NMX_Sampling_AddChannelsAll_1(pHandle, ref pulNElementsTotal));
        }

        // ### NMX_Sampling_AddChannel_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_Sampling_AddChannel_1(IntPtr pHandle, UInt32 ulChannelNumber, ref UInt32 pulNElementsTotal);
        public NMX_STATUS Sampling_AddChannel_1(IntPtr pHandle, UInt32 ulChannelNumber, ref UInt32 pulNElementsTotal)
        {
            return UInt32_To_STATUS(NMX_Sampling_AddChannel_1(pHandle, ulChannelNumber, ref pulNElementsTotal));
        }

        // ### NMX_Sampling_AddDigiInAll_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_Sampling_AddDigiInAll_1(IntPtr pHandle, ref UInt32 pulNElementsTotal);
        public NMX_STATUS Sampling_AddDigiInAll_1(IntPtr pHandle, ref UInt32 pulNElementsTotal)
        {
            return UInt32_To_STATUS(NMX_Sampling_AddDigiInAll_1(pHandle, ref pulNElementsTotal));
        }

        // ### NMX_Sampling_AddDigiInByte_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_Sampling_AddDigiInByte_1(IntPtr pHandle, UInt32 ulDigiInByteNo, ref UInt32 pulNElementsTotal);
        public NMX_STATUS Sampling_AddDigiInByte_1(IntPtr pHandle, UInt32 ulDigiInByteNo, ref UInt32 pulNElementsTotal)
        {
            return UInt32_To_STATUS(NMX_Sampling_AddDigiInByte_1(pHandle, ulDigiInByteNo, ref pulNElementsTotal));
        }

        // ### NMX_Sampling_AddDigiOutAll_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_Sampling_AddDigiOutAll_1(IntPtr pHandle, ref UInt32 pulNElementsTotal);
        public NMX_STATUS Sampling_AddDigiOutAll_1(IntPtr pHandle, ref UInt32 pulNElementsTotal)
        {
            return UInt32_To_STATUS(NMX_Sampling_AddDigiOutAll_1(pHandle, ref pulNElementsTotal));
        }

        // ### NMX_Sampling_AddDigiOutByte_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_Sampling_AddDigiOutByte_1(IntPtr pHandle, UInt32 ulDigiOutByteNo, ref UInt32 pulNElementsTotal);
        public NMX_STATUS Sampling_AddDigiOutByte_1(IntPtr pHandle, UInt32 ulDigiOutByteNo, ref UInt32 pulNElementsTotal)
        {
            return UInt32_To_STATUS(NMX_Sampling_AddDigiOutByte_1(pHandle, ulDigiOutByteNo, ref pulNElementsTotal));
        }

        // ### NMX_Sampling_SetTriggerDigiIn_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_Sampling_SetTriggerDigiIn_1(IntPtr pHandle, UInt32 ulDigiInByteNo, UInt32 ulDigiInBitNo,
            UInt32 ulMode, UInt32 ulPolarity);
        public NMX_STATUS Sampling_SetTriggerDigiIn_1(IntPtr pHandle, UInt32 ulDigiInByteNo, UInt32 ulDigiInBitNo,
            UInt32 ulMode, UInt32 ulPolarity)
        {
            return UInt32_To_STATUS(NMX_Sampling_SetTriggerDigiIn_1(pHandle, ulDigiInByteNo, ulDigiInBitNo, ulMode, ulPolarity));
        }

        // ### NMX_Sampling_PrepareTime_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_Sampling_PrepareTime_1(IntPtr pHandle, UInt32 ulSamplePeriod, UInt32 ulDLLArrayLength, UInt64 udMaxSamples);
        public NMX_STATUS Sampling_PrepareTime_1(IntPtr pHandle, UInt32 ulSamplePeriod, UInt32 ulDLLArrayLength, UInt64 udMaxSamples)
        {
            return UInt32_To_STATUS(NMX_Sampling_PrepareTime_1(pHandle, ulSamplePeriod, ulDLLArrayLength, udMaxSamples));
        }

        // ### NMX_Sampling_PrepareCustomTFT_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_Sampling_PrepareCustomTFT_1(IntPtr pHandle,
            UInt32 ulSamplePeriod,
            UInt32 ulFilteredPeriod,
            UInt32 ulArrayLength,
            UInt64 udMaxSamples,
            UInt32 ulNTailSamples,
            UInt32 ulTriggerDigiInByteNo,
            UInt32 ulTriggerDigiInBitNo,
            UInt32 ulTriggerMode,
            UInt32 ulTriggerPolarity);
        public NMX_STATUS Sampling_PrepareCustomTFT_1(IntPtr pHandle,
            UInt32 ulSamplePeriod,
            UInt32 ulFilteredPeriod,
            UInt32 ulArrayLength,
            UInt64 udMaxSamples,
            UInt32 ulNTailSamples,
            UInt32 ulTriggerDigiInByteNo,
            UInt32 ulTriggerDigiInBitNo,
            UInt32 ulTriggerMode,
            UInt32 ulTriggerPolarity)
        {
            return UInt32_To_STATUS(NMX_Sampling_PrepareCustomTFT_1(pHandle, ulSamplePeriod, ulFilteredPeriod, ulArrayLength,
                udMaxSamples, ulNTailSamples, ulTriggerDigiInByteNo, ulTriggerDigiInBitNo, ulTriggerMode, ulTriggerPolarity));
        }

        // ### NMX_Sampling_PreparePosition_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_Sampling_PreparePosition_1(IntPtr pHandle,
            UInt32 ulSamplePeriod,
            UInt32 ulArrayLength,
            UInt64 udMaxSamples,
            UInt32 ulTriggerChannelNumber,
            double fdScale,
            double fdStart,
            double fdDistance);
        public NMX_STATUS Sampling_PreparePosition_1(IntPtr pHandle,
            UInt32 ulSamplePeriod,
            UInt32 ulArrayLength,
            UInt64 udMaxSamples,
            UInt32 ulTriggerChannelNumber,
            double fdScale,
            double fdStart,
            double fdDistance)
        {
            return UInt32_To_STATUS(NMX_Sampling_PreparePosition_1(pHandle, ulSamplePeriod, ulArrayLength, udMaxSamples,
                ulTriggerChannelNumber, fdScale, fdStart, fdDistance));
        }

        // ### NMX_Sampling_Start_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_Sampling_Start_1(IntPtr pHandle);
        public NMX_STATUS Sampling_Start_1(IntPtr pHandle)
        {
            return UInt32_To_STATUS(NMX_Sampling_Start_1(pHandle));
        }

        // ### NMX_Sampling_Stop_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_Sampling_Stop_1(IntPtr pHandle);
        public NMX_STATUS Sampling_Stop_1(IntPtr pHandle)
        {
            return UInt32_To_STATUS(NMX_Sampling_Stop_1(pHandle));
        }

        // ### NMX_Sampling_ReadRow32_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_Sampling_ReadRow32_1(IntPtr pHandle,
            ref Int32 aslSamples, UInt32 ulMaxSamples, ref UInt32 pulSamplesCopied, ref UInt64 pudSampleNo);
        public NMX_STATUS Sampling_ReadRow32_1(IntPtr pHandle,
            ref Int32[] aslSamples, ref UInt32 pulSamplesCopied, ref UInt64 pudSampleNo)
        {
            return UInt32_To_STATUS(NMX_Sampling_ReadRow32_1(pHandle,
                ref aslSamples[0], (UInt32)aslSamples.Length, ref pulSamplesCopied, ref pudSampleNo));
        }

        // ### NMX_Sampling_GetStatus_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_Sampling_GetStatus_1(IntPtr pHandle,
            ref byte pucStatus, ref UInt32 pulNSamplingElements,
            ref UInt64 pudSamplesReceived, ref UInt64 pudMaxSamples);
        public NMX_STATUS Sampling_GetStatus_1(IntPtr pHandle,
            ref byte pucStatus, ref UInt32 pulNSamplingElements,
            ref UInt64 pudSamplesReceived, ref UInt64 pudMaxSamples)
        {
            return UInt32_To_STATUS(NMX_Sampling_GetStatus_1(pHandle, ref pucStatus, ref pulNSamplingElements, ref pudSamplesReceived, ref pudMaxSamples));
        }

        // ### NMX_Sampling_GetRowsLeft_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_Sampling_GetRowsLeft_1(IntPtr pHandle, ref UInt64 pudRowsLeft);
        public NMX_STATUS Sampling_GetRowsLeft_1(IntPtr pHandle, ref UInt64 pudRowsLeft)
        {
            return UInt32_To_STATUS(NMX_Sampling_GetRowsLeft_1(pHandle, ref pudRowsLeft));
        }

        // ### NMX_DiagClearEvent_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_DiagClearEvent_1(IntPtr pHandle, UInt32 ulBoxNo, byte ucEventNo);
        public NMX_STATUS DiagClearEvent_1(IntPtr pHandle, UInt32 ulBoxNo, byte ucEventNo)
        {
            return UInt32_To_STATUS(NMX_DiagClearEvent_1(pHandle, ulBoxNo, ucEventNo));
        }

        // ### NMX_DiagGetEventText_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_DiagGetEventText_1(IntPtr pHandle, byte ucEventNo, IntPtr pcText, UInt32 ulSizeofText);
        public NMX_STATUS DiagGetEventText_1(IntPtr pHandle, byte ucEventNo, ref string strText)
        {
            NMX_STATUS eReturn = NMX_STATUS.UNKNOWN;
            byte[] byteData = new byte[MAX_STR_LENGTH];

            eReturn = UInt32_To_STATUS(NMX_DiagGetEventText_1(pHandle, ucEventNo, pBuf1, MAX_STR_LENGTH));
            if (eReturn == NMX_STATUS.SUCCESS)
            {
                Array.Resize(ref byteData, MAX_STR_LENGTH);
                Array.Clear(byteData, 0, MAX_STR_LENGTH);
                Marshal.Copy(pBuf1, byteData, 0, MAX_STR_LENGTH);
                Array.Resize(ref byteData, GetByteStringLength(byteData));
                strText = System.Text.Encoding.UTF7.GetString(byteData);
            }

            return eReturn;
        }

        // ### NMX_SetDateTime_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_SetDateTime_1(IntPtr pHandle);
        public NMX_STATUS SetDateTime_1(IntPtr pHandle)
        {
            return UInt32_To_STATUS(NMX_SetDateTime_1(pHandle));
        }

        // ### NMX_SystemReset_1
        [DllImport(DRIVER_DLL_NAME)]
        private static extern UInt32 NMX_SystemReset_1(IntPtr pHandle, UInt32 ulDelayMaster, UInt32 ulDelaySlave);
        public NMX_STATUS SystemReset_1(IntPtr pHandle, UInt32 ulDelayMaster, UInt32 ulDelaySlave)
        {
            return UInt32_To_STATUS(NMX_SystemReset_1(pHandle, ulDelayMaster, ulDelaySlave));
        }
    }
}