﻿using System;

namespace NmxDLL_Demo_CS_2017
{
    public class ChannelData
    {
        private Int32 slStaticValue;
        public Int32 slStaticMin;
        public Int32 slStaticMax;
        public double fdFactor;
        public UInt32 ulNDigits;
        public String strUnit;

        public ChannelData()
        {
            fdFactor = 1.0f;
            slStaticValue = 0x7FFFFFFF;
            ResetStaticMinMax();
            strUnit = "Digit";
            ulNDigits = 0;
        }
        public void NewStaticValue(Int32 slValue)
        {
            /* Update Min / Max */
            if (slValue < slStaticMin)
            {
                slStaticMin = slValue;
            }

            if (slValue > slStaticMax)
            {
                slStaticMax = slValue;
            }

            /* Update value */
            slStaticValue = slValue;
        }


        public Int32 GetNewestValue()
        {
            return slStaticValue;
        }


        public void ResetStaticMinMax()
        {
            slStaticMin = Int32.MaxValue;
            slStaticMax = Int32.MinValue;
        }


        public Int32 GetStaticDiff()
        {
            if (slStaticMax >= slStaticMin)
            {
                return (slStaticMax - slStaticMin);
            }
            return 0x7FFFFFFF;
        }

        public string GetStaticUnitValue()
	    {
		    string strFormat = string.Format("F{0}", ulNDigits);
		    double fdValue = (double)slStaticValue * fdFactor;
		    return fdValue.ToString(strFormat) + " " + strUnit;
	    }


        public string GetStaticUnitMin()
	    {
		    string strFormat = string.Format("F{0}", ulNDigits);
		    double fdValue = (double)slStaticMin * fdFactor;
		    return fdValue.ToString(strFormat) + " " + strUnit;
	    }


        public string GetStaticUnitMax()
	    {
		    string strFormat = string.Format("F{0}", ulNDigits);
		    double fdValue = (double)slStaticMax * fdFactor;
		    return fdValue.ToString(strFormat) + " " + strUnit;
	    }


	    public string GetStaticUnitDiff()
	    {
		    string strFormat = string.Format("F{0}", ulNDigits);
		    double fdValue = (double)GetStaticDiff() * fdFactor;
		    return fdValue.ToString(strFormat) + " " + strUnit;
	    }
    }
}