﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;

namespace NmxDLL_Demo_CS_2017
{
    public partial class Form1 : Form
    {
        private const int N_STATIC_CH_DISPLAY = 64;
        private const int N_DIGIIO_DISPLAY = 128;
        private const int N_MAX_SAMPLING_CHANNELS = 256;

        private bool bConnected;
        private UInt32 ulBoxInfoUpdates;
        private UInt32 ulChannelInfoUpdates;
        private UInt32 ulStatic1stCh;
        private UInt32 ulNSamplingElements;
        bool bNewStatic;
        bool bNewSamplingData;
        bool bNewReconnected;
        private UInt32 ulCtrReconnects;
        private UInt32 ulCtrSamplingNotificationsNewData;
        private UInt32 ulCtrSamplingNotificationsFinished;
        private UInt32 ulCtrSamplingNotificationsAllReceived;
        private UInt32 ulCtrSamplingNotificationsError;
        private UInt32 ulCtrSamplingNotificationsBufferOverflow;
        private UInt32 ulCtrSamplingNotificationTimeout;
        private ChannelData[] aclChannelData;
        private UInt32 ulSamplePeriodUltraFast;
        private UInt32 ulSamplePeriodFast;
        private UInt32 ulSamplePeriodStandard;
        private UInt32 ulSamplingEndlessArrayLength;
        private UInt32 ulSamplingArrayRowNewest;
        private UInt64 udSamplingCtrNewest;
        bool bWriteDigitalOutputData;
        private CNmx clNmx;
        private IntPtr pHandleNmx;
        private Int32[,] aaslRingBuf = new Int32[1, 1];

        public Form1()
        {
            InitializeComponent();
        }

        /******************************************************************************
        * FUNCTION: Form1_Load
        *-----------------------------------------------------------------------------
        * Called after the form is loaded. Do several initializations.
        ******************************************************************************/
        private void Form1_Load(object sender, EventArgs e)
        {
            UInt32 ulI = 0;
            string str = "";
            string strHeader = "";

            bConnected = false;
            ulBoxInfoUpdates = 0;
            ulChannelInfoUpdates = 0;
            ulStatic1stCh = 1;
            bNewStatic = false;
            bNewSamplingData = false;
            bNewReconnected = false;
            SamplingClearNotificationCtrs();
            aclChannelData = new ChannelData[N_STATIC_CH_DISPLAY];
            for (ulI = 0; ulI < N_STATIC_CH_DISPLAY; ulI++)
            {
                aclChannelData[ulI] = new ChannelData();
            }
            ulNSamplingElements = 0;
            ulSamplingEndlessArrayLength = 0;
            ulSamplingArrayRowNewest = 0;
            udSamplingCtrNewest = 0;
            ulSamplePeriodUltraFast = 1000;
            ulSamplePeriodFast = 500;
            ulSamplePeriodStandard = 100;
            ulCtrReconnects = 0;
            bWriteDigitalOutputData = false;

            cblSampling_MeasChannels.Items.Clear();
            cblSampling_DigitalInputs.Items.Clear();
            cblSampling_DigitalOutputs.Items.Clear();

            cbSamplingDInTrgBit.SelectedIndex = 0;
            cbSamplingDInTrgMode.SelectedIndex = 0;
            cbSamplingDInTrgPol.SelectedIndex = 0;
            cbSamplingTftTriggerBit.SelectedIndex = 0;
            cbSamplingTftTriggerMode.SelectedIndex = 0;
            cbSamplingTftTriggerPolarity.SelectedIndex = 0;

            /* Set Readme text */
            str = "This is a demo for the Nmx-DLL. Please note:\r\n\r\n" +
                "The purpose of this demo is helping software developers to integrate the measurement system into their software.\r\n" +
                "Focus has been put on demonstrating how to use the Nmx-DLL. User interface design an error handling are very basic. " +
                "Integration into your own software probably requires a more sophisticated user interface and extended error handling.\r\n\r\n" +
                "THIS DEMO COMES WITHOUT ANY WARRANTY OR LIABILITY.\r\n\r\n" +
                "We strongly recomment to separate the GUI-update and the DLL into different Windows-threads. " +
                "One way to do this is using Windows messages in combination with a timer, that runs in the GUI thread. " +
                "In this example this is demonstrated by the combination of WndProc and tmrStatic_Tick.\r\n" +
                "In this demo the NmxDLL.dll file must be placed in the same directory as the Exe.\r\n" +
                "If x64 is used, make sure that the define _M_X64 is set, see CNmx.cs.\r\n\r\n" +
                "By default the IP-Adress 192.168.3.99 is used for the system. Change it, if required.\r\n\r\n" +
                "Messtechnik Sachs GmbH\r\nwww.messtechnik-sachs.de\r\nPhone: +49 7181 26935 0";
            tBoxReadme.Text = str;

            /* Try to load the DLL */
            clNmx = new CNmx();
            try
            {
                /* Dll loaded successfully. Get version info. */
                UInt16 usMajor = 0;
                UInt16 usMinor = 0;
                UInt16 usPatch = 0;
                UInt16 usBuild = 0;
                clNmx.GetDllVersion_1(ref usMajor, ref usMinor, ref usPatch, ref usBuild);
                str = string.Format("NmxDll loaded successfully: V{0}.{1}.{2}.{3}", usMajor, usMinor, usPatch, usBuild);
                strHeader = string.Format("NmxDLL V{0}.{1}.{2}.{3}", usMajor, usMinor, usPatch, usBuild);
                AddHistoryEntry(str, false);
            }
            catch
            {
                /* Failed to load the Dll */
                AddHistoryEntry("Failed to load the NmxDll. In same directory as the exe?", true);
            }

            this.Text = "Nmx Demo for VCpp # " + strHeader;
        }


        /******************************************************************************
        * FUNCTION: AddHistoryEntry
        *-----------------------------------------------------------------------------
        * Add a new line with information for the user in the history-Listbox.
        *-----------------------------------------------------------------------------
        * PARAMETERS:
        * str: String to display in the new line
        * bError: false -> "only" information
        *         true -> an error occured
        *         So far this parameter is not used. It is intended future
        *         extension of this function. However, when calling this function,
        *         this parameter should be used as intended.
        *-----------------------------------------------------------------------------
        * Return: none
        ******************************************************************************/
        private void AddHistoryEntry(string str, bool bError)
        {
            if (bError == false)
            {
                lbHistory.Items.Insert(0, str);
            }
            else
            {
                lbHistory.Items.Insert(0, "[Error] " + str);
            }
        }


        /******************************************************************************
        * FUNCTION: SamplingClearNotificationCtrs
        *-----------------------------------------------------------------------------
        * Clear all notification counters for sampling.
        *-----------------------------------------------------------------------------
        * PARAMETERS: none
        *-----------------------------------------------------------------------------
        * Return: none
        ******************************************************************************/
        private void SamplingClearNotificationCtrs()
        {
            ulCtrSamplingNotificationsNewData = 0;
            ulCtrSamplingNotificationsFinished = 0;
            ulCtrSamplingNotificationsAllReceived = 0;
            ulCtrSamplingNotificationsError = 0;
            ulCtrSamplingNotificationsBufferOverflow = 0;
            ulCtrSamplingNotificationTimeout = 0;
        }

        /******************************************************************************
        * FUNCTION: Form1_FormClosed
        *-----------------------------------------------------------------------------
        * Called after the form has been closed. Do some cleanup.
        ******************************************************************************/
        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            clNmx.DeviceClose_1(ref pHandleNmx);
        }

        /******************************************************************************
        * FUNCTION: btnConnect_Click
        *-----------------------------------------------------------------------------
        * Connect / Disconnect the NMX device.
        ******************************************************************************/
        private void btnConnect_Click(object sender, EventArgs e)
        {
            if (bConnected == false)
            {
                ulCtrReconnects = 0;

                NMX_STATUS tStatus = clNmx.DeviceIPv4Open_1(192, 168, 3, 99, 22517, 22516, ref pHandleNmx);
                if (tStatus == NMX_STATUS.SUCCESS)
                {
                    AddHistoryEntry("Device connected successfully", false);
                    bConnected = true;
                    lbConnectionStatus.Text = "Status: Connected";
                    lbConnectionStatus.ForeColor = Color.Green;
                    btnConnect.Text = "Disconnect";

                    btnChannelInfoUpdate_Click(sender, e);

                    /* Update lists of measurement channels / DIO for sampling */
                    cblSampling_MeasChannels.Items.Clear();
                    cblSampling_DigitalInputs.Items.Clear();
                    cblSampling_DigitalOutputs.Items.Clear();
                    cbSamplingDInTrgByte.Items.Clear();

                    UInt32 ulNChannels = 0;
                    UInt32 ulNInputs = 0;
                    UInt32 ulNOutputs = 0;
                    clNmx.GetChannelCount_1(pHandleNmx, ref ulNChannels, ref ulNInputs, ref ulNOutputs);

                    bool bChecked = true;   // Set first check box to enabled
                    for (UInt32 ulI = 0; ulI < ulNChannels; ulI++)
                    {
                        UInt32 ulBoxNo = 0xFF;
                        UInt32 ulChannelNo = 0xFF;
                        UInt32 ulDummy = 0;
                        Int32 slDummy = 0;
                        float flDummy = 0.0f;
                        string strDummy = "";
                        clNmx.GetChannelInfo_1(pHandleNmx,
                            ulI, ref ulDummy, ref ulDummy, ref ulBoxNo, ref ulDummy, ref ulChannelNo, ref slDummy, ref slDummy, ref slDummy, ref flDummy, ref strDummy, ref strDummy, ref strDummy);
                        cblSampling_MeasChannels.Items.Add(new System.Windows.Forms.CheckBox(), bChecked);
                        bChecked = false;
                        cblSampling_MeasChannels.Items[(int)ulI] = string.Format("P{0} - Box {1} . Ch {2}", ulI + 1, ulBoxNo, ulChannelNo);
                        cbSamplingPositionTriggerChannel.Items.Add(string.Format("P{0} - Box {1} . Ch {2}", ulI + 1, ulBoxNo, ulChannelNo));
                    }
                    if (cbSamplingPositionTriggerChannel.Items.Count > 0)
                    {
                        cbSamplingPositionTriggerChannel.SelectedIndex = 0;
                    }

                    for (UInt32 ulI = 0; ulI < ulNInputs; ulI++)
                    {
                        UInt32 ulBoxNo = 0xFF;
                        UInt32 ulByteNo = 0xFF;
                        clNmx.GetDigitalInputInfo_1(pHandleNmx, ulI, ref ulBoxNo, ref ulByteNo);
                        cblSampling_DigitalInputs.Items.Add(new System.Windows.Forms.CheckBox(), false);
                        cblSampling_DigitalInputs.Items[(int)ulI] = string.Format("In Byte {0} - Box {1} : {2}..{3}", ulI + 1, ulBoxNo, (ulByteNo - 1) * 8 + 1, (ulByteNo - 1) * 8 + 8);
                        cbSamplingDInTrgByte.Items.Add(string.Format("In Byte {0} - Box {1} : {2}..{3}", ulI + 1, ulBoxNo, (ulByteNo - 1) * 8 + 1, (ulByteNo - 1) * 8 + 8));
                        cbSamplingTftTriggerByte.Items.Add(string.Format("In Byte {0} - Box {1} : {2}..{3}", ulI + 1, ulBoxNo, (ulByteNo - 1) * 8 + 1, (ulByteNo - 1) * 8 + 8));
                    }
                    if (cbSamplingDInTrgByte.Items.Count > 0)
                    {
                        cbSamplingDInTrgByte.SelectedIndex = 0;
                    }
                    if (cbSamplingTftTriggerByte.Items.Count > 0)
                    {
                        cbSamplingTftTriggerByte.SelectedIndex = 0;
                    }

                    for (UInt32 ulI = 0; ulI < ulNOutputs; ulI++)
                    {
                        UInt32 ulBoxNo = 0xFF;
                        UInt32 ulByteNo = 0xFF;
                        clNmx.GetDigitalOutputInfo_1(pHandleNmx, ulI, ref ulBoxNo, ref ulByteNo);
                        cblSampling_DigitalOutputs.Items.Add(new System.Windows.Forms.CheckBox(), false);
                        cblSampling_DigitalOutputs.Items[(int)ulI] = string.Format("Out Byte {0} - Box {1} : {2}..{3}", ulI + 1, ulBoxNo, (ulByteNo - 1) * 8 + 1, (ulByteNo - 1) * 8 + 8);
                    }


                    nuChannelSetParameterNo.Value = 0;
                    if (ulNChannels > 0)
                    {
                        UInt32 ulTemp = ulNChannels - 1;
                        nuChannelSetParameterNo.Maximum = System.Convert.ToDecimal(ulTemp);
                        nuChannelSetConfigNo.Maximum = System.Convert.ToDecimal(ulTemp);
                    }


                    /* Register Windows messages to receive notifications from the NMX-DLL. 
                     * The messages will be received by the message handler WndProc (see below). */
                    tStatus = clNmx.RegisterMessage_1(pHandleNmx, (UInt32)NMX_NOTIFY.DISCONNECTED, (IntPtr)Handle, NMXWM.DISCONNECTED, 0, 0);
                    if (tStatus != NMX_STATUS.SUCCESS) { AddHistoryEntry("Registering message for disconnect failed.", true); }
                    tStatus = clNmx.RegisterMessage_1(pHandleNmx, (UInt32)NMX_NOTIFY.FAILURE_DATA_EXCHANGE, (IntPtr)Handle, NMXWM.FAILURE_DATA_EXCHANGE, 0, 0);
                    if (tStatus != NMX_STATUS.SUCCESS) { AddHistoryEntry("Registering message for data exchange failure failed.", true); }
                    tStatus = clNmx.RegisterMessage_1(pHandleNmx, (UInt32)NMX_NOTIFY.RECONNECTED, (IntPtr)Handle, NMXWM.RECONNECTED, 0, 0);
                    if (tStatus != NMX_STATUS.SUCCESS) { AddHistoryEntry("Registering message for reconnected failed.", true); }
                    tStatus = clNmx.RegisterMessage_1(pHandleNmx, (UInt32)NMX_NOTIFY.NEW_STATIC32, (IntPtr)Handle, NMXWM.NEW_STATIC32, 0, 0);
                    if (tStatus != NMX_STATUS.SUCCESS) { AddHistoryEntry("Registering message for new static data failed.", true); }
                    tStatus = clNmx.RegisterMessage_1(pHandleNmx, (UInt32)NMX_NOTIFY.SAMPLING_NEW_DATA, (IntPtr)Handle, NMXWM.SAMPLING_NEW_DATA, 0, 0);
                    if (tStatus != NMX_STATUS.SUCCESS) { AddHistoryEntry("Registering message for new sampling data failed.", true); }
                    tStatus = clNmx.RegisterMessage_1(pHandleNmx, (UInt32)NMX_NOTIFY.SAMPLING_ALL_DATA_RECEIVED, (IntPtr)Handle, NMXWM.SAMPLING_ALL_DATA_RECEIVED, 0, 0);
                    if (tStatus != NMX_STATUS.SUCCESS) { AddHistoryEntry("Registering message for 'all sampling data received' failed.", true); }
                    tStatus = clNmx.RegisterMessage_1(pHandleNmx, (UInt32)NMX_NOTIFY.SAMPLING_FINISHED, (IntPtr)Handle, NMXWM.SAMPLING_FINISHED, 0, 0);
                    if (tStatus != NMX_STATUS.SUCCESS) { AddHistoryEntry("Registering message for 'sampling finished' failed.", true); }
                    tStatus = clNmx.RegisterMessage_1(pHandleNmx, (UInt32)NMX_NOTIFY.SAMPLING_ERROR, (IntPtr)Handle, NMXWM.SAMPLING_ERROR, 0, 0);
                    if (tStatus != NMX_STATUS.SUCCESS) { AddHistoryEntry("Registering message for 'sampling error' failed.", true); }
                    tStatus = clNmx.RegisterMessage_1(pHandleNmx, (UInt32)NMX_NOTIFY.SAMPLING_BUFFER_OVERFLOW, (IntPtr)Handle, NMXWM.SAMPLING_BUFFER_OVERFLOW, 0, 0);
                    if (tStatus != NMX_STATUS.SUCCESS) { AddHistoryEntry("Registering message for 'sampling buffer overflow' failed.", true); }
                    tStatus = clNmx.RegisterMessage_1(pHandleNmx, (UInt32)NMX_NOTIFY.SAMPLING_TIMEOUT, (IntPtr)Handle, NMXWM.SAMPLING_TIMEOUT, 0, 0);
                    if (tStatus != NMX_STATUS.SUCCESS) { AddHistoryEntry("Registering message for 'sampling timeout' failed.", true); }

                    /* Get min sample period and determine different speed levels for the demo.
                    * In your measurement application you do not need to have different speed levels.
                    * This is just for the demo! */
                    SamplingUpdateSpeedLevels();

                }
                else
                {
                    AddHistoryEntry("Failed connecting the device", true);
                }
            }
            else
            {
                NMX_STATUS tStatus = clNmx.DeviceClose_1(ref pHandleNmx);
                if (tStatus == NMX_STATUS.SUCCESS)
                {
                    AddHistoryEntry("Device disconnected successfully", false);
                }
                else
                {
                    AddHistoryEntry("Failed disconnecting the device", true);
                }
                bConnected = false;
                btnConnect.Text = "Connect";
            }
        }

        /******************************************************************************
        * FUNCTION: btnBoxInfoUpdate_Click
        *-----------------------------------------------------------------------------
        * Update box information.
        ******************************************************************************/
        private void btnBoxInfoUpdate_Click(object sender, EventArgs e)
        {
            UInt32 ulBoxCount = 0;
            UInt32 ulBoxNo = 0;
            UInt32[] aulInfoData = new UInt32[20];
            UInt64 udMacAddress = 0;
            string strSerNo = "NA";
            string strProdCode = "NA";
            string strOrderNo = "NA";
            string strName = "NA";

            if (clNmx.GetBoxCount_1(pHandleNmx, ref ulBoxCount) != NMX_STATUS.SUCCESS)
            {
                AddHistoryEntry("Reading box count failed.", true);
                return;
            }

            dataGridViewBoxInfo.Rows.Clear();
            for (ulBoxNo = 0; ulBoxNo < ulBoxCount; ulBoxNo++)
            {
                if (clNmx.GetBoxInfo_1(pHandleNmx, ulBoxNo, ref aulInfoData, ref udMacAddress, ref strSerNo, ref strProdCode, ref strOrderNo, ref strName) != NMX_STATUS.SUCCESS)
                {
                    AddHistoryEntry("Reading box info failed.", true);
                }
                else
                {
                    dataGridViewBoxInfo.Rows.Add();
                    dataGridViewBoxInfo[0, dataGridViewBoxInfo.Rows.Count - 1].Value = String.Format("{0}", aulInfoData[0]);        /* Box-No */
                    dataGridViewBoxInfo[1, dataGridViewBoxInfo.Rows.Count - 1].Value = strName;                                     /* Name */
                    dataGridViewBoxInfo[2, dataGridViewBoxInfo.Rows.Count - 1].Value = strSerNo;                                    /* Serial number */
                    dataGridViewBoxInfo[3, dataGridViewBoxInfo.Rows.Count - 1].Value = String.Format("{0:X2}-{1:X2}-{2:X2}-{3:X2}-{4:X2}-{5:X2}",   /* MAC-Address */
                        (udMacAddress >> 40) & 0xFF,
                        (udMacAddress >> 32) & 0xFF,
                        (udMacAddress >> 24) & 0xFF,
                        (udMacAddress >> 16) & 0xFF,
                        (udMacAddress << 8) & 0xFF,
                        udMacAddress & 0xFF);
                    dataGridViewBoxInfo[4, dataGridViewBoxInfo.Rows.Count - 1].Value = String.Format("V{0}.{1}.{2}.{3}",            /* Firmware-Version */
                        aulInfoData[4],
                        aulInfoData[5],
                        aulInfoData[6],
                        aulInfoData[7]);
                    dataGridViewBoxInfo[5, dataGridViewBoxInfo.Rows.Count - 1].Value = String.Format("V{0}.{1} Rev {2}",            /* Hardware-Version / -Revision */
                        aulInfoData[1],
                        aulInfoData[2],
                        aulInfoData[3]);
                    dataGridViewBoxInfo[6, dataGridViewBoxInfo.Rows.Count - 1].Value = String.Format("{0}", aulInfoData[8]);        /* Number of measurement channels */
                    dataGridViewBoxInfo[7, dataGridViewBoxInfo.Rows.Count - 1].Value = String.Format("{0}", aulInfoData[13]);       /* Number of digital inputs */
                    dataGridViewBoxInfo[8, dataGridViewBoxInfo.Rows.Count - 1].Value = String.Format("{0}", aulInfoData[14]);       /* Number of digital outputs */
                    dataGridViewBoxInfo[9, dataGridViewBoxInfo.Rows.Count - 1].Value = strProdCode;                                 /* Production code */
                }
            }

            ulBoxInfoUpdates++;
            lbBoxInfoUpdates.Text = String.Format("{0} update", ulBoxInfoUpdates);
            if (ulBoxInfoUpdates > 1)
            {
                lbBoxInfoUpdates.Text += "s";
            }
        }

        /******************************************************************************
        * FUNCTION: btnChannelInfoUpdate_Click
        *-----------------------------------------------------------------------------
        * Update channel information.
        ******************************************************************************/
        private void btnChannelInfoUpdate_Click(object sender, EventArgs e)
        {
            UInt32 ulChannelCount = 0;
            UInt32 ulChannel = 0;

            UInt32 ulChannelType = 0;
            UInt32 ulNDigits = 1;
            UInt32 ulBoxNo = 0;
            UInt32 ulBoxChannelNo = 0;
            Int32  slRawDataType = 0;
            Int32  slFactNumerator = 1;
            Int32  slFactDenominator = 1;
            float  flFactDigitsToUnit = 1.0f;
            string strUnit = "";
            string strOrderNo = "";
            string strSerialNo = "";
            UInt32 ulDummy = 0;

            if (clNmx.UpdateChannelInfo_1(pHandleNmx) != NMX_STATUS.SUCCESS)
            {
                AddHistoryEntry("Updating channel information failed.", true);
                return;
            }

            if (clNmx.GetChannelCount_1(pHandleNmx, ref ulChannelCount, ref ulDummy, ref ulDummy) != NMX_STATUS.SUCCESS)
            {
                AddHistoryEntry("Reading channel count failed.", true);
            }

            dataGridViewChInfo.Rows.Clear();
            for (ulChannel = 0; ulChannel < ulChannelCount; ulChannel++)
            {
                if (clNmx.GetChannelInfo_1(pHandleNmx, ulChannel,
                    ref ulChannelType, ref ulNDigits, ref ulBoxNo, ref ulDummy, ref ulBoxChannelNo, ref slRawDataType,
                    ref slFactNumerator, ref slFactDenominator, ref flFactDigitsToUnit, ref strUnit,
                    ref strOrderNo, ref strSerialNo) != NMX_STATUS.SUCCESS)
                {
                    AddHistoryEntry("Reading channel info failed.", true);
                }
                else
                {
                    dataGridViewChInfo.Rows.Add();
                    dataGridViewChInfo[0, dataGridViewChInfo.Rows.Count - 1].Value = string.Format("{0}", ulChannel);           /* Channel-No */
                    dataGridViewChInfo[1, dataGridViewChInfo.Rows.Count - 1].Value = string.Format("Box {0} # Ch. {1}", ulBoxNo, ulBoxChannelNo);       /* Location */
                    dataGridViewChInfo[2, dataGridViewChInfo.Rows.Count - 1].Value = string.Format("0x{0:X4}", ulChannelType);  /* Channel-type */
                    dataGridViewChInfo[3, dataGridViewChInfo.Rows.Count - 1].Value = strUnit;    /* Unit */
                    dataGridViewChInfo[4, dataGridViewChInfo.Rows.Count - 1].Value = string.Format("{0} {1}/digit\n{2}/{3}", flFactDigitsToUnit, strUnit, slFactNumerator, slFactDenominator); /* Factor to Unit */
                    if (ulChannel < N_STATIC_CH_DISPLAY)
                    {
                        aclChannelData[ulChannel].fdFactor = flFactDigitsToUnit;
                        aclChannelData[ulChannel].ulNDigits = ulNDigits;
                        aclChannelData[ulChannel].strUnit = strUnit;
                    }
                    dataGridViewChInfo[5, dataGridViewChInfo.Rows.Count - 1].Value = string.Format("{0}", ulNDigits);   /* Decimal Digits */
                    dataGridViewChInfo[6, dataGridViewChInfo.Rows.Count - 1].Value = strOrderNo;    /* Ordern-No */
                    dataGridViewChInfo[7, dataGridViewChInfo.Rows.Count - 1].Value = strSerialNo;    /* Serial-No */
                }
            }

            ulChannelInfoUpdates++;
            lbChInfoUpdates.Text = string.Format("{0} update", ulChannelInfoUpdates);
            if (ulChannelInfoUpdates > 1)
            {
                lbChInfoUpdates.Text += "s";
            }
        }

        /******************************************************************************
        * FUNCTION: WndProc
        *-----------------------------------------------------------------------------
        * This function is called when the form receives a new windows message.
        * All messages from the MscDll are filtered out and processed. All other
        * messages are forwarded to the respective form message function
        * (Form::WndProc).
        ******************************************************************************/
        protected override void WndProc(ref Message m)
        {
            // Listen for operating system messages.
            switch (m.Msg)
            {
                case NMXWM.DISCONNECTED:
                    bConnected = false;
                    btnConnect.Text = "Connect";
                    lbConnectionStatus.Text = "Status: Disconnected";
                    lbConnectionStatus.ForeColor = Color.Black;
                    break;

                case NMXWM.FAILURE_DATA_EXCHANGE:
                    lbConnectionStatus.Text = "Status: Timeout";
                    lbConnectionStatus.ForeColor = Color.Red;
                    break;

                case NMXWM.RECONNECTED:
                    bConnected = true;
                    ulCtrReconnects++;
                    btnConnect.Text = "Disconnect";
                    lbConnectionStatus.Text = string.Format("Status: Reconnected ({0})", ulCtrReconnects);
                    lbConnectionStatus.ForeColor = Color.Purple;
                    bNewReconnected = true;
                    break;

                case NMXWM.NEW_STATIC32:
                    bNewStatic = true;
                    break;

                case NMXWM.SAMPLING_NEW_DATA:
                    bNewSamplingData = true;
                    ulCtrSamplingNotificationsNewData++;
                    break;

                case NMXWM.SAMPLING_ALL_DATA_RECEIVED:
                    ulCtrSamplingNotificationsAllReceived++;
                    break;

                case NMXWM.SAMPLING_FINISHED:
                    ulCtrSamplingNotificationsFinished++;
                    break;

                case NMXWM.SAMPLING_ERROR:
                    ulCtrSamplingNotificationsError++;
                    break;

                case NMXWM.SAMPLING_BUFFER_OVERFLOW:
                    ulCtrSamplingNotificationsBufferOverflow++;
                    break;

                case NMXWM.SAMPLING_TIMEOUT:
                    ulCtrSamplingNotificationTimeout++;
                    break;

                default:
                    {
                        /* Pass all standard messages to the GUI form. */
                        base.WndProc(ref m);
                    }
                    break;
            }
        }

        /******************************************************************************
        * FUNCTION: rbStaticCH1_8_CheckedChanged
        *-----------------------------------------------------------------------------
        * Static measurement: The channel selection has been changed (e.g. from 1..8
        * to 9..16). Update GUI.
        ******************************************************************************/
        private void rbStaticCH1_8_CheckedChanged(object sender, EventArgs e)
        {
            if (sender == rbStaticCH9_16)
            {
                ulStatic1stCh = 9;
            }
            else if (sender == rbStaticCH17_24)
            {
                ulStatic1stCh = 17;
            }
            else if (sender == rbStaticCH25_32)
            {
                ulStatic1stCh = 25;
            }
            else if (sender == rbStaticCH33_40)
            {
                ulStatic1stCh = 33;
            }
            else if (sender == rbStaticCH41_48)
            {
                ulStatic1stCh = 41;
            }
            else if (sender == rbStaticCH49_56)
            {
                ulStatic1stCh = 49;
            }
            else if (sender == rbStaticCH57_64)
            {
                ulStatic1stCh = 57;
            }
            else
            {
                ulStatic1stCh = 1;
            }
            lbStaticCh1.Text = (ulStatic1stCh + 0).ToString();
            lbStaticCh2.Text = (ulStatic1stCh + 1).ToString();
            lbStaticCh3.Text = (ulStatic1stCh + 2).ToString();
            lbStaticCh4.Text = (ulStatic1stCh + 3).ToString();
            lbStaticCh5.Text = (ulStatic1stCh + 4).ToString();
            lbStaticCh6.Text = (ulStatic1stCh + 5).ToString();
            lbStaticCh7.Text = (ulStatic1stCh + 6).ToString();
            lbStaticCh8.Text = (ulStatic1stCh + 7).ToString();
            lbStaticDigits1.Text = "*";
            lbStaticDigits2.Text = "*";
            lbStaticDigits3.Text = "*";
            lbStaticDigits4.Text = "*";
            lbStaticDigits5.Text = "*";
            lbStaticDigits6.Text = "*";
            lbStaticDigits7.Text = "*";
            lbStaticDigits8.Text = "*";
            lbStaticUnit1.Text = "*";
            lbStaticUnit2.Text = "*";
            lbStaticUnit3.Text = "*";
            lbStaticUnit4.Text = "*";
            lbStaticUnit5.Text = "*";
            lbStaticUnit6.Text = "*";
            lbStaticUnit7.Text = "*";
            lbStaticUnit8.Text = "*";
            lbStaticHwStat1.Text = "*";
            lbStaticHwStat2.Text = "*";
            lbStaticHwStat3.Text = "*";
            lbStaticHwStat4.Text = "*";
            lbStaticHwStat5.Text = "*";
            lbStaticHwStat6.Text = "*";
            lbStaticHwStat7.Text = "*";
            lbStaticHwStat8.Text = "*";
            lbStaticMin1.Text = "*";
            lbStaticMin2.Text = "*";
            lbStaticMin3.Text = "*";
            lbStaticMin4.Text = "*";
            lbStaticMin5.Text = "*";
            lbStaticMin6.Text = "*";
            lbStaticMin7.Text = "*";
            lbStaticMin8.Text = "*";
            lbStaticMax1.Text = "*";
            lbStaticMax2.Text = "*";
            lbStaticMax3.Text = "*";
            lbStaticMax4.Text = "*";
            lbStaticMax5.Text = "*";
            lbStaticMax6.Text = "*";
            lbStaticMax7.Text = "*";
            lbStaticMax8.Text = "*";
            lbStaticDiff1.Text = "*";
            lbStaticDiff2.Text = "*";
            lbStaticDiff3.Text = "*";
            lbStaticDiff4.Text = "*";
            lbStaticDiff5.Text = "*";
            lbStaticDiff6.Text = "*";
            lbStaticDiff7.Text = "*";
            lbStaticDiff8.Text = "*";
        }

        /******************************************************************************
        * FUNCTION: tmrStatic_Tick
        *-----------------------------------------------------------------------------
        * Timer for update of static data.
        ******************************************************************************/
        private void tmrStatic_Tick(object sender, EventArgs e)
        {
            System.Windows.Forms.Label[] albDIn = new System.Windows.Forms.Label[] {
                lbDIn_1, lbDIn_2, lbDIn_3, lbDIn_4, lbDIn_5, lbDIn_6, lbDIn_7, lbDIn_8,
		        lbDIn_9, lbDIn_10, lbDIn_11, lbDIn_12, lbDIn_13, lbDIn_14, lbDIn_15, lbDIn_16,
		        lbDIn_17, lbDIn_18, lbDIn_19, lbDIn_20, lbDIn_21, lbDIn_22, lbDIn_23, lbDIn_24,
		        lbDIn_25, lbDIn_26, lbDIn_27, lbDIn_28, lbDIn_29, lbDIn_30, lbDIn_31, lbDIn_32,
		        lbDIn_33, lbDIn_34, lbDIn_35, lbDIn_36, lbDIn_37, lbDIn_38, lbDIn_39, lbDIn_40,
		        lbDIn_41, lbDIn_42, lbDIn_43, lbDIn_44, lbDIn_45, lbDIn_46, lbDIn_47, lbDIn_48,
		        lbDIn_49, lbDIn_50, lbDIn_51, lbDIn_52, lbDIn_53, lbDIn_54, lbDIn_55, lbDIn_56,
		        lbDIn_57, lbDIn_58, lbDIn_59, lbDIn_60, lbDIn_61, lbDIn_62, lbDIn_63, lbDIn_64,
		        lbDIn_65, lbDIn_66, lbDIn_67, lbDIn_68, lbDIn_69, lbDIn_70, lbDIn_71, lbDIn_72,
		        lbDIn_73, lbDIn_74, lbDIn_75, lbDIn_76, lbDIn_77, lbDIn_78, lbDIn_79, lbDIn_80,
		        lbDIn_81, lbDIn_82, lbDIn_83, lbDIn_84, lbDIn_85, lbDIn_86, lbDIn_87, lbDIn_88,
		        lbDIn_89, lbDIn_90, lbDIn_91, lbDIn_92, lbDIn_93, lbDIn_94, lbDIn_95, lbDIn_96,
		        lbDIn_97, lbDIn_98, lbDIn_99, lbDIn_100, lbDIn_101, lbDIn_102, lbDIn_103, lbDIn_104,
		        lbDIn_105, lbDIn_106, lbDIn_107, lbDIn_108, lbDIn_109, lbDIn_110, lbDIn_111, lbDIn_112,
		        lbDIn_113, lbDIn_114, lbDIn_115, lbDIn_116, lbDIn_117, lbDIn_118, lbDIn_119, lbDIn_120,
		        lbDIn_121, lbDIn_122, lbDIn_123, lbDIn_124, lbDIn_125, lbDIn_126, lbDIn_127, lbDIn_128
            };

            /* Disable this timer */
            tmrStatic.Enabled = false;

            cbStaticFastUpdate.Enabled = bConnected;
            btnDigiEnableOutputWrite.Enabled = bConnected;

            if (bNewStatic != false)
            {
                bNewStatic = false;
                Int32[] aslMeasVal = new Int32[N_STATIC_CH_DISPLAY];
                byte[] aucHardStat = new byte[N_STATIC_CH_DISPLAY];
                byte[] aucDigiIn = new byte[N_DIGIIO_DISPLAY / 8];
                byte[] aucDummy = new byte[1];
                UInt32 ulNUpdates = 0;
                Array.Clear(aslMeasVal, 0, aslMeasVal.Length);
                Array.Clear(aucHardStat, 0, aucHardStat.Length);
                Array.Clear(aucDigiIn, 0, aucDigiIn.Length);
                if (clNmx.StaticGet32_1(pHandleNmx, ref aslMeasVal, ref aucHardStat, ref aucDigiIn, ref aucDummy, ref ulNUpdates) == NMX_STATUS.SUCCESS)
                {
                    if ((ulStatic1stCh > 0) && (ulStatic1stCh <= (N_STATIC_CH_DISPLAY - 7)))
                    {
                        UInt32 ul1stCh = ulStatic1stCh - 1;

                        for (UInt32 ulI = 0; ulI < 8; ulI++)
                        {
                            aclChannelData[ul1stCh + ulI].NewStaticValue(aslMeasVal[ul1stCh + ulI]);
                        }

                        lbStaticDigits1.Text = aclChannelData[ul1stCh + 0].GetNewestValue().ToString();
                        lbStaticDigits2.Text = aclChannelData[ul1stCh + 1].GetNewestValue().ToString();
                        lbStaticDigits3.Text = aclChannelData[ul1stCh + 2].GetNewestValue().ToString();
                        lbStaticDigits4.Text = aclChannelData[ul1stCh + 3].GetNewestValue().ToString();
                        lbStaticDigits5.Text = aclChannelData[ul1stCh + 4].GetNewestValue().ToString();
                        lbStaticDigits6.Text = aclChannelData[ul1stCh + 5].GetNewestValue().ToString();
                        lbStaticDigits7.Text = aclChannelData[ul1stCh + 6].GetNewestValue().ToString();
                        lbStaticDigits8.Text = aclChannelData[ul1stCh + 7].GetNewestValue().ToString();

                        lbStaticHwStat1.Text = string.Format("0x{0:X2}", aucHardStat[ul1stCh + 0]);
                        lbStaticHwStat2.Text = string.Format("0x{0:X2}", aucHardStat[ul1stCh + 1]);
                        lbStaticHwStat3.Text = string.Format("0x{0:X2}", aucHardStat[ul1stCh + 2]);
                        lbStaticHwStat4.Text = string.Format("0x{0:X2}", aucHardStat[ul1stCh + 3]);
                        lbStaticHwStat5.Text = string.Format("0x{0:X2}", aucHardStat[ul1stCh + 4]);
                        lbStaticHwStat6.Text = string.Format("0x{0:X2}", aucHardStat[ul1stCh + 5]);
                        lbStaticHwStat7.Text = string.Format("0x{0:X2}", aucHardStat[ul1stCh + 6]);
                        lbStaticHwStat8.Text = string.Format("0x{0:X2}", aucHardStat[ul1stCh + 7]);

                        lbStaticUnit1.Text = aclChannelData[ul1stCh + 0].GetStaticUnitValue();
                        lbStaticUnit2.Text = aclChannelData[ul1stCh + 1].GetStaticUnitValue();
                        lbStaticUnit3.Text = aclChannelData[ul1stCh + 2].GetStaticUnitValue();
                        lbStaticUnit4.Text = aclChannelData[ul1stCh + 3].GetStaticUnitValue();
                        lbStaticUnit5.Text = aclChannelData[ul1stCh + 4].GetStaticUnitValue();
                        lbStaticUnit6.Text = aclChannelData[ul1stCh + 5].GetStaticUnitValue();
                        lbStaticUnit7.Text = aclChannelData[ul1stCh + 6].GetStaticUnitValue();
                        lbStaticUnit8.Text = aclChannelData[ul1stCh + 7].GetStaticUnitValue();

                        lbStaticMin1.Text = aclChannelData[ul1stCh + 0].GetStaticUnitMin();
                        lbStaticMin2.Text = aclChannelData[ul1stCh + 1].GetStaticUnitMin();
                        lbStaticMin3.Text = aclChannelData[ul1stCh + 2].GetStaticUnitMin();
                        lbStaticMin4.Text = aclChannelData[ul1stCh + 3].GetStaticUnitMin();
                        lbStaticMin5.Text = aclChannelData[ul1stCh + 4].GetStaticUnitMin();
                        lbStaticMin6.Text = aclChannelData[ul1stCh + 5].GetStaticUnitMin();
                        lbStaticMin7.Text = aclChannelData[ul1stCh + 6].GetStaticUnitMin();
                        lbStaticMin8.Text = aclChannelData[ul1stCh + 7].GetStaticUnitMin();

                        lbStaticMax1.Text = aclChannelData[ul1stCh + 0].GetStaticUnitMax();
                        lbStaticMax2.Text = aclChannelData[ul1stCh + 1].GetStaticUnitMax();
                        lbStaticMax3.Text = aclChannelData[ul1stCh + 2].GetStaticUnitMax();
                        lbStaticMax4.Text = aclChannelData[ul1stCh + 3].GetStaticUnitMax();
                        lbStaticMax5.Text = aclChannelData[ul1stCh + 4].GetStaticUnitMax();
                        lbStaticMax6.Text = aclChannelData[ul1stCh + 5].GetStaticUnitMax();
                        lbStaticMax7.Text = aclChannelData[ul1stCh + 6].GetStaticUnitMax();
                        lbStaticMax8.Text = aclChannelData[ul1stCh + 7].GetStaticUnitMax();

                        lbStaticDiff1.Text = aclChannelData[ul1stCh + 0].GetStaticUnitDiff();
                        lbStaticDiff2.Text = aclChannelData[ul1stCh + 1].GetStaticUnitDiff();
                        lbStaticDiff3.Text = aclChannelData[ul1stCh + 2].GetStaticUnitDiff();
                        lbStaticDiff4.Text = aclChannelData[ul1stCh + 3].GetStaticUnitDiff();
                        lbStaticDiff5.Text = aclChannelData[ul1stCh + 4].GetStaticUnitDiff();
                        lbStaticDiff6.Text = aclChannelData[ul1stCh + 5].GetStaticUnitDiff();
                        lbStaticDiff7.Text = aclChannelData[ul1stCh + 6].GetStaticUnitDiff();
                        lbStaticDiff8.Text = aclChannelData[ul1stCh + 7].GetStaticUnitDiff();
                    }

                    lbStaticUpdates.Text = string.Format("{0} Updates", ulNUpdates);
                    lbDInUpdates.Text = lbStaticUpdates.Text;

                    for (UInt32 ulI = 0; ulI < N_DIGIIO_DISPLAY; ulI++)
                    {
                        int iTemp = (int)(ulI % 8);
                        iTemp = 2 ^ iTemp;
                        int iDigiIn = aucDigiIn[ulI / 8];
                        if ((iDigiIn & iTemp) != 0)
                        {
                            albDIn[ulI].ForeColor = Color.Blue;
                            albDIn[ulI].Font = new System.Drawing.Font(albDIn[ulI].Font, FontStyle.Bold);
                        }
                        else
                        {
                            albDIn[ulI].ForeColor = Color.Gray;
                            albDIn[ulI].Font = new System.Drawing.Font(albDIn[ulI].Font, FontStyle.Regular);
                        }
                    }
                }
            }

            /* Update system time in case of a reconnect */
            if (bNewReconnected != false)
            {
                bNewReconnected = false;
                clNmx.SetDateTime_1(pHandleNmx);
            }

            /* Re-enable this timer */
            tmrStatic.Enabled = true;
        }

        /******************************************************************************
        * FUNCTION: btnStaticResetMinMax_Click
        *-----------------------------------------------------------------------------
        * Reset all Min/Max - values of static measurement data.
        ******************************************************************************/
        private void btnStaticResetMinMax_Click(object sender, EventArgs e)
        {
            for (UInt32 ulI = 0; ulI < N_STATIC_CH_DISPLAY; ulI++)
            {
                aclChannelData[ulI].ResetStaticMinMax();
            }
        }

        /******************************************************************************
        * FUNCTION: cbDOut_1_CheckedChanged
        *-----------------------------------------------------------------------------
        * Transfer digital output data from GUI to device.
        ******************************************************************************/
        private void cbDOut_1_CheckedChanged(object sender, EventArgs e)
        {
            byte[] aucDigiOut = new byte[N_DIGIIO_DISPLAY / 8];
            if (bWriteDigitalOutputData != false)
            {
                Array.Clear(aucDigiOut, 0, aucDigiOut.Length);

                if (cbDOut_1.Checked != false) aucDigiOut[0] |= (1 << 0);
                if (cbDOut_2.Checked != false) aucDigiOut[0] |= (1 << 1);
                if (cbDOut_3.Checked != false) aucDigiOut[0] |= (1 << 2);
                if (cbDOut_4.Checked != false) aucDigiOut[0] |= (1 << 3);
                if (cbDOut_5.Checked != false) aucDigiOut[0] |= (1 << 4);
                if (cbDOut_6.Checked != false) aucDigiOut[0] |= (1 << 5);
                if (cbDOut_7.Checked != false) aucDigiOut[0] |= (1 << 6);
                if (cbDOut_8.Checked != false) aucDigiOut[0] |= (1 << 7);

                if (cbDOut_9.Checked != false) aucDigiOut[1] |= (1 << 0);
                if (cbDOut_10.Checked != false) aucDigiOut[1] |= (1 << 1);
                if (cbDOut_11.Checked != false) aucDigiOut[1] |= (1 << 2);
                if (cbDOut_12.Checked != false) aucDigiOut[1] |= (1 << 3);
                if (cbDOut_13.Checked != false) aucDigiOut[1] |= (1 << 4);
                if (cbDOut_14.Checked != false) aucDigiOut[1] |= (1 << 5);
                if (cbDOut_15.Checked != false) aucDigiOut[1] |= (1 << 6);
                if (cbDOut_16.Checked != false) aucDigiOut[1] |= (1 << 7);

                if (cbDOut_17.Checked != false) aucDigiOut[2] |= (1 << 0);
                if (cbDOut_18.Checked != false) aucDigiOut[2] |= (1 << 1);
                if (cbDOut_19.Checked != false) aucDigiOut[2] |= (1 << 2);
                if (cbDOut_20.Checked != false) aucDigiOut[2] |= (1 << 3);
                if (cbDOut_21.Checked != false) aucDigiOut[2] |= (1 << 4);
                if (cbDOut_22.Checked != false) aucDigiOut[2] |= (1 << 5);
                if (cbDOut_23.Checked != false) aucDigiOut[2] |= (1 << 6);
                if (cbDOut_24.Checked != false) aucDigiOut[2] |= (1 << 7);

                if (cbDOut_25.Checked != false) aucDigiOut[3] |= (1 << 0);
                if (cbDOut_26.Checked != false) aucDigiOut[3] |= (1 << 1);
                if (cbDOut_27.Checked != false) aucDigiOut[3] |= (1 << 2);
                if (cbDOut_28.Checked != false) aucDigiOut[3] |= (1 << 3);
                if (cbDOut_29.Checked != false) aucDigiOut[3] |= (1 << 4);
                if (cbDOut_30.Checked != false) aucDigiOut[3] |= (1 << 5);
                if (cbDOut_31.Checked != false) aucDigiOut[3] |= (1 << 6);
                if (cbDOut_32.Checked != false) aucDigiOut[3] |= (1 << 7);

                if (cbDOut_33.Checked != false) aucDigiOut[4] |= (1 << 0);
                if (cbDOut_34.Checked != false) aucDigiOut[4] |= (1 << 1);
                if (cbDOut_35.Checked != false) aucDigiOut[4] |= (1 << 2);
                if (cbDOut_36.Checked != false) aucDigiOut[4] |= (1 << 3);
                if (cbDOut_37.Checked != false) aucDigiOut[4] |= (1 << 4);
                if (cbDOut_38.Checked != false) aucDigiOut[4] |= (1 << 5);
                if (cbDOut_39.Checked != false) aucDigiOut[4] |= (1 << 6);
                if (cbDOut_40.Checked != false) aucDigiOut[4] |= (1 << 7);

                if (cbDOut_41.Checked != false) aucDigiOut[5] |= (1 << 0);
                if (cbDOut_42.Checked != false) aucDigiOut[5] |= (1 << 1);
                if (cbDOut_43.Checked != false) aucDigiOut[5] |= (1 << 2);
                if (cbDOut_44.Checked != false) aucDigiOut[5] |= (1 << 3);
                if (cbDOut_45.Checked != false) aucDigiOut[5] |= (1 << 4);
                if (cbDOut_46.Checked != false) aucDigiOut[5] |= (1 << 5);
                if (cbDOut_47.Checked != false) aucDigiOut[5] |= (1 << 6);
                if (cbDOut_48.Checked != false) aucDigiOut[5] |= (1 << 7);

                if (cbDOut_49.Checked != false) aucDigiOut[6] |= (1 << 0);
                if (cbDOut_50.Checked != false) aucDigiOut[6] |= (1 << 1);
                if (cbDOut_51.Checked != false) aucDigiOut[6] |= (1 << 2);
                if (cbDOut_52.Checked != false) aucDigiOut[6] |= (1 << 3);
                if (cbDOut_53.Checked != false) aucDigiOut[6] |= (1 << 4);
                if (cbDOut_54.Checked != false) aucDigiOut[6] |= (1 << 5);
                if (cbDOut_55.Checked != false) aucDigiOut[6] |= (1 << 6);
                if (cbDOut_56.Checked != false) aucDigiOut[6] |= (1 << 7);

                if (cbDOut_57.Checked != false) aucDigiOut[7] |= (1 << 0);
                if (cbDOut_58.Checked != false) aucDigiOut[7] |= (1 << 1);
                if (cbDOut_59.Checked != false) aucDigiOut[7] |= (1 << 2);
                if (cbDOut_60.Checked != false) aucDigiOut[7] |= (1 << 3);
                if (cbDOut_61.Checked != false) aucDigiOut[7] |= (1 << 4);
                if (cbDOut_62.Checked != false) aucDigiOut[7] |= (1 << 5);
                if (cbDOut_63.Checked != false) aucDigiOut[7] |= (1 << 6);
                if (cbDOut_64.Checked != false) aucDigiOut[7] |= (1 << 7);

                if (cbDOut_65.Checked != false) aucDigiOut[8] |= (1 << 0);
                if (cbDOut_66.Checked != false) aucDigiOut[8] |= (1 << 1);
                if (cbDOut_67.Checked != false) aucDigiOut[8] |= (1 << 2);
                if (cbDOut_68.Checked != false) aucDigiOut[8] |= (1 << 3);
                if (cbDOut_69.Checked != false) aucDigiOut[8] |= (1 << 4);
                if (cbDOut_70.Checked != false) aucDigiOut[8] |= (1 << 5);
                if (cbDOut_71.Checked != false) aucDigiOut[8] |= (1 << 6);
                if (cbDOut_72.Checked != false) aucDigiOut[8] |= (1 << 7);

                if (cbDOut_73.Checked != false) aucDigiOut[9] |= (1 << 0);
                if (cbDOut_74.Checked != false) aucDigiOut[9] |= (1 << 1);
                if (cbDOut_75.Checked != false) aucDigiOut[9] |= (1 << 2);
                if (cbDOut_76.Checked != false) aucDigiOut[9] |= (1 << 3);
                if (cbDOut_77.Checked != false) aucDigiOut[9] |= (1 << 4);
                if (cbDOut_78.Checked != false) aucDigiOut[9] |= (1 << 5);
                if (cbDOut_79.Checked != false) aucDigiOut[9] |= (1 << 6);
                if (cbDOut_80.Checked != false) aucDigiOut[9] |= (1 << 7);

                if (cbDOut_81.Checked != false) aucDigiOut[10] |= (1 << 0);
                if (cbDOut_82.Checked != false) aucDigiOut[10] |= (1 << 1);
                if (cbDOut_83.Checked != false) aucDigiOut[10] |= (1 << 2);
                if (cbDOut_84.Checked != false) aucDigiOut[10] |= (1 << 3);
                if (cbDOut_85.Checked != false) aucDigiOut[10] |= (1 << 4);
                if (cbDOut_86.Checked != false) aucDigiOut[10] |= (1 << 5);
                if (cbDOut_87.Checked != false) aucDigiOut[10] |= (1 << 6);
                if (cbDOut_88.Checked != false) aucDigiOut[10] |= (1 << 7);

                if (cbDOut_89.Checked != false) aucDigiOut[11] |= (1 << 0);
                if (cbDOut_90.Checked != false) aucDigiOut[11] |= (1 << 1);
                if (cbDOut_91.Checked != false) aucDigiOut[11] |= (1 << 2);
                if (cbDOut_92.Checked != false) aucDigiOut[11] |= (1 << 3);
                if (cbDOut_93.Checked != false) aucDigiOut[11] |= (1 << 4);
                if (cbDOut_94.Checked != false) aucDigiOut[11] |= (1 << 5);
                if (cbDOut_95.Checked != false) aucDigiOut[11] |= (1 << 6);
                if (cbDOut_96.Checked != false) aucDigiOut[11] |= (1 << 7);

                if (cbDOut_97.Checked != false) aucDigiOut[12] |= (1 << 0);
                if (cbDOut_98.Checked != false) aucDigiOut[12] |= (1 << 1);
                if (cbDOut_99.Checked != false) aucDigiOut[12] |= (1 << 2);
                if (cbDOut_100.Checked != false) aucDigiOut[12] |= (1 << 3);
                if (cbDOut_101.Checked != false) aucDigiOut[12] |= (1 << 4);
                if (cbDOut_102.Checked != false) aucDigiOut[12] |= (1 << 5);
                if (cbDOut_103.Checked != false) aucDigiOut[12] |= (1 << 6);
                if (cbDOut_104.Checked != false) aucDigiOut[12] |= (1 << 7);

                if (cbDOut_105.Checked != false) aucDigiOut[13] |= (1 << 0);
                if (cbDOut_106.Checked != false) aucDigiOut[13] |= (1 << 1);
                if (cbDOut_107.Checked != false) aucDigiOut[13] |= (1 << 2);
                if (cbDOut_108.Checked != false) aucDigiOut[13] |= (1 << 3);
                if (cbDOut_109.Checked != false) aucDigiOut[13] |= (1 << 4);
                if (cbDOut_110.Checked != false) aucDigiOut[13] |= (1 << 5);
                if (cbDOut_111.Checked != false) aucDigiOut[13] |= (1 << 6);
                if (cbDOut_112.Checked != false) aucDigiOut[13] |= (1 << 7);

                if (cbDOut_113.Checked != false) aucDigiOut[14] |= (1 << 0);
                if (cbDOut_114.Checked != false) aucDigiOut[14] |= (1 << 1);
                if (cbDOut_115.Checked != false) aucDigiOut[14] |= (1 << 2);
                if (cbDOut_116.Checked != false) aucDigiOut[14] |= (1 << 3);
                if (cbDOut_117.Checked != false) aucDigiOut[14] |= (1 << 4);
                if (cbDOut_118.Checked != false) aucDigiOut[14] |= (1 << 5);
                if (cbDOut_119.Checked != false) aucDigiOut[14] |= (1 << 6);
                if (cbDOut_120.Checked != false) aucDigiOut[14] |= (1 << 7);

                if (cbDOut_121.Checked != false) aucDigiOut[15] |= (1 << 0);
                if (cbDOut_122.Checked != false) aucDigiOut[15] |= (1 << 1);
                if (cbDOut_123.Checked != false) aucDigiOut[15] |= (1 << 2);
                if (cbDOut_124.Checked != false) aucDigiOut[15] |= (1 << 3);
                if (cbDOut_125.Checked != false) aucDigiOut[15] |= (1 << 4);
                if (cbDOut_126.Checked != false) aucDigiOut[15] |= (1 << 5);
                if (cbDOut_127.Checked != false) aucDigiOut[15] |= (1 << 6);
                if (cbDOut_128.Checked != false) aucDigiOut[15] |= (1 << 7);

                clNmx.SetOutputs_1(pHandleNmx, aucDigiOut, 0);
            }
        }

        private void tmrUpdateDateTime_Tick(object sender, EventArgs e)
        {
            tmrUpdateDateTime.Enabled = false;

            if (bConnected != false)
            {
                clNmx.SetDateTime_1(pHandleNmx);
            }

            tmrUpdateDateTime.Enabled = true;
        }

        /******************************************************************************
        * FUNCTION: cbStaticFastUpdate_CheckedChanged
        *-----------------------------------------------------------------------------
        * Enable/Disable median filter for static values. Default by the system is
        * enabled.
        ******************************************************************************/
        private void cbStaticFastUpdate_CheckedChanged(object sender, EventArgs e)
        {
            if (cbStaticFastUpdate.Checked)
            {
                /* Enable median filter. Filter depth should be odd. 5 is a good value. */
                clNmx.StaticSetMedianDepth_1(pHandleNmx, 5);
            }
            else
            {
                /* Disable median filter */
                clNmx.StaticSetMedianDepth_1(pHandleNmx, 1);
            }
        }

        /******************************************************************************
        * FUNCTION: btnDigiEnableOutputWrite_Click
        *-----------------------------------------------------------------------------
        * Enable/Disable writing the digital output data.
        ******************************************************************************/
        private void btnDigiEnableOutputWrite_Click(object sender, EventArgs e)
        {
            if (bWriteDigitalOutputData == false)
            {
                bWriteDigitalOutputData = true;
                btnDigiEnableOutputWrite.Text = "Click to DISABLE writing output data to device";
                btnDigiEnableOutputWrite.ForeColor = Color.Black;
                cbDOut_1_CheckedChanged(sender, e);
            }
            else
            {
                bWriteDigitalOutputData = false;
                btnDigiEnableOutputWrite.Text = "Click to ENABLE writing output data to device";
                btnDigiEnableOutputWrite.ForeColor = Color.Red;
                clNmx.DisableOutputUpdate_1(pHandleNmx);
            }
        }

        /******************************************************************************
        * FUNCTION: cbDigiDisableIOReset_CheckedChanged
        *-----------------------------------------------------------------------------
        * Enable / Disable automatic reset of digital outputs, after a communication
        * breakdown.
        ******************************************************************************/
        private void cbDigiDisableIOReset_CheckedChanged(object sender, EventArgs e)
        {
            if (cbDigiDisableIOReset.Checked == false)
            {
                if (clNmx.DigitalIoConfig_1(pHandleNmx, 0) == NMX_STATUS.SUCCESS)
                {
                    AddHistoryEntry("Automatic digital output reset disabled successfully.", false);
                }
                else
                {
                    AddHistoryEntry("Failed disabling automatic digital output reset.", true);
                }
            }
            else
            {
                if (clNmx.DigitalIoConfig_1(pHandleNmx, 1) == NMX_STATUS.SUCCESS)
                {
                    AddHistoryEntry("Automatic digital output reset enabled successfully.", false);
                }
                else
                {
                    AddHistoryEntry("Failed enabling automatic digital output reset.", true);
                }
            }
        }

        /******************************************************************************
        * FUNCTION: SamplingUpdateSpeedLevels
        *-----------------------------------------------------------------------------
        * Retrieve the maximum speed from the system and set speed levels
        * accordingly.
        * Using different speed levels is not required for your measurement application.
        * It is just for demonstration purposes here.
        ******************************************************************************/
        private void SamplingUpdateSpeedLevels()
        {
            UInt32 ulPeriodMin = 1000;
            if (clNmx.Sampling_GetMaxSpeed_1(pHandleNmx, ref ulPeriodMin) == NMX_STATUS.SUCCESS)
            {
                ulSamplePeriodUltraFast = ulPeriodMin;
                if (ulPeriodMin < 1000)
                {
                    ulSamplePeriodFast = 1000;
                    ulSamplePeriodStandard = 10000;
                }
                else
                {
                    ulSamplePeriodFast = 500;
                    ulSamplePeriodStandard = 10000;
                }
                double flTime = (double)ulSamplePeriodUltraFast / 1000.0f;
                double flSpeed = 1000000.0f / (double)ulSamplePeriodUltraFast;
                rbSampling_TimeHigh.Text = string.Format("{0}ms / {1} samples/s", flTime, (UInt32)flSpeed);
                flTime = (double)ulSamplePeriodFast / 1000.0f;
                flSpeed = 1000000.0f / (double)ulSamplePeriodFast;
                rbSampling_TimeMid.Text = string.Format("{0}ms / {1} samples/s", flTime, (UInt32)flSpeed);
                flTime = (double)ulSamplePeriodStandard / 1000.0f;
                flSpeed = 1000000.0f / (double)ulSamplePeriodStandard;
                rbSampling_TimeStandard.Text = string.Format("{0}ms / {1} samples/s", flTime, (UInt32)flSpeed);
            }
            else
            {
                AddHistoryEntry("Failed reading minimum sample period.", true);
            }
        }

        /******************************************************************************
        * FUNCTION: btnSamplingAddChannelsAll_Click
        *-----------------------------------------------------------------------------
        * Add all measurement channels to the list of sampled data.
        ******************************************************************************/
        private void btnSamplingAddChannelsAll_Click(object sender, EventArgs e)
        {
            UInt32 ulNElements = 0;
            if (clNmx.Sampling_AddChannelsAll_1(pHandleNmx, ref ulNElements) == NMX_STATUS.SUCCESS)
            {
                AddHistoryEntry("All measurement channels successfully added to the sampling list.", false);
                lbSampling_NElements.Text = string.Format("{0} sampling elements added.", ulNElements);
                ulNSamplingElements = ulNElements;
            }
            else
            {
                AddHistoryEntry("Failed adding all measurement channels to the sampling list.", true);
            }

            btnSamplingAddChannelsAll.Enabled = false;
            btnSampling_AddChannels.Enabled = false;

            if (ulNElements > 0)
            {
                btnSampling_PrepareFiniteT.Enabled = true;
                btnSampling_PrepareEndlessT.Enabled = true;
                btnSamplingPrepareCustomTft.Enabled = true;
                btnSamplingPreparePosition.Enabled = true;
            }
        }

        /******************************************************************************
        * FUNCTION: btnSampling_AddChannels_Click
        *-----------------------------------------------------------------------------
        * Add selected measurement channels (checkboxes) to the list of sampled data.
        ******************************************************************************/
        private void btnSampling_AddChannels_Click(object sender, EventArgs e)
        {
            UInt32 ulNTotal = 0;
            UInt32 ulCtr = 0;
            bool bOk = true;

            for (Int32 slI = 0; slI < cblSampling_MeasChannels.Items.Count; slI++)
            {
                if (cblSampling_MeasChannels.GetItemChecked(slI) != false)
                {
                    if (clNmx.Sampling_AddChannel_1(pHandleNmx, (UInt32)slI, ref ulNTotal) != NMX_STATUS.SUCCESS)
                    {
                        AddHistoryEntry(string.Format("Failed adding P{0} to the list of sampled elements.", slI + 1), true);
                        bOk = false;
                    }
                    ulCtr++;
                }
            }

            if (bOk != false)
            {
                AddHistoryEntry(string.Format("Successfully added {0} MEASUREMENT CHANNELS to sampling list.", ulCtr), false);
            }

            lbSampling_NElements.Text = string.Format("{0} sampling elements added.", ulNTotal);
            ulNSamplingElements = ulNTotal;

            btnSamplingAddChannelsAll.Enabled = false;
            btnSampling_AddChannels.Enabled = false;

            if (ulNTotal > 0)
            {
                btnSampling_PrepareFiniteT.Enabled = true;
                btnSampling_PrepareEndlessT.Enabled = true;
                btnSamplingPrepareCustomTft.Enabled = true;
                btnSamplingPreparePosition.Enabled = true;
            }
        }

        /******************************************************************************
        * FUNCTION: btnSampling_AddInputsAll_Click
        *-----------------------------------------------------------------------------
        * Add all digital input bytes to the list of sampled data.
        ******************************************************************************/
        private void btnSampling_AddInputsAll_Click(object sender, EventArgs e)
        {
            UInt32 ulNElements = 0;
            if (clNmx.Sampling_AddDigiInAll_1(pHandleNmx, ref ulNElements) == NMX_STATUS.SUCCESS)
            {
                AddHistoryEntry("All digital inputs successfully added to the sampling list.", false);
                lbSampling_NElements.Text = string.Format("{0} sampling elements added.", ulNElements);
                ulNSamplingElements = ulNElements;
            }
            else
            {
                AddHistoryEntry("Failed adding all digital inputs to the sampling list.", true);
            }

            btnSampling_AddInputsAll.Enabled = false;
            btnSampling_AddDigitalInputs.Enabled = false;

            if (ulNElements > 0)
            {
                btnSampling_PrepareFiniteT.Enabled = true;
                btnSampling_PrepareEndlessT.Enabled = true;
                btnSamplingPrepareCustomTft.Enabled = true;
                btnSamplingPreparePosition.Enabled = true;
            }
        }

        /******************************************************************************
        * FUNCTION: btnSampling_AddDigitalInputs_Click
        *-----------------------------------------------------------------------------
        * Add selected digital input bytes (checkboxes) to the list of sampled data.
        ******************************************************************************/
        private void btnSampling_AddDigitalInputs_Click(object sender, EventArgs e)
        {
            UInt32 ulNTotal = 0;
            UInt32 ulCtr = 0;
            bool bOk = true;

            for (Int32 slI = 0; slI < cblSampling_DigitalInputs.Items.Count; slI++)
            {
                if (cblSampling_DigitalInputs.GetItemChecked(slI) != false)
                {
                    if (clNmx.Sampling_AddDigiInByte_1(pHandleNmx, (UInt32)slI, ref ulNTotal) != NMX_STATUS.SUCCESS)
                    {
                        AddHistoryEntry(string.Format("Failed adding Digital Input byte {0} to the list of sampled elements.", slI + 1), true);
                        bOk = false;
                    }
                    ulCtr++;
                }
            }

            if (bOk != false)
            {
                AddHistoryEntry(string.Format("Successfully added {0} digital INPUT bytes to sampling list.", ulCtr), false);
            }

            lbSampling_NElements.Text = string.Format("{0} sampling elements added.", ulNTotal);
            ulNSamplingElements = ulNTotal;

            btnSampling_AddInputsAll.Enabled = false;
            btnSampling_AddDigitalInputs.Enabled = false;


            if (ulNTotal > 0)
            {
                btnSampling_PrepareFiniteT.Enabled = true;
                btnSampling_PrepareEndlessT.Enabled = true;
                btnSamplingPrepareCustomTft.Enabled = true;
                btnSamplingPreparePosition.Enabled = true;
            }
        }

        /******************************************************************************
        * FUNCTION: btnSampling_AddOutputsAll_Click
        *-----------------------------------------------------------------------------
        * Add all digital output bytes to the list of sampled data.
        ******************************************************************************/
        private void btnSampling_AddOutputsAll_Click(object sender, EventArgs e)
        {
            UInt32 ulNElements = 0;
            if (clNmx.Sampling_AddDigiOutAll_1(pHandleNmx, ref ulNElements) == NMX_STATUS.SUCCESS)
            {
                AddHistoryEntry("All digital outputs successfully added to the sampling list.", false);
                lbSampling_NElements.Text = string.Format("{0} sampling elements added.", ulNElements);
                ulNSamplingElements = ulNElements;
            }
            else
            {
                AddHistoryEntry("Failed adding all digital outputs to the sampling list.", true);
            }

            btnSampling_AddOutputsAll.Enabled = false;
            btnSampling_AddDigitalOutputs.Enabled = false;


            if (ulNElements > 0)
            {
                btnSampling_PrepareFiniteT.Enabled = true;
                btnSampling_PrepareEndlessT.Enabled = true;
                btnSamplingPrepareCustomTft.Enabled = true;
                btnSamplingPreparePosition.Enabled = true;
            }
        }

        /******************************************************************************
        * FUNCTION: btnSampling_AddDigitalOutputs_Click
        *-----------------------------------------------------------------------------
        * Add selected digital output bytes (checkboxes) to the list of sampled data.
        ******************************************************************************/
        private void btnSampling_AddDigitalOutputs_Click(object sender, EventArgs e)
        {
            UInt32 ulNTotal = 0;
            UInt32 ulCtr = 0;
            bool bOk = true;

            for (Int32 slI = 0; slI < cblSampling_DigitalOutputs.Items.Count; slI++)
            {
                if (cblSampling_DigitalOutputs.GetItemChecked(slI) != false)
                {
                    if (clNmx.Sampling_AddDigiOutByte_1(pHandleNmx, (UInt32)slI, ref ulNTotal) != NMX_STATUS.SUCCESS)
                    {
                        AddHistoryEntry(string.Format("Failed adding Digital Output byte {0} to the list of sampled elements.", slI + 1), true);
                        bOk = false;
                    }
                    ulCtr++;
                }
            }

            if (bOk != false)
            {
                AddHistoryEntry(string.Format("Successfully added {0} digital OUTPUT bytes to sampling list.", ulCtr), false);
            }

            lbSampling_NElements.Text = string.Format("{0} sampling elements added.", ulNTotal);
            ulNSamplingElements = ulNTotal;

            btnSampling_AddOutputsAll.Enabled = false;
            btnSampling_AddDigitalOutputs.Enabled = false;

            if (ulNTotal > 0)
            {
                btnSampling_PrepareFiniteT.Enabled = true;
                btnSampling_PrepareEndlessT.Enabled = true;
                btnSamplingPrepareCustomTft.Enabled = true;
                btnSamplingPreparePosition.Enabled = true;
            }
        }

        /******************************************************************************
        * FUNCTION: btnSamplingReset_Click
        *-----------------------------------------------------------------------------
        * Resets the current sampling configuration (and stop sampling if running).
        ******************************************************************************/
        private void btnSamplingReset_Click(object sender, EventArgs e)
        {
            if (clNmx.Sampling_Reset_1(pHandleNmx) == NMX_STATUS.SUCCESS)
            {
                AddHistoryEntry("Sampling reset successfully.", false);
                lbSampling_NElements.Text = "No sampling elements added.";

                btnSamplingAddChannelsAll.Enabled = true;
                btnSampling_AddChannels.Enabled = true;
                btnSampling_AddInputsAll.Enabled = true;
                btnSampling_AddDigitalInputs.Enabled = true;
                btnSampling_AddOutputsAll.Enabled = true;
                btnSampling_AddDigitalOutputs.Enabled = true;

                btnSampling_PrepareFiniteT.Enabled = false;
                btnSampling_PrepareEndlessT.Enabled = false;
                btnSamplingPrepareCustomTft.Enabled = false;
                btnSamplingPreparePosition.Enabled = false;

                SamplingClearNotificationCtrs();
            }
            else
            {
                AddHistoryEntry("Failed to reset sampling.", true);
            }
        }

        /******************************************************************************
        * FUNCTION: btnSampling_PrepareFiniteT_Click
        *-----------------------------------------------------------------------------
        * Prepare time-based & time-limited measurement.
        ******************************************************************************/
        private void btnSampling_PrepareFiniteT_Click(object sender, EventArgs e)
        {
            tmrSampling.Enabled = false;
            tmrSamplingEndlessReadData.Enabled = false;

            /* Get sample period from radio buttons */
            UInt32 ulSamplePeriod = ulSamplePeriodFast;
            if (rbSampling_TimeHigh.Checked == true)
            {
                ulSamplePeriod = ulSamplePeriodUltraFast;
            }
            else if (rbSampling_TimeStandard.Checked == true)
            {
                ulSamplePeriod = ulSamplePeriodStandard;
            }

            /* --> In this example with time-limited sampling, the DLL-internal buffer has enough space for
            *      storing all the sample values in the DLL (Sampling_PrepareTime_1 function parameters
            *      ulDLLArrayLength = udMaxSamples). This is possible, if the sampling-time is limited
            *      to a few seconds, since then only a small amount of memory is required. */
            if (clNmx.Sampling_PrepareTime_1(pHandleNmx, ulSamplePeriod, (UInt32)nuSampling_TimeNSamples.Value, (UInt32)nuSampling_TimeNSamples.Value) == NMX_STATUS.SUCCESS)
            {
                AddHistoryEntry("Time-limited sampling prepared successfully.", false);
                btnSampling_TEndlessStart.Enabled = false;
                btnSampling_TLimitedStart.Enabled = true;
                btnSampling_Store.Enabled = false;
                btnSampling_EndlessStore.Enabled = false;

                btnSamplingAddChannelsAll.Enabled = false;
                btnSampling_AddChannels.Enabled = false;
                btnSampling_AddInputsAll.Enabled = false;
                btnSampling_AddDigitalInputs.Enabled = false;
                btnSampling_AddOutputsAll.Enabled = false;
                btnSampling_AddDigitalOutputs.Enabled = false;
            }
            else
            {
                AddHistoryEntry("Failed preparing time-limited sampling.", true);
            }

            SamplingClearNotificationCtrs();
        }

        /******************************************************************************
        * FUNCTION: btnSampling_PrepareEndlessT_Click
        *-----------------------------------------------------------------------------
        * Prepare endless time-based measurement.
        ******************************************************************************/
        private void btnSampling_PrepareEndlessT_Click(object sender, EventArgs e)
        {
            UInt32 ulColumn = 0;
            UInt32 ulRow = 0;

            tmrSampling.Enabled = false;
            tmrSamplingEndlessReadData.Enabled = false;

            /* Get sample period from radio buttons */
            UInt32 ulSamplePeriod = ulSamplePeriodFast;
            if (rbSampling_TimeHigh.Checked == true)
            {
                ulSamplePeriod = ulSamplePeriodUltraFast;
            }
            else if (rbSampling_TimeStandard.Checked == true)
            {
                ulSamplePeriod = ulSamplePeriodStandard;
            }

            /* Specify DLL internal array size for buffering the samples. An array, which is large enough for
             * a few seconds, e.g. 10s, is good practice. */
            UInt32 ulSamplesPer10s = (10 * 1000000) / ulSamplePeriod;

            /* Create buffers for sample values */
            ulSamplingEndlessArrayLength = (UInt32)nuSampling_TimeKeepSamples.Value;
            aaslRingBuf = new Int32[ulNSamplingElements, ulSamplingEndlessArrayLength];
            for (ulColumn = 0; ulColumn < ulNSamplingElements; ulColumn++)
            {
                for (ulRow = 0; ulRow < ulSamplingEndlessArrayLength; ulRow++)
                {
                    aaslRingBuf[ulColumn,ulRow] = -2147483647;
                }
            }
            ulSamplingArrayRowNewest = 0;
            udSamplingCtrNewest = 0;

            /* --> Since it is impossible having an endless buffer for the sampled data, using a ring-buffer is required.
             *     The Nmx-DLL uses an internal ring-buffer; its size if specified by ulSamplesPer10s. 
             *     Using 0 as the last function parameter tells the DLL/measurement system, that the sampling is endless.
             *     Please note: this demo application also uses a ringbuffer for storing the last sampled data. It
             *     is optional and independent of the DLLs ringbuffer. Feel free to store the sampled data as you prefer it. */
            if (clNmx.Sampling_PrepareTime_1(pHandleNmx, ulSamplePeriod, ulSamplesPer10s, 0/*0=NoLimit*/) == NMX_STATUS.SUCCESS)
            {
                AddHistoryEntry("Endless sampling prepared successfully.", false);
                tmrSamplingEndlessReadData.Enabled = true;

                btnSampling_TLimitedStart.Enabled = false;
                btnSampling_TEndlessStart.Enabled = true;
                btnSampling_Store.Enabled = false;
                btnSampling_EndlessStore.Enabled = false;

                btnSamplingAddChannelsAll.Enabled = false;
                btnSampling_AddChannels.Enabled = false;
                btnSampling_AddInputsAll.Enabled = false;
                btnSampling_AddDigitalInputs.Enabled = false;
                btnSampling_AddOutputsAll.Enabled = false;
                btnSampling_AddDigitalOutputs.Enabled = false;
            }
            else
            {
                AddHistoryEntry("Failed preparing endless sampling.", true);
            }

            SamplingClearNotificationCtrs();
        }

        /******************************************************************************
        * FUNCTION: btnSamplingPrepareCustomTft_Click
        *-----------------------------------------------------------------------------
        * Prepare custom sampling, type TFT.
        ******************************************************************************/
        private void btnSamplingPrepareCustomTft_Click(object sender, EventArgs e)
        {
            UInt32 ulFilterPeriod = (UInt32)nuSamplingTftFilterPeriod.Value * 1000;
            UInt32 ulMod = 0;
            UInt32 ulDiv = 0;
            UInt32 ulNSamples = (UInt32)nuSamplingTftNSamples.Value;
            UInt32 ulNTailSamples = (UInt32)nuSamplingTftNTailSamples.Value;
            UInt32 ulTriggerByteNo = (UInt32)cbSamplingTftTriggerByte.SelectedIndex;
            UInt32 ulTriggerBitNo = (UInt32)cbSamplingTftTriggerBit.SelectedIndex;
            UInt32 ulTriggerMode = (UInt32)cbSamplingTftTriggerMode.SelectedIndex;
            UInt32 ulTriggerPolarity = (UInt32)cbSamplingTftTriggerPolarity.SelectedIndex + 1;


            tmrSampling.Enabled = false;
            tmrSamplingEndlessReadData.Enabled = false;

            /* Get sample period from radio buttons */
            UInt32 ulSamplePeriod = ulSamplePeriodFast;
            if (rbSampling_TimeHigh.Checked == true)
            {
                ulSamplePeriod = ulSamplePeriodUltraFast;
            }
            else if (rbSampling_TimeStandard.Checked == true)
            {
                ulSamplePeriod = ulSamplePeriodStandard;
            }

            ulMod = ulFilterPeriod % ulSamplePeriod;
            ulDiv = ulFilterPeriod / ulSamplePeriod;
            if ((ulMod != 0) || (ulDiv < 1))
            {
                MessageBox.Show("Invalid filter period. Must be >= sample period and a multiple of the sample period. Example: sample period = 1ms, filter period = 5ms.");
                AddHistoryEntry("Failed preparing TFT sampling: filter period invalid", true);
                return;
            }


            /* --> In this example, a few assumptions are made for simplicity: 
             *     - It is assumed that number of samples is limited (e.g. < 100000 per sampling element),
             *       therefore the size of the internal DLL array length is selected to have enough
             *       space for all samples.
             *     - Endless sampling is not implemented in this example, but could be used. */
            NMX_STATUS eStat = clNmx.Sampling_PrepareCustomTFT_1(pHandleNmx,
                ulSamplePeriod,
                ulFilterPeriod,
                ulNSamples + ulNTailSamples,
                (UInt64)ulNSamples,
		        ulNTailSamples,
		        ulTriggerByteNo,
		        ulTriggerBitNo,
		        ulTriggerMode,
		        ulTriggerPolarity);
            if (eStat == NMX_STATUS.SUCCESS)
            {
                AddHistoryEntry("TFT sampling prepared successfully.", false);
                btnSampling_TEndlessStart.Enabled = false;
                btnSampling_TLimitedStart.Enabled = true;
                btnSampling_Store.Enabled = false;
                btnSampling_EndlessStore.Enabled = false;

                btnSamplingAddChannelsAll.Enabled = false;
                btnSampling_AddChannels.Enabled = false;
                btnSampling_AddInputsAll.Enabled = false;
                btnSampling_AddDigitalInputs.Enabled = false;
                btnSampling_AddOutputsAll.Enabled = false;
                btnSampling_AddDigitalOutputs.Enabled = false;
            }
            else
            {
                AddHistoryEntry("Failed preparing TFT sampling.", true);
            }

            SamplingClearNotificationCtrs();
        }

        /******************************************************************************
        * FUNCTION: btnSamplingPreparePosition_Click
        *-----------------------------------------------------------------------------
        * Prepare position triggered sampling.
        ******************************************************************************/
        private void btnSamplingPreparePosition_Click(object sender, EventArgs e)
        {
            UInt32 ulArrayLength = (UInt32)nuSamplingPositionNSamples.Value;
            UInt64 udMaxSamples = (UInt64)nuSamplingPositionNSamples.Value;
            UInt32 ulTriggerChannelNumber = (UInt32)cbSamplingPositionTriggerChannel.SelectedIndex;
            double fdScale = (double)nuSamplingPositionScale.Value;
            double fdStart = (double)nuSamplingPositionStart.Value;
            double fdDistance = (double)nuSamplingPositionDistance.Value;


            tmrSampling.Enabled = false;
            tmrSamplingEndlessReadData.Enabled = false;

            /* Get sample period from radio buttons */
            UInt32 ulSamplePeriod = ulSamplePeriodFast;
            if (rbSampling_TimeHigh.Checked == true)
            {
                ulSamplePeriod = ulSamplePeriodUltraFast;
            }
            else if (rbSampling_TimeStandard.Checked == true)
            {
                ulSamplePeriod = ulSamplePeriodStandard;
            }

            /* --> In this example, a few assumptions are made for simplicity:
            *     - It is assumed that number of samples is limited (e.g. < 100000 per sampling element),
            *       therefore the size of the internal DLL array length is selected to have enough
            *       space for all samples.
            *     - Endless sampling is not implemented in this example, but could be used. */
            NMX_STATUS eStat = clNmx.Sampling_PreparePosition_1(pHandleNmx,
                ulSamplePeriod,
                ulArrayLength,
                udMaxSamples,
                ulTriggerChannelNumber,
                fdScale,
                fdStart,
                fdDistance);
            if (eStat == NMX_STATUS.SUCCESS)
            {
                AddHistoryEntry("Position-Triggered sampling prepared successfully.", false);
                btnSampling_TEndlessStart.Enabled = false;
                btnSampling_TLimitedStart.Enabled = true;
                btnSampling_Store.Enabled = false;
                btnSampling_EndlessStore.Enabled = false;

                btnSamplingAddChannelsAll.Enabled = false;
                btnSampling_AddChannels.Enabled = false;
                btnSampling_AddInputsAll.Enabled = false;
                btnSampling_AddDigitalInputs.Enabled = false;
                btnSampling_AddOutputsAll.Enabled = false;
                btnSampling_AddDigitalOutputs.Enabled = false;
            }
            else
            {
                AddHistoryEntry("Failed preparing Position-Triggered sampling.", true);
            }

            SamplingClearNotificationCtrs();
        }

        /******************************************************************************
        * FUNCTION: btnSampling_Start_Click
        *-----------------------------------------------------------------------------
        * Start time-limited sampling.
        ******************************************************************************/
        private void btnSampling_TLimitedStart_Click(object sender, EventArgs e)
        {
            if (clNmx.Sampling_Start_1(pHandleNmx) == NMX_STATUS.SUCCESS)
            {
                AddHistoryEntry("Sampling (time-limited) started successfully.", false);
                tmrSampling.Enabled = true;
                btnSampling_TLimitedStart.Enabled = false;
            }
            else
            {
                AddHistoryEntry("Failed starting time-limited sampling.", true);
            }
        }

        /******************************************************************************
        * FUNCTION: btnSampling_TEndlessStart_Click
        *-----------------------------------------------------------------------------
        * Start endless sampling.
        ******************************************************************************/
        private void btnSampling_TEndlessStart_Click(object sender, EventArgs e)
        {
            if (clNmx.Sampling_Start_1(pHandleNmx) == NMX_STATUS.SUCCESS)
            {
                AddHistoryEntry("Sampling (endless) started successfully.", false);
                tmrSampling.Enabled = true;
                btnSampling_TEndlessStart.Enabled = false;
            }
            else
            {
                AddHistoryEntry("Failed starting endless sampling.", true);
            }
        }

        /******************************************************************************
        * FUNCTION: btnSampling_Store_Click
        *-----------------------------------------------------------------------------
        * Time-limited sampling: Store sampled values into a CSV file.
        ******************************************************************************/
        private void btnSampling_Store_Click(object sender, EventArgs e)
        {
            string strPath = Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().Location) + "\\Samples.csv";
            string str = "";
            UInt64 udSamplesReceived = 0;
            UInt32 ulSamplesCopied = 0;
            byte ucDummy = 0;
            UInt32 ulDummy = 0;
            UInt64 udDummy = 0;


            /* ---> In this example with time-limited sampling, all measurement values are
             * read here from the DLL in a single step. This is possible, if the time and therefore
             * the memory consumption for the samples is not too large. */



            /* Get number of samples, which are available. */
            clNmx.Sampling_GetStatus_1(pHandleNmx, ref ucDummy, ref ulDummy, ref udSamplesReceived, ref udDummy);


            try
            {
                /* Create file path. Samples.csv will be stored in the same
                * directory as the *.exe-File of the application. */
                StreamWriter cStreamWriter = File.CreateText(strPath);

                /* Writer Header line */
                str = "";
                for (UInt32 ulColumn = 0; ulColumn < ulNSamplingElements; ulColumn++)
                {
                    if (ulColumn == 0)
                    {
                        str += string.Format("E{0}", ulColumn + 1);
                    }
                    else
                    {
                        str += string.Format(";E{0}", ulColumn + 1);
                    }
                }
                cStreamWriter.WriteLine(str);

                /* There are 2 possibilities reading data from the DLL:
                 * 1. Read data column-wise, which means: read an array of sample-values for a specific sampling element, e.g. a probe. 
                 * 2. Read data row-wise, which means: read the values of all sampling-elements, which have been sampled at the same time.
                 * The first way is a bit better regarding performance. On many PCs this is neglectable. 
                 * See documentation for more information.
                 * Choose the possibility, which is more convenient for you.
                 * In this example only row-wise is used. */

                /* Create array for values */
                Int32[] aslValues = new Int32[ulNSamplingElements];

                UInt64 udRowsLeft = 0;
                clNmx.Sampling_GetRowsLeft_1(pHandleNmx, ref udRowsLeft);
                while (udRowsLeft > 0)
                {
                    udRowsLeft--;

                    for (UInt32 ulColumn = 0; ulColumn < ulNSamplingElements; ulColumn++)
                    {
                        aslValues[ulColumn] = -2147483647;
                    }

                    /* Get values from DLL.
                     * Feel free to do some more error handling here, e.g. check ulSamplesCopied and checking the function return code. */
                    clNmx.Sampling_ReadRow32_1(pHandleNmx, ref aslValues, ref ulSamplesCopied, ref udDummy);

                    /* Write line with samples. */
                    str = "";
                    for (UInt32 ulColumn = 0; ulColumn < ulNSamplingElements; ulColumn++)
                    {
                        if (ulColumn == 0)
                        {
                            str += string.Format("{0}", aslValues[ulColumn]);
                        }
                        else
                        {
                            str += string.Format(";{0}", aslValues[ulColumn]);
                        }
                    }
                    cStreamWriter.WriteLine(str);
                }

                cStreamWriter.Close();

                /* Disable this button, since reading row-wise can only be done once. */
                btnSampling_Store.Enabled = false;

                str = "Sample values successfully written to " + strPath + ".";
                AddHistoryEntry(str, false);
            }
	        catch (Exception exc)
	        {
		        str = "Sample values cannot be written Samples.csv (" + exc.Message + ").";
		        AddHistoryEntry(str, true);
            }

	        /* Inform user about result of writing the file (success, error) */
	        MessageBox.Show(str, "Store sampled measurement values");
        }

        /******************************************************************************
        * FUNCTION: btnSampling_EndlessStore_Click
        *-----------------------------------------------------------------------------
        * Store last sampled values of endless sampling into a CSV file.
        ******************************************************************************/
        private void btnSampling_EndlessStore_Click(object sender, EventArgs e)
        {
            string strPath = Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().Location) + "\\Samples.csv";
            string str = "";
            UInt32 ulColumn = 0;
            UInt32 ulRow = 0;
            UInt32 ulArrayIndex = 0;

            try
            {
                /* Create file path. Samples.csv will be stored in the same
                * directory as the *.exe-File of the application. */
                StreamWriter cStreamWriter = File.CreateText(strPath);

                /* Writer Header line */
                str = "";
                for (ulColumn = 0; ulColumn < ulNSamplingElements; ulColumn++)
                {
                    if (ulColumn == 0)
                    {
                        str += string.Format("E{0}", ulColumn + 1);
                    }
                    else
                    {
                        str += string.Format(";E{0}", ulColumn + 1);
                    }
                }
                cStreamWriter.WriteLine(str);


                /* Write sample values to file */
                UInt32 ulTotalRows = ulSamplingEndlessArrayLength;
                UInt32 ulSkip = 0;
                if (ulTotalRows > udSamplingCtrNewest)
                {
                    ulTotalRows = (UInt32)udSamplingCtrNewest;
                    ulSkip = ulSamplingEndlessArrayLength - ulTotalRows;
                }
                for (ulRow = 0; ulRow < ulTotalRows; ulRow++)
                {
                    str = "";
                    ulArrayIndex = (ulRow + ulSamplingArrayRowNewest + ulSkip) % ulSamplingEndlessArrayLength;
                    for (ulColumn = 0; ulColumn < ulNSamplingElements; ulColumn++)
                    {
                        if (ulColumn == 0)
                        {
                            str += string.Format("{0}", aaslRingBuf[ulColumn,ulArrayIndex]);
                        }
                        else
                        {
                            str += string.Format(";{0}", aaslRingBuf[ulColumn,ulArrayIndex]);
                        }
                    }
                    cStreamWriter.WriteLine(str);
                }

                /* Write finished: close file*/
                cStreamWriter.Close();

                str = "Sample values successfully written to " + strPath + ".";
                AddHistoryEntry(str, false);
            }
            catch (Exception exc)
	        {
                str = "Sample values cannot be written Samples.csv (" + exc.Message + ").";
                AddHistoryEntry(str, true);
            }

            /* Inform user about result of writing the file (success, error) */
            MessageBox.Show(str, "Store sampled measurement values");
        }

        /******************************************************************************
        * FUNCTION: btnSampling_Stop_Click
        *-----------------------------------------------------------------------------
        * Stop sampling.
        ******************************************************************************/
        private void btnSampling_Stop_Click(object sender, EventArgs e)
        {
            if (clNmx.Sampling_Stop_1(pHandleNmx) == NMX_STATUS.SUCCESS)
            {
                AddHistoryEntry("Sampling stop requested.", false);
            }
            else
            {
                AddHistoryEntry("Failed stopping sampling.", true);
            }
        }

        /******************************************************************************
        * FUNCTION: tmrSampling_Tick
        *-----------------------------------------------------------------------------
        * Update sampling status.
        ******************************************************************************/
        private void tmrSampling_Tick(object sender, EventArgs e)
        {
            byte ucStatus = 0;
            UInt64 udSamplesReceived = 0;
            UInt64 udSamplesMax = 0;
            UInt32 ulDummy = 0;

            /* Disable this timer */
            tmrSampling.Enabled = false;

            /* Update status information */
            lbSampling_NotificationsNewData.Text = string.Format("{0} new-data notifications", ulCtrSamplingNotificationsNewData);
            lbSampling_NotificationAllReceived.Text = string.Format("{0} all-received notifications", ulCtrSamplingNotificationsAllReceived);
            lbSampling_NotificationFinished.Text = string.Format("{0} finished notifications", ulCtrSamplingNotificationsFinished);
            lbSampling_NotificationError.Text = string.Format("{0} error notifications", ulCtrSamplingNotificationsError);
            lbSampling_NotificationBufOverflow.Text = string.Format("{0} buffer overflow notifications", ulCtrSamplingNotificationsBufferOverflow);
            lbSampling_NotificationTimeout.Text = string.Format("{0} timeout notifications", ulCtrSamplingNotificationTimeout);

            if (clNmx.Sampling_GetStatus_1(pHandleNmx, ref ucStatus, ref ulDummy, ref udSamplesReceived, ref udSamplesMax) == NMX_STATUS.SUCCESS)
            {
                lbSampling_NSamplesReceived.Text = string.Format("{0} samples received / {1}", udSamplesReceived, ucStatus);

                if (udSamplesReceived > 0)
                {
                    btnSampling_Store.Enabled = true;
                }

                if (udSamplesMax > 1000000000)
                {
                    /* Just an alternate text to ensure that its length gets not too large with endless sampling. */
                    lbSampling_MaxSamples.Text = string.Format("> 1 billion samples max");
                }
                else
                {
                    lbSampling_MaxSamples.Text = string.Format("{0} samples max", udSamplesMax);
                }
            }
            else
            {
                lbSampling_NSamplesReceived.Text = "*";
                lbSampling_MaxSamples.Text = "*";
            }

            /* Re-enable this timer */
            tmrSampling.Enabled = true;
        }

        /******************************************************************************
        * FUNCTION: tmrSamplingEndlessReadData_Tick
        *-----------------------------------------------------------------------------
        * Endless sampling: read sampled data and store it in local (ring-)buffer.
        ******************************************************************************/
        private void tmrSamplingEndlessReadData_Tick(object sender, EventArgs e)
        {
            UInt64 udSamplesReceived = 0;
            UInt32 ulRemainingRows = 0;
            UInt32 ulSamplesCopied = 0;
            UInt64 udNoFirstSample = 0;
            byte ucDummy = 0;
            UInt32 ulDummy = 0;
            UInt64 udDummy = 0;


            /* Disable this timer */
            tmrSamplingEndlessReadData.Enabled = false;

            if (bNewSamplingData != false)
            {
                bNewSamplingData = false;

                /* Get number of samples, which are available. */
                if (clNmx.Sampling_GetStatus_1(pHandleNmx, ref ucDummy, ref ulDummy, ref udSamplesReceived, ref udDummy) != NMX_STATUS.SUCCESS)
                {
                    AddHistoryEntry("Error reading endless sampling data: cannot get sampling status", true);
                    return;
                }

                btnSampling_EndlessStore.Enabled = true;

                /* Calculate remaining array rows until the end of the array. */
                if (ulSamplingArrayRowNewest == (ulSamplingEndlessArrayLength - 1))
                {
                    /* End of array reached. Start again from beginning. */
                    ulRemainingRows = ulSamplingEndlessArrayLength;
                }
                if (ulSamplingEndlessArrayLength >= ulSamplingArrayRowNewest)
                {
                    ulRemainingRows = ulSamplingEndlessArrayLength - ulSamplingArrayRowNewest;
                }
                else
                {
                    ulRemainingRows = 0;
                    AddHistoryEntry("Error reading endless sampling data: invalid array index ulSamplingArrayRowNewest", true);
                    return;
                }

                /* There are 2 possibilities reading data from the DLL:
                * 1. Read data column-wise, which means: read an array of sample-values for a specific sampling element, e.g. a probe.
                * 2. Read data row-wise, which means: read the values of all sampling-elements, which have been sampled at the same time.
                * The first way is a bit better regarding performance. On many PCs this is neglectable.
                * See documentation for more information.
                * Choose the possibility, which is more convenient for you.
                * In this example only row-wise reading is implemented. */
                /* ---> Read column-wise */
                /* Read row-wise */
                Int32[] aslValues = new Int32[ulNSamplingElements];
                bool bError = false;
                UInt64 udRowsLeft = 0;
                clNmx.Sampling_GetRowsLeft_1(pHandleNmx, ref udRowsLeft);
                while (udRowsLeft > 0)
                {
                    udRowsLeft--;

                    for (UInt32 ulColumn = 0; ulColumn < ulNSamplingElements; ulColumn++)
                    {
                        aslValues[ulColumn] = -2147483647;
                    }

                    /* Read samples from DLL into local array */
                    if (clNmx.Sampling_ReadRow32_1(pHandleNmx, ref aslValues, ref ulSamplesCopied, ref udNoFirstSample) != NMX_STATUS.SUCCESS)
                    {
                        AddHistoryEntry("Error reading endless sampling data: cannot read sample data", true);
                        bError = true;
                        break; ;
                    }

                    if (udNoFirstSample != udSamplingCtrNewest)
                    {
                        AddHistoryEntry("Error reading endless sampling data: invalid sample counter received", true);
                        bError = true;
                        break;
                    }

                    /* Copy samples from local array to global Ring-buffer */
                    for (UInt32 ulColumn = 0; ulColumn < ulNSamplingElements; ulColumn++)
                    {
                        aaslRingBuf[ulColumn,ulSamplingArrayRowNewest] = aslValues[ulColumn];
                    }
                    /* Update row, which contains the newest sampling data */
                    ulSamplingArrayRowNewest = (ulSamplingArrayRowNewest + 1) % ulSamplingEndlessArrayLength;


                    udSamplingCtrNewest++;
                }

                if (bError != false)
                {
                    return;
                }
            }


            /* Re-enable this timer */
            tmrSamplingEndlessReadData.Enabled = true;
        }

        /******************************************************************************
        * FUNCTION: btnSamplingDInTrgSet_Click
        *-----------------------------------------------------------------------------
        * Sampling: set the digital input trigger.
        * Using a trigger is optional! If you do not need it, ignore this code.
        ******************************************************************************/
        private void btnSamplingDInTrgSet_Click(object sender, EventArgs e)
        {
            UInt32 ulByte = 0;
            UInt32 ulBit = 0;
            UInt32 ulMode = 0;
            UInt32 ulPol = 0;

            ulByte = (UInt32)cbSamplingDInTrgByte.SelectedIndex;
            ulBit = (UInt32)cbSamplingDInTrgBit.SelectedIndex;
            ulMode = (UInt32)(cbSamplingDInTrgMode.SelectedIndex + 1);
            ulPol = (UInt32)(cbSamplingDInTrgPol.SelectedIndex + 1);

            if (clNmx.Sampling_SetTriggerDigiIn_1(pHandleNmx, ulByte, ulBit, ulMode, ulPol) == NMX_STATUS.SUCCESS)
            {
                AddHistoryEntry("Sampling: digital input trigger set successfully.", false);
            }
            else
            {
                AddHistoryEntry("Failed setting digital input trigger for sampling.", true);
            }
        }

        /******************************************************************************
        * FUNCTION: btnChannelSetParameter_Click
        *-----------------------------------------------------------------------------
        * Send string with "channel parameter" to device and receive its response.
        ******************************************************************************/
        private void btnChannelSetParameter_Click(object sender, EventArgs e)
        {
            string strRx = "";

            tbChannelSetParameterRx.Text = "";
            if (clNmx.ChannelSetParameter_1(pHandleNmx, (UInt32)nuChannelSetParameterNo.Value, tbChannelSetParameterTx.Text, ref strRx) == NMX_STATUS.SUCCESS)
            {
                AddHistoryEntry("Channel Parameter string exchanged successfully", false);
                tbChannelSetParameterRx.Text = strRx;
            }
            else
            {
                AddHistoryEntry("Failed exchanging Channel Parameter String", true);
                tbChannelSetParameterRx.Text = "Error";
            }
        }

        /******************************************************************************
        * FUNCTION: btnChannelSetConfig_Click
        *-----------------------------------------------------------------------------
        * Send string with "channel config" to device and receive its response.
        ******************************************************************************/
        private void btnChannelSetConfig_Click(object sender, EventArgs e)
        {
            string strRx = "";

            tbChannelSetConfigRx.Text = "";
            if (clNmx.ChannelSetConfig_1(pHandleNmx, (UInt32)nuChannelSetConfigNo.Value, tbChannelSetConfigTx.Text, ref strRx) == NMX_STATUS.SUCCESS)
            {
                AddHistoryEntry("Channel Config string exchanged successfully", false);
                tbChannelSetConfigRx.Text = strRx;
            }
            else
            {
                AddHistoryEntry("Failed exchanging Channel Config String", true);
                tbChannelSetConfigRx.Text = "Error";
            }
        }
    }
}
