#pragma once
#include "Windows.h"
#include "NmxApi.h"

using namespace System;

/* ---------------------------------------------------------------------------
* Defines
* ---------------------------------------------------------------------------*/
#define NMX_CALLCONV		__stdcall

/* ---------------------------------------------------------------------------
* Windows messages
* ---------------------------------------------------------------------------*/
#define WM_MESSAGE_DISCONNECTED					(WM_USER + NMXNOTIFY_DISCONNECTED)					// Message for "dicsonnected"
#define WM_MESSAGE_FAILURE_DATA_EXCHANGE		(WM_USER + NMXNOTIFY_FAILURE_DATA_EXCHANGE)			// Message for "permanent data exchange failure"
#define WM_MESSAGE_RECONNECTED					(WM_USER + NMXNOTIFY_RECONNECTED)					// Message for "Reconnected"
#define	WM_MESSAGE_NEW_STATIC32					(WM_USER + NMXNOTIFY_NEW_STATIC32)					// Message for "new static data" received
#define WM_MESSAGE_SAMPLING_NEWDATA				(WM_USER + NMXNOTIFY_SAMPLING_NEW_DATA)				// Message for "new sampling data" received
#define WM_MESSAGE_SAMPLING_ALLRECEIVED			(WM_USER + NMXNOTIFY_SAMPLING_ALL_DATA_RECEIVED)	// Message for "all sampling data has been received"
#define WM_MESSAGE_SAMPLING_FINISHED			(WM_USER + NMXNOTIFY_SAMPLING_FINISHED)				// Message for "sampling is finished"
#define WM_MESSAGE_SAMPLING_ERROR				(WM_USER + NMXNOTIFY_SAMPLING_ERROR)				// Message for "sampling error"
#define WM_MESSAGE_SAMPLING_BUFFER_OVERFLOW		(WM_USER + NMXNOTIFY_SAMPLING_BUFFER_OVERFLOW)		// Message for "sampling buffer overflow in DLL"
#define WM_MESSAGE_SAMPLING_TIMEOUT				(WM_USER + NMXNOTIFY_SAMPLING_TIMEOUT)				// Message for "sampling: timeout receiving data"


class CNmx
{
public:
	CNmx();
	~CNmx();
	bool Load(void);
	T_NMX_GetDllVersion_1				GetDllVersion_1;
	T_NMX_DeviceIPv4Open_1				DeviceIPv4Open_1;
	T_NMX_DeviceClose_1					DeviceClose_1;
	T_NMX_GetBoxCount_1					GetBoxCount_1;
	T_NMX_GetBoxInfo_1					GetBoxInfo_1;
	T_NMX_UpdateChannelInfo_1			UpdateChannelInfo_1;
	T_NMX_GetChannelCount_1				GetChannelCount_1;
	T_NMX_GetChannelInfo_1				GetChannelInfo_1;
	T_NMX_GetDigitalInputInfo_1			GetDigitalInputInfo_1;
	T_NMX_GetDigitalOutputInfo_1		GetDigitalOutputInfo_1;
	T_NMX_RegisterMessage_1				RegisterMessage_1;
	T_NMX_RegisterCallback_1			RegisterCallback_1;
	T_NMX_ChannelSetParameter_1			ChannelSetParameter_1;
	T_NMX_ChannelSetConfig_1			ChannelSetConfig_1;
	T_NMX_StaticGet32_1					StaticGet32_1;
	T_NMX_StaticSetMedianDepth_1		StaticSetMedianDepth_1;
	T_NMX_SetOutputs_1					SetOutputs_1;
	T_NMX_DisableOutputUpdate_1			DisableOutputUpdate_1;
	T_NMX_DigitalIoConfig_1				DigitalIoConfig_1;
	T_NMX_DigitalOutputsGetState_1		DigitalOutputsGetState_1;
	T_NMX_Sampling_GetMaxSpeed_1		Sampling_GetMaxSpeed_1;
	T_NMX_Sampling_Reset_1				Sampling_Reset_1;
	T_NMX_Sampling_AddChannelsAll_1		Sampling_AddChannelsAll_1;
	T_NMX_Sampling_AddChannel_1			Sampling_AddChannel_1;
	T_NMX_Sampling_AddDigiInAll_1		Sampling_AddDigiInAll_1;
	T_NMX_Sampling_AddDigiInByte_1		Sampling_AddDigiInByte_1;
	T_NMX_Sampling_AddDigiOutAll_1		Sampling_AddDigiOutAll_1;
	T_NMX_Sampling_AddDigiOutByte_1		Sampling_AddDigiOutByte_1;
	T_NMX_Sampling_SetTriggerDigiIn_1	Sampling_SetTriggerDigiIn_1;
	T_NMX_Sampling_PrepareTime_1		Sampling_PrepareTime_1;
	T_NMX_Sampling_PrepareCustomTFT_1   Sampling_PrepareCustomTFT_1;
	T_NMX_Sampling_PreparePosition_1	Sampling_PreparePosition_1;
	T_NMX_Sampling_Start_1				Sampling_Start_1;
	T_NMX_Sampling_Stop_1				Sampling_Stop_1;
	T_NMX_Sampling_ReadColumn32_1		Sampling_ReadColumn32_1;
	T_NMX_Sampling_ReadRow32_1			Sampling_ReadRow32_1;
	T_NMX_Sampling_GetStatus_1			Sampling_GetStatus_1;
	T_NMX_DiagClearEvent_1				DiagClearEvent_1;
	T_NMX_DiagGetEventText_1			DiagGetEventText_1;
	T_NMX_SetDateTime_1					SetDateTime_1;
private:
	HINSTANCE hNmxDll;
};

