#include "stdafx.h"
#include "ChannelData.h"

namespace CppCLR_WinformsProjekt {


	ChannelData::ChannelData()
	{
		fdFactor = 1.0f;
		slStaticValue = 0x7FFFFFFF;
		ResetStaticMinMax();
		strUnit = "Digit";
		ulNDigits = 0;
	}


	void ChannelData::NewStaticValue(signed long slValue)
	{
		/* Update Min / Max */
		if (slValue < slStaticMin) {
			slStaticMin = slValue;
		}

		if (slValue > slStaticMax) {
			slStaticMax = slValue;
		}

		/* Update value */
		slStaticValue = slValue;
	}


	signed long ChannelData::GetNewestValue(void)
	{
		return slStaticValue;
	}


	void ChannelData::ResetStaticMinMax(void)
	{
		slStaticMin = 0x7FFFFFFF;
		slStaticMax = 0x80000000;
	}


	signed long ChannelData::GetStaticDiff(void)
	{
		if (slStaticMax >= slStaticMin) {
			return (slStaticMax - slStaticMin);
		}
		return 0x7FFFFFFF;
	}

	String^ ChannelData::GetStaticUnitValue(void)
	{
		String^ strFormat = String::Format("F{0}", ulNDigits);
		double fdValue = (double)slStaticValue * fdFactor;
		return fdValue.ToString(strFormat) + " " + strUnit;
	}


	String^ ChannelData::GetStaticUnitMin(void)
	{
		String^ strFormat = String::Format("F{0}", ulNDigits);
		double fdValue = (double)slStaticMin * fdFactor;
		return fdValue.ToString(strFormat) + " " + strUnit;
	}


	String^ ChannelData::GetStaticUnitMax(void)
	{
		String^ strFormat = String::Format("F{0}", ulNDigits);
		double fdValue = (double)slStaticMax * fdFactor;
		return fdValue.ToString(strFormat) + " " + strUnit;
	}


	String^ ChannelData::GetStaticUnitDiff(void)
	{
		String^ strFormat = String::Format("F{0}", ulNDigits);
		double fdValue = (double)GetStaticDiff() * fdFactor;
		return fdValue.ToString(strFormat) + " " + strUnit;
	}


}