//****************************************************************************
//*
//*                           NmxApi.h
//*
//****************************************************************************
//*   Platform:  Windows
//*   Version:   $VERSION$  
//****************************************************************************
//*   Purpose:      
//*      API specification for NmxDLL
//*
//****************************************************************************
//*             (c) Messtechnik Sachs GmbH, 73614 Schorndorf
//****************************************************************************
#pragma once


/* ---------------------------------------------------------------------------
* Common definitions
* ---------------------------------------------------------------------------*/
#define NMX_DECL_EXPORT		__declspec(dllexport)
#define NMX_CALLCONV		__stdcall
#define NMX_EXTC			extern "C"
typedef void* NMX_PHANDLE;	/* Device handle */

/* General limitations */
#define MAX_BOXES				((unsigned long)64)
#define MAX_CHANNELS			((unsigned long)256)
#define MAX_DIGI_BYTES			((unsigned long)128)
#define MAX_SAMPLING_ELEMENTS	((unsigned long)512)


/* ---------------------------------------------------------------------------
* Function return codes
* ---------------------------------------------------------------------------*/
typedef unsigned long NMX_STATUS;
/* General */
#define NST_SUCCESS							((NMX_STATUS)0x00000000)	/* Everything ok */
#define NST_HANDLE_INVALID					((NMX_STATUS)0xF0000000)	/* Invalid device handle */
#define NST_HANDLE_TOO_MANY					((NMX_STATUS)0xF0000001)	/* Too many handles exist */
#define NST_CONNECT_OPEN_FAILED				((NMX_STATUS)0xF0000010)	/* Failed to open a connection */
#define NST_NOT_CONNECTED					((NMX_STATUS)0xF0000011)	/* No connection established */
#define NST_NOT_AVAILABLE					((NMX_STATUS)0xF000001F)	/* Data not available */
#define NST_SEND_SIZE_TOO_LARGE				((NMX_STATUS)0xF0000020)	/* Too much data to send */
#define NST_DX_TIMEOUT_1					((NMX_STATUS)0xF0000021)	/* Data exchange timeout (type 1) */
#define NST_DX_TIMEOUT_2					((NMX_STATUS)0xF0000022)	/* Data exchange timeout (type 2) */
#define NST_DX_TIMEOUT_COMMON				((NMX_STATUS)0xF0000023)	/* General data exchange timeout */
#define NST_INV_RESP						((NMX_STATUS)0xF0000030)	/* Invalid response received from device */
#define NST_RESP_ERR						((NMX_STATUS)0xF0000031)	/* Device response contained error code */
#define NST_REQ_VERS_NOSUPPORT				((NMX_STATUS)0xF0000032)	/* Request version not supported by device */

#define NST_BOXNO_INVALID					((NMX_STATUS)0xF0000040)	/* Invalid box number */
#define NST_CHANNEL_INVALID					((NMX_STATUS)0xF0000041)	/* Invalid channel number */
#define NST_DIGIIN_INVALID					((NMX_STATUS)0xF0000042)	/* Invalid digital input byte number */
#define NST_DIGIOUT_INVALID					((NMX_STATUS)0xF0000043)	/* Invalid digital output byte number */
#define NST_STRING_INVALID					((NMX_STATUS)0xF0000047)	/* Invalid string */

#define NST_DATA_TOOLARGE					((NMX_STATUS)0xF0000048)	/* Data provided in the parameters list is too large */

#define NST_NOTIFICATION_UNKNOWN			((NMX_STATUS)0xF0000050)	/* Unknown notification type */

/* Sampling */
#define NST_SAMPLING_TOOMANY_ELEMENTS		((NMX_STATUS)0xF0000100)	/* Too many sampling channels defined */
#define NST_SAMPLING_GUID_INVALID			((NMX_STATUS)0xF0000101)	/* Sampling configuration is invalid (e.g. configured in parallel by other software) */
#define NST_SAMPLING_NO_ELEMENTS			((NMX_STATUS)0xF0000102)	/* No elements selected for sampling */
#define NST_SAMPLING_DOUBLE_ELEMENT			((NMX_STATUS)0xF0000103)	/* An element is already part of the sampling list and therefore cannot be added */
#define NST_SAMPLING_INVALID_CHANNELNO		((NMX_STATUS)0xF0000104)	/* The channel number is invalid */
#define NST_SAMPLING_INVALID_ELEMENTNO		((NMX_STATUS)0xF0000105)	/* The number of the sampling element is invalid */
#define NST_SAMPLING_ALREADY_STARTED		((NMX_STATUS)0xF0000106)	/* Action cannot be done, because sampling has already been prepared / started. */
#define NST_SAMPLING_INVALID_BITNO			((NMX_STATUS)0xF0000107)	/* Invalid digital input or output bit number */
#define NST_SAMPLING_INVALID_TRGMODE		((NMX_STATUS)0xF0000108)	/* Invalid trigger mode */
#define NST_SAMPLING_INVALID_TRGPOL			((NMX_STATUS)0xF0000109)	/* Invalid trigger polarity */
#define NST_SAMPLING_ELEMENTS_NOACCEPT		((NMX_STATUS)0xF0000120)	/* The list of sampling elements has not been accepted by the device */
#define NST_SAMPLING_INVALID_PERIOD			((NMX_STATUS)0xF0000121)	/* Invalid sampling period */
#define NST_SAMPLING_INVALID_MAXSAMPLES		((NMX_STATUS)0xF0000122)	/* Maximum number of measurement samples is invalid */
#define NST_SAMPLING_START_FAILED			((NMX_STATUS)0xF0000130)	/* Starting Sampling failed */
#define NST_SAMPLING_START_CONFIG			((NMX_STATUS)0xF0000131)	/* Sampling cannot be started due to invalid configuration */
#define NST_SAMPLING_START_NOTPREPARED		((NMX_STATUS)0xF0000132)	/* Sampling has not been prepared and therefore cannot be started */
#define NST_SAMPLING_NO_DATA_AVAILABLE		((NMX_STATUS)0xF0000140)	/* No data is available for readout */
#define NST_SAMPLING_READ_DATA_ERROR		((NMX_STATUS)0xF0000141)	/* General error reading sampled data */
#define NST_SAMPLING_NOTENOUGH_MEMORY		((NMX_STATUS)0xF00001F8)	/* Not enough memory for allocating internal sampling buffers */
#define NST_SAMPLING_INTERNAL				((NMX_STATUS)0xF00001FF)	/* Internal sampling error */

/* High-level sampling */
#define NST_HLSAMPLING_INVALID_FILTPERIOD	((NMX_STATUS)0xF0000200)	/* Invalid filter period */
#define NST_HLSAMPLING_INVALID_SCALE		((NMX_STATUS)0xF0000201)	/* Invalid scale factor (zero or invalid floating point value) */
#define NST_HLSAMPLING_INVALID_START		((NMX_STATUS)0xF0000202)	/* Invalid start value (invalid floating point value) */
#define NST_HLSAMPLING_INVALID_DISTANCE		((NMX_STATUS)0xF0000203)	/* Invalid distance value (zero or invalid floating point value) */

/* DLL Internal */
#define NST_INTERNAL_SEQ					((NMX_STATUS)0xF0001000)	/* Internal sequence error */
#define NST_INVALID_EVENT					((NMX_STATUS)0xF0001001)	/* Invalid internal event */

/* ---------------------------------------------------------------------------
* Notifications, which can be triggered by the NmxDll
* ---------------------------------------------------------------------------*/
#define NMXNOTIFY_DISCONNECTED					((UINT32)0x00000002)	/* Connection closed */
#define NMXNOTIFY_FAILURE_DATA_EXCHANGE			((UINT32)0x00000003)	/* Permanent failure during data exchange (e.g. timeout) */
#define NMXNOTIFY_RECONNECTED					((UINT32)0x00000004)	/* Reconnected after data exchange failure */
#define NMXNOTIFY_NEW_STATIC32					((UINT32)0x00000010)	/* New static data available */
#define NMXNOTIFY_SAMPLING_NEW_DATA				((UINT32)0x00000020)	/* New sampling data available */
#define NMXNOTIFY_SAMPLING_FINISHED				((UINT32)0x00000021)	/* Sampling has been finished */
#define NMXNOTIFY_SAMPLING_ALL_DATA_RECEIVED	((UINT32)0x00000022)	/* All sampled data has been received */
#define NMXNOTIFY_SAMPLING_ERROR				((UINT32)0x00000028)	/* An error occured during sampling */
#define NMXNOTIFY_SAMPLING_BUFFER_OVERFLOW		((UINT32)0x00000029)	/* A buffer overflow occured: application has not read data */
#define NMXNOTIFY_SAMPLING_TIMEOUT				((UINT32)0x0000002A)	/* A timeout occured during sampling. (-> Multiple root causes / no new data received) */

/* ---------------------------------------------------------------------------
* Measurement channel raw data types
* ---------------------------------------------------------------------------*/
#define DTRAW_UNKNOWN			((SINT32)0)		/* Unknown raw data type */
#define DTRAW_SINT08			((SINT32)1)		/* Signed character (byte) */
#define DTRAW_SINT16			((SINT32)2)		/* Signed short integer (single word) */
#define DTRAW_SINT32			((SINT32)4)		/* Signed long integer (double word) */
#define DTRAW_SINT64			((SINT32)8)		/* Signed long long integer */

/* ---------------------------------------------------------------------------
* API functions
* ---------------------------------------------------------------------------*/
NMX_EXTC NMX_DECL_EXPORT void NMX_CALLCONV NMX_GetDllVersion_1(
	unsigned short* pusMajor,
	unsigned short* pusMinor,
	unsigned short* pusPatch,
	unsigned short* pusBuild);
typedef void (NMX_CALLCONV *T_NMX_GetDllVersion_1)(
	unsigned short* pusMajor,
	unsigned short* pusMinor,
	unsigned short* usPatch,
	unsigned short* usBuild);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_DeviceIPv4Open_1(
	unsigned char ucIp3,
	unsigned char ucIp2,
	unsigned char ucIp1,
	unsigned char ucIp0,
	unsigned short usPortCmd,
	unsigned short usPortData,
	NMX_PHANDLE *ppHandle);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_DeviceIPv4Open_1)(
	unsigned char ucIp3,
	unsigned char ucIp2,
	unsigned char ucIp1,
	unsigned char ucIp0,
	unsigned short usPortCmd,
	unsigned short usPortData,
	NMX_PHANDLE *ppHandle);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_DeviceClose_1(
	NMX_PHANDLE *ppHandle);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_DeviceClose_1)(
	NMX_PHANDLE *ppHandle);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_GetBoxCount_1(
	NMX_PHANDLE pHandle,
	unsigned long* pulBoxCount);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_GetBoxCount_1)(
	NMX_PHANDLE pHandle,
	unsigned long* pulBoxCount);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_GetBoxInfo_1(
	NMX_PHANDLE pHandle,
	unsigned long ulBoxNo,
	unsigned long* pulInfoData, unsigned long ulInfoDataNElements,
	unsigned long long* pudMacAddress,
	char* pcSerNo, unsigned long ulSizeofSerNo,
	char* pcProdCode, unsigned long ulSizeofProdCode,
	char* pcOrderNo, unsigned long ulSizeofOrderNo,
	char* pcName, unsigned long ulSizeofName);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_GetBoxInfo_1)(
	NMX_PHANDLE pHandle,
	unsigned long ulBoxNo,
	unsigned long* pulInfoData, unsigned long ulInfoDataNElements,
	unsigned long long* pudMacAddress,
	char* pcSerNo, unsigned long ulSizeofSerNo,
	char* pcProdCode, unsigned long ulSizeofProdCode,
	char* pcOrderNo, unsigned long ulSizeofOrderNo,
	char* pcName, unsigned long ulSizeofName);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_UpdateChannelInfo_1(
	NMX_PHANDLE pHandle);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_UpdateChannelInfo_1)(
	NMX_PHANDLE pHandle);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_GetChannelCount_1(
	NMX_PHANDLE pHandle,
	unsigned long* pulChannelCount,
	unsigned long* pulNDigitalInputBytes,
	unsigned long* pulNDigitalOutputBytes);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_GetChannelCount_1)(
	NMX_PHANDLE pHandle,
	unsigned long* pulChannelCount,
	unsigned long* pulNDigitalInputBytes,
	unsigned long* pulNDigitalOutputBytes);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_GetChannelInfo_1(
	NMX_PHANDLE pHandle,
	unsigned long ulChannelNo,
	unsigned long* pulChannelType,
	unsigned long* pulNDigits,
	unsigned long* pulBoxNo,
	unsigned long* pulReserved,
	unsigned long* pulBoxChannelNo,
	signed long* pslRawDataType,
	signed long* pslFactNumerator,
	signed long* pslFactDenominator,
	float* pflFactDigitsToUnit,
	char* pcUnit, unsigned long ulSizeofUnit,
	char* pcOrderNo, unsigned long ulSizeofOrderNo,
	char* pcSerialNo, unsigned long ulSizeofSerialNo);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_GetChannelInfo_1)(
	NMX_PHANDLE pHandle,
	unsigned long ulChannelNo,
	unsigned long* pulChannelType,
	unsigned long* pulNDigits,
	unsigned long* pulBoxNo,
	unsigned long* pulReserved,
	unsigned long* pulBoxChannelNo,
	signed long* pslRawDataType,
	signed long* pslFactNumerator,
	signed long* pslFactDenominator,
	float* pflFactDigitsToUnit,
	char* pcUnit, unsigned long ulSizeofUnit,
	char* pcOrderNo, unsigned long ulSizeofOrderNo,
	char* pcSerialNo, unsigned long ulSizeofSerialNo);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_GetDigitalInputInfo_1(
	NMX_PHANDLE pHandle,
	unsigned long ulInputByteNo,
	unsigned long* pulBoxNo,
	unsigned long* pulBoxByteNo);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_GetDigitalInputInfo_1)(
	NMX_PHANDLE pHandle,
	unsigned long ulInputByteNo,
	unsigned long* pulBoxNo,
	unsigned long* pulBoxByteNo);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_GetDigitalOutputInfo_1(
	NMX_PHANDLE pHandle,
	unsigned long ulOutputByteNo,
	unsigned long* pulBoxNo,
	unsigned long* pulBoxByteNo);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_GetDigitalOutputInfo_1)(
	NMX_PHANDLE pHandle,
	unsigned long ulOutputByteNo,
	unsigned long* pulBoxNo,
	unsigned long* pulBoxByteNo);


NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_RegisterMessage_1(
	NMX_PHANDLE pHandle,
	unsigned long ulNotification,
	HWND hWnd,
	unsigned long ulMsgCode,
	WPARAM tWParam,
	LPARAM tLParam);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_RegisterMessage_1)(
	NMX_PHANDLE pHandle,
	unsigned long ulNotification,
	HWND hWnd,
	unsigned long ulMsgCode,
	WPARAM tWParam,
	LPARAM tLParam);

typedef void NMX_CALLCONV NMX_NOTIFICATION_CALLBACK(IN void* pvContext);
NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_RegisterCallback_1(
	NMX_PHANDLE pHandle,
	unsigned long ulNotification,
	NMX_NOTIFICATION_CALLBACK* pCbFunction,
	void* pvContext);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_RegisterCallback_1)(
	NMX_PHANDLE pHandle,
	unsigned long ulNotification,
	NMX_NOTIFICATION_CALLBACK* pCbFunction,
	void* pvContext);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_ChannelSetParameter_1(
	NMX_PHANDLE pHandle,
	unsigned long ulChannelNo,
	char* pcStringTx, unsigned long ulSizeofTxString,
	char* pcStringRx, unsigned long ulMaxSizeofRxString, unsigned long* pulSizeofRxString);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_ChannelSetParameter_1)(
	NMX_PHANDLE pHandle,
	unsigned long ulChannelNo,
	char* pcStringTx, unsigned long ulSizeofTxString,
	char* pcStringRx, unsigned long ulMaxSizeofRxString, unsigned long* pulSizeofRxString);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_ChannelSetConfig_1(
	NMX_PHANDLE pHandle,
	unsigned long ulChannelNo,
	char* pcStringTx, unsigned long ulSizeofTxString,
	char* pcStringRx, unsigned long ulMaxSizeofRxString, unsigned long* pulSizeofRxString);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_ChannelSetConfig_1)(
	NMX_PHANDLE pHandle,
	unsigned long ulChannelNo,
	char* pcStringTx, unsigned long ulSizeofTxString,
	char* pcStringRx, unsigned long ulMaxSizeofRxString, unsigned long* pulSizeofRxString);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_StaticGet32_1(
	NMX_PHANDLE pHandle,
	signed long aslValues[], unsigned long ulValuesNElements,
	unsigned char aucHardwareStatus[], unsigned long ulSizeofHardwareStatus,
	unsigned char aucDigiIn[], unsigned long ulSizeofDigiIn,
	unsigned char aucBoxStatus[], unsigned long ulSizeofBoxStatus,
	unsigned long* pulUpdateCtr);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_StaticGet32_1)(
	NMX_PHANDLE pHandle,
	signed long aslValues[], unsigned long ulValuesNElements,
	unsigned char aucHardwareStatus[], unsigned long ulSizeofHardwareStatus,
	unsigned char aucDigiIn[], unsigned long ulSizeofDigiIn,
	unsigned char aucBoxStatus[], unsigned long ulSizeofBoxStatus,
	unsigned long* pulUpdateCtr);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_StaticSetMedianDepth_1(
	NMX_PHANDLE pHandle,
	unsigned long ulMedianDepth);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_StaticSetMedianDepth_1)(
	NMX_PHANDLE pHandle,
	unsigned long ulMedianDepth);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_SetOutputs_1(
	NMX_PHANDLE pHandle,
	unsigned char* pucDigiOut, unsigned long ulSizeofDigiOut,
	unsigned char ucForceSendImmediately);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_SetOutputs_1)(
	NMX_PHANDLE pHandle,
	unsigned char* pucDigiOut, unsigned long ulSizeofDigiOut,
	unsigned char ucForceSendImmediately);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_DisableOutputUpdate_1(
	NMX_PHANDLE pHandle);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_DisableOutputUpdate_1)(
	NMX_PHANDLE pHandle);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_DigitalIoConfig_1(
	NMX_PHANDLE pHandle,
	unsigned char ucOutputResetEnabled);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_DigitalIoConfig_1)(
	NMX_PHANDLE pHandle,
	unsigned char ucOutputResetEnabled);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_DigitalOutputsGetState_1(
	NMX_PHANDLE pHandle,
	unsigned char* pucOutputState,
	unsigned long ulSizeofOutputState);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_DigitalOutputsGetState_1)(
	NMX_PHANDLE pHandle,
	unsigned char* pucOutputState,
	unsigned long ulSizeofOutputState);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_Sampling_GetMaxSpeed_1(
	NMX_PHANDLE pHandle,
	unsigned long *pulInSamplePeriodUs);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_Sampling_GetMaxSpeed_1)(
	NMX_PHANDLE pHandle,
	unsigned long *pulMinSamplePeriodUs);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_Sampling_Reset_1(
	NMX_PHANDLE pHandle);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_Sampling_Reset_1)(
	NMX_PHANDLE pHandle);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_Sampling_AddChannelsAll_1(
	NMX_PHANDLE pHandle,
	unsigned long* pulNElementsTotal);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_Sampling_AddChannelsAll_1)(
	NMX_PHANDLE pHandle,
	unsigned long* pulNElementsTotal);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_Sampling_AddChannel_1(
	NMX_PHANDLE pHandle,
	unsigned long ulChannelNumber,
	unsigned long* pulNElementsTotal);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_Sampling_AddChannel_1)(
	NMX_PHANDLE pHandle,
	unsigned long ulChannelNumber,
	unsigned long* pulNElementsTotal);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_Sampling_AddDigiInAll_1(
	NMX_PHANDLE pHandle,
	unsigned long* pulNElementsTotal);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_Sampling_AddDigiInAll_1)(
	NMX_PHANDLE pHandle,
	unsigned long* pulNElementsTotal);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_Sampling_AddDigiInByte_1(
	NMX_PHANDLE pHandle,
	unsigned long ulDigiInByteNo,
	unsigned long* pulNElementsTotal);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_Sampling_AddDigiInByte_1)(
	NMX_PHANDLE pHandle,
	unsigned long ulDigiInByteNo,
	unsigned long* pulNElementsTotal);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_Sampling_AddDigiOutAll_1(
	NMX_PHANDLE pHandle,
	unsigned long* pulNElementsTotal);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_Sampling_AddDigiOutAll_1)(
	NMX_PHANDLE pHandle,
	unsigned long* pulNElementsTotal);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_Sampling_AddDigiOutByte_1(
	NMX_PHANDLE pHandle,
	unsigned long ulDigiOutByteNo,
	unsigned long* pulNElementsTotal);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_Sampling_AddDigiOutByte_1)(
	NMX_PHANDLE pHandle,
	unsigned long ulDigiOutByteNo,
	unsigned long* pulNElementsTotal);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_Sampling_SetTriggerDigiIn_1(
	NMX_PHANDLE pHandle,
	unsigned long ulDigiInByteNo,
	unsigned long ulDigiInBitNo,
	unsigned long ulMode,
	unsigned long ulPolarity);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_Sampling_SetTriggerDigiIn_1)(
	NMX_PHANDLE pHandle,
	unsigned long ulDigiInByteNo,
	unsigned long ulDigiInBitNo,
	unsigned long ulMode,
	unsigned long ulPolarity);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_Sampling_PrepareTime_1(
	NMX_PHANDLE pHandle,
	unsigned long ulSamplePeriod,
	unsigned long ulDLLArrayLength,
	unsigned long long udMaxSamples);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_Sampling_PrepareTime_1)(
	NMX_PHANDLE pHandle,
	unsigned long ulSamplePeriod,
	unsigned long ulDLLArrayLength,
	unsigned long long udMaxSamples);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_Sampling_PrepareCustomTFT_1(
	NMX_PHANDLE pHandle,
	unsigned long ulSamplePeriod,
	unsigned long ulFilteredPeriod,
	unsigned long ulArrayLength,
	unsigned long long udMaxSamples,
	unsigned long ulNTailSamples,
	unsigned long ulTriggerDigiInByteNo,
	unsigned long ulTriggerDigiInBitNo,
	unsigned long ulTriggerMode,
	unsigned long ulTriggerPolarity);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_Sampling_PrepareCustomTFT_1)(
	NMX_PHANDLE pHandle,
	unsigned long ulSamplePeriod,
	unsigned long ulFilteredPeriod,
	unsigned long ulArrayLength,
	unsigned long long udMaxSamples,
	unsigned long ulNTailSamples,
	unsigned long ulTriggerDigiInByteNo,
	unsigned long ulTriggerDigiInBitNo,
	unsigned long ulTriggerMode,
	unsigned long ulTriggerPolarity);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_Sampling_PreparePosition_1(
	NMX_PHANDLE pHandle,
	unsigned long ulSamplePeriod,
	unsigned long ulArrayLength,
	unsigned long long udMaxSamples,
	unsigned long ulTriggerChannelNumber,
	double fdScale,
	double fdStart,
	double fdDistance);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_Sampling_PreparePosition_1)(
	NMX_PHANDLE pHandle,
	unsigned long ulSamplePeriod,
	unsigned long ulArrayLength,
	unsigned long long udMaxSamples,
	unsigned long ulTriggerChannelNumber,
	double fdScale,
	double fdStart,
	double fdDistance);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_Sampling_Start_1(
	NMX_PHANDLE pHandle);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_Sampling_Start_1)(
	NMX_PHANDLE pHandle);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_Sampling_Stop_1(
	NMX_PHANDLE pHandle);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_Sampling_Stop_1)(
	NMX_PHANDLE pHandle);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_Sampling_ReadColumn32_1(
	NMX_PHANDLE pHandle,
	signed long aslSamples[],
	unsigned long ulMaxSamples,
	unsigned long ulElementNo,
	unsigned long ulDoNotDelete,
	unsigned long* pulSamplesCopied,
	unsigned long long* pudNoFirstSample);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_Sampling_ReadColumn32_1)(
	NMX_PHANDLE pHandle,
	signed long aslSamples[],
	unsigned long ulMaxSamples,
	unsigned long ulElementNo,
	unsigned long ulDoNotDelete,
	unsigned long* pulSamplesCopied,
	unsigned long long* pudNoFirstSample);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_Sampling_ReadRow32_1(
	NMX_PHANDLE pHandle,
	signed long aslSamples[],
	unsigned long ulMaxSamples,
	unsigned long* pulSamplesCopied,
	unsigned long long* pudSampleNo);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_Sampling_ReadRow32_1)(
	NMX_PHANDLE pHandle,
	signed long aslSamples[],
	unsigned long ulMaxSamples,
	unsigned long* pulSamplesCopied,
	unsigned long long* pudSampleNo);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_Sampling_GetStatus_1(
	NMX_PHANDLE pHandle,
	unsigned char* pucStatus,
	unsigned long* pulNSamplingElements,
	unsigned long long* pudSamplesReceived,
	unsigned long long* pudMaxSamples);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_Sampling_GetStatus_1)(
	NMX_PHANDLE pHandle,
	unsigned char* pucStatus,
	unsigned long* pulNSamplingElements,
	unsigned long long* pudSamplesReceived,
	unsigned long long* pudMaxSamples);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_DiagClearEvent_1(
	NMX_PHANDLE pHandle,
	unsigned long ulBoxNo,
	unsigned char ucEventNo);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_DiagClearEvent_1)(
	NMX_PHANDLE pHandle,
	unsigned long ulBoxNo,
	unsigned char ucEventNo);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_DiagGetEventText_1(
	NMX_PHANDLE pHandle,
	unsigned char ucEventNo,
	char* pcText, unsigned long ulSizeofText);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_DiagGetEventText_1)(
	NMX_PHANDLE pHandle,
	unsigned char ucEventNo,
	char* pcText, unsigned long ulSizeofText);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_SetDateTime_1(
	NMX_PHANDLE pHandle);
typedef NMX_STATUS(NMX_CALLCONV *T_NMX_SetDateTime_1)(
	NMX_PHANDLE pHandle);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_SystemReset_1(
	NMX_PHANDLE pHandle,
	unsigned long ulDelayMaster,
	unsigned long ulDelaySlave);

NMX_EXTC NMX_DECL_EXPORT NMX_STATUS NMX_CALLCONV NMX_ExchangeString_1(
	NMX_PHANDLE pHandle,
	unsigned char ucDataCode,
	char* pcStringTx, unsigned long ulSizeofTxString,
	char* pcStringRx, unsigned long ulMaxSizeofRxString, unsigned long* pulSizeofRxString);

