@ECHO off
cd /d %~dp0
IF "%1" == "EMBEDDED" GOTO SILENT
ECHO.
ECHO BIOS update will start automatically.
ECHO Do not switch off the system.
ECHO.
ECHO The BIOS Update will take several minutes.
ECHO.
ECHO During the BIOS Update there will be no access to the system. 
ECHO.
ECHO Please do not use the keyboard or mouse. 
ECHO Please wait until you are asked to close the window.


:SILENT
SET DSKFLASHPATH=DSKFLASH.exe
IF "%1" == "EMBEDDED" (
REM In EMBEDDED mode DeskUpdate can control the reboot behavor    
    IF "%2" == "" (
        %DSKFLASHPATH% /UPD /OV /ARB /USEINSTALLED
    ) ELSE (
        %DSKFLASHPATH% /UPD /OV %2 /USEINSTALLED
    )
) ELSE (
    %DSKFLASHPATH% /UPD /OV /ARB /USEINSTALLED
)
ECHO.
ECHO done with return code %ERRORLEVEL%
ECHO.

IF ERRORLEVEL 1042 GOTO ERROR_SECURE_PLATFORM_UPDATE_REQUIRED
IF ERRORLEVEL 1041 GOTO ERROR_INCOMPATIBLE_INSTALLED_FEATURE_VERSION
IF ERRORLEVEL 1040 GOTO ERROR_TXT_HW_NOT_SUPPORTED
IF ERRORLEVEL 1039 GOTO ERROR_TXT_CANCELLED_BYUSER
IF ERRORLEVEL 1038 GOTO ERROR_TXT_ENABLED
IF ERRORLEVEL 1037 GOTO ERROR_ACCESS_DENIED
IF ERRORLEVEL 1036 GOTO ERROR_BIOS_VERSION_NOT_UPDATE_COMPATIBLE
IF ERRORLEVEL 1035 GOTO ERROR_DOWNGRADING_PROHIBITED
IF ERRORLEVEL 1034 GOTO ERROR_IGNOREAC_NOT_SUPPORTED
IF ERRORLEVEL 1033 GOTO ERROR_BATTERY_CAPACATY_NOT_RECOGNIZEABLE_CONNECT_AC
IF ERRORLEVEL 1032 GOTO ERROR_NO_AC_ADAPTER_RECOGNIZEABLE
IF ERRORLEVEL 1031 GOTO ERROR_AC_ADAPTER_NOT_CONNECTED
IF ERRORLEVEL 1030 GOTO ERROR_BATTERY_NOT_ATTACHED
IF ERRORLEVEL 1029 GOTO ERROR_BATTERY_CAPACATY_NOT_RECOGNIZEABLE_HELPDESK
IF ERRORLEVEL 1028 GOTO ERROR_REMAINING_BATTERY_CAPACATY_TOO_LOW
IF ERRORLEVEL 1027 GOTO ERROR_BATTERY_NOT_ATTACHED
IF ERRORLEVEL 1026 GOTO ERROR_BATTERY_CAPACATY_NOT_RECOGNIZEABLE_NO_W_PARAM
IF ERRORLEVEL 1025 GOTO ERROR_BATTERY_CAPACITY_LOW_PLEASE_CHARGE
IF ERRORLEVEL 1024 GOTO ERROR_BITLOCKER_PROTECTED_DRIVES


IF ERRORLEVEL 310 GOTO ERROR_INTERNAL
IF ERRORLEVEL 307 GOTO ERROR_EXECUTION_INTERRUPTED
IF ERRORLEVEL 306 GOTO ERROR_INSUFFICIENT_PRIVILEGES
IF ERRORLEVEL 305 GOTO ERROR_UNSUPPORTED_OS
IF ERRORLEVEL 304 GOTO ERROR_DESKVIEW_5_INSTALLED
IF ERRORLEVEL 303 GOTO ERROR_INCOMPATIBLE_APPLICATION_RUNNING
IF ERRORLEVEL 302 GOTO ERROR_INSTANCE_RUNNING
IF ERRORLEVEL 301 GOTO ERROR_REBOOT_NEEDED
IF ERRORLEVEL 300 GOTO ERROR_INSTALLED_BUT_PATH_NOT_FOUND

IF ERRORLEVEL 64 GOTO ERROR_INSUFFICIENT_PRIVILEGES
IF ERRORLEVEL 32 GOTO ERROR_MISSING_CONFIRMATION
IF ERRORLEVEL 22 GOTO ERROR_ELEVATION_REQUIRED
IF ERRORLEVEL 16 GOTO ERROR_INSUFFICIENT_DISKSPACE
IF ERRORLEVEL 8 GOTO ERROR_NO_VALID_BIOSFILE
IF ERRORLEVEL 4 GOTO ERROR_SYNTAX
IF ERRORLEVEL 2 GOTO ERROR_GENERAL
IF ERRORLEVEL 1 GOTO WARNING
IF ERRORLEVEL 0 GOTO SUCCESS

REM 1024
:ERROR_BITLOCKER_PROTECTED_DRIVES
ECHO No update action possible with Bitlocker protected drives
GOTO END

REM 1025
:ERROR_BATTERY_CAPACITY_LOW_PLEASE_CHARGE
ECHO The remaining battery capacity is too low. Please charge the battery or
ECHO do not use /W parameter.
GOTO END

REM 1026
:ERROR_BATTERY_CAPACATY_NOT_RECOGNIZEABLE_NO_W_PARAM
ECHO The battery capacity couldn't be recognized. Please do not 
ECHO use /W parameter.
GOTO END

REM 1027
:ERROR_BATTERY_NOT_ATTACHED
ECHO The battery is not attached. Please plug in charged battery or do not 
ECHO use /W parameter.
GOTO END

REM 1028
:ERROR_REMAINING_BATTERY_CAPACATY_TOO_LOW
ECHO The remaining battery capacity is too low. Please charge the battery 
ECHO and try again.
GOTO END

REM 1029
:ERROR_BATTERY_CAPACATY_NOT_RECOGNIZEABLE_HELPDESK
ECHO Could not recognize battery capacity on the notebook system. Please 
ECHO contact support helpdesk.
GOTO END

REM 1030
:ERROR_BATTERY_NOT_ATTACHED
ECHO The battery is not attached. Please plug in charged battery and 
ECHO try again.
GOTO END

REM 1031
:ERROR_AC_ADAPTER_NOT_CONNECTED
ECHO AC adapter is not connected on the notebook system. Please plug in AC 
ECHO adapter cable.
GOTO END

REM 1032
:ERROR_NO_AC_ADAPTER_RECOGNIZEABLE
ECHO Could not recognize AC adapter on the notebook system. Please contact 
ECHO support helpdesk.
GOTO END

REM 1033
:ERROR_BATTERY_CAPACATY_NOT_RECOGNIZEABLE_CONNECT_AC
ECHO The battery capacity couldn't be recognized. Please connect AC adapter 
ECHO and do not use /W parameter.
GOTO END

REM 1034
:ERROR_IGNOREAC_NOT_SUPPORTED
ECHO /IGNOREAC parameter is not supported on this system.
GOTO END

REM 1035
:ERROR_DOWNGRADING_PROHIBITED
ECHO Downgrading to this BIOS version is prohibited.
GOTO END

REM 1036
:ERROR_BIOS_VERSION_NOT_UPDATE_COMPATIBLE
ECHO The BIOS version in the file is not update compatible with the version installed.
GOTO END

REM 1037
:ERROR_ACCESS_DENIED
ECHO Access denied.
GOTO END

REM 1038
:ERROR_TXT_ENABLED
ECHO No update action possible with TXT processor extension enabled.
GOTO END

REM 1039
:ERROR_TXT_CANCELLED_BYUSER
ECHO Operation has been cancelled by user.
GOTO END

REM 1040
:ERROR_TXT_HW_NOT_SUPPORTED
ECHO Hardware not supported (no supporting module found).
GOTO END

REM 1041
:ERROR_INCOMPATIBLE_INSTALLED_FEATURE_VERSION
ECHO DeskFlash is already installed but the version is incompatible.
GOTO END

REM 1042
:ERROR_SECURE_PLATFORM_UPDATE_REQUIRED
ECHO Update to a DeskFlash compatible BIOS version is required. Please update the
ECHO BIOS using the appropriate FJJ version, e.g. 2.08FJJ.
GOTO END

:ERROR_INTERNAL
ECHO Internal error.
GOTO END

REM  307
:ERROR_EXECUTION_INTERRUPTED
ECHO Execution interrupted without system modifications
GOTO END

:ERROR_UNSUPPORTED_OS
ECHO Unsupported operating system.
GOTO END

:ERROR_DESKVIEW_5_INSTALLED
ECHO DeskFlash cannot run on a computer with DeskView 5 installed.
GOTO END

:ERROR_INCOMPATIBLE_APPLICATION_RUNNING
ECHO An incompatible application is currently running. Try again later.
GOTO END

:ERROR_INSTANCE_RUNNING
ECHO An instance of 'DeskView Instant' is already running. Try again later.
GOTO END

:ERROR_REBOOT_NEEDED
ECHO Computer needs to be restarted before DeskFlash can run.
GOTO END

:ERROR_INSTALLED_BUT_PATH_NOT_FOUND
ECHO The DeskFlash installation on this system seems to be damaged!
ECHO Please uninstall or reinstall DeskFlash.
GOTO END

:ERROR_INSUFFICIENT_PRIVILEGES
ECHO Insufficient privileges
GOTO END

:ERROR_MISSING_CONFIRMATION
ECHO Missing confirmations for action
GOTO END

:ERROR_ELEVATION_REQUIRED
ECHO The requested operation requires elevation.
GOTO END

:ERROR_INSUFFICIENT_DISKSPACE
ECHO Insufficient disk space
GOTO END

:ERROR_NO_VALID_BIOSFILE
ECHO No valid BIOS file found!
ECHO Maybe the BIOS file does not fit your system. Please check the Fujitsu 
ECHO service website for a suitable update file or use the tool DeskUpdate 
ECHO for an automated BIOS update.
GOTO END

:ERROR_SYNTAX
ECHO Syntax error in command line
GOTO END

:ERROR_GENERAL
ECHO This package cannot run on this system.
ECHO Maybe the BIOS file does not fit your system. Please check the Fujitsu 
ECHO service website for a suitable update file or use the tool DeskUpdate 
ECHO for an automated BIOS update.
GOTO END

:WARNING
ECHO.
ECHO BIOS update has finished but reported a warning.

:SUCCESS
ECHO.
ECHO BIOS update has finished successfully and will take effect after reboot.

:END
ECHO.
ECHO This window can be closed now.

IF NOT "%1" == "EMBEDDED" Pause>nul
EXIT %ERRORLEVEL%
