/*
 * Copyright(c) 2007 - 2009 Intel Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59
 * Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * The full GNU General Public License is included in this distribution in the
 * file called COPYING.
 */

#include <linux/cpu.h>

#ifndef register_hotcpu_notifier
	#ifdef CONFIG_HOTPLUG_CPU
		#define register_hotcpu_notifier(nb) register_cpu_notifier(nb)
	#else
		#define register_hotcpu_notifier(nb) do { } while(0)
	#endif
#endif

#ifndef unregister_hotcpu_notifier
	#ifdef CONFIG_HOTPLUG_CPU
		#define unregister_hotcpu_notifier(nb) unregister_cpu_notifier(nb)
	#else
		#define unregister_hotcpu_notifier(nb) do { } while(0)
	#endif
#endif

#include <linux/notifier.h>
#ifndef BLOCKING_NOTIFIER_HEAD
	#define BLOCKING_NOTIFIER_HEAD(name) struct notifier_block *name
	#define blocking_notifier_chain_register(head, nb) notifier_chain_register((head), (nb))
	#define blocking_notifier_chain_unregister(head, nb) notifier_chain_unregister((head), (nb))
	#define blocking_notifier_call_chain(head, val, v) notifier_call_chain((head), (val), (v))
#endif

#include <linux/version.h>
#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,18))
#define DCA_CLASS_SLES_VERSION
#endif

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,27))
#define IOAT_BEFORE_KERNEL_2_6_27_PATCHES
#endif

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,28))
#define IOAT_BEFORE_KERNEL_2_6_28_PATCHES
#endif
