/*
 * Copyright(c) 2007 - 2009 Intel Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59
 * Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * The full GNU General Public License is included in this distribution in the
 * file called COPYING.
 */

#include <linux/pci_ids.h>
#ifndef PCI_DEVICE_ID_INTEL_IOAT
	#define PCI_DEVICE_ID_INTEL_IOAT 0x1a38
#endif
#ifndef PCI_DEVICE_ID_INTEL_IOAT_CNB
	#define PCI_DEVICE_ID_INTEL_IOAT_CNB 0x360b
#endif
#ifndef PCI_DEVICE_ID_INTEL_IOAT_SNB
	#define PCI_DEVICE_ID_INTEL_IOAT_SNB 0x402f
#endif

#ifndef PCI_DEVICE_ID_INTEL_IOAT_TBG0
	#define PCI_DEVICE_ID_INTEL_IOAT_TBG0 0x3430
#endif
#ifndef PCI_DEVICE_ID_INTEL_IOAT_TBG1
	#define PCI_DEVICE_ID_INTEL_IOAT_TBG1 0x3431
#endif
#ifndef PCI_DEVICE_ID_INTEL_IOAT_TBG2
	#define PCI_DEVICE_ID_INTEL_IOAT_TBG2 0x3432
#endif
#ifndef PCI_DEVICE_ID_INTEL_IOAT_TBG3
	#define PCI_DEVICE_ID_INTEL_IOAT_TBG3 0x3433
#endif
#ifndef PCI_DEVICE_ID_INTEL_IOAT_TBG4
	#define PCI_DEVICE_ID_INTEL_IOAT_TBG4 0x3429
#endif
#ifndef PCI_DEVICE_ID_INTEL_IOAT_TBG5
	#define PCI_DEVICE_ID_INTEL_IOAT_TBG5 0x342a
#endif
#ifndef PCI_DEVICE_ID_INTEL_IOAT_TBG6
	#define PCI_DEVICE_ID_INTEL_IOAT_TBG6 0x342b
#endif
#ifndef PCI_DEVICE_ID_INTEL_IOAT_TBG7
	#define PCI_DEVICE_ID_INTEL_IOAT_TBG7 0x342c
#endif
 
#ifndef PCI_DEVICE_ID_INTEL_IOAT_SCNB
	#define PCI_DEVICE_ID_INTEL_IOAT_SCNB 0x65ff
#endif
#ifndef PCI_VENDOR_ID_UNISYS
	#define PCI_VENDOR_ID_UNISYS			0x1018
	#define PCI_DEVICE_ID_UNISYS_DMA_DIRECTOR	0x001C
#endif

#ifndef X86_FEATURE_DCA
	#define X86_FEATURE_DCA	(4*32+18) /* Direct Cache Access */
#endif

#include <linux/interrupt.h>
#ifndef IRQF_SHARED
	#define IRQF_SHARED SA_SHIRQ
#endif

#include <linux/version.h>
#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,19))
typedef irqreturn_t (*old_irq_handler_t)(int, void*, struct pt_regs *);
typedef irqreturn_t (*new_irq_handler_t)(int, void*);

static inline int __request_irq(unsigned int irq,
				new_irq_handler_t handler,
				unsigned long flags,
				const char *devname,
				void *dev_id)
{
	old_irq_handler_t old_handler = (old_irq_handler_t) handler;
	return request_irq(irq, old_handler, flags, devname, dev_id);
}

#define request_irq(irq, handler, flags, devname, dev_id) \
__request_irq((irq), (handler), (flags), (devname), (dev_id))
#endif

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,23))
#define IOAT_OLD_DMA_INTERFACE		1

#define dma_cap_set(a, b)		do { } while (0)
#define dma_async_tx_descriptor_init(tx, ch) \
			(tx)->chan = ch; \
			spin_lock_init(&(tx)->lock); \
			INIT_LIST_HEAD(&(tx)->depend_node); \
			INIT_LIST_HEAD(&(tx)->depend_list);
#endif

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,25))
#define IOAT_BEFORE_TX_ASYNC_PATCH
#endif

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,26))
#define IOAT_BEFORE_ACK_TO_FLAGS_PATCH
#endif

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,26))
#define IOAT_BEFORE_KILL_DEVICE_DEPENDENCY_ADDED_PATCH
#endif

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,27))
#define IOAT_BEFORE_KERNEL_2_6_27_PATCHES
#endif

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,29))
#define IOAT_BEFORE_KERNEL_2_6_29_PATCHES
#endif

#if (LINUX_VERSION_CODE > KERNEL_VERSION(2,6,26))
#define IOAT_TCP_DMA_COPYBREAK_PATCH
#endif
