/*******************************************************************************


"This software program is licensed subject to the GNU General Public License 
(GPL). Version 2, June 1991, available at 
<http://www.fsf.org/copyleft/gpl.html>"

GNU General Public License 

Version 2, June 1991

Copyright (C) 1989, 1991 Free Software Foundation, Inc.  
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA

Everyone is permitted to copy and distribute verbatim copies of this license
document, but changing it is not allowed.

Preamble

The licenses for most software are designed to take away your freedom to 
share and change it. By contrast, the GNU General Public License is intended
to guarantee your freedom to share and change free software--to make sure 
the software is free for all its users. This General Public License applies 
to most of the Free Software Foundation's software and to any other program 
whose authors commit to using it. (Some other Free Software Foundation 
software is covered by the GNU Library General Public License instead.) You 
can apply it to your programs, too.

When we speak of free software, we are referring to freedom, not price. Our
General Public Licenses are designed to make sure that you have the freedom 
to distribute copies of free software (and charge for this service if you 
wish), that you receive source code or can get it if you want it, that you 
can change the software or use pieces of it in new free programs; and that 
you know you can do these things.

To protect your rights, we need to make restrictions that forbid anyone to 
deny you these rights or to ask you to surrender the rights. These 
restrictions translate to certain responsibilities for you if you distribute
copies of the software, or if you modify it.

For example, if you distribute copies of such a program, whether gratis or 
for a fee, you must give the recipients all the rights that you have. You 
must make sure that they, too, receive or can get the source code. And you 
must show them these terms so they know their rights.
 
We protect your rights with two steps: (1) copyright the software, and (2) 
offer you this license which gives you legal permission to copy, distribute 
and/or modify the software. 

Also, for each author's protection and ours, we want to make certain that 
everyone understands that there is no warranty for this free software. If 
the software is modified by someone else and passed on, we want its 
recipients to know that what they have is not the original, so that any 
problems introduced by others will not reflect on the original authors' 
reputations. 

Finally, any free program is threatened constantly by software patents. We 
wish to avoid the danger that redistributors of a free program will 
individually obtain patent licenses, in effect making the program 
proprietary. To prevent this, we have made it clear that any patent must be 
licensed for everyone's free use or not licensed at all. 

The precise terms and conditions for copying, distribution and modification 
follow. 

TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

0. This License applies to any program or other work which contains a notice
   placed by the copyright holder saying it may be distributed under the 
   terms of this General Public License. The "Program", below, refers to any
   such program or work, and a "work based on the Program" means either the 
   Program or any derivative work under copyright law: that is to say, a 
   work containing the Program or a portion of it, either verbatim or with 
   modifications and/or translated into another language. (Hereinafter, 
   translation is included without limitation in the term "modification".) 
   Each licensee is addressed as "you". 

   Activities other than copying, distribution and modification are not 
   covered by this License; they are outside its scope. The act of running 
   the Program is not restricted, and the output from the Program is covered 
   only if its contents constitute a work based on the Program (independent 
   of having been made by running the Program). Whether that is true depends
   on what the Program does. 

1. You may copy and distribute verbatim copies of the Program's source code 
   as you receive it, in any medium, provided that you conspicuously and 
   appropriately publish on each copy an appropriate copyright notice and 
   disclaimer of warranty; keep intact all the notices that refer to this 
   License and to the absence of any warranty; and give any other recipients 
   of the Program a copy of this License along with the Program. 

   You may charge a fee for the physical act of transferring a copy, and you 
   may at your option offer warranty protection in exchange for a fee. 

2. You may modify your copy or copies of the Program or any portion of it, 
   thus forming a work based on the Program, and copy and distribute such 
   modifications or work under the terms of Section 1 above, provided that 
   you also meet all of these conditions: 

   * a) You must cause the modified files to carry prominent notices stating 
        that you changed the files and the date of any change. 

   * b) You must cause any work that you distribute or publish, that in 
        whole or in part contains or is derived from the Program or any part 
        thereof, to be licensed as a whole at no charge to all third parties
        under the terms of this License. 

   * c) If the modified program normally reads commands interactively when 
        run, you must cause it, when started running for such interactive 
        use in the most ordinary way, to print or display an announcement 
        including an appropriate copyright notice and a notice that there is
        no warranty (or else, saying that you provide a warranty) and that 
        users may redistribute the program under these conditions, and 
        telling the user how to view a copy of this License. (Exception: if 
        the Program itself is interactive but does not normally print such 
        an announcement, your work based on the Program is not required to 
        print an announcement.) 

   These requirements apply to the modified work as a whole. If identifiable 
   sections of that work are not derived from the Program, and can be 
   reasonably considered independent and separate works in themselves, then 
   this License, and its terms, do not apply to those sections when you 
   distribute them as separate works. But when you distribute the same 
   sections as part of a whole which is a work based on the Program, the 
   distribution of the whole must be on the terms of this License, whose 
   permissions for other licensees extend to the entire whole, and thus to 
   each and every part regardless of who wrote it. 

   Thus, it is not the intent of this section to claim rights or contest 
   your rights to work written entirely by you; rather, the intent is to 
   exercise the right to control the distribution of derivative or 
   collective works based on the Program. 

   In addition, mere aggregation of another work not based on the Program 
   with the Program (or with a work based on the Program) on a volume of a 
   storage or distribution medium does not bring the other work under the 
   scope of this License. 

3. You may copy and distribute the Program (or a work based on it, under 
   Section 2) in object code or executable form under the terms of Sections 
   1 and 2 above provided that you also do one of the following: 

   * a) Accompany it with the complete corresponding machine-readable source 
        code, which must be distributed under the terms of Sections 1 and 2 
        above on a medium customarily used for software interchange; or, 

   * b) Accompany it with a written offer, valid for at least three years, 
        to give any third party, for a charge no more than your cost of 
        physically performing source distribution, a complete machine-
        readable copy of the corresponding source code, to be distributed 
        under the terms of Sections 1 and 2 above on a medium customarily 
        used for software interchange; or, 

   * c) Accompany it with the information you received as to the offer to 
        distribute corresponding source code. (This alternative is allowed 
        only for noncommercial distribution and only if you received the 
        program in object code or executable form with such an offer, in 
        accord with Subsection b above.) 

   The source code for a work means the preferred form of the work for 
   making modifications to it. For an executable work, complete source code 
   means all the source code for all modules it contains, plus any 
   associated interface definition files, plus the scripts used to control 
   compilation and installation of the executable. However, as a special 
   exception, the source code distributed need not include anything that is 
   normally distributed (in either source or binary form) with the major 
   components (compiler, kernel, and so on) of the operating system on which
   the executable runs, unless that component itself accompanies the 
   executable. 

   If distribution of executable or object code is made by offering access 
   to copy from a designated place, then offering equivalent access to copy 
   the source code from the same place counts as distribution of the source 
   code, even though third parties are not compelled to copy the source 
   along with the object code. 

4. You may not copy, modify, sublicense, or distribute the Program except as
   expressly provided under this License. Any attempt otherwise to copy, 
   modify, sublicense or distribute the Program is void, and will 
   automatically terminate your rights under this License. However, parties 
   who have received copies, or rights, from you under this License will not
   have their licenses terminated so long as such parties remain in full 
   compliance. 

5. You are not required to accept this License, since you have not signed 
   it. However, nothing else grants you permission to modify or distribute 
   the Program or its derivative works. These actions are prohibited by law 
   if you do not accept this License. Therefore, by modifying or 
   distributing the Program (or any work based on the Program), you 
   indicate your acceptance of this License to do so, and all its terms and
   conditions for copying, distributing or modifying the Program or works 
   based on it. 

6. Each time you redistribute the Program (or any work based on the 
   Program), the recipient automatically receives a license from the 
   original licensor to copy, distribute or modify the Program subject to 
   these terms and conditions. You may not impose any further restrictions 
   on the recipients' exercise of the rights granted herein. You are not 
   responsible for enforcing compliance by third parties to this License. 

7. If, as a consequence of a court judgment or allegation of patent 
   infringement or for any other reason (not limited to patent issues), 
   conditions are imposed on you (whether by court order, agreement or 
   otherwise) that contradict the conditions of this License, they do not 
   excuse you from the conditions of this License. If you cannot distribute 
   so as to satisfy simultaneously your obligations under this License and 
   any other pertinent obligations, then as a consequence you may not 
   distribute the Program at all. For example, if a patent license would 
   not permit royalty-free redistribution of the Program by all those who 
   receive copies directly or indirectly through you, then the only way you 
   could satisfy both it and this License would be to refrain entirely from 
   distribution of the Program. 

   If any portion of this section is held invalid or unenforceable under any
   particular circumstance, the balance of the section is intended to apply
   and the section as a whole is intended to apply in other circumstances. 

   It is not the purpose of this section to induce you to infringe any 
   patents or other property right claims or to contest validity of any 
   such claims; this section has the sole purpose of protecting the 
   integrity of the free software distribution system, which is implemented 
   by public license practices. Many people have made generous contributions
   to the wide range of software distributed through that system in 
   reliance on consistent application of that system; it is up to the 
   author/donor to decide if he or she is willing to distribute software 
   through any other system and a licensee cannot impose that choice. 

   This section is intended to make thoroughly clear what is believed to be 
   a consequence of the rest of this License. 

8. If the distribution and/or use of the Program is restricted in certain 
   countries either by patents or by copyrighted interfaces, the original 
   copyright holder who places the Program under this License may add an 
   explicit geographical distribution limitation excluding those countries, 
   so that distribution is permitted only in or among countries not thus 
   excluded. In such case, this License incorporates the limitation as if 
   written in the body of this License. 

9. The Free Software Foundation may publish revised and/or new versions of 
   the General Public License from time to time. Such new versions will be 
   similar in spirit to the present version, but may differ in detail to 
   address new problems or concerns. 

   Each version is given a distinguishing version number. If the Program 
   specifies a version number of this License which applies to it and "any 
   later version", you have the option of following the terms and 
   conditions either of that version or of any later version published by 
   the Free Software Foundation. If the Program does not specify a version 
   number of this License, you may choose any version ever published by the 
   Free Software Foundation. 

10. If you wish to incorporate parts of the Program into other free programs
    whose distribution conditions are different, write to the author to ask 
    for permission. For software which is copyrighted by the Free Software 
    Foundation, write to the Free Software Foundation; we sometimes make 
    exceptions for this. Our decision will be guided by the two goals of 
    preserving the free status of all derivatives of our free software and 
    of promoting the sharing and reuse of software generally. 

   NO WARRANTY

11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY 
    FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN 
    OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES 
    PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER 
    EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
    WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE 
    ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH 
    YOU. SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL 
    NECESSARY SERVICING, REPAIR OR CORRECTION. 

12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING 
    WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR 
    REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR 
    DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL 
    DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM 
    (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED 
    INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF 
    THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER OR 
    OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. 

END OF TERMS AND CONDITIONS

How to Apply These Terms to Your New Programs

If you develop a new program, and you want it to be of the greatest 
possible use to the public, the best way to achieve this is to make it free 
software which everyone can redistribute and change under these terms. 

To do so, attach the following notices to the program. It is safest to 
attach them to the start of each source file to most effectively convey the
exclusion of warranty; and each file should have at least the "copyright" 
line and a pointer to where the full notice is found. 

one line to give the program's name and an idea of what it does.
Copyright (C) yyyy  name of author

This program is free software; you can redistribute it and/or modify it 
under the terms of the GNU General Public License as published by the Free 
Software Foundation; either version 2 of the License, or (at your option) 
any later version.

This program is distributed in the hope that it will be useful, but WITHOUT 
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details.

You should have received a copy of the GNU General Public License along with
this program; if not, write to the Free Software Foundation, Inc., 59 
Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Also add information on how to contact you by electronic and paper mail. 

If the program is interactive, make it output a short notice like this when 
it starts in an interactive mode: 

Gnomovision version 69, Copyright (C) year name of author Gnomovision comes 
with ABSOLUTELY NO WARRANTY; for details type 'show w'.  This is free 
software, and you are welcome to redistribute it under certain conditions; 
type 'show c' for details.

The hypothetical commands 'show w' and 'show c' should show the appropriate 
parts of the General Public License. Of course, the commands you use may be 
called something other than 'show w' and 'show c'; they could even be 
mouse-clicks or menu items--whatever suits your program. 

You should also get your employer (if you work as a programmer) or your 
school, if any, to sign a "copyright disclaimer" for the program, if 
necessary. Here is a sample; alter the names: 

Yoyodyne, Inc., hereby disclaims all copyright interest in the program 
'Gnomovision' (which makes passes at compilers) written by James Hacker.

signature of Ty Coon, 1 April 1989
Ty Coon, President of Vice

This General Public License does not permit incorporating your program into 
proprietary programs. If your program is a subroutine library, you may 
consider it more useful to permit linking proprietary applications with the 
library. If this is what you want to do, use the GNU Library General Public 
License instead of this License.

*******************************************************************************/

#include <linux/i2c.h>
#include <linux/i2c-sensor.h>
#include <linux/init.h>
#include <asm/semaphore.h>
#include <linux/slab.h>
#include <linux/module.h>
#include <linux/string.h>
#include <linux/errno.h>
#include <linux/workqueue.h>
#include <linux/sched.h>
#include <linux/reboot.h>
#include <linux/pm.h>
#include <linux/timer.h>
#include <linux/delay.h>
#include <linux/pci.h>

/****************************************************************
 * **************************************************************
 * general defines                                              *
 * **************************************************************
 * **************************************************************/
#define I2C_DRIVERID_ASFWDG 0x8086

#define WATCHDOG_OFF     0	
#define WATCHDOG_RUNNING 1
#define WATCHDOG_STOPPED 2

#define SMB_RETRY_COUNT 20

//per-device reboot notifiers have a higher priority than the global reboot notifier, 
//so they will be called first
#define ASFWDG_GLOBAL_REBOOT_NOTIFY_PRIORITY 	1
#define ASFWDG_DEVICE_REBOOT_NOTIFY_PRIORITY 	ASFWDG_GLOBAL_REBOOT_NOTIFY_PRIORITY+1	

#ifdef I2C_CLIENT_PEC
#define	ASF_I2C_PEC I2C_CLIENT_PEC
#else
/* temporary ride on unused I2C_M_TEN flag to request PEC transactions */
#define ASF_I2C_PEC (0x10|0x04)
#endif

#define REP_SMBUS_CMD(exp, count, pec)		\
do{						\
	if (pec == 1) {				\
		client->flags |= ASF_I2C_PEC;	\
	} else {				\
		client->flags &= ~ASF_I2C_PEC;	\
	}					\
	while((count--)>0)			\
		if((exp)>= 0) break;		\
		else mdelay(20);		\
} while(0);

#define CASF_DEVICE_POLL_CMD            0x01

#define CASF_SYSTEM_STATE_CMD           0x01
#define CASF_SET_SYSTEM_STATE_SUBCMD    0x18
#define CASF_SYSTEM_STATE_VERSION       0x10

#define CASF_SYSTEM_STATE_S0            0x00
#define CASF_SYSTEM_STATE_S1            0x01
#define CASF_SYSTEM_STATE_S2            0x02
#define CASF_SYSTEM_STATE_S3            0x03
#define CASF_SYSTEM_STATE_S4            0x04
#define CASF_SYSTEM_STATE_S5            0x05
#define CASF_SYSTEM_STATE_S45           0x06
#define CASF_SYSTEM_STATE_G3            0x07
#define CASF_SYSTEM_STATE_SLEEP         0x08
#define CASF_SYSTEM_STATE_G1            0x09
#define CASF_SYSTEM_STATE_ON            0x0B
#define CASF_SYSTEM_STATE_OFF           0x0C
#define CASF_SYSTEM_STATE_UNKNOWN       0x0E

#define CASF_WDTIMERMSG_CMD             0x02
#define CASF_WDSTARTTIMER_SUBCMD        0x13
#define CASF_WDSTOPTIMER_SUBCMD         0x14
#define CASF_WDTIMER_VERSION            0x10
#define CASF_WD_SENSORTYPE              0x20    //sensor type 20h (os hung)
#define CASF_WD_EVTTYPE                 0x6F    //event type
#define CASF_WD_EVTOFFSET               0x01    //event offset 01h(run-time stop) or 00h(timer expired)
#define CASF_WD_EVTSOURCETYPE           0x68    //event source type (68h - ASF 1.0 implementatoin)
#define CASF_WD_EVTSEVERITY             0x10    //event severity
#define CASF_WD_SENSORDEVICE            0xFF    //sensor device
#define CASF_WD_SENSORNO                0xFF    //sensor number
#define CASF_WD_ENTITY                  0x23    //entity(OS-entity)
#define CASF_WD_ENTITYINSTANCE          0x00    //enity instance

/****************************************************************
 * **************************************************************
 * functions prototypes                                         *
 * **************************************************************
 * **************************************************************/
/* module functions */
static int __init sensors_asfwdg_init(void);
static void __exit asfwdg_cleanup(void);
static int asfwdg_attach_adapter(struct i2c_adapter *adapter);
static int asfwdg_detach_client(struct i2c_client *client);
/* access functions */
static ssize_t show_addr(struct device *dev, char *buf);
static ssize_t set_addr(struct device *dev, const char *buf, size_t count);
static ssize_t show_last_reset_time(struct device *dev, char *buf);
static ssize_t set_last_reset_time(struct device *dev, const char *buf, size_t count);
static ssize_t show_interval(struct device *dev, char *buf);
static ssize_t set_interval(struct device *dev, const char *buf, size_t count);
static ssize_t show_start(struct device *dev, char *buf);
static ssize_t set_start(struct device *dev, const char *buf, size_t count);
static ssize_t show_pec(struct device *dev, char *buf);
static ssize_t set_pec(struct device *dev, const char *buf, size_t count);
static ssize_t show_rpec(struct device *dev, char *buf);
static ssize_t set_rpec(struct device *dev, const char *buf, size_t count);
/* work queue functions */
static void asfwdg_watchdog (void * data);
static void asfwdg_start_watchdog_process(struct i2c_client *client);
static void asfwdg_stop_watchdog_process(struct i2c_client *client);
static void asfwdg_watchdog_tick(unsigned long data);
/*SMBUS access functions*/
static void asfwdg_smbus_watchdog_cmd(struct i2c_client *client, int start);
static int asfwdg_smbus_device_type_poll_cmd(struct i2c_client *client);
static void asfwdg_smbus_system_state_cmd(struct i2c_client *client, u8 state);
static int asfwdg_reboot_notify(struct notifier_block *nt, unsigned long type,void *unused);
static int asfwdg_global_reboot_notify(struct notifier_block *nt, unsigned long type,void *unused);
/* PM functions */
#ifdef CONFIG_PM
static void asfwdg_pm_register(struct i2c_client *client);
static void asfwdg_pm_unregister(struct i2c_client *client);
static int asfwdg_pm_event(struct pm_dev *dev, pm_request_t rqst, void *data);
#endif

/****************************************************************
 * **************************************************************
 * creating the proper files in the sys fs                      *
 * **************************************************************
 * **************************************************************/
static DEVICE_ATTR(addr, S_IWUSR | S_IRUGO , show_addr, set_addr);
static DEVICE_ATTR(last_reset_time, S_IWUSR | S_IRUGO , show_last_reset_time, set_last_reset_time);
static DEVICE_ATTR(interval, S_IWUSR | S_IRUGO , show_interval, set_interval);
static DEVICE_ATTR(start, S_IWUSR | S_IRUGO , show_start, set_start);
static DEVICE_ATTR(pec, S_IWUSR | S_IRUGO , show_pec, set_pec);
static DEVICE_ATTR(rpec, S_IWUSR | S_IRUGO , show_rpec, set_rpec);

/****************************************************************
 * **************************************************************
 * struct definitions                                            *
 * **************************************************************
 * **************************************************************/
static struct i2c_driver asfwdg_driver = {
    owner:      THIS_MODULE,
	name:		"asfwdg",
	id:		I2C_DRIVERID_ASFWDG,
	flags:		I2C_DF_NOTIFY,
	attach_adapter:	&asfwdg_attach_adapter,
	detach_client:	&asfwdg_detach_client
};

struct asfwdg_notifier {
    struct notifier_block nt_block;
    struct i2c_client *client;
};

struct asfwdg_dat {
	struct semaphore lock;
	unsigned long last_watchdog_reset;
	int interval;
	int watchdog_status;
	int watchdog_on_suspend;
	int block_pec;
	int reg_pec;
	struct timer_list watchdog_timer;
	struct work_struct watchdog_wq;
	struct asfwdg_notifier reboot_notify;
	struct pm_dev *pm_dev_data; 
};

//static global reboot notifier
static struct notifier_block wd_global_nt_block;

/****************************************************************
 * **************************************************************
 * functions                                                    *
 * **************************************************************
 * **************************************************************/
static ssize_t show_addr(struct device *dev, char *buf)
{
	struct i2c_client *client = to_i2c_client(dev);
	struct asfwdg_dat * dat = (struct asfwdg_dat *)i2c_get_clientdata(client);
	unsigned long addr;
	
	down(&dat->lock);
	
	addr = client->addr;
	
	up(&dat->lock);
		
	return sprintf(buf, "%lu\n", addr);	
}

//====================================================================
//====================================================================
static ssize_t set_addr(struct device *dev, const char *buf, size_t count)
{
	struct i2c_client *client = to_i2c_client(dev);
	struct asfwdg_dat * dat = (struct asfwdg_dat *)i2c_get_clientdata(client);
	int watchdog_status = dat->watchdog_status;
	unsigned long addr = simple_strtoul(buf,NULL,10);
	
	down(&dat->lock);
	
	if ((addr < 0) || (addr > 0x80) || (addr == client->addr)) 
	{
    	up(&dat->lock);
    	return count;
    }

    if(watchdog_status == WATCHDOG_RUNNING)
    {
    	asfwdg_stop_watchdog_process(client);
        client->addr = addr;
        asfwdg_start_watchdog_process(client);
    }
    else 
    {
    	client->addr = addr;
    }

    printk(KERN_DEBUG "asfwdg: Address for %s set to %x\n", client->adapter->name, client->addr);
 
	up(&dat->lock);
	
	return count;
}

//====================================================================
//====================================================================
static ssize_t show_last_reset_time(struct device *dev, char *buf)
{
	struct i2c_client *client = to_i2c_client(dev);
	struct asfwdg_dat * dat = (struct asfwdg_dat *)i2c_get_clientdata(client);
	unsigned long lastWDreset;
		
	lastWDreset = dat->last_watchdog_reset / HZ;
	
	return sprintf(buf, "%lu\n",lastWDreset);	
}

//====================================================================
//====================================================================
static ssize_t set_last_reset_time(struct device *dev, const char *buf, size_t count)
{
	struct i2c_client *client = to_i2c_client(dev);
	struct asfwdg_dat * dat = (struct asfwdg_dat *)i2c_get_clientdata(client);
		
	dat->last_watchdog_reset = jiffies;
	
	return count;
}

//====================================================================
//====================================================================
static ssize_t show_interval(struct device *dev, char *buf)
{
	struct i2c_client *client = to_i2c_client(dev);
	struct asfwdg_dat * dat = (struct asfwdg_dat *)i2c_get_clientdata(client);
	unsigned long interval;
	
	down(&dat->lock);
	
	interval = dat->interval;
	
	up(&dat->lock);
		
	return sprintf(buf, "%lu\n", interval);	
}

//====================================================================
//====================================================================
static ssize_t set_interval(struct device *dev, const char *buf, size_t count)
{
	struct i2c_client *client = to_i2c_client(dev);
	struct asfwdg_dat * dat = (struct asfwdg_dat *)i2c_get_clientdata(client);
	int watchdog_status = dat->watchdog_status;
	unsigned long interval = simple_strtoul(buf,NULL,10);
		
	down(&dat->lock);
	
	if(interval > 0)
	{
	    dat->interval = interval;
     	printk(KERN_DEBUG "asfwdg: Set interval to %d for %s\n", dat->interval,client->adapter->name);
	    if (watchdog_status == WATCHDOG_RUNNING)
        {
        	asfwdg_stop_watchdog_process(client);
            asfwdg_start_watchdog_process(client);
        }
    }
 
	up(&dat->lock);
	
	return count;
}

//====================================================================
//====================================================================
static ssize_t show_start(struct device *dev, char *buf)
{
	struct i2c_client *client = to_i2c_client(dev);
	struct asfwdg_dat * dat = (struct asfwdg_dat *)i2c_get_clientdata(client);
	unsigned long status;
		
	down(&dat->lock);
	
	status = dat->watchdog_status;
	
	up(&dat->lock);
		
	return sprintf(buf, "%lu\n", status);	
}

//====================================================================
//====================================================================
static ssize_t set_start(struct device *dev, const char *buf, size_t count)
{
	struct i2c_client *client = to_i2c_client(dev);
	struct asfwdg_dat * dat = (struct asfwdg_dat *)i2c_get_clientdata(client);
	int watchdog_status = dat->watchdog_status;
	unsigned long status = simple_strtoul(buf,NULL,10);
		
	down(&dat->lock);
	
	if(status != watchdog_status)
	{
		if(status == 1 )
		{
        	if (!asfwdg_smbus_device_type_poll_cmd(client)) 
        	{
				asfwdg_start_watchdog_process(client);
            } 
            else 
            {
            	printk(KERN_DEBUG "asfwdg: Cannot start watchdog on "
                           "non-alerting device %s addr 0x%x\n",
                           client->adapter->name, client->addr);
                up(&dat->lock);
                return count;
            }
		} 
		else if(status == 0)
		{
			asfwdg_stop_watchdog_process(client);
		}
        printk(KERN_DEBUG "asfwdg: Watchdog status for %s set to %d\n",
                   client->adapter->name, dat->watchdog_status);
	} 
	else if (status == 0)
	{
			//send only SMBUS message
			asfwdg_smbus_watchdog_cmd(client, 0);
	}
		
 
	up(&dat->lock);
	
	return count;
}

//====================================================================
//====================================================================
static ssize_t show_pec(struct device *dev, char *buf)
{
	struct i2c_client *client = to_i2c_client(dev);
	struct asfwdg_dat * dat = (struct asfwdg_dat *)i2c_get_clientdata(client);
	unsigned long pec;
		
	down(&dat->lock);
	
	if (dat->block_pec)
		pec = 1;
	else 
		pec = 0;
	
	up(&dat->lock);
		
	return sprintf(buf, "%lu\n", pec);	
}

//====================================================================
//====================================================================
static ssize_t set_pec(struct device *dev, const char *buf, size_t count)
{
	struct i2c_client *client = to_i2c_client(dev);
	struct asfwdg_dat * dat = (struct asfwdg_dat *)i2c_get_clientdata(client);
	unsigned long pec = simple_strtoul(buf,NULL,10);
		
	down(&dat->lock);
	
	if (pec)
		dat->block_pec = 1;
	else 
		dat->block_pec = 0;
		
	up(&dat->lock);
	
	return count;
}

//====================================================================
//====================================================================
static ssize_t show_rpec(struct device *dev, char *buf)
{
	struct i2c_client *client = to_i2c_client(dev);
	struct asfwdg_dat * dat = (struct asfwdg_dat *)i2c_get_clientdata(client);
	unsigned long rpec;
	
	down(&dat->lock);
	
	if (dat->reg_pec)
		rpec = 1;
	else 
		rpec = 0;
	
	up(&dat->lock);
		
	return sprintf(buf, "%lu\n", rpec);		
}

//====================================================================
//====================================================================
static ssize_t set_rpec(struct device *dev, const char *buf, size_t count)
{
	struct i2c_client *client = to_i2c_client(dev);
	struct asfwdg_dat * dat = (struct asfwdg_dat *)i2c_get_clientdata(client);
	unsigned long rpec = simple_strtoul(buf,NULL,10);
		
	down(&dat->lock);
	
	if (rpec)
		dat->reg_pec = 1;
	else 
		dat->reg_pec = 0;
		
	up(&dat->lock);
	
	return count;
}

//===========================================================================
//===========================================================================
//===========================================================================

static void asfwdg_watchdog (void * data)
{
    struct i2c_client *client = (struct i2c_client *)data;
    struct asfwdg_dat * dat = (struct asfwdg_dat *)i2c_get_clientdata(client);

    if (dat->watchdog_status == WATCHDOG_OFF){
		asfwdg_smbus_watchdog_cmd(client, 0);
		dat->watchdog_status = WATCHDOG_STOPPED;
    } else {
		dat->last_watchdog_reset = jiffies;
		asfwdg_smbus_watchdog_cmd(client, 1);
    }
}

//====================================================================
//====================================================================
static void asfwdg_start_watchdog_process(struct i2c_client *client)
{
    struct asfwdg_dat * dat = (struct asfwdg_dat *)i2c_get_clientdata(client);
    
    dat->watchdog_status = WATCHDOG_RUNNING;
	INIT_WORK(&dat->watchdog_wq, asfwdg_watchdog, (void *) client);
    mod_timer(&dat->watchdog_timer, jiffies + 1);
    printk(KERN_DEBUG "asfwdg: Watchdog started on %s\n",
		   client->adapter->name);
}

//====================================================================
//====================================================================
static void asfwdg_stop_watchdog_process(struct i2c_client *client)
{
	struct asfwdg_dat * dat = (struct asfwdg_dat *)i2c_get_clientdata(client);
	
    if (dat->watchdog_status == WATCHDOG_RUNNING) {
		del_timer_sync(&dat->watchdog_timer);
        dat->watchdog_status = WATCHDOG_OFF;
		schedule_work(&dat->watchdog_wq);
        while(dat->watchdog_status != WATCHDOG_STOPPED){
			schedule();
        }
        printk(KERN_DEBUG "asfwdg: Watchdog stopped on %s\n",
               client->adapter->name);
        dat->watchdog_status = WATCHDOG_OFF;
    }
}

//====================================================================
//====================================================================
static void asfwdg_watchdog_tick(unsigned long data)
{
    struct asfwdg_dat *dat = (struct asfwdg_dat *)data;
    mod_timer(&dat->watchdog_timer, jiffies + ((dat->interval * HZ)>>1));
    schedule_work(&dat->watchdog_wq);
}

//===========================================================================
//===========================================================================
//===========================================================================

static void asfwdg_smbus_watchdog_cmd(struct i2c_client *client, int start)
{
	u8 message[13];
	u8 length;
	int repeat_count = SMB_RETRY_COUNT;
	struct asfwdg_dat * dat = (struct asfwdg_dat *)i2c_get_clientdata(client);

	memset(message, 0, 13);
	if (start) {
		length = 13;
		message[0]  = CASF_WDSTARTTIMER_SUBCMD;
		message[1]  = CASF_WDTIMER_VERSION;
		message[2]  = dat->interval & 0xFF;
		message[3]  = (dat->interval & 0xFF00)>>8;
		message[4]  = CASF_WD_SENSORTYPE;
		message[5]  = CASF_WD_EVTTYPE;
		message[6]  = CASF_WD_EVTOFFSET;
		message[7]  = CASF_WD_EVTSOURCETYPE;
		message[8]  = CASF_WD_EVTSEVERITY;
		message[9]  = CASF_WD_SENSORDEVICE;
		message[10] = CASF_WD_SENSORNO;
		message[11] = CASF_WD_ENTITY;
		message[12] = CASF_WD_ENTITYINSTANCE;
	} else {
		length = 2;
		message[0] = CASF_WDSTOPTIMER_SUBCMD;
		message[1] = CASF_WDTIMER_VERSION;
	}

	REP_SMBUS_CMD(i2c_smbus_write_block_data(client, CASF_WDTIMERMSG_CMD,
						 length, message),
		      repeat_count,
		      dat->block_pec);

	if (repeat_count <= 0) {
		printk(KERN_DEBUG "asfwdg: Watchdog %s failed on %s at 0x%x\n",
		       ((start)?"start":"stop"), client->adapter->name, client->addr);
	}
}

//====================================================================
//====================================================================
static void asfwdg_smbus_system_state_cmd(struct i2c_client *client, u8 state)
{
	u8 message[3];
	int repeat_count = SMB_RETRY_COUNT;
	struct asfwdg_dat * dat = (struct asfwdg_dat *)i2c_get_clientdata(client);
    
	message[0]  = CASF_SET_SYSTEM_STATE_SUBCMD;
	message[1]  = CASF_SYSTEM_STATE_VERSION;
	message[2]  = state;

	REP_SMBUS_CMD(i2c_smbus_write_block_data(client, CASF_SYSTEM_STATE_CMD,
						 3, message),
		      repeat_count,
		      dat->block_pec);
	if (repeat_count <= 0) {
		printk (KERN_DEBUG "asfwdg: Set system state failed on device %s\n",
			client->adapter->name); 
	}
}

//====================================================================
//====================================================================
static int asfwdg_smbus_device_type_poll_cmd(struct i2c_client *client)
{
	u8 message[32];
	int length=0;
	int repeat_count = SMB_RETRY_COUNT;
	struct asfwdg_dat * dat = (struct asfwdg_dat *)i2c_get_clientdata(client);

	memset(message, 0, 32);

	REP_SMBUS_CMD((length = i2c_smbus_read_block_data(client,
							  CASF_DEVICE_POLL_CMD,
							  message)),
		      repeat_count,
		      dat->block_pec);

	if (repeat_count > 0) {      
		if (length == 3) {
			if ((message[2]&3) == 1){
				return 0;
			}
		}
	}

	printk (KERN_DEBUG "asfwdg: Device Type Poll failed on device "
		"%s address 0x%x\n", client->adapter->name, client->addr);

	return -1;
}

//====================================================================
//====================================================================
static void asfwdg_set_auto_arp_reply(struct i2c_client *client, int enable)
{
	s32 registerE2 = 0;
	int repeat_count = SMB_RETRY_COUNT;
	struct asfwdg_dat * dat = (struct asfwdg_dat *)i2c_get_clientdata(client);

	REP_SMBUS_CMD((registerE2 = i2c_smbus_read_byte_data(client, 0xE2)),
		      repeat_count, dat->reg_pec);

	if(registerE2 > 0) {
		if (enable) {
			registerE2 |= 0x02;
		} else {
			registerE2 &= ~0x02;
		}
		repeat_count = SMB_RETRY_COUNT;

		REP_SMBUS_CMD((i2c_smbus_write_byte_data(client, 0xE2,
							 registerE2 & 0xFF)),
			      repeat_count,
			      dat->reg_pec);
	}
}

//====================================================================
//====================================================================
static int asfwdg_reboot_notify(struct notifier_block *nt, unsigned long type, void *unused)
{
    struct asfwdg_notifier *asfwdg_nt = (struct asfwdg_notifier *) nt;

	printk(KERN_DEBUG "asfwdg: Watchdog power down notifier %u for %s\n",
           (int)type, asfwdg_nt->client->adapter->name);

	switch(type) {
	case SYS_DOWN:
	case SYS_HALT:
	case SYS_POWER_OFF:
		if (asfwdg_nt->client->addr != 0xff) {
			asfwdg_stop_watchdog_process(asfwdg_nt->client);
			asfwdg_smbus_system_state_cmd(asfwdg_nt->client, CASF_SYSTEM_STATE_UNKNOWN);
			asfwdg_set_auto_arp_reply(asfwdg_nt->client, 1);
		}
	}

    return NOTIFY_DONE;
}

//====================================================================
//====================================================================
static int asfwdg_global_reboot_notify(struct notifier_block *nt, unsigned long type, void *unused) {

	struct pci_dev *pdev = NULL;
	struct pci_driver *pdriver;

	printk(KERN_DEBUG "asfwdg: Watchdog global power down notifier %u\n", (int)type);

	switch(type) {
	case SYS_DOWN:
	case SYS_HALT:
	case SYS_POWER_OFF:
		//for all e100 pci devices, call base driver "suspend" function (if available), to enable PME on power-down
		while((pdev = pci_find_device(PCI_ANY_ID,PCI_ANY_ID,pdev)) != NULL) {
			pdriver = pci_dev_driver(pdev);
			if (pdriver) {
				if ((!strcmp(pdriver->name,"e100")) /* || (!strcmp(pdriver->name,"e1000"))*/) {
					if (pdriver->suspend) {
						pdriver->suspend(pdev, 3); //D3 state
					}
				}
			}	
		}
	}
	return NOTIFY_DONE;
}

//===========================================================================
//===========================================================================
//===========================================================================
#ifdef CONFIG_PM

static void asfwdg_pm_register(struct i2c_client *client)
{
   struct asfwdg_dat * dat = (struct asfwdg_dat *)i2c_get_clientdata(client);
   dat->pm_dev_data = pm_register(0, 0, asfwdg_pm_event);
   if (dat->pm_dev_data) {
       dat->pm_dev_data->data = (void *)client;
   }
}

static void asfwdg_pm_unregister(struct i2c_client *client)
{
   struct asfwdg_dat * dat = (struct asfwdg_dat *)i2c_get_clientdata(client);

   if (dat->pm_dev_data) {
       pm_unregister(dat->pm_dev_data);
   }
}
 
static int asfwdg_pm_event(struct pm_dev *dev, pm_request_t rqst, void *data)
{
	struct i2c_client *client = dev->data;
	struct asfwdg_dat * dat = (struct asfwdg_dat *)i2c_get_clientdata(client);

	printk(KERN_DEBUG "asfwdg: PM event %d for %s\n", (int)rqst,
	       client->adapter->name);

	if (client->addr == 0xff)
		 return 0;
    
	down(&dat->lock);
	switch (rqst){
	case PM_RESUME:
		if (dat->watchdog_on_suspend == WATCHDOG_RUNNING) {
			asfwdg_start_watchdog_process(client);
		}
		asfwdg_smbus_system_state_cmd(client, CASF_SYSTEM_STATE_S0);
		asfwdg_set_auto_arp_reply(client, 0);
	break;
	case PM_SUSPEND:
		dat->watchdog_on_suspend = dat->watchdog_status;
		if (dat->watchdog_on_suspend == WATCHDOG_RUNNING) {
			asfwdg_stop_watchdog_process(client);
		}
		asfwdg_smbus_system_state_cmd(client, CASF_SYSTEM_STATE_UNKNOWN);
		asfwdg_set_auto_arp_reply(client, 1);
	break;
	}
	up(&dat->lock);
	return 0;
}

#endif /*CONFIG_PM*/

/****************************************************************
 * **************************************************************
 * attachment function                                          *
 * **************************************************************
 * **************************************************************/
static int asfwdg_attach_adapter(struct i2c_adapter *adapter)
{
  struct i2c_client *new_client;
  struct asfwdg_dat *dat;
  int res;

  printk(KERN_DEBUG "asfwdg: Attaching adapter %s\n", adapter->name);
    
        /* check adapter's class for I2C_CLASS_HWMON */
  //  if(!(adapter->class & I2C_CLASS_HWMON))
  //   return -EPERM;

   	/* check if the adapter is functional */ 
  if(!i2c_check_functionality(adapter, I2C_FUNC_SMBUS_BLOCK_DATA))
    return -ENODEV;
    
       /* allocate memory for data structs */
  if(!(new_client = kmalloc(sizeof(struct i2c_client) + sizeof(struct asfwdg_dat), GFP_KERNEL)))
  {
    return -ENOMEM;
  }

       /* devide the memory between structs */
  memset(new_client,0, sizeof(struct i2c_client) + sizeof(struct asfwdg_dat));
  dat = (struct asfwdg_dat *)( (u8 *)new_client + sizeof(struct i2c_client));
	
       /* fill in data to the client so we can access the watchdog "chip" */
  memcpy(new_client->name, "ASF alert dev watchdog", sizeof(new_client->name));
  new_client->addr = 0xff;
  new_client->flags = 0;
  i2c_set_clientdata(new_client,dat);
  new_client->adapter = adapter;
  new_client->driver = &asfwdg_driver;
  new_client->id = 0x8086;

	/* fill in data to initialize the watchdog */
  dat->watchdog_status = WATCHDOG_OFF;
  dat->watchdog_on_suspend = WATCHDOG_OFF;
  dat->interval = 30;
  dat->last_watchdog_reset = 0;
  dat->block_pec = 0;
  dat->reg_pec = 0;
  
  init_timer(&dat->watchdog_timer);
  dat->watchdog_timer.data = (unsigned long) dat;
  dat->watchdog_timer.function = (void *) &asfwdg_watchdog_tick;
  dat->reboot_notify.nt_block.notifier_call = asfwdg_reboot_notify;
  dat->reboot_notify.nt_block.next = NULL;	
  dat->reboot_notify.nt_block.priority = ASFWDG_DEVICE_REBOOT_NOTIFY_PRIORITY;
  dat->reboot_notify.client = new_client;

  register_reboot_notifier(&dat->reboot_notify.nt_block);
 
#ifdef CONFIG_PM
  asfwdg_pm_register(new_client);
#endif

    /* inform the i2c system about the new client  */
  if((res = i2c_attach_client(new_client)))
  {
    printk(KERN_DEBUG "asfwdg: attaching the client failed \n");
    kfree(new_client);
    return res;
  }

	/* init the semaphore of the asfwdg_dat dat */ 
  init_MUTEX(&dat->lock);
 
    /* register sysfs hooks */
  device_create_file(&new_client->dev, &dev_attr_addr);
  device_create_file(&new_client->dev, &dev_attr_last_reset_time);
  device_create_file(&new_client->dev, &dev_attr_interval);
  device_create_file(&new_client->dev, &dev_attr_start);
  device_create_file(&new_client->dev, &dev_attr_pec);
  device_create_file(&new_client->dev, &dev_attr_rpec);
    
  return 0;
}

/****************************************************************
 * **************************************************************
 * detachment function                                          *
 * **************************************************************
 * **************************************************************/
static int asfwdg_detach_client(struct i2c_client *client)
{
  int err;
  struct asfwdg_dat * dat;

  printk(KERN_DEBUG "asfwdg: Detaching client %s \n ", client->adapter->name);
  
  if(client)
  {
  	dat = (struct asfwdg_dat *)i2c_get_clientdata(client);
  	
  	down(&dat->lock);
    asfwdg_stop_watchdog_process(client);
    up(&dat->lock);

    unregister_reboot_notifier(&dat->reboot_notify.nt_block);

#ifdef CONFIG_PM
    asfwdg_pm_unregister(client);
#endif
  	 
  	err = i2c_detach_client(client);
	if(err)
	{
	  printk(KERN_DEBUG "asfwdg: Detaching failed \n");
	  kfree(client);
	  return err;
	}
	else
	{
	  kfree(client);
	}
  }
  return 0;
	
}

/****************************************************************
 * **************************************************************
 * init function                                                *
 * **************************************************************
 * **************************************************************/
static int __init sensors_asfwdg_init(void)
{ 
  int err;

  printk(KERN_NOTICE "Adding ASF alerting device watchdog driver."
           "Version %s\n", COMPONENT_VERSION);
   
	//register for global reboot notifier
  wd_global_nt_block.notifier_call = asfwdg_global_reboot_notify;
  wd_global_nt_block.next = NULL;
  wd_global_nt_block.priority = ASFWDG_GLOBAL_REBOOT_NOTIFY_PRIORITY;

  err = register_reboot_notifier(&wd_global_nt_block);
  if (err) {
	return err;
  }
  
  err = i2c_add_driver(&asfwdg_driver);       

  if(err)
    printk(KERN_NOTICE "    ASF - sensors_asfwdg_init - i2c_add_driver failed\n");
  else
    printk(KERN_NOTICE "    ASF - sensors_asfwdg_init - i2c_add_driver passed\n");
    
  return 0;
}
/****************************************************************
 * **************************************************************
 * clean up function                                            *
 * **************************************************************
 * **************************************************************/
static void __exit asfwdg_cleanup(void)
{
  int err;

  printk(KERN_NOTICE "Deleting ASF alerting device watchdog driver\n");	
	
  err = i2c_del_driver(&asfwdg_driver);
	
  if(err)
    printk(KERN_NOTICE "asfwdg: cleanup failed\n");
  else
    printk(KERN_NOTICE "asfwdg: cleanup passed\n");
  
  unregister_reboot_notifier(&wd_global_nt_block);
}

/****************************************************************
 * **************************************************************
 * General driver information                                   *
 * **************************************************************
 * **************************************************************/
MODULE_AUTHOR("Intel");
MODULE_DESCRIPTION("ASF alerting device watchdog driver. Version " COMPONENT_VERSION);
MODULE_LICENSE("GPL");

/****************************************************************
 * **************************************************************
 * Linux system access functions                                *
 * **************************************************************
 * **************************************************************/
module_init(sensors_asfwdg_init);
module_exit(asfwdg_cleanup);

