@ECHO OFF
SET NAME=SA07AR15.BIN
IF "%1"=="AMT" GOTO AMT
IF "%1"=="amt" GOTO AMT
GOTO BIOS

:BIOS
rem -------------------- Flash BIOS only -------------------------------------
echo.
echo *************************** Notice!! ********************************
echo             Start updating BIOS without touching ME firmware
echo *********************************************************************
echo.
pause
xtbios %NAME% bios.rom
rem fpt -bios -f bios.rom
afudos BIOS.rom /p /b /n
IF ERRORLEVEL 405 GOTO FAILED
IF ERRORLEVEL 1 GOTO ERROR
echo ***************************************************
echo            Flash process completed.
echo            Please restart system.
echo ***************************************************
GOTO END


rem -------------------- Flash BIOS and AMT/ME -------------------------------
:AMT
echo.
echo *************************** Notice!! ********************************
echo             Start updating both BIOS and ME firmware.
echo                   Any AMT/ME data will be lost.
echo *********************************************************************
echo.
pause
if exist temp.eep del bios.rom
fpt -gbe -d temp.eep -y
IF ERRORLEVEL 1 GOTO FAILED
fpt -f %NAME% -y
IF ERRORLEVEL 405 GOTO FAILED
IF ERRORLEVEL 1 GOTO ERROR
fpt -gbe -f temp.eep
IF ERRORLEVEL 1 GOTO ERROR
echo ***************************************************
echo            Flash process completed.
echo Please turn power off and on for restarting system.
echo ***************************************************
GOTO END


rem -------------------- Flash Exit -------------------------------------------
:FAILED
echo ***************************************************
echo                 Update failed
echo ***************************************************
GOTO END

:ERROR
echo ***************************************************
echo  Data error detected. Please re-execute this batch
echo ***************************************************
rem GOTO BIOS
rem GOTO AMT
GOTO END

:END