REM ************************************************
REM This section is used for content that needs to
REM have the longest eviction path as possible.
REM This will put the content into the BOOT LRU.
REM
REM Begin loading AOAC content into cache.
REM Make sure the drive selected is Accelerated i.e.
REM "C:\".
REM ************************************************

C:\Intel\SshdScripts\rstcli.exe --accelerate --loadCache C:\windows\system32\winevt\logs\*.evtx

REM ************************************************
REM To make sure the content in the BOOT LRU doesn't
REM get evicted, a time delay can be used.
REM This is only needed if the user content is >1.7GB
REM and can be loaded in less than 60s.
REM The time can be "fine-tuned" to adjust for a
REM particular system.  Below is the max to ensure
REM BOOT LRU content doesn't get evicted.
REM ************************************************

timeout 60

REM ************************************************
REM Finish loading content into cache.
REM Make sure the drive selected is Accelerated i.e.
REM "C:\"
REM ************************************************

C:\Intel\SshdScripts\rstcli.exe --accelerate --loadCache "C:\Program Files" --recurse

C:\Intel\SshdScripts\rstcli.exe --accelerate --loadCache "C:\Program Files (x86)" --recurse

C:\Intel\SshdScripts\rstcli.exe --accelerate --loadCache C:\ProgramData --recurse

C:\Intel\SshdScripts\rstcli.exe --accelerate --loadCache C:\Windows --recurse


REM ************************************************
REM Clean up the registry and shutdown
REM ************************************************

regedit C:\Intel\SshdScripts\cache_cleanup.reg

shutdown -f -r -c "SSHD Cache loading complete"