REM ************************************************
REM Make sure we are in our scripts directory.
REM This might need to be altered to match specific 
REM systems.
REM ************************************************
cd C:\Intel\NvCacheScripts

REM ************************************************
REM This section is used for content that needs to
REM have the longest eviction path as possible.
REM This will put the content into the BOOT LRU.
REM
REM Begin loading AOAC content into NV cache.
REM Make sure the drive selected is Accelerated i.e.
REM "C:\".
REM ************************************************
rstcli.exe --accelerate --loadCache "C:\windows\system32\winevt\logs\*.evtx"

REM ************************************************
REM To make sure the content in the BOOT LRU doesn't
REM get evicted, a time delay can be used.
REM This is only needed if the user content is >1.7GB
REM and can be loaded in less than 60s.
REM The time can be "fine-tuned" to adjust for a
REM particular system.  Below is the max to ensure
REM BOOT LRU content doesn't get evicted.
REM ************************************************
timeout 60

REM ************************************************
REM Finish loading content into NV cache.
REM Make sure the drive selected is Accelerated i.e.
REM "C:\"
REM ************************************************
rstcli.exe --accelerate --loadCache "C:\Windows\*" --recurse
rstcli.exe --accelerate --loadCache "C:Program Files\*" --recurse

REM ************************************************
REM Put Accelerated volume into Enhanced mode.
REM The disk ID must match that of the
REM accelerated disk (HDD).  In the example below,
REM the HDD is on AHCI port #5 which has the ID of
REM 0-5-0-0.
REM ************************************************
rstcli.exe --accelerate --setAccelConfig --disk-to-accel 0-5-0-0 --mode enhanced


REM ************************************************
REM Clean up the registry and shutdown
REM ************************************************
regedit cache_cleanup.reg
shutdown -f -r -c "NV Cache loading complete"